package com.bringspring.visualdev.generater.controller;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.NoDataSourceBind;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.ListVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.model.visiual.DownloadCodeForm;
import com.bringspring.common.util.*;
import com.bringspring.common.util.enums.FileTypeEnum;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.visualdev.base.model.read.ReadListVO;
import com.bringspring.visualdev.base.service.VisualdevService;
import com.bringspring.visualdev.base.util.ReadFile;
import com.bringspring.visualdev.generater.service.VisualdevGenService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import static com.bringspring.common.constant.CacheConsts.FIVE_MINUTES_CACHE;

/**
 * 可视化开发功能表
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @author RKKJ开发平台组
 * @date 2021/3/16
 */
@Api(tags = "代码生成器", value = "Generater")
@RestController
@RequestMapping("/api/visualdev/Generater")
public class VisualdevGenController {

    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private CacheUtil cacheUtil;
    @Autowired
    private VisualdevService visualdevService;
    @Autowired
    private VisualdevGenService visualdevGenService;


    /**
     * 下载文件
     *
     * @return
     */
    @NoDataSourceBind()
    @ApiOperation("下载文件")
    @GetMapping("/DownloadVisCode")
    public void downloadCode() throws DataException {
        HttpServletRequest request = ServletUtils.getRequest();
        String reqJson = request.getParameter("encryption");
        String fileNameAll = DesUtil.aesDecode(reqJson);
        if (!StringUtils.isEmpty(fileNameAll)) {
            String token = fileNameAll.split("#")[0];
            if (cacheUtil.exists(token)) {
                String fileName = fileNameAll.split("#")[1];
                String path = configValueUtil.getServiceDirectoryPath() + fileName;
                String zipFile = configValueUtil.getTemporaryFilePath() + fileName + ".zip";
                boolean exists = UploadUtil.downCode(configValueUtil.getFileType(), fileName + ".zip", FileTypeEnum.CODETEMP, path, zipFile);
                if (!exists){
                    throw new DataException("文件不存在");
                }
            }
        }else {
            throw new DataException("token验证失败");
        }
    }

    @ApiOperation("获取命名空间")
    @GetMapping("/AreasName")
    public ActionResult getAreasName() {
        String areasName = configValueUtil.getCodeAreasName();
        List<String> areasNameList = new ArrayList(Arrays.asList(areasName.split(",")));
        return ActionResult.success(areasNameList);
    }

    @ApiOperation("下载代码")
    @PostMapping("/{id}/Actions/DownloadCode")
    @DSTransactional
    public ActionResult downloadCode(@PathVariable("id") String id, @RequestBody DownloadCodeForm downloadCodeForm) throws Exception {
        UserInfo userInfo = userProvider.get();
        DownloadVO vo;
        String fileName = visualdevGenService.codeGengerate(id, downloadCodeForm);
        //上传到minio
        UploadUtil.uploadFolder(configValueUtil.getFileType(), fileName, FileTypeEnum.CODETEMP, configValueUtil.getServiceDirectoryPath());
        vo = DownloadVO.builder().name(fileName).url(UploaderUtil.uploaderVisualFile(userInfo.getId() + "#" + fileName)).build();
        if (vo == null) {
            return ActionResult.fail(MsgCode.FA006.get());
        }
        return ActionResult.success(vo);
    }


    /**
     * 输出移动开发模板
     *
     * @return
     */
    @ApiOperation("预览代码")
    @PostMapping("/{id}/Actions/CodePreview")
    public ActionResult codePreview(@PathVariable("id") String id, @RequestBody DownloadCodeForm downloadCodeForm) throws Exception {
        String fileName = visualdevGenService.codeGengerate(id, downloadCodeForm);
        List<ReadListVO> dataList = ReadFile.priviewCode(configValueUtil.getServiceDirectoryPath() + fileName);
        if (dataList.size() == 0) {
            return ActionResult.fail(MsgCode.FA015.get());
        }
        ListVO datas = new ListVO<>();
        datas.setList(dataList);
        return ActionResult.success(datas);
    }

    /**
     * App预览(后台APP表单设计)
     *
     * @return
     */
    @ApiOperation("App预览(后台APP表单设计)")
    @PostMapping("/App/Preview")
    public ActionResult appPreview(String data) {
        String id = RandomUtil.uuId();
        cacheUtil.insert(FIVE_MINUTES_CACHE, id, data, 300);
        return ActionResult.success((Object) id);
    }

    /**
     * App预览(后台APP表单设计)
     *
     * @return
     */
    @ApiOperation("App预览查看")
    @GetMapping("/App/{id}/Preview")
    public ActionResult preview(@PathVariable("id") String id) {
        if (cacheUtil.exists(FIVE_MINUTES_CACHE, id)) {
            Object object = cacheUtil.query(FIVE_MINUTES_CACHE, id);
            return ActionResult.success(object);
        } else {
            return ActionResult.fail(MsgCode.FA019.get());
        }
    }

}
