package com.bringspring.visualdev.generater.util.common;

import com.bringspring.common.model.*;
import com.bringspring.common.model.visiual.*;
import com.bringspring.common.model.visiual.fields.FieLdsModel;
import com.bringspring.common.model.visiual.fields.config.ConfigModel;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.context.SpringContext;
import com.bringspring.common.util.enums.ModuleTypeEnum;
import com.bringspring.system.base.entity.DictionaryDataEntity;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.visualdev.base.entity.VisualdevEntity;
import com.bringspring.workflow.engine.entity.FlowEngineEntity;
import com.bringspring.workflow.engine.entity.FlowEngineTemplateEntity;
import com.bringspring.workflow.engine.model.flowengine.FlowEngineModel;
import com.bringspring.workflow.engine.model.flowengine.FlowExportModel;
import com.bringspring.workflow.engine.service.FlowEngineTemplateService;
import lombok.Cleanup;
import org.checkerframework.checker.units.qual.A;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 *
 * 功能流程公共工具
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date  2021/8/25
 */

public class FunctionFormPublicUtil {

	public static FlowExportModel jsonFile(VisualdevEntity entity, DownloadCodeForm downloadCodeForm) {
		FlowEngineTemplateService flowEngineTemplateService = SpringContext.getBean(FlowEngineTemplateService.class);
		List<FormAllModel> formAllModel = new ArrayList<>();
		forDataMode(entity,formAllModel);
		List<FormAllModel> mastList = formAllModel.stream().filter(t -> FormEnum.mast.getMessage().equals(t.getKeyName())).collect(Collectors.toList());
		List<FlowEngineModel> tempJson = new ArrayList<>();
		for (FormAllModel mastModel : mastList) {
			FieLdsModel fieLdsModel = mastModel.getFormColumnModel().getFieLdsModel();
			String model =  fieLdsModel.getVModel();
			ConfigModel config = fieLdsModel.getConfig();
			if(StringUtils.isNotEmpty(model)){
				FlowEngineModel engineModel = new FlowEngineModel();
				String label = config.getLabel();
				engineModel.setFiledId(model);
				engineModel.setFiledName(label);
				engineModel.setRequired(config.isRequired());
				tempJson.add(engineModel);
			}
		}
		List<FormAllModel> tableList = formAllModel.stream().filter(t -> FormEnum.table.getMessage().equals(t.getKeyName())).collect(Collectors.toList());
		List<TableModel> tableModelList = JsonUtil.getJsonToList(entity.getVisualTables(),TableModel.class);
		Map<String,String> tableListAll = tableNameRename(downloadCodeForm,tableModelList);
		for (FormAllModel model : tableList) {
			String table = model.getChildList().getTableName();
			String name = tableListAll.get(table);
			FormColumnTableModel childList = model.getChildList();
			String label = childList.getLabel();
			boolean required = childList.isRequired();
			FlowEngineModel engineModel = new FlowEngineModel();
			engineModel.setFiledId(name.toLowerCase()+"List");
			engineModel.setFiledName(label);
			engineModel.setRequired(required);
			tempJson.add(engineModel);
			for (FormColumnModel columnModel : model.getChildList().getChildList()) {
				String vModel = columnModel.getFieLdsModel().getVModel();
				String childLable = columnModel.getFieLdsModel().getConfig().getLabel();
				ConfigModel config = columnModel.getFieLdsModel().getConfig();
				if(StringUtils.isNotEmpty(vModel)) {
					FlowEngineModel childModel = new FlowEngineModel();
					childModel.setFiledId(name.toLowerCase() + "List-" + vModel);
					childModel.setFiledName(label+"-"+childLable);
					childModel.setRequired(config.isRequired());
					tempJson.add(childModel);
				}
			}
		}
		List<FormAllModel> mastTableList = formAllModel.stream().filter(t -> FormEnum.mastTable.getMessage().equals(t.getKeyName())).collect(Collectors.toList());
		for (FormAllModel mastTableModel : mastTableList) {
			FormMastTableModel formMastTableModel = mastTableModel.getFormMastTableModel();
			FieLdsModel fieLdsModel = formMastTableModel.getMastTable().getFieLdsModel();
			String model =  formMastTableModel.getVModel();
			ConfigModel config = fieLdsModel.getConfig();
			if(StringUtils.isNotEmpty(model)){
				FlowEngineModel engineModel = new FlowEngineModel();
				String label = config.getLabel();
				engineModel.setFiledId(model);
				engineModel.setFiledName(label);
				engineModel.setRequired(config.isRequired());
				tempJson.add(engineModel);
			}
		}
		List<FlowEngineTemplateEntity> templateList = flowEngineTemplateService.getListByFlowId(entity.getId());
		tableJson(tableList, entity, tableListAll,templateList);
 		FlowEngineEntity engineEntity = flowEngine(entity,downloadCodeForm.getClassName());
		engineEntity.setFormData(JsonUtil.getObjectToString(tempJson));
		FlowExportModel exportModel = new FlowExportModel();
		exportModel.setFlowEngine(engineEntity);
		exportModel.setVisibleList(new ArrayList<>());
		exportModel.setTemplateList(templateList);
		return exportModel;
	}


	private static FlowEngineEntity flowEngine(VisualdevEntity entity,String className){
		FlowEngineEntity engineEntity = JsonUtil.getJsonToBean(entity,FlowEngineEntity.class);
		engineEntity.setFlowTables("[]");
		engineEntity.setFormType(1);
		engineEntity.setType(1);
		engineEntity.setSortCode(0L);
		engineEntity.setEnabledMark(1);
		engineEntity.setIcon("fa fa-file-text-o");
		String formUrl = "extend/"+className.toLowerCase()+"/form.vue";
		//代码生成器默认表单路径
		if (entity.getType() ==4 && entity.getWebType() == 3 ){
			engineEntity.setFormUrl(formUrl);
		}else if (entity.getType() == 5 && entity.getWebType()==3){
			engineEntity.setAppFormUrl(formUrl);
		}
		DictionaryDataService dataService = SpringContext.getBean(DictionaryDataService.class);
		DictionaryDataEntity dataEntity = dataService.getInfo(entity.getCategory());
		engineEntity.setCategory(dataEntity!=null?dataEntity.getEnCode():entity.getCategory());
		return engineEntity;
	}


	/**
	 * 创建文件
	 * @param data
	 * @param path
	 */
	public static void createFile(String data, String path) {
		try {
			File file = new File(XSSEscape.escapePath(path+File.separator+"flow."+ ModuleTypeEnum.FLOW_FLOWENGINE.getTableName()));
			boolean b = file.createNewFile();
			if(b) {
				@Cleanup Writer out = new FileWriter(file);
				out.write(data);
				out.close();
			}
		}catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * 封装数据
	 *
	 * @param entity
	 * @param formAllModel
	 */
	private static void forDataMode(VisualdevEntity entity, List<FormAllModel> formAllModel) {
		//formTempJson
		FormDataModel formData = JsonUtil.getJsonToBean(entity.getFormData(), FormDataModel.class);
		List<FieLdsModel> list = JsonUtil.getJsonToList(formData.getFields(), FieLdsModel.class);
		List<TableModel> tableModelList = JsonUtil.getJsonToList(entity.getVisualTables(), TableModel.class);
		RecursionForm recursionForm = new RecursionForm(list,tableModelList);
		FormCloumnUtil.recursionForm(recursionForm, formAllModel);
	}

	public static Map<String,String> tableNameRename(DownloadCodeForm downloadCodeForm, List<TableModel> tableModelList){
		Map<String, String> tableNameMap = new HashMap<>(16);
		int i = 0;
		for (TableModel tableModel : tableModelList) {
			if ("0".equals(tableModel.getTypeId())) {
				String[] subClassName = downloadCodeForm.getSubClassName().split(",");
				tableNameMap.put(tableModel.getTable(), subClassName[i]);
				i++;
			}else {
				tableNameMap.put(tableModel.getTable(),downloadCodeForm.getClassName());
			}
		}
		return tableNameMap;
	}

    private static void tableJson(List<FormAllModel> tableList, VisualdevEntity entity, Map<String, String> tableListAll,List<FlowEngineTemplateEntity> templateList) {
		FlowEngineTemplateService flowEngineTemplateService = SpringContext.getBean(FlowEngineTemplateService.class);
        templateList.stream().forEach(template->{
        	String json = template.getFlowTemplateJson();
			for (FormAllModel model : tableList) {
				String table = model.getChildList().getTableName();
				String tableModel = model.getChildList().getTableModel();
				String name = tableListAll.get(table);
				json = json.replaceAll(tableModel, name.toLowerCase() + "List");
			}
			template.setFlowTemplateJson(json);
			flowEngineTemplateService.saveOrUpdate(template);
		});

//        entity.setFlowTemplateJson(json);
    }

}
