package com.bringspring.visualdev.onlinedev.service;


import com.baomidou.mybatisplus.extension.service.IService;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.model.visiual.FormDataField;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.visualdev.base.entity.VisualdevEntity;
import com.bringspring.visualdev.onlinedev.entity.VisualdevModelDataEntity;
import com.bringspring.visualdev.onlinedev.model.*;

import java.io.IOException;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.List;
import java.util.Map;

/**
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021/3/16
 */
public interface VisualdevModelDataService extends IService<VisualdevModelDataEntity> {

    /**
     * 获取表单主表属性下拉框
     * @return
     */
    List<FormDataField> fieldList(String id);

    /**
     * 弹窗数据分页
     * @param visualdevEntity
     * @param paginationModel
     * @return
     */
    List<Map<String,Object>> getPageList(VisualdevEntity visualdevEntity, PaginationModel paginationModel);

    List<VisualdevModelDataEntity> getList(String modelId);

    VisualdevModelDataEntity getInfo(String id);

    VisualdevModelDataInfoVO infoDataChange(String id, VisualdevEntity visualdevEntity) throws IOException, ParseException, DataException, SQLException;

    void delete(VisualdevModelDataEntity entity);

    boolean tableDelete(String id, VisualdevEntity visualdevEntity) throws DataException, SQLException;

    ActionResult tableDeleteMore(List<String> id, VisualdevEntity  visualdevEntity) throws DataException, SQLException;

    List<Map<String, Object>> exportData(String[] keys, PaginationModelExport paginationModelExport, VisualdevEntity visualdevEntity) throws IOException, ParseException, SQLException, DataException;

    ActionResult visualCreate(VisualdevEntity visualdevEntity, Map<String, Object> dataMap, VisualdevModelDataCrForm visualdevModelDataCrForm, String mainId) throws WorkFlowException;

    ActionResult visualUpdate(String id, VisualdevEntity visualdevEntity, Map<String, Object> map, VisualdevModelDataUpForm visualdevModelDataUpForm) throws WorkFlowException;
}
