/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.visualdev.onlinedev.util;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.database.model.dto.PreparedStatementDTO;
import com.bringspring.common.database.model.entity.DbLinkEntity;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.model.visiual.TableModel;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.visualdev.base.entity.VisualdevEntity;
import com.bringspring.visualdev.base.util.VisualUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class OnlineDevDbUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean deleteTable(String id, VisualdevEntity visualdevEntity, DbLinkEntity linkEntity) throws SQLException, DataException {
        List tableModels = JsonUtil.getJsonToList((String)visualdevEntity.getVisualTables(), TableModel.class);
        TableModel mainTableModel = tableModels.stream().filter(t -> "1".equals(t.getTypeId())).findFirst().orElse(null);
        String mainTable = mainTableModel.getTable();
        Connection conn = VisualUtils.getDataConn(linkEntity);
        try {
            String pKeyName = VisualUtils.getpKey(conn, mainTable);
            String delMain = "DELETE FROM " + mainTable + " WHERE " + pKeyName + "= ?";
            LinkedList<PreparedStatementDTO> DTOs = new LinkedList<PreparedStatementDTO>();
            PreparedStatementDTO dto = new PreparedStatementDTO(conn, delMain, new Object[]{id});
            DTOs.add(dto);
            String queryMain = "SELECT * FROM " + mainTable + " WHERE " + pKeyName + "='" + id + "'";
            List<Map<String, Object>> mainMapList = VisualUtils.getTableDataInfo(queryMain, linkEntity);
            mainMapList = VisualUtils.toLowerKeyList(mainMapList);
            if (mainMapList.size() > 0 && tableModels.size() > 1) {
                tableModels.remove(mainTableModel);
                for (TableModel table : tableModels) {
                    String relationField = table.getRelationField();
                    String relationFieldValue = mainMapList.get(0).get(relationField.toLowerCase()).toString();
                    String tableField = table.getTableField();
                    String childSql = "DELETE FROM " + table.getTable() + " WHERE " + tableField + "= ?";
                    PreparedStatementDTO childDto = new PreparedStatementDTO(conn, childSql, new Object[]{relationFieldValue});
                    DTOs.add(childDto);
                }
            }
            boolean bl = OnlineDevDbUtil.sqlPrepareStatement(conn, DTOs, true);
            return bl;
        }
        finally {
            if (Collections.singletonList(conn).get(0) != null) {
                conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ActionResult deleteTables(List<String> idList, VisualdevEntity visualdevEntity, DbLinkEntity linkEntity) throws SQLException, DataException {
        List tableModels = JsonUtil.getJsonToList((String)visualdevEntity.getVisualTables(), TableModel.class);
        if (idList.size() == 0) {
            return ActionResult.fail((String)MsgCode.FA003.get());
        }
        TableModel tableModel = tableModels.stream().filter(t -> "1".equals(t.getTypeId())).findFirst().orElse(null);
        String mainTable = Optional.ofNullable(tableModel.getTable()).orElse("");
        Connection conn = VisualUtils.getDataConn(linkEntity);
        try {
            String pKeyName = VisualUtils.getpKey(conn, mainTable);
            boolean close = false;
            for (int i = 0; i < idList.size(); ++i) {
                String id = idList.get(i);
                String selectSql = "SELECT * FROM " + mainTable + " WHERE " + pKeyName + "='" + id + "'";
                List<Map<String, Object>> mainMapList = VisualUtils.getTableDataInfo(selectSql, linkEntity);
                String delMain = "DELETE FROM " + mainTable + " WHERE " + pKeyName + "= ?";
                LinkedList<PreparedStatementDTO> DTOs = new LinkedList<PreparedStatementDTO>();
                PreparedStatementDTO dto = new PreparedStatementDTO(conn, delMain, new Object[]{id});
                DTOs.add(dto);
                if (mainMapList.size() > 0 && tableModels.size() > 1) {
                    tableModels.remove(tableModel);
                    for (TableModel table : tableModels) {
                        String relationField = table.getRelationField();
                        String relationFieldValue = mainMapList.get(0).get(relationField.toLowerCase()).toString();
                        String tableField = table.getTableField();
                        String childSql = "DELETE FROM " + table.getTable() + " WHERE " + tableField + "= ?";
                        PreparedStatementDTO childDto = new PreparedStatementDTO(conn, childSql, new Object[]{relationFieldValue});
                        DTOs.add(childDto);
                    }
                }
                if (i == idList.size() - 1) {
                    close = true;
                }
                OnlineDevDbUtil.sqlPrepareStatement(conn, DTOs, close);
            }
            if (conn != null) {
                conn.close();
            }
            ActionResult actionResult = ActionResult.success((String)MsgCode.SU003.get());
            return actionResult;
        }
        finally {
            if (Collections.singletonList(conn).get(0) != null) {
                conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean sqlPrepareStatement(Connection conn, List<PreparedStatementDTO> DTOs, boolean close) {
        try {
            conn.setAutoCommit(false);
            for (PreparedStatementDTO DTO : DTOs) {
                PreparedStatement statement = conn.prepareStatement(DTO.getPrepareSql());
                try {
                    LinkedList prepareDataList = DTO.getPrepareDataList();
                    for (int i = 0; i < prepareDataList.size(); ++i) {
                        statement.setObject(i + 1, prepareDataList.get(i));
                    }
                    statement.executeUpdate();
                }
                finally {
                    if (Collections.singletonList(statement).get(0) == null) continue;
                    statement.close();
                }
            }
            conn.commit();
        }
        catch (SQLException sqlException) {
            try {
                conn.rollback();
            }
            catch (SQLException throwables) {
                throwables.printStackTrace();
            }
            sqlException.printStackTrace();
        }
        finally {
            if (close && conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sqlException) {
                    sqlException.printStackTrace();
                }
            }
        }
        return true;
    }
}

