package com.bringspring.visualdev.base.util;


import com.bringspring.common.model.visiual.fields.FieLdsModel;
import com.bringspring.common.util.*;
import com.bringspring.common.util.context.SpringContext;
import com.bringspring.system.base.service.DataInterfaceService;

import java.io.IOException;
import java.util.List;
import java.util.Map;

import static com.bringspring.common.constant.CacheConsts.FOREVER_CACHE;

/**
 *
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @author RKKJ开发平台组
 * @date 2021/3/16
 */
public class DynamicUtil {

    private CacheUtil cacheUtil;
    private CacheKeyUtil cacheKeyUtil;
    private DataInterfaceService dataInterfaceService;

    /**
     * 获取远端数据转换关键词返回
     * @param model
     * @param keyJsonMap
     * @return
     * @throws IOException
     */
    public Map<String, Object> dynamicKeyData(FieLdsModel model, Map<String, Object> keyJsonMap) throws IOException {

//        long startTime = System.currentTimeMillis(); //获取开始时间
        cacheUtil = SpringContext.getBean(CacheUtil.class);
        cacheKeyUtil = SpringContext.getBean(CacheKeyUtil.class);
        String cacheKey = cacheKeyUtil.getDynamic() + model.getConfig().getPropsUrl();
        if (cacheUtil.exists(FOREVER_CACHE, cacheKey)) {
            Object dynamic = cacheUtil.query(FOREVER_CACHE, cacheKey);
            if (dynamic instanceof String) {
                model = JsonUtil.getJsonToBean(dynamic.toString(), FieLdsModel.class);
            } else {
                model = (FieLdsModel) dynamic;
            }
        } else {
            //获取远端数据
            model = dynamicData(model);
            cacheUtil.insert(FOREVER_CACHE, cacheKey, model);
        }
        String keyStr = String.valueOf(keyJsonMap.get(model.getVModel()));

        if (model.getSlot() != null && model.getSlot().getOptions() != null) {
            List<Map<String, Object>> modelOpt = JsonUtil.getJsonToListMap(model.getSlot().getOptions());
            for (Map<String, Object> map : modelOpt) {
                if (map.get(model.getConfig().getProps().getValue()).toString().equals(keyStr)) {
                    keyJsonMap.put(model.getVModel(), map.get(model.getConfig().getProps().getLabel()).toString());
                }

            }
        }
        return keyJsonMap;
    }


    /**
     * 获取远端数据
     * @param model
     * @return
     * @throws IOException
     */
    public FieLdsModel dynamicData(FieLdsModel model) throws IOException {
        dataInterfaceService = SpringContext.getBean(DataInterfaceService.class);
        cacheUtil = SpringContext.getBean(CacheUtil.class);
        cacheKeyUtil = SpringContext.getBean(CacheKeyUtil.class);
        String cacheKey = cacheKeyUtil.getDynamic() + model.getConfig().getPropsUrl();
        if (cacheUtil.exists(FOREVER_CACHE, cacheKey)) {
            Object dynamic = cacheUtil.query(FOREVER_CACHE, cacheKey);
            if (dynamic instanceof String) {
                model = JsonUtil.getJsonToBean(dynamic.toString(), FieLdsModel.class);
            } else {
                model = (FieLdsModel) dynamic;
            }
        } else {
            //获取远端数据
            Object object = dataInterfaceService.infoToId(model.getConfig().getPropsUrl());
            Map<String, Object> dynamicMap= JsonUtil.entityToMap(object);
            if (dynamicMap.get("data") != null) {
                List<Map<String, Object>> dataList = JsonUtil.getJsonToListMap(dynamicMap.get("data").toString());
                if(model.getSlot()!=null){
                    model.getSlot().setOptions(JsonUtil.getObjectToString(dataList));
                }
            }
            cacheUtil.insert(FOREVER_CACHE, cacheKey, model);
        }
        return model;
    }

}
