/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.visualdev.onlinedev.util.onlineDevUtil;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.database.data.DataSourceContextHolder;
import com.bringspring.common.model.visiual.ColumnDataModel;
import com.bringspring.common.util.CacheUtil;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.context.SpringContext;
import com.bringspring.system.base.model.dataInterface.DataInterfaceActionVo;
import com.bringspring.system.base.service.DataInterfaceService;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.system.base.service.ProvinceService;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.PositionService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.PermissionUtil;
import com.bringspring.visualdev.base.entity.VisualdevEntity;
import com.bringspring.visualdev.base.service.VisualdevService;
import com.bringspring.visualdev.onlinedev.model.OnlineDevEnum.CacheKeyEnum;
import com.bringspring.visualdev.onlinedev.model.OnlineDevEnum.MultipleControlEnum;
import com.bringspring.visualdev.onlinedev.model.OnlineDevEnum.OnlineDataTypeEnum;
import com.bringspring.visualdev.onlinedev.model.OnlineDevListModel.OnlineDevListDataVO;
import com.bringspring.visualdev.onlinedev.model.OnlineDevListModel.OnlineFieldsModel;
import com.bringspring.visualdev.onlinedev.model.OnlineDevListModel.VisualColumnSearchVO;
import com.bringspring.visualdev.onlinedev.model.VisualdevModelDataInfoVO;
import com.bringspring.visualdev.onlinedev.service.VisualDevInfoService;
import com.bringspring.visualdev.onlinedev.service.VisualdevModelDataService;
import com.bringspring.visualdev.onlinedev.util.onlineDevUtil.OnlineDatabaseUtils;
import com.bringspring.visualdev.onlinedev.util.onlineDevUtil.OnlinePublicUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnlineDevListUtils {
    private static final Logger log = LoggerFactory.getLogger(OnlineDevListUtils.class);
    private static CacheUtil cacheUtil;
    private static DictionaryDataService dictionaryDataService;
    private static UserService userService;
    private static PositionService positionService;
    private static ProvinceService provinceService;
    private static OrganizeService organizeService;
    private static VisualdevService visualdevService;
    private static VisualdevModelDataService visualdevModelDataService;
    private static DataInterfaceService dataInterfaceService;
    private static VisualDevInfoService visualDevInfoService;

    public static void init() {
        visualdevModelDataService = (VisualdevModelDataService)SpringContext.getBean(VisualdevModelDataService.class);
        dictionaryDataService = (DictionaryDataService)SpringContext.getBean(DictionaryDataService.class);
        userService = (UserService)SpringContext.getBean(UserService.class);
        positionService = (PositionService)SpringContext.getBean(PositionService.class);
        cacheUtil = (CacheUtil)SpringContext.getBean(CacheUtil.class);
        provinceService = (ProvinceService)SpringContext.getBean(ProvinceService.class);
        organizeService = (OrganizeService)SpringContext.getBean(OrganizeService.class);
        visualdevService = (VisualdevService)SpringContext.getBean(VisualdevService.class);
        dataInterfaceService = (DataInterfaceService)SpringContext.getBean(DataInterfaceService.class);
        visualDevInfoService = (VisualDevInfoService)SpringContext.getBean(VisualDevInfoService.class);
    }

    public static List<OnlineDevListDataVO> getNoSwapList(List<OnlineDevListDataVO> list, List<VisualColumnSearchVO> searchList) {
        ArrayList<OnlineDevListDataVO> resultList = new ArrayList<OnlineDevListDataVO>();
        if (searchList == null) {
            return list;
        }
        for (OnlineDevListDataVO dataVo : list) {
            int i = 0;
            for (VisualColumnSearchVO vo : searchList) {
                Object dataModel = dataVo.getData().get(vo.getVModel());
                if (dataModel == null || ObjectUtil.isEmpty((Object)dataModel)) continue;
                if (vo.getConfig().getKeyName().equals("checkbox") || "cascader".equals(vo.getConfig().getKeyName())) {
                    vo.setMultiple(true);
                }
                if (vo.getSearchType().equals("1")) {
                    if (vo.getMultiple() != null && vo.getMultiple().booleanValue()) {
                        List<String> asList;
                        if (String.valueOf(dataModel).contains("[")) {
                            asList = JsonUtil.getJsonToList((String)String.valueOf(dataModel), String.class);
                        } else {
                            String[] multipleList = String.valueOf(dataModel).split(",");
                            asList = Arrays.asList(multipleList);
                        }
                        boolean b = asList.stream().anyMatch(t -> vo.getValue().toString().contains((CharSequence)t));
                        if (b) {
                            ++i;
                        }
                    } else if (String.valueOf(vo.getValue()).equals(String.valueOf(dataModel))) {
                        ++i;
                    }
                }
                if (vo.getSearchType().equals("2") && String.valueOf(dataModel).contains(String.valueOf(vo.getValue()))) {
                    ++i;
                }
                if (vo.getSearchType().equals("3")) {
                    String key;
                    switch (key = vo.getConfig().getKeyName()) {
                        case "modifyTime": 
                        case "createTime": {
                            JSONArray timeStampArray = (JSONArray)vo.getValue();
                            Long o1 = (Long)timeStampArray.get(0);
                            Long o2 = (Long)timeStampArray.get(1);
                            String startTime = DateUtil.daFormat((Long)o1);
                            String endTime = DateUtil.daFormat((Long)o2);
                            endTime = endTime.substring(0, 10);
                            String firstTimeDate = OnlineDatabaseUtils.getTimeFormat(startTime);
                            String lastTimeDate = OnlineDatabaseUtils.getLastTimeFormat(endTime);
                            String value = String.valueOf(dataModel);
                            if (value.contains(".")) {
                                value = value.substring(0, value.lastIndexOf("."));
                            }
                            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                            try {
                                boolean b = DateUtil.isEffectiveDate((Date)sdf.parse(value), (Date)sdf.parse(firstTimeDate), (Date)sdf.parse(lastTimeDate));
                                if (!b) break;
                                ++i;
                            }
                            catch (ParseException e) {
                                e.printStackTrace();
                            }
                            break;
                        }
                        case "numInput": 
                        case "calculate": {
                            Float firstValue = null;
                            Float secondValue = null;
                            JSONArray objects = (JSONArray)vo.getValue();
                            for (int k = 0; k < objects.size(); ++k) {
                                Object n = objects.get(k);
                                if (!ObjectUtil.isNotEmpty((Object)n)) continue;
                                if (k == 0) {
                                    firstValue = Float.valueOf(Float.parseFloat(String.valueOf(n)));
                                    continue;
                                }
                                secondValue = Float.valueOf(Float.parseFloat(String.valueOf(n)));
                            }
                            Float numValue = Float.valueOf(Float.parseFloat(String.valueOf(dataModel)));
                            if (firstValue != null && secondValue == null && numValue.floatValue() >= firstValue.floatValue()) {
                                ++i;
                            }
                            if (firstValue != null && secondValue != null && numValue.floatValue() >= firstValue.floatValue() && numValue.floatValue() <= secondValue.floatValue()) {
                                ++i;
                            }
                            if (firstValue != null || secondValue == null || !(numValue.floatValue() <= secondValue.floatValue())) break;
                            ++i;
                            break;
                        }
                        case "date": {
                            String endTimeDates;
                            String starTimeDates;
                            if (dataModel == null) break;
                            if (!String.valueOf(vo.getValue()).contains(":") && !String.valueOf(vo.getValue()).contains("-")) {
                                JSONArray DateTimeStampArray = (JSONArray)vo.getValue();
                                Long d1 = (Long)DateTimeStampArray.get(0);
                                Long d2 = (Long)DateTimeStampArray.get(1);
                                long d1FirstTime = Long.parseLong(String.valueOf(d1));
                                long d2LastTime = Long.parseLong(String.valueOf(d2));
                                starTimeDates = DateUtil.daFormat((Long)d1FirstTime);
                                endTimeDates = DateUtil.daFormat((Long)d2LastTime);
                            } else {
                                String[] keyArray = String.valueOf(vo.getValue()).split(",");
                                starTimeDates = keyArray[0];
                                endTimeDates = keyArray[1];
                            }
                            if (vo.getFormat() == null) {
                                starTimeDates = starTimeDates.substring(0, 10);
                                endTimeDates = endTimeDates.substring(0, 10);
                            }
                            starTimeDates = OnlineDatabaseUtils.getTimeFormat(starTimeDates);
                            endTimeDates = OnlineDatabaseUtils.getLastTimeFormat(endTimeDates);
                            String dateValue = dataModel.toString();
                            if (!dateValue.contains(":") && !dateValue.contains("-")) {
                                Long timeResult = (Long)dataModel;
                                dateValue = DateUtil.daFormat((Long)timeResult);
                            }
                            if (dateValue.contains(".")) {
                                dateValue = dateValue.substring(0, dateValue.lastIndexOf("."));
                            }
                            dateValue = OnlineDatabaseUtils.getTimeFormat(dateValue);
                            SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                            try {
                                Boolean b = DateUtil.isEffectiveDate((Date)sdfDate.parse(dateValue), (Date)sdfDate.parse(starTimeDates), (Date)sdfDate.parse(endTimeDates));
                                if (!b.booleanValue()) break;
                                ++i;
                            }
                            catch (ParseException e) {
                                e.printStackTrace();
                            }
                            break;
                        }
                        case "time": {
                            JSONArray timeArray = (JSONArray)vo.getValue();
                            String start = String.valueOf(timeArray.get(0));
                            String end = String.valueOf(timeArray.get(1));
                            start = OnlineDatabaseUtils.getTimeFormat(start);
                            end = OnlineDatabaseUtils.getLastTimeFormat(end);
                            String timeValue = OnlineDatabaseUtils.getTimeFormat(String.valueOf(dataModel));
                            SimpleDateFormat timeSim = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                            try {
                                boolean b = DateUtil.isEffectiveDate((Date)timeSim.parse(timeValue), (Date)timeSim.parse(start), (Date)timeSim.parse(end));
                                if (!b) break;
                                ++i;
                            }
                            catch (ParseException e) {
                                e.printStackTrace();
                            }
                            break;
                        }
                    }
                }
                if (i != searchList.size()) continue;
                resultList.add(dataVo);
            }
        }
        return resultList;
    }

    public static List<OnlineDevListDataVO> getSwapList(List<OnlineDevListDataVO> list, List<OnlineFieldsModel> swapDataVoList, String visualDevId) {
        if (list.isEmpty()) {
            return list;
        }
        OnlineDevListUtils.init();
        HashMap<String, Object> localCache = new HashMap<String, Object>();
        HashSet userList = new HashSet();
        HashSet orgList = new HashSet();
        HashSet posList = new HashSet();
        HashSet allOrgList = new HashSet();
        localCache.put("__user_list", userList);
        localCache.put("__org_list", orgList);
        localCache.put("__pos_list", posList);
        localCache.put("__allOrg_list", allOrgList);
        OnlineDevListUtils.pageIdList(list, swapDataVoList, localCache);
        OnlineDevListUtils.sysNeedSwapData(swapDataVoList, visualDevId, localCache);
        String dsName = Optional.ofNullable(DataSourceContextHolder.getDatasourceId()).orElse("");
        HashMap<String, Object> orgMap = new HashMap<String, Object>(20);
        HashMap<String, Object> allOrgMap = new HashMap<String, Object>(20);
        HashMap<String, Object> posMap = new HashMap<String, Object>(20);
        HashMap<String, Object> userMap = new HashMap<String, Object>(20);
        Map proMap = (Map)localCache.get(dsName + CacheKeyEnum.PRO.getName());
        for (OnlineFieldsModel swapDataVo : swapDataVoList) {
            String keyName = swapDataVo.getConfig().getKeyName();
            String vModel = swapDataVo.getVModel();
            String dataType = String.valueOf(swapDataVo.getConfig().getDataType());
            Boolean isMultiple = Objects.nonNull(swapDataVo.getMultiple()) ? swapDataVo.getMultiple() : false;
            for (OnlineDevListDataVO listVo : list) {
                try {
                    String s;
                    String redisKey;
                    Map<String, Object> dataMap = listVo.getData();
                    if (StringUtils.isEmpty((String)String.valueOf(dataMap.get(vModel))) || dataMap.get(vModel) == null) continue;
                    if (String.valueOf(dataMap.get(vModel)).equals("[]") || String.valueOf(dataMap.get(vModel)).equals("null")) {
                        dataMap.put(vModel, null);
                        continue;
                    }
                    switch (keyName) {
                        case "comSelect": 
                        case "depSelect": 
                        case "currDept": 
                        case "currOrganize": {
                            if (orgMap.size() == 0) {
                                List organizeEntityList = organizeService.getOrgEntityList(orgList);
                                organizeEntityList.stream().forEach(org -> orgMap.put(org.getId(), org.getFullName()));
                                String orgString = JsonUtil.getObjectToString(orgMap);
                                cacheUtil.insert("fiveMinutesCacheSpace", visualDevId + CacheKeyEnum.ORG.getName(), (Object)orgString, 300L);
                            }
                            if ("all".equals(swapDataVo.getShowLevel())) {
                                if (allOrgMap.size() == 0) {
                                    for (String org2 : allOrgList) {
                                        String infoByOrgId = PermissionUtil.getLinkInfoByOrgId((String)org2, (OrganizeService)organizeService, (Boolean)false);
                                        allOrgMap.put(org2, infoByOrgId);
                                    }
                                    String allOrgString = JsonUtil.getObjectToString(allOrgMap);
                                    cacheUtil.insert("fiveMinutesCacheSpace", visualDevId + CacheKeyEnum.AllORG.getName(), (Object)allOrgString, 300L);
                                }
                                dataMap.put(vModel, OnlinePublicUtils.getDataInMethod(allOrgMap, dataMap.get(vModel), isMultiple));
                                break;
                            }
                            dataMap.put(vModel, OnlinePublicUtils.getDataInMethod(orgMap, dataMap.get(vModel), isMultiple));
                            break;
                        }
                        case "posSelect": 
                        case "currPosition": {
                            if (posMap.size() == 0) {
                                List positionList = positionService.getPositionList(posList);
                                positionList.stream().forEach(positionEntity -> posMap.put(positionEntity.getId(), positionEntity.getFullName()));
                                String posString = JsonUtil.getObjectToString(posMap);
                                cacheUtil.insert("fiveMinutesCacheSpace", visualDevId + CacheKeyEnum.POS.getName(), (Object)posString, 300L);
                            }
                            String posData = OnlinePublicUtils.getDataInMethod(posMap, dataMap.get(vModel), isMultiple);
                            dataMap.put(vModel, posData);
                            break;
                        }
                        case "userSelect": 
                        case "createUser": 
                        case "modifyUser": {
                            if (userMap.size() == 0) {
                                List userEntityList = userService.getUserNameList(userList);
                                userEntityList.stream().forEach(userEntity -> userMap.put(userEntity.getId(), userEntity.getRealName()));
                                String userString = JsonUtil.getObjectToString(userMap);
                                cacheUtil.insert("fiveMinutesCacheSpace", visualDevId + CacheKeyEnum.USER.getName(), (Object)userString, 300L);
                            }
                            String userData = OnlinePublicUtils.getDataInMethod(userMap, dataMap.get(vModel), isMultiple);
                            dataMap.put(vModel, userData);
                            break;
                        }
                        case "address": {
                            String addressValue = String.valueOf(dataMap.get(vModel));
                            if (OnlinePublicUtils.getMultiple(addressValue, MultipleControlEnum.MULTIPLE_JSON_TWO.getMultipleChar()).booleanValue()) {
                                String[][] data = (String[][])JsonUtil.getJsonToBean((String)addressValue, String[][].class);
                                ArrayList<String> addList = new ArrayList<String>();
                                for (String[] AddressData : data) {
                                    ArrayList<String> adList = new ArrayList<String>();
                                    for (String s2 : AddressData) {
                                        adList.add(String.valueOf(proMap.get(s2)));
                                    }
                                    addList.add(String.join((CharSequence)"/", adList));
                                }
                                dataMap.put(vModel, String.join((CharSequence)";", addList));
                                break;
                            }
                            if (!OnlinePublicUtils.getMultiple(addressValue, MultipleControlEnum.MULTIPLE_JSON_ONE.getMultipleChar()).booleanValue()) break;
                            List proDataS = JsonUtil.getJsonToList((String)String.valueOf(dataMap.get(vModel)), String.class);
                            proDataS = proDataS.stream().map(pro -> String.valueOf(proMap.get(pro))).collect(Collectors.toList());
                            dataMap.put(vModel, String.join((CharSequence)"/", proDataS));
                            break;
                        }
                        case "switch": {
                            String switchValue = String.valueOf(dataMap.get(vModel)).equals("1") ? swapDataVo.getActiveTxt() : swapDataVo.getInactiveTxt();
                            dataMap.put(vModel, switchValue);
                            break;
                        }
                        case "cascader": {
                            Map<String, Object> cascaderMap;
                            String redisKey2 = OnlineDataTypeEnum.STATIC.getType().equals(dataType) ? String.format("%s-%s-%s", visualDevId, swapDataVo.getVModel(), OnlineDataTypeEnum.STATIC.getType()) : (dataType.equals(OnlineDataTypeEnum.DYNAMIC.getType()) ? String.format("%s-%s-%s-%s-%s-%s", dsName, OnlineDataTypeEnum.DYNAMIC.getType(), swapDataVo.getConfig().getPropsUrl(), swapDataVo.getProps().getProps().getLabel(), swapDataVo.getProps().getProps().getValue(), swapDataVo.getProps().getProps().getChildren()) : String.format("%s-%s-%s", dsName, OnlineDataTypeEnum.DICTIONARY.getType(), swapDataVo.getConfig().getDictionaryType()));
                            if (dataType.equals(OnlineDataTypeEnum.DICTIONARY.getType())) {
                                List checkBoxList = (List)localCache.get(redisKey2);
                                cascaderMap = OnlinePublicUtils.getDataMap((List<Map<String, Object>>)checkBoxList, swapDataVo);
                            } else {
                                cascaderMap = (Map<String, Object>)localCache.get(redisKey2);
                            }
                            String s1 = OnlinePublicUtils.getDataInMethod(cascaderMap, dataMap.get(vModel), isMultiple);
                            dataMap.put(vModel, s1);
                            break;
                        }
                        case "checkbox": {
                            Map<String, Object> checkboxMap;
                            String checkBox = OnlineDataTypeEnum.STATIC.getType().equals(dataType) ? String.format("%s-%s-%s", visualDevId, swapDataVo.getVModel(), OnlineDataTypeEnum.STATIC.getType()) : (dataType.equals(OnlineDataTypeEnum.DYNAMIC.getType()) ? String.format("%s-%s-%s", dsName, OnlineDataTypeEnum.DYNAMIC.getType(), swapDataVo.getConfig().getPropsUrl()) : String.format("%s-%s-%s", dsName, OnlineDataTypeEnum.DICTIONARY.getType(), swapDataVo.getConfig().getDictionaryType()));
                            if (dataType.equals(OnlineDataTypeEnum.DICTIONARY.getType())) {
                                List checkBoxList = (List)localCache.get(checkBox);
                                checkboxMap = OnlinePublicUtils.getDataMap((List<Map<String, Object>>)checkBoxList, swapDataVo);
                            } else {
                                checkboxMap = (Map<String, Object>)localCache.get(checkBox);
                            }
                            String s2 = OnlinePublicUtils.getDataInMethod(checkboxMap, dataMap.get(vModel), isMultiple);
                            dataMap.put(vModel, s2);
                            break;
                        }
                        case "relationForm": {
                            String redisKey2 = String.format("%s-%s-%s-%s-%s", dsName, "relationForm", swapDataVo.getModelId(), swapDataVo.getRelationField(), dataMap.get(vModel));
                            VisualdevModelDataInfoVO infoVO = null;
                            if (localCache.containsKey(redisKey2) || cacheUtil.exists(redisKey2)) {
                                if (localCache.containsKey(redisKey2)) {
                                    infoVO = (VisualdevModelDataInfoVO)localCache.get(redisKey2);
                                } else {
                                    Object redisVal = cacheUtil.query(redisKey2);
                                    infoVO = redisVal instanceof String ? (VisualdevModelDataInfoVO)JSONObject.parseObject((String)String.valueOf(redisVal), VisualdevModelDataInfoVO.class) : (VisualdevModelDataInfoVO)redisVal;
                                    localCache.put(redisKey2, infoVO);
                                }
                            } else {
                                VisualdevEntity entity = visualdevService.getInfo(swapDataVo.getModelId());
                                String keyId = String.valueOf(dataMap.get(vModel));
                                infoVO = !StringUtils.isEmpty((String)entity.getVisualTables()) && !"[]".equals(entity.getVisualTables()) ? visualDevInfoService.getDetailsDataInfo(keyId, entity) : visualdevModelDataService.infoDataChange(keyId, entity);
                                cacheUtil.insert("fiveMinutesCacheSpace", redisKey2, (Object)infoVO, 300L);
                                localCache.put(redisKey2, infoVO);
                            }
                            if (infoVO == null) break;
                            Map formDataMap = JsonUtil.stringToMap((String)infoVO.getData());
                            String relationField = swapDataVo.getRelationField();
                            if (formDataMap.size() <= 0) break;
                            dataMap.put(vModel + "_id", dataMap.get(vModel));
                            dataMap.put(vModel, formDataMap.get(relationField));
                            break;
                        }
                        case "popupSelect": {
                            ActionResult data;
                            String redisKey2 = String.format("%s-%s-%s", dsName, OnlineDataTypeEnum.DYNAMIC.getType(), swapDataVo.getInterfaceId());
                            if (localCache.containsKey(redisKey2) || cacheUtil.exists(redisKey2)) {
                                if (localCache.containsKey(redisKey2)) {
                                    data = (ActionResult)localCache.get(redisKey2);
                                } else {
                                    Object redisVal = cacheUtil.query(redisKey2);
                                    data = redisVal instanceof String ? (ActionResult)JSONObject.parseObject((String)String.valueOf(redisVal), ActionResult.class) : (ActionResult)redisVal;
                                    localCache.put(redisKey2, data);
                                }
                            } else {
                                data = dataInterfaceService.infoToId(swapDataVo.getInterfaceId());
                                cacheUtil.insert("foreverCacheSpace", redisKey2, (Object)JSONObject.toJSONString((Object)data));
                                localCache.put(redisKey2, data);
                            }
                            if (data == null || data.getData() == null) break;
                            List mapList = new ArrayList();
                            if (data.getData() instanceof DataInterfaceActionVo) {
                                DataInterfaceActionVo actionVo = (DataInterfaceActionVo)data.getData();
                                if (actionVo.getData() instanceof List) {
                                    mapList = (List)actionVo.getData();
                                }
                            } else if (data.getData() instanceof List) {
                                mapList = (List)data.getData();
                            } else if (data.getData() instanceof JSONObject) {
                                Map map2 = JsonUtil.entityToMap((Object)data.getData());
                                mapList = JsonUtil.getJsonToListMap((String)String.valueOf(map2.get("data")));
                            }
                            mapList.stream().filter(map -> map.get(swapDataVo.getPropsValue()).equals(dataMap.get(vModel))).forEach(modelMap -> dataMap.put(vModel, modelMap.get(swapDataVo.getRelationField())));
                            break;
                        }
                        case "modifyTime": 
                        case "createTime": 
                        case "date": {
                            String format;
                            String dateSwapInfo;
                            String dateData = String.valueOf(dataMap.get(vModel));
                            String string = swapDataVo.getFormat() != null ? swapDataVo.getFormat() : (dateSwapInfo = swapDataVo.getType() != null && swapDataVo.getType().equals("date") ? "yyyy-MM-dd" : "yyyy-MM-dd HH:mm:ss");
                            if (!dateData.contains("-") && !dateData.contains(":") && dateData.length() > 10) {
                                DateTimeFormatter ftf = DateTimeFormatter.ofPattern(dateSwapInfo);
                                format = ftf.format(LocalDateTime.ofInstant(Instant.ofEpochMilli((Long)dataMap.get(vModel)), ZoneId.of("+8")));
                            } else {
                                format = dateData;
                            }
                            if (format.contains(".")) {
                                format = format.substring(0, format.lastIndexOf("."));
                            }
                            SimpleDateFormat sdf = new SimpleDateFormat(dateSwapInfo);
                            Date date = sdf.parse(format);
                            String outTime = sdf.format(sdf.parse(DateUtil.dateFormat((Date)date)));
                            dataMap.put(vModel, outTime);
                            break;
                        }
                    }
                    if (dataType == null || keyName.equals("cascader") || keyName.equals("checkbox")) continue;
                    if (dataType.equals(OnlineDataTypeEnum.STATIC.getType())) {
                        redisKey = String.format("%s-%s-%s", visualDevId, swapDataVo.getVModel(), OnlineDataTypeEnum.STATIC.getType());
                        Map staticMap = (Map)localCache.get(redisKey);
                        s = OnlinePublicUtils.getDataInMethod(staticMap, dataMap.get(vModel), isMultiple);
                        dataMap.put(vModel, s);
                        continue;
                    }
                    if (dataType.equals(OnlineDataTypeEnum.DYNAMIC.getType())) {
                        redisKey = String.format("%s-%s-%s-%s-%s-", dsName, OnlineDataTypeEnum.DYNAMIC.getType(), swapDataVo.getConfig().getPropsUrl(), swapDataVo.getConfig().getProps().getLabel(), swapDataVo.getConfig().getProps().getValue());
                        if (keyName.equals("treeSelect")) {
                            redisKey = String.format("%s-%s-%s-%s-%s-%s", dsName, OnlineDataTypeEnum.DYNAMIC.getType(), swapDataVo.getConfig().getPropsUrl(), swapDataVo.getProps().getProps().getLabel(), swapDataVo.getProps().getProps().getValue(), swapDataVo.getProps().getProps().getChildren());
                        }
                        Map dynamicMap = (Map)localCache.get(redisKey);
                        s = OnlinePublicUtils.getDataInMethod(dynamicMap, dataMap.get(vModel), isMultiple);
                        dataMap.put(vModel, s);
                        continue;
                    }
                    if (!dataType.equals(OnlineDataTypeEnum.DICTIONARY.getType())) continue;
                    redisKey = String.format("%s-%s-%s", dsName, OnlineDataTypeEnum.DICTIONARY.getType(), swapDataVo.getConfig().getDictionaryType());
                    Object dicObj = localCache.get(redisKey);
                    List dictionaryList = dicObj instanceof String ? JsonUtil.getJsonToListMap((String)String.valueOf(localCache.get(redisKey))) : (List)dicObj;
                    Map<String, Object> dataInterfaceMap = OnlinePublicUtils.getDataMap((List<Map<String, Object>>)dictionaryList, swapDataVo);
                    String s3 = OnlinePublicUtils.getDataInMethod(dataInterfaceMap, dataMap.get(vModel), isMultiple);
                    dataMap.put(vModel, s3);
                }
                catch (Exception e) {
                    log.error("\u5728\u7ebf\u5f00\u53d1\u8f6c\u6362\u6570\u636e\u9519\u8bef:" + e.getMessage());
                }
            }
        }
        return list;
    }

    public static void pageIdList(List<OnlineDevListDataVO> list, List<OnlineFieldsModel> swapDataVoList, Map<String, Object> localCache) {
        Set userList = (Set)localCache.get("__user_list");
        Set orgList = (Set)localCache.get("__org_list");
        Set posList = (Set)localCache.get("__pos_list");
        Set AllOrgList = (Set)localCache.get("__allOrg_list");
        for (OnlineFieldsModel swapDataVo : swapDataVoList) {
            String keyName = swapDataVo.getConfig().getKeyName();
            String vModel = swapDataVo.getVModel();
            for (OnlineDevListDataVO listVo : list) {
                Map<String, Object> dataMap = listVo.getData();
                if (StringUtils.isEmpty((String)String.valueOf(dataMap.get(vModel))) || dataMap.get(vModel) == null || String.valueOf(dataMap.get(vModel)).equals("[]") || String.valueOf(dataMap.get(vModel)).equals("null")) continue;
                switch (keyName) {
                    case "comSelect": 
                    case "depSelect": 
                    case "currDept": 
                    case "currOrganize": {
                        if ("all".equals(swapDataVo.getShowLevel())) {
                            OnlineDevListUtils.getIdInMethod(AllOrgList, dataMap.get(vModel));
                            break;
                        }
                        OnlineDevListUtils.getIdInMethod(orgList, dataMap.get(vModel));
                        break;
                    }
                    case "posSelect": 
                    case "currPosition": {
                        OnlineDevListUtils.getIdInMethod(posList, dataMap.get(vModel));
                        break;
                    }
                    case "userSelect": 
                    case "createUser": 
                    case "modifyUser": {
                        OnlineDevListUtils.getIdInMethod(userList, dataMap.get(vModel));
                        break;
                    }
                }
            }
        }
    }

    public static Collection<String> getIdInMethod(Collection<String> idList, Object modelData) {
        if (OnlinePublicUtils.getMultiple(String.valueOf(modelData), MultipleControlEnum.MULTIPLE_JSON_TWO.getMultipleChar()).booleanValue()) {
            String[][] data;
            String[][] stringArray = data = (String[][])JsonUtil.getJsonToBean((String)String.valueOf(modelData), String[][].class);
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String[] AddressData;
                for (String s : AddressData = stringArray[i]) {
                    idList.add(s);
                }
            }
        } else if (OnlinePublicUtils.getMultiple(String.valueOf(modelData), MultipleControlEnum.MULTIPLE_JSON_ONE.getMultipleChar()).booleanValue()) {
            idList.addAll(JsonUtil.getJsonToList((String)String.valueOf(modelData), String.class));
        } else {
            String[] modelDatas = String.valueOf(modelData).split(",");
            for (int i = 0; i < modelDatas.length; ++i) {
                idList.add(modelDatas[i]);
            }
        }
        return idList;
    }

    public static void sysNeedSwapData(List<OnlineFieldsModel> swapDataVoList, String visualDevId, Map<String, Object> localCache) {
        OnlineDevListUtils.init();
        String dsName = Optional.ofNullable(DataSourceContextHolder.getDatasourceId()).orElse("");
        try {
            for (OnlineFieldsModel swapDataVo : swapDataVoList) {
                JSONArray data;
                String value;
                String label;
                String redisKey;
                String keyName = swapDataVo.getConfig().getKeyName();
                String dataType = swapDataVo.getConfig().getDataType();
                switch (keyName) {
                    case "address": {
                        redisKey = dsName + CacheKeyEnum.PRO.getName();
                        if (!cacheUtil.exists("oneWeekCacheSpace", redisKey)) {
                            List provinceEntityList = provinceService.getAllProList();
                            HashMap provinceMap = new HashMap(16);
                            provinceEntityList.stream().forEach(p -> provinceMap.put(p.getId(), p.getFullName()));
                            cacheUtil.insert("oneWeekCacheSpace", redisKey, provinceMap, 604800L);
                        }
                        if (localCache.containsKey(redisKey)) break;
                        localCache.put(redisKey, cacheUtil.getMap(redisKey));
                        break;
                    }
                }
                if (dataType == null) continue;
                String children = "";
                ArrayList<Map<String, Object>> options = new ArrayList();
                if (swapDataVo.getConfig().getKeyName().equals("cascader") || swapDataVo.getConfig().getKeyName().equals("treeSelect")) {
                    label = swapDataVo.getProps().getProps().getLabel();
                    value = swapDataVo.getProps().getProps().getValue();
                    children = swapDataVo.getProps().getProps().getChildren();
                } else {
                    label = swapDataVo.getConfig().getProps().getLabel();
                    value = swapDataVo.getConfig().getProps().getValue();
                }
                HashMap dataInterfaceMap = new HashMap(16);
                if (dataType.equals(OnlineDataTypeEnum.STATIC.getType())) {
                    redisKey = String.format("%s-%s-%s", visualDevId, swapDataVo.getVModel(), OnlineDataTypeEnum.STATIC.getType());
                    if (!cacheUtil.exists("fiveMinutesCacheSpace", redisKey)) {
                        if (swapDataVo.getOptions() != null) {
                            options = JsonUtil.getJsonToListMap((String)swapDataVo.getOptions());
                            String Children = swapDataVo.getProps().getProps().getChildren();
                            data = JsonUtil.getListToJsonArray(options);
                            OnlineDevListUtils.getOptions(label, value, Children, data, options);
                        } else {
                            options = swapDataVo.getSlot().getOptions();
                        }
                        options.stream().forEach(o -> dataInterfaceMap.put(String.valueOf(o.get(value)), String.valueOf(o.get(label))));
                        String staticData = JsonUtil.getObjectToString(dataInterfaceMap);
                        cacheUtil.insert("fiveMinutesCacheSpace", redisKey, (Object)staticData, 300L);
                        if (!localCache.containsKey(redisKey)) {
                            localCache.put(redisKey, dataInterfaceMap);
                        }
                    } else if (!localCache.containsKey(redisKey)) {
                        String staticDataString = cacheUtil.query("fiveMinutesCacheSpace", redisKey).toString();
                        localCache.put(redisKey, JsonUtil.stringToMap((String)staticDataString));
                    }
                }
                if (dataType.equals(OnlineDataTypeEnum.DYNAMIC.getType())) {
                    redisKey = String.format("%s-%s-%s", dsName, OnlineDataTypeEnum.DYNAMIC.getType(), swapDataVo.getConfig().getPropsUrl());
                    String redisKey2 = String.format("%s-%s-%s-%s-%s-%s", dsName, OnlineDataTypeEnum.DYNAMIC.getType(), swapDataVo.getConfig().getPropsUrl(), label, value, children);
                    if (!cacheUtil.exists(redisKey2)) {
                        data = null;
                        if (!cacheUtil.exists("fiveMinutesCacheSpace", redisKey)) {
                            data = dataInterfaceService.infoToId(swapDataVo.getConfig().getPropsUrl());
                            cacheUtil.insert("fiveMinutesCacheSpace", redisKey, (Object)JSONObject.toJSONString((Object)data), 300L);
                        } else {
                            data = (ActionResult)JSONObject.parseObject((String)String.valueOf(cacheUtil.query("fiveMinutesCacheSpace", redisKey)), ActionResult.class);
                        }
                        if (!localCache.containsKey(redisKey)) {
                            localCache.put(redisKey, data);
                        }
                        if (data != null && data.getData() != null) {
                            List dataList = new ArrayList();
                            if (data.getData() instanceof DataInterfaceActionVo) {
                                DataInterfaceActionVo actionVo = (DataInterfaceActionVo)data.getData();
                                if (actionVo.getData() instanceof List) {
                                    dataList = (List)actionVo.getData();
                                }
                            } else if (data.getData() instanceof List) {
                                dataList = (List)data.getData();
                            }
                            JSONArray dataAll = JsonUtil.getListToJsonArray(dataList);
                            OnlineDevListUtils.treeToList(label, value, children, dataAll, options);
                            options.stream().forEach(o -> dataInterfaceMap.put(String.valueOf(o.get(value)), String.valueOf(o.get(label))));
                            String dynamicData = JsonUtil.getObjectToString(dataInterfaceMap);
                            cacheUtil.insert("fiveMinutesCacheSpace", redisKey2, (Object)dynamicData, 300L);
                            localCache.put(redisKey2, dataInterfaceMap);
                        }
                    } else {
                        if (!localCache.containsKey(redisKey)) {
                            localCache.put(redisKey, JSONObject.parseObject((String)String.valueOf(cacheUtil.query("fiveMinutesCacheSpace", redisKey)), ActionResult.class));
                        }
                        if (!localCache.containsKey(redisKey2)) {
                            String dynamicString = cacheUtil.query("fiveMinutesCacheSpace", redisKey2).toString();
                            localCache.put(redisKey2, JsonUtil.stringToMap((String)dynamicString));
                        }
                    }
                }
                if (!dataType.equals(OnlineDataTypeEnum.DICTIONARY.getType())) continue;
                redisKey = String.format("%s-%s-%s", dsName, OnlineDataTypeEnum.DICTIONARY.getType(), swapDataVo.getConfig().getDictionaryType());
                if (!cacheUtil.exists("fiveMinutesCacheSpace", redisKey)) {
                    List list = dictionaryDataService.getDicList(swapDataVo.getConfig().getDictionaryType());
                    options = list.stream().map(dic -> {
                        HashMap<String, String> dictionaryMap = new HashMap<String, String>(16);
                        dictionaryMap.put("id", dic.getId());
                        dictionaryMap.put("enCode", dic.getEnCode());
                        dictionaryMap.put("fullName", dic.getFullName());
                        return dictionaryMap;
                    }).collect(Collectors.toList());
                    String dictionaryData = JsonUtil.getObjectToString(options);
                    cacheUtil.insert("fiveMinutesCacheSpace", redisKey, (Object)dictionaryData, 300L);
                    localCache.put(redisKey, options);
                    continue;
                }
                if (localCache.containsKey(redisKey)) continue;
                String dictionaryStringData = cacheUtil.query("fiveMinutesCacheSpace", redisKey).toString();
                localCache.put(redisKey, JsonUtil.getJsonToListMap((String)dictionaryStringData));
            }
        }
        catch (Exception e) {
            log.error("\u5728\u7ebf\u5f00\u53d1\u8f6c\u6362\u6570\u636e\u5f02\u5e38:" + e.getMessage());
            e.printStackTrace();
        }
    }

    public static void getOptions(String label, String value, String Children, JSONArray data, List<Map<String, Object>> options) {
        for (int i = 0; i < data.size(); ++i) {
            JSONObject ob = data.getJSONObject(i);
            HashMap<String, String> tree = new HashMap<String, String>(16);
            tree.put(value, String.valueOf(ob.get((Object)value)));
            tree.put(label, String.valueOf(ob.get((Object)label)));
            options.add(tree);
            if (ob.get((Object)Children) == null) continue;
            JSONArray childrenArray = ob.getJSONArray(Children);
            OnlineDevListUtils.getOptions(label, value, Children, childrenArray, options);
        }
    }

    public static List<Map<String, Object>> groupData(List<Map<String, Object>> realList, ColumnDataModel columnDataModel) {
        List columnList = JsonUtil.getJsonToListMap((String)columnDataModel.getColumnList());
        String groupField = columnDataModel.getGroupField();
        Map map = columnList.stream().filter(t -> !String.valueOf(t.get("prop")).equals(columnDataModel.getGroupField())).findFirst().orElse(null);
        if (map == null) {
            map = columnList.stream().filter(t -> String.valueOf(t.get("prop")).equals(columnDataModel.getGroupField())).findFirst().orElse(null);
        }
        String firstField = String.valueOf(map.get("prop"));
        HashMap<String, List> twoMap = new HashMap<String, List>(16);
        for (Map<String, Object> realMap : realList) {
            boolean isKey;
            String value = String.valueOf(realMap.get(groupField));
            boolean bl = isKey = twoMap.get(value) != null;
            if (isKey) {
                List maps = (List)twoMap.get(value);
                maps.add(realMap);
                twoMap.put(value, maps);
                continue;
            }
            ArrayList<Map<String, Object>> childrenList = new ArrayList<Map<String, Object>>();
            childrenList.add(realMap);
            twoMap.put(value, childrenList);
        }
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        for (String key : twoMap.keySet()) {
            HashMap<String, Object> thirdMap = new HashMap<String, Object>(16);
            thirdMap.put(firstField, !key.equals("null") ? key : "");
            thirdMap.put("top", true);
            thirdMap.put("id", RandomUtil.uuId());
            thirdMap.put("children", twoMap.get(key));
            resultList.add(thirdMap);
        }
        return resultList;
    }

    private static void treeToList(String value, String label, String children, JSONArray data, List<Map<String, Object>> result) {
        for (int i = 0; i < data.size(); ++i) {
            JSONObject ob = data.getJSONObject(i);
            HashMap<String, String> tree = new HashMap<String, String>(16);
            tree.put(value, String.valueOf(ob.get((Object)value)));
            tree.put(label, String.valueOf(ob.get((Object)label)));
            result.add(tree);
            if (ob.get((Object)children) == null) continue;
            JSONArray childArray = ob.getJSONArray(children);
            OnlineDevListUtils.treeToList(value, label, children, childArray, result);
        }
    }
}

