package com.bringspring.visualdev.portal.service.impl;


import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.*;
import com.bringspring.common.util.enums.DictionaryDataEnum;
import com.bringspring.system.base.entity.DictionaryDataEntity;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.system.permission.entity.AuthorizeEntity;
import com.bringspring.system.permission.entity.RoleEntity;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.service.RoleService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.visualdev.portal.entity.PortalEntity;
import com.bringspring.visualdev.portal.mapper.PortalMapper;
import com.bringspring.visualdev.portal.model.PortalPagination;
import com.bringspring.visualdev.portal.model.PortalSelectModel;
import com.bringspring.visualdev.portal.service.PortalService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021/3/16
 */
@Service
public class PortalServiceImpl extends ServiceImpl<PortalMapper, PortalEntity> implements PortalService {

    @Autowired
    private PortalService portalService;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private UserService userService;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private DictionaryDataService dictionaryDataService;
    @Autowired
    private RoleService roleService;

    @Override
    public List<PortalEntity> getList(PortalPagination portalPagination) {
        // 定义变量判断是否需要使用修改时间倒序
        boolean flag = false;
        QueryWrapper<PortalEntity> queryWrapper = new QueryWrapper<>();
        if (!StringUtils.isEmpty(portalPagination.getKeyword())) {
            flag = true;
            queryWrapper.lambda().like(PortalEntity::getFullName, portalPagination.getKeyword());
        }
        if (StringUtils.isNotEmpty(portalPagination.getCategory())){
            flag = true;
            queryWrapper.lambda().eq(PortalEntity::getCategory, portalPagination.getCategory());
        }
        queryWrapper.lambda().orderByAsc(PortalEntity::getSortCode).orderByDesc(PortalEntity::getCreatorTime);
        if (flag) {
            queryWrapper.lambda().orderByDesc(PortalEntity::getLastModifyTime);
        }
        Page<PortalEntity> page = new Page<>(portalPagination.getCurrentPage(), portalPagination.getPageSize());
        IPage<PortalEntity> userPage = this.page(page, queryWrapper);
        return portalPagination.setData(userPage.getRecords(), page.getTotal());
    }


    @Override
    public List<PortalEntity> getList() {
        QueryWrapper<PortalEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().orderByAsc(PortalEntity::getSortCode).orderByDesc(PortalEntity::getCreatorTime);
        return this.list(queryWrapper);
    }

    @Override
    public List<PortalEntity> getListAll(String enabledMark) {
        QueryWrapper<PortalEntity> queryWrapper = new QueryWrapper<>();
        // postgreSQL数字类型不能使用String
        queryWrapper.lambda().eq(PortalEntity::getEnabledMark, Integer.parseInt(enabledMark));
        queryWrapper.lambda().orderByAsc(PortalEntity::getSortCode).orderByDesc(PortalEntity::getCreatorTime);
        return this.list(queryWrapper);
    }

    @Override
    public PortalEntity getInfo(String id) {
        QueryWrapper<PortalEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(PortalEntity::getId, id);
        return this.getOne(queryWrapper);
    }

    @Override
    public void create(PortalEntity entity) {
        if (StringUtils.isEmpty(entity.getId())) {
            entity.setId(RandomUtil.uuId());
        }
        this.save(entity);
    }

    @Override
    public boolean update(String id, PortalEntity entity) {
        entity.setId(id);
        entity.setLastModifyTime(DateUtil.getNowDate());
        return this.updateById(entity);
    }

    @Override
    public void delete(PortalEntity entity) {
        if (entity != null) {
            this.removeById(entity.getId());
        }
    }

    @Override
    public List<PortalSelectModel> getList(String type) {
        List<PortalEntity> list = portalService.getListAll("1");
        UserInfo userInfo = userProvider.get();
        if ("1".equals(type) && userInfo != null && !userInfo.getIsAdministrator()) {
            List<String> roleIds = CollectionUtil.list(false);
            List<RoleEntity> listByUserId = roleService.getListByUserId(userInfo.getUserId());
            if (CollectionUtil.isNotEmpty(listByUserId)){
                roleIds = listByUserId.stream().map(RoleEntity::getId).collect(Collectors.toList());
            }
            List<String> itemIds = new ArrayList<>();
            Set<String> set = new HashSet<>(16);
            List<PortalEntity> newPortalList = new ArrayList<>();
            for (String ids : roleIds) {
                List<AuthorizeEntity> authorizeEntityList = authorizeService.getListByObjectId(ids,"portal");
                for (AuthorizeEntity authorizeEntity : authorizeEntityList) {
                    itemIds.add(authorizeEntity.getItemId());
                }
            }
            set.addAll(itemIds);
            for (PortalEntity entity : list) {
                for (String iid : set) {
                    if (iid.equals(entity.getId())) {
                        newPortalList.add(entity);
                    }
                }
            }
            list = newPortalList;
        }
        List<PortalSelectModel> modelList = JsonUtil.getJsonToList(list, PortalSelectModel.class);

        // 外层菜单排序取数据字典
        List<DictionaryDataEntity> entityList = dictionaryDataService.getList(DictionaryDataEnum.VISUALDEV_PORTAL.getDictionaryTypeId());
        for (DictionaryDataEntity dataEntity : entityList) {
            // 当前分类下不含有数据则不显示
            List<PortalEntity> num = list.stream().filter(t -> dataEntity.getId().equals(t.getCategory())).collect(Collectors.toList());
            if (num.size() <= 0) {
                continue;
            }
            PortalSelectModel model = new PortalSelectModel();
            model.setId(dataEntity.getId());
            model.setFullName(dataEntity.getFullName());
            model.setParentId("0");
            model.setEnCode(dataEntity.getEnCode());
            if (!modelList.contains(model)) {
                modelList.add(model);
            }
        }
        return modelList;
    }

}
