/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.visualdev.base.util;

import com.bringspring.common.util.FileUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.visualdev.base.model.read.ReadEnum;
import com.bringspring.visualdev.base.model.read.ReadListVO;
import com.bringspring.visualdev.base.model.read.ReadModel;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadFile {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReadFile.class);

    public static List<ReadListVO> priviewCode(String codePath) {
        File fileAll = new File(XSSEscape.escapePath((String)codePath));
        ArrayList fileList = new ArrayList();
        if (fileAll.exists()) {
            FileUtil.getFile((File)fileAll, fileList);
        }
        LinkedHashMap data = new LinkedHashMap();
        for (int i = fileList.size() - 1; i >= 0; --i) {
            File file = (File)fileList.get(i);
            String path = file.getAbsolutePath();
            ReadEnum readEnum = ReadEnum.getMessage(path);
            if (readEnum == null) continue;
            ReadModel readModel = new ReadModel();
            String fileContent = ReadFile.readFile(file);
            readModel.setFileContent(fileContent);
            readModel.setFileName(file.getName());
            readModel.setFileType(readEnum.getMessage());
            readModel.setId(RandomUtil.uuId());
            String folderName = FileUtil.getFileType((File)file);
            readModel.setFolderName(folderName);
            ArrayList<ReadModel> readModelList = data.get(readEnum.getMessage()) != null ? (List)data.get(readEnum.getMessage()) : new ArrayList<ReadModel>();
            readModelList.add(readModel);
            data.put(readEnum.getMessage(), readModelList);
        }
        ArrayList<ReadListVO> list = new ArrayList<ReadListVO>();
        for (String fileName : data.keySet()) {
            ReadListVO listVO = new ReadListVO();
            listVO.setFileName(fileName);
            listVO.setChildren((List)data.get(fileName));
            listVO.setId(RandomUtil.uuId());
            list.add(listVO);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFile(File path) {
        String fileRead = "";
        try {
            FileInputStream is = new FileInputStream(path);
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                try {
                    int n;
                    byte[] buffer = new byte[1024];
                    while ((n = ((InputStream)is).read(buffer)) != -1) {
                        out.write(buffer, 0, n);
                    }
                    ((InputStream)is).close();
                    fileRead = out.toString();
                }
                finally {
                    if (Collections.singletonList(out).get(0) != null) {
                        out.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(is).get(0) != null) {
                    ((InputStream)is).close();
                }
            }
        }
        catch (IOException e) {
            log.error("\u4ee3\u7801\u751f\u6210\u5668\u8bfb\u53d6\u6587\u4ef6\u62a5\u9519:" + e.getMessage());
        }
        return fileRead;
    }
}

