/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.visualdev.base.util;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.database.model.dto.PreparedStatementDTO;
import com.bringspring.common.database.model.entity.DbLinkEntity;
import com.bringspring.common.database.model.interfaces.DbSourceOrDbLink;
import com.bringspring.common.database.util.ConnUtil;
import com.bringspring.common.database.util.DataSourceUtil;
import com.bringspring.common.database.util.DbTypeUtil;
import com.bringspring.common.database.util.JdbcUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.model.FormAllModel;
import com.bringspring.common.model.FormEnum;
import com.bringspring.common.model.visiual.ColumnDataModel;
import com.bringspring.common.model.visiual.FormCloumnUtil;
import com.bringspring.common.model.visiual.FormDataModel;
import com.bringspring.common.model.visiual.RecursionForm;
import com.bringspring.common.model.visiual.TableFields;
import com.bringspring.common.model.visiual.TableModel;
import com.bringspring.common.model.visiual.TimeControl;
import com.bringspring.common.model.visiual.fields.FieLdsModel;
import com.bringspring.common.model.visiual.fields.config.ConfigModel;
import com.bringspring.common.model.visiual.fields.props.PropsBeanModel;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.context.SpringContext;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.visualdev.base.entity.VisualdevEntity;
import com.bringspring.visualdev.base.util.DynamicUtil;
import com.bringspring.visualdev.onlinedev.entity.VisualdevModelDataEntity;
import com.bringspring.visualdev.onlinedev.model.OnlineDevListModel.VisualColumnSearchVO;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VisualUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VisualUtils.class);
    private static DbSourceOrDbLink dbSourceOrDbLink;
    private static DataSourceUtil dataSourceUtil;
    private static ConfigValueUtil configValueUtil;
    private static UserProvider userProvider;

    public static void init() {
        configValueUtil = (ConfigValueUtil)SpringContext.getBean(ConfigValueUtil.class);
        userProvider = (UserProvider)SpringContext.getBean(UserProvider.class);
        dataSourceUtil = (DataSourceUtil)SpringContext.getBean(DataSourceUtil.class);
        dbSourceOrDbLink = (DbSourceOrDbLink)SpringContext.getBean(DbSourceOrDbLink.class);
    }

    public static List<FieLdsModel> deleteVmodel(List<FieLdsModel> modelList) {
        ArrayList<FieLdsModel> newModelList = new ArrayList<FieLdsModel>();
        for (FieLdsModel model : modelList) {
            if ("table".equals(model.getConfig().getKeyName())) {
                List childModelList = JsonUtil.getJsonToList((Object)model.getConfig().getChildren(), FieLdsModel.class);
                ArrayList<FieLdsModel> newchildModelList = new ArrayList<FieLdsModel>();
                for (FieLdsModel childModel : childModelList) {
                    if (!StringUtils.isNotEmpty((String)childModel.getVModel())) continue;
                    newchildModelList.add(childModel);
                }
                model.getConfig().setChildren(newchildModelList);
                newModelList.add(model);
                continue;
            }
            if (!StringUtils.isNotEmpty((String)model.getVModel())) continue;
            newModelList.add(model);
        }
        return newModelList;
    }

    public static List<FieLdsModel> deleteMoreVmodel(FieLdsModel model) {
        if ("".equals(model.getVModel()) && model.getConfig().getChildren() != null) {
            List childModelList = JsonUtil.getJsonToList((Object)model.getConfig().getChildren(), FieLdsModel.class);
            return childModelList;
        }
        return null;
    }

    public static List<FieLdsModel> deleteMore(List<FieLdsModel> modelList) {
        ArrayList<FieLdsModel> newModelList = new ArrayList<FieLdsModel>();
        for (FieLdsModel model : modelList) {
            List<FieLdsModel> newList = VisualUtils.deleteMoreVmodel(model);
            if (newList == null || "table".equals(model.getConfig().getKeyName())) {
                newModelList.add(model);
                continue;
            }
            newModelList.addAll(VisualUtils.deleteMore(newList));
        }
        return newModelList;
    }

    public static List<VisualdevModelDataEntity> getTableDataList(Connection conn, String sql, String pKeyName) throws SQLException, DataException {
        ArrayList<VisualdevModelDataEntity> list = new ArrayList<VisualdevModelDataEntity>();
        List dataList = JdbcUtil.queryListLowercase((PreparedStatementDTO)new PreparedStatementDTO(conn, sql));
        for (Map<String, Object> dataMap : dataList) {
            VisualdevModelDataEntity dataEntity = new VisualdevModelDataEntity();
            dataMap = VisualUtils.toLowerKey(dataMap);
            dataEntity.setData(JsonUtil.getObjectToStringDateFormat(dataMap, (String)"yyyy-MM-dd HH:mm"));
            if (dataMap.containsKey(pKeyName.toUpperCase())) {
                dataEntity.setId(String.valueOf(dataMap.get(pKeyName.toUpperCase())));
            }
            list.add(dataEntity);
        }
        return list;
    }

    public static Boolean existKey(String feilds, String pKeyName) {
        String[] strs = feilds.split(",");
        if (strs.length > 0) {
            for (String feild : strs) {
                if (!feild.equals(pKeyName)) continue;
                return true;
            }
        }
        return false;
    }

    public static String getInsertSql(String table, String feilds, String mainpKeyName, String childPkName, String mainId) {
        StringBuilder insertSql = new StringBuilder();
        feilds = feilds.toLowerCase().trim();
        mainpKeyName = mainpKeyName.toLowerCase();
        childPkName = childPkName.toLowerCase();
        if (VisualUtils.existKey(feilds, mainpKeyName).booleanValue() && VisualUtils.existKey(feilds, childPkName).booleanValue()) {
            insertSql.append("INSERT INTO " + table + "(" + feilds + ")  VALUES (");
        } else if (VisualUtils.existKey(feilds, mainpKeyName).booleanValue() && !VisualUtils.existKey(feilds, childPkName).booleanValue()) {
            insertSql.append("INSERT INTO " + table + "(" + childPkName + "," + feilds + ")  VALUES ('" + RandomUtil.uuId() + "',");
        } else if (!VisualUtils.existKey(feilds, mainpKeyName).booleanValue() && VisualUtils.existKey(feilds, childPkName).booleanValue()) {
            insertSql.append("INSERT INTO " + table + "(" + mainpKeyName + "," + feilds + ")  VALUES ('" + mainId + "',");
        } else {
            insertSql.append("INSERT INTO " + table + "(" + childPkName + "," + mainpKeyName + "," + feilds + ")  VALUES ('" + RandomUtil.uuId() + "','" + mainId + "',");
        }
        return insertSql.toString();
    }

    public static String getRealSql(String baseSql, String mainId) {
        String[] sql = baseSql.split(",");
        Object realSql = baseSql;
        if (sql.length == 2) {
            realSql = "('" + RandomUtil.uuId() + "'," + sql[1] + ",";
        } else if (sql.length == 1 && !baseSql.contains(mainId)) {
            realSql = "('" + RandomUtil.uuId() + "',";
        }
        return realSql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getpKey(Connection conn, String mainTable) throws SQLException {
        String pKeyName = "id";
        String catalog = conn.getCatalog();
        ResultSet primaryKeyResultSet = conn.getMetaData().getPrimaryKeys(catalog, null, mainTable);
        try {
            while (primaryKeyResultSet.next()) {
                pKeyName = primaryKeyResultSet.getString("COLUMN_NAME");
            }
            primaryKeyResultSet.close();
            String string = pKeyName;
            return string;
        }
        finally {
            if (Collections.singletonList(primaryKeyResultSet).get(0) != null) {
                primaryKeyResultSet.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Map<String, Object>> getTableDataInfo(String sql, DbLinkEntity linkEntity) throws DataException, SQLException {
        Connection conn = VisualUtils.getTableConn();
        try {
            if (linkEntity != null) {
                conn = VisualUtils.getDataConn(linkEntity);
            }
            List dataList = JdbcUtil.queryListLowercase((PreparedStatementDTO)new PreparedStatementDTO(conn, sql));
            for (Map dataMap : dataList) {
                for (Map.Entry entry : dataMap.entrySet()) {
                    if (entry.getValue() == null || !String.valueOf(entry.getValue()).contains(",") || "[\"".equals(String.valueOf(entry.getValue()).substring(0, 2)) || !entry.getValue().toString().contains("]")) continue;
                    JSONArray list = JsonUtil.getJsonToJsonArray((String)String.valueOf(entry.getValue()));
                    entry.setValue(list);
                }
            }
            List list = dataList;
            return list;
        }
        finally {
            if (Collections.singletonList(conn).get(0) != null) {
                conn.close();
            }
        }
    }

    public static List<Map<String, Object>> swapTableDataInfoList(List<FieLdsModel> modelList, List<Map<String, Object>> dataMapList) throws ParseException {
        ArrayList<Map<String, Object>> newDataMapList = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> dataMap : dataMapList) {
            HashMap<String, Object> newDataMap = new HashMap<String, Object>(16);
            for (FieLdsModel fieLdsModel : modelList) {
                for (Map.Entry<String, Object> entryMap : dataMap.entrySet()) {
                    List list;
                    String value;
                    if (!entryMap.getKey().equals(fieLdsModel.getVModel())) continue;
                    if ("uploadFz".equals(fieLdsModel.getConfig().getKeyName()) || "uploadImg".equals(fieLdsModel.getConfig().getKeyName())) {
                        value = String.valueOf(entryMap.getValue());
                        if ("[]".equals(value)) continue;
                        List map = JsonUtil.getJsonToListMap((String)value);
                        newDataMap.put(entryMap.getKey(), map);
                        continue;
                    }
                    if ("checkbox".equals(fieLdsModel.getConfig().getKeyName())) {
                        list = JsonUtil.getJsonToList((String)String.valueOf(entryMap.getValue()), String.class);
                        newDataMap.put(entryMap.getKey(), list);
                        continue;
                    }
                    if ("createTime".equals(fieLdsModel.getConfig().getKeyName()) || "modifyTime".equals(fieLdsModel.getConfig().getKeyName())) {
                        newDataMap.put(entryMap.getKey(), String.valueOf(entryMap.getValue()));
                        continue;
                    }
                    if (fieLdsModel.getConfig().getKeyName().contains("date") && entryMap.getValue() != null) {
                        if (entryMap.getValue().toString().contains(",")) {
                            list = JsonUtil.getJsonToList((String)String.valueOf(entryMap.getValue()), String.class);
                            SimpleDateFormat sdf = new SimpleDateFormat(fieLdsModel.getFormat());
                            ArrayList<Object> newList = new ArrayList<Object>();
                            for (String dateStr : list) {
                                try {
                                    newList.add(Long.valueOf(dateStr));
                                }
                                catch (Exception e) {
                                    Long s = sdf.parse(dateStr).getTime();
                                    newList.add(s.toString());
                                }
                            }
                            newDataMap.put(entryMap.getKey(), newList);
                            continue;
                        }
                        SimpleDateFormat sdf = new SimpleDateFormat(fieLdsModel.getFormat());
                        Long s = sdf.parse(entryMap.getValue().toString()).getTime();
                        newDataMap.put(entryMap.getKey(), s);
                        continue;
                    }
                    if ("cascader".equals(fieLdsModel.getConfig().getKeyName())) {
                        if (entryMap.getKey().equals(fieLdsModel.getVModel()) && (entryMap.getValue() != null || entryMap.getValue() != "")) {
                            value = String.valueOf(entryMap.getValue());
                            List list2 = JsonUtil.getJsonToList((String)value, String.class);
                            entryMap.setValue(list2);
                        }
                        newDataMap.put(entryMap.getKey(), entryMap.getValue());
                        continue;
                    }
                    newDataMap.put(entryMap.getKey(), entryMap.getValue());
                }
            }
            newDataMapList.add(newDataMap);
        }
        return newDataMapList;
    }

    public static Map<String, Object> swapTableDataInfoOne(List<FieLdsModel> modelList, Map<String, Object> dataMap) throws ParseException {
        HashMap<String, Object> newDataMap = new HashMap<String, Object>(16);
        for (FieLdsModel fieLdsModel : modelList) {
            for (Map.Entry<String, Object> entryMap : dataMap.entrySet()) {
                List list;
                if (!entryMap.getKey().equals(fieLdsModel.getVModel())) continue;
                if ("uploadFz".equals(fieLdsModel.getConfig().getKeyName()) || "uploadImg".equals(fieLdsModel.getConfig().getKeyName())) {
                    String value = String.valueOf(entryMap.getValue());
                    if ("[]".equals(value)) continue;
                    List map = JsonUtil.getJsonToListMap((String)value);
                    newDataMap.put(entryMap.getKey(), map);
                    continue;
                }
                if ("switch".equals(fieLdsModel.getConfig().getKeyName())) {
                    newDataMap.put(entryMap.getKey(), entryMap.getValue() != null ? Integer.valueOf(Integer.parseInt(String.valueOf(entryMap.getValue()))) : null);
                    continue;
                }
                if ("slider".equals(fieLdsModel.getConfig().getKeyName())) {
                    newDataMap.put(entryMap.getKey(), entryMap.getValue() != null ? Integer.valueOf(Integer.parseInt(String.valueOf(entryMap.getValue()))) : null);
                    continue;
                }
                if ("checkbox".equals(fieLdsModel.getConfig().getKeyName())) {
                    list = JsonUtil.getJsonToList((String)String.valueOf(entryMap.getValue()), String.class);
                    newDataMap.put(entryMap.getKey(), list);
                    continue;
                }
                if ("createTime".equals(fieLdsModel.getConfig().getKeyName()) || "modifyTime".equals(fieLdsModel.getConfig().getKeyName())) {
                    newDataMap.put(entryMap.getKey(), entryMap.getValue() != null ? String.valueOf(entryMap.getValue()) : "");
                    continue;
                }
                if (fieLdsModel.getConfig().getKeyName().contains("date") && entryMap.getValue() != null) {
                    if (String.valueOf(entryMap.getValue()).contains(",")) {
                        list = JsonUtil.getJsonToList((String)String.valueOf(entryMap.getValue()), String.class);
                        ArrayList<String> newList = new ArrayList<String>();
                        SimpleDateFormat sdf = new SimpleDateFormat(fieLdsModel.getFormat());
                        for (String dateStr : list) {
                            try {
                                Long.valueOf(dateStr);
                            }
                            catch (Exception e) {
                                Long s = sdf.parse(dateStr).getTime();
                                newList.add(s.toString());
                            }
                        }
                        newDataMap.put(entryMap.getKey(), newList);
                        continue;
                    }
                    String fieldFormat = fieLdsModel.getFormat() != null ? fieLdsModel.getFormat() : (fieLdsModel.getType() == "date" ? "yyyy-MM-dd" : "yyyy-MM-dd HH:mm:ss");
                    SimpleDateFormat sdf = new SimpleDateFormat(fieldFormat);
                    Long s = sdf.parse(entryMap.getValue().toString()).getTime();
                    newDataMap.put(entryMap.getKey(), s);
                    continue;
                }
                if ("cascader".equals(fieLdsModel.getConfig().getKeyName()) || "address".equals(fieLdsModel.getConfig().getKeyName())) {
                    if (entryMap.getKey().equals(fieLdsModel.getVModel()) && ObjectUtil.isNotEmpty((Object)entryMap.getValue())) {
                        list = JsonUtil.getJsonToList((Object)entryMap.getValue(), String.class);
                        entryMap.setValue(String.join((CharSequence)",", list));
                    }
                    newDataMap.put(entryMap.getKey(), entryMap.getValue());
                    continue;
                }
                newDataMap.put(entryMap.getKey(), entryMap.getValue());
            }
        }
        return newDataMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void opaTableDataInfo(String sql, DbLinkEntity linkEntity) throws SQLException {
        Connection conn = VisualUtils.getTableConn();
        try {
            if (linkEntity != null) {
                conn = VisualUtils.getDataConn(linkEntity);
            }
            try {
                JdbcUtil.creUpDe((PreparedStatementDTO)new PreparedStatementDTO(conn, sql));
            }
            catch (DataException e) {
                e.printStackTrace();
            }
        }
        finally {
            if (Collections.singletonList(conn).get(0) != null) {
                conn.close();
            }
        }
    }

    public static Connection getTableConn() {
        VisualUtils.init();
        String tenId = !configValueUtil.isMultiTenancy() ? dataSourceUtil.getDbName() : userProvider.get().getTenantDbConnectionString();
        try {
            return ConnUtil.getConn((DbSourceOrDbLink)dataSourceUtil, (String)tenId);
        }
        catch (DataException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Connection getDataConn(DbLinkEntity linkEntity) throws SQLException {
        Connection conn = null;
        if (linkEntity != null) {
            try {
                conn = ConnUtil.getConn((DbSourceOrDbLink)linkEntity);
            }
            catch (DataException e) {
                e.printStackTrace();
            }
        } else {
            conn = VisualUtils.getTableConn();
        }
        if (conn == null) {
            throw new SQLException("\u8fde\u63a5\u6570\u636e\u5e93\u5931\u8d25");
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer getTableDataCount(String sql) throws SQLException, DataException {
        VisualUtils.init();
        String tenId = !configValueUtil.isMultiTenancy() ? dataSourceUtil.getDbName() : userProvider.get().getTenantDbConnectionString();
        Connection conn = ConnUtil.getConn((DbSourceOrDbLink)dataSourceUtil, (String)tenId);
        try {
            Integer n = JdbcUtil.queryOneInt((PreparedStatementDTO)new PreparedStatementDTO(conn, sql), (String)"rec");
            return n;
        }
        finally {
            if (Collections.singletonList(conn).get(0) != null) {
                conn.close();
            }
        }
    }

    public static String setDicValue(List<String> fieldList, String fieldStr, PropsBeanModel props, List<Map<String, Object>> options, FieLdsModel fieLdsModel) {
        if (fieldList != null && fieldList.size() > 0) {
            for (String fieStr : fieldList) {
                for (Map<String, Object> optMap : options) {
                    if (fieLdsModel.getSlot().getOptions() == null || props == null) continue;
                    String label = props.getLabel();
                    String value = props.getValue();
                    if (!fieStr.equals(optMap.get(value).toString())) continue;
                    return optMap.get(label).toString();
                }
            }
        } else {
            for (Map<String, Object> optMap : options) {
                if (fieLdsModel.getSlot().getOptions() == null || props == null) continue;
                String label = props.getLabel();
                String value = props.getValue();
                if (!fieldStr.equals(optMap.get(value).toString())) continue;
                return optMap.get(label).toString();
            }
        }
        return null;
    }

    public static List<VisualdevModelDataEntity> deleteKey(List<VisualdevModelDataEntity> list, String[] keys) {
        for (VisualdevModelDataEntity entity : list) {
            if (StringUtils.isEmpty((String)entity.getData()) || keys.length <= 0) continue;
            Map keyMap = JsonUtil.stringToMap((String)entity.getData());
            HashMap keyResult = new HashMap(16);
            for (String selkey : keys) {
                for (Map.Entry entry : keyMap.entrySet()) {
                    String key = (String)entry.getKey();
                    if (!key.equals(selkey)) continue;
                    keyResult.put(key, entry.getValue());
                }
            }
            entity.setData(JSON.toJSONString(keyResult));
        }
        return list;
    }

    public static List<String> analysisField(String field) {
        List<String> keyList = new ArrayList<String>();
        if (field != null) {
            try {
                keyList = JsonUtil.getJsonToList((String)field, String.class);
                if (keyList != null) {
                    return keyList;
                }
                return new ArrayList<String>();
            }
            catch (Exception e) {
                return keyList;
            }
        }
        return keyList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DownloadVO createModelExcel(VisualdevEntity visualdevEntity, String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        VisualUtils.init();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            FormDataModel formDataModel = (FormDataModel)JsonUtil.getJsonToBean((String)visualdevEntity.getFormData(), FormDataModel.class);
            List fieLdsModelList = JsonUtil.getJsonToList((String)formDataModel.getFields(), FieLdsModel.class);
            ArrayList formAllModel = new ArrayList();
            RecursionForm rf = new RecursionForm();
            rf.setTableModelList(JsonUtil.getJsonToList((String)visualdevEntity.getVisualTables(), TableModel.class));
            rf.setList(fieLdsModelList);
            FormCloumnUtil.recursionForm((RecursionForm)rf, formAllModel);
            List mast = formAllModel.stream().filter(t -> FormEnum.mast.getMessage().equals(t.getKeyName())).collect(Collectors.toList());
            List mastTable = formAllModel.stream().filter(t -> FormEnum.mastTable.getMessage().equals(t.getKeyName())).collect(Collectors.toList());
            ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
            for (FormAllModel model : mast) {
                FieLdsModel fieLdsModel = model.getFormColumnModel().getFieLdsModel();
                if (keys.length <= 0) continue;
                for (String key : keys) {
                    if (!key.equals(fieLdsModel.getVModel())) continue;
                    entitys.add(new ExcelExportEntity(fieLdsModel.getConfig().getLabel(), (Object)fieLdsModel.getVModel()));
                }
            }
            for (FormAllModel model : mastTable) {
                FieLdsModel mastFieldModel = model.getFormMastTableModel().getMastTable().getFieLdsModel();
                if (keys.length <= 0) continue;
                for (String key : keys) {
                    if (!key.equals(mastFieldModel.getVModel())) continue;
                    entitys.add(new ExcelExportEntity(mastFieldModel.getConfig().getLabel(), (Object)mastFieldModel.getVModel()));
                }
            }
            ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String fileName = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMddHHmmss") + ".xls";
                path = (String)path + fileName;
                FileOutputStream fos = new FileOutputStream((String)path);
                try {
                    workbook.write((OutputStream)fos);
                    fos.close();
                    UploadUtil.uploadFile((String)configValueUtil.getFileType(), (String)path, (String)"temporary", (String)fileName);
                    vo.setName(fileName);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + fileName + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(fos).get(0) != null) {
                        fos.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return vo;
    }

    public static List<String> getLabelMapSize(List<Map<String, Object>> optMapList, String label, String value, List<String> fieldList) {
        if (optMapList.size() > 0) {
            ArrayList<String> result = new ArrayList<String>();
            for (Map<String, Object> optMap : optMapList) {
                List optChildMapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToString((Object)optMap.get("children")));
                if (fieldList.contains(String.valueOf(optMap.get(value)))) {
                    result.add(String.valueOf(optMap.get(label)));
                }
                if (optChildMapList == null || optChildMapList.size() <= 0) continue;
                result.addAll(VisualUtils.getLabelMapSize(optChildMapList, label, value, fieldList));
                return result;
            }
            return result;
        }
        return null;
    }

    public static List<String> getValueMapSize(List<Map<String, Object>> optMapList, String value, List<String> fieldList) {
        if (optMapList.size() > 0) {
            ArrayList<String> result = new ArrayList<String>();
            for (Map<String, Object> optMap : optMapList) {
                List optChildMapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToString((Object)optMap.get("children")));
                if (fieldList.contains(String.valueOf(optMap.get(value)))) {
                    result.add(String.valueOf(optMap.get(value)));
                }
                if (optChildMapList == null || optChildMapList.size() <= 0) continue;
                result.addAll(VisualUtils.getValueMapSize(optChildMapList, value, fieldList));
                return result;
            }
            return result;
        }
        return null;
    }

    public static List<String> analysisLabelMap(Map<String, Object> optMap, FieLdsModel fieLdsModel, PropsBeanModel props, List<String> fieldList) {
        ArrayList<String> list = new ArrayList<String>();
        if (fieLdsModel.getProps() != null && fieLdsModel.getProps().getProps() != null && props != null) {
            List<String> other;
            String label = props.getLabel();
            String value = props.getValue();
            String lab = String.valueOf(optMap.get(label));
            String vau = String.valueOf(optMap.get(value));
            if (fieldList.contains(vau)) {
                list.add(lab);
            }
            if (optMap.containsKey("children") && (other = VisualUtils.getLabelMapSize(JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToString((Object)optMap.get("children"))), label, value, fieldList)) != null) {
                list.addAll(other);
            }
        }
        return list;
    }

    public static List<String> analysisValueMap(Map<String, Object> optMap, FieLdsModel fieLdsModel, PropsBeanModel props, List<String> fieldList) {
        ArrayList<String> list = new ArrayList<String>();
        if (fieLdsModel.getProps() != null && fieLdsModel.getProps().getProps() != null && props != null) {
            List<String> other;
            String value = props.getValue();
            String vau = String.valueOf(optMap.get(value));
            if (fieldList.contains(vau)) {
                list.add(vau);
            }
            if (optMap.containsKey("children") && (other = VisualUtils.getValueMapSize(JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToString((Object)optMap.get("children"))), value, fieldList)) != null) {
                list.addAll(other);
            }
        }
        return list;
    }

    public static Map<String, Object> cascaderOperation(FieLdsModel fieLdsModel, List<String> fieldList, Map<String, Object> keyJsonMap) {
        HashMap<String, Object> cascaderMap = new HashMap<String, Object>(16);
        if (fieLdsModel.getOptions() != null) {
            ArrayList<String> cascaderList = new ArrayList<String>();
            ArrayList<String> keyListLast = new ArrayList<String>();
            List options = JsonUtil.getJsonToListMap((String)fieLdsModel.getOptions());
            PropsBeanModel props = (PropsBeanModel)JsonUtil.getJsonToBean((String)fieLdsModel.getProps().getProps(), PropsBeanModel.class);
            List<Object> filedListAll = new ArrayList();
            if (props.getMultiple().booleanValue()) {
                for (String id : fieldList) {
                    List list = JsonUtil.getJsonToList((String)id, String.class);
                    filedListAll.addAll(list);
                }
            } else {
                filedListAll = fieldList;
            }
            for (Map optMap : options) {
                List<String> labelList = VisualUtils.analysisLabelMap(optMap, fieLdsModel, props, filedListAll);
                List<String> valueList = VisualUtils.analysisValueMap(optMap, fieLdsModel, props, filedListAll);
                if (labelList.size() != filedListAll.size()) continue;
                for (int k = 0; k < labelList.size(); ++k) {
                    if (!((String)filedListAll.get(k)).equals(valueList.get(k))) continue;
                    cascaderList.add(labelList.get(k));
                }
                if (keyJsonMap != null && keyJsonMap.get(fieLdsModel.getVModel()) != null) {
                    List keyList = JsonUtil.getJsonToList((Object)keyJsonMap.get(fieLdsModel.getVModel()), String.class);
                    if (labelList.size() <= keyList.size()) {
                        for (int k = 0; k < labelList.size(); ++k) {
                            if (!((String)keyList.get(k)).equals(valueList.get(k))) continue;
                            keyListLast.add(labelList.get(k));
                        }
                        if (keyListLast.size() == labelList.size()) {
                            keyJsonMap.put(fieLdsModel.getVModel(), keyListLast);
                        }
                    }
                }
                cascaderMap.put("keyJsonMap", keyJsonMap);
                if (cascaderList.size() != labelList.size()) continue;
                cascaderMap.put("value", cascaderList);
            }
        }
        return cascaderMap;
    }

    public static String treeSelectOperation(FieLdsModel fieLdsModel, String fieldStr) {
        ArrayList<String> result = new ArrayList<String>();
        if (fieLdsModel.getOptions() != null) {
            String[] str;
            List options = JsonUtil.getJsonToListMap((String)fieLdsModel.getOptions());
            PropsBeanModel props = (PropsBeanModel)JsonUtil.getJsonToBean((String)fieLdsModel.getProps().getProps(), PropsBeanModel.class);
            String value = props.getValue();
            String label = props.getLabel();
            for (String id : str = fieldStr.split(",")) {
                for (Map optMap : options) {
                    List anotherOptions;
                    String another;
                    if (optMap.get(value).toString().equals(id)) {
                        result.add(optMap.get(label).toString());
                        continue;
                    }
                    if (optMap.get("children") == null || id.equals(another = VisualUtils.treeSelectGetValue(value, label, anotherOptions = (List)optMap.get("children"), id))) continue;
                    result.add(another);
                }
            }
        }
        return String.join((CharSequence)",", result);
    }

    public static String treeSelectGetValue(String value, String label, List<Map<String, Object>> anotherOptions, String fieldStr) {
        for (Map<String, Object> optMap : anotherOptions) {
            List childOptions;
            String another;
            if (optMap.get(value).toString().equals(fieldStr)) {
                return optMap.get(label).toString();
            }
            if (optMap.get("children") == null || !StringUtils.isNotEmpty((String)(another = VisualUtils.treeSelectGetValue(value, label, childOptions = (List)optMap.get("children"), fieldStr)))) continue;
            return another;
        }
        return fieldStr;
    }

    public static List<Map<String, Object>> getRealList(List<VisualColumnSearchVO> searchList, List<VisualdevModelDataEntity> list, TimeControl timeControl) throws ParseException, ParseException {
        ArrayList<Map<String, Object>> realList = new ArrayList<Map<String, Object>>();
        for (VisualdevModelDataEntity entity : list) {
            Map m2 = JsonUtil.stringToMap((String)entity.getData());
            if (searchList != null && searchList.size() != 0) {
                int i = 0;
                for (VisualColumnSearchVO entry1 : searchList) {
                    String m2value;
                    Object m1value = entry1.getValue() == null ? "" : entry1.getValue();
                    String string = m2value = m2.get(entry1.getVModel()) == null ? "" : m2.get(entry1.getVModel());
                    if (!StringUtils.isEmpty((String)m1value.toString()) && !StringUtils.isEmpty((String)m2value.toString())) {
                        if (m2value.toString().contains(m1value.toString()) && !DateUtil.isValidDate((String)m2value.toString()) && !entry1.getConfig().getKeyName().contains("date") && !entry1.getConfig().getKeyName().contains("numInput")) {
                            m2.put("id", entity.getId());
                            ++i;
                        }
                        if (entry1.getConfig().getKeyName().contains("numInput")) {
                            JSONArray searchArray = (JSONArray)m1value;
                            Integer firstValue = (Integer)searchArray.get(0);
                            Integer secondValue = (Integer)searchArray.get(1);
                            Integer value = Integer.valueOf(String.valueOf(m2value));
                            if (firstValue != null && secondValue == null && value >= firstValue) {
                                m2.put("id", entity.getId());
                                ++i;
                            }
                            if (firstValue != null && secondValue != null && value >= firstValue && value <= secondValue) {
                                m2.put("id", entity.getId());
                                ++i;
                            }
                            if (firstValue == null && secondValue != null && value <= secondValue) {
                                m2.put("id", entity.getId());
                                ++i;
                            }
                        }
                        if (timeControl != null) {
                            boolean b;
                            String format;
                            SimpleDateFormat sdf;
                            String lastTimeDate;
                            String firstTimeDate;
                            String endTime;
                            Object jsonObj2;
                            Object jsonObj1;
                            Date dayTimeEnd2;
                            Date dayTimeEnd1;
                            SimpleDateFormat df;
                            List list2;
                            List list1;
                            boolean b2;
                            JSONArray keyArray;
                            if (!StringUtils.isEmpty((String)timeControl.getDate()) && timeControl.getDate().contains(entry1.getVModel())) {
                                keyArray = String.valueOf(m1value).split(",");
                                String startTime = keyArray[0];
                                Object endTime2 = keyArray[1];
                                if (!startTime.contains(":") && !startTime.contains("-")) {
                                    long firstTime = Long.parseLong(startTime);
                                    long lastTime = Long.parseLong((String)endTime2);
                                    startTime = DateUtil.daFormat((Long)firstTime);
                                    endTime2 = DateUtil.daFormat((Long)lastTime);
                                }
                                String firstTimeDate2 = VisualUtils.getTimeFormat(startTime);
                                String lastTimeDate2 = VisualUtils.getLastTimeFormat((String)endTime2);
                                SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                                String value = VisualUtils.getTimeFormat(m2value.toString());
                                b2 = DateUtil.isEffectiveDate((Date)sdf2.parse(value), (Date)sdf2.parse(firstTimeDate2), (Date)sdf2.parse(lastTimeDate2));
                                if (b2) {
                                    m2.put("id", entity.getId());
                                    ++i;
                                }
                            }
                            if (!StringUtils.isEmpty((String)timeControl.getTimeRange()) && timeControl.getTimeRange().contains(entry1.getVModel())) {
                                list1 = JsonUtil.getJsonToList((Object)m1value, String.class);
                                list2 = JsonUtil.getJsonToList((Object)m2value, String.class);
                                if (list1.size() == 2 && list2.size() == 2) {
                                    list1.add(0, ((String)list1.get(0)).substring(0, ((String)list1.get(0)).length() - 1));
                                    list2.add(0, ((String)list2.get(0)).substring(0, ((String)list2.get(0)).length() - 1));
                                    df = new SimpleDateFormat("HH:mm:ss");
                                    Date dayTimeStart1 = df.parse((String)list1.get(0));
                                    dayTimeEnd1 = df.parse((String)list1.get(2));
                                    Date dayTimeStart2 = df.parse((String)list2.get(0));
                                    dayTimeEnd2 = df.parse((String)list2.get(2));
                                    boolean cont = DateUtil.isOverlap((Date)dayTimeStart1, (Date)dayTimeEnd1, (Date)dayTimeStart2, (Date)dayTimeEnd2);
                                    if (cont) {
                                        m2.put("id", entity.getId());
                                        ++i;
                                    }
                                }
                            }
                            if (StringUtils.isNotEmpty((String)timeControl.getTime()) && timeControl.getTime().contains(entry1.getVModel())) {
                                keyArray = (JSONArray)m1value;
                                jsonObj1 = keyArray.get(0);
                                jsonObj2 = keyArray.get(1);
                                String firstTime = String.valueOf(jsonObj1);
                                String lastTime = String.valueOf(jsonObj2);
                                firstTime = VisualUtils.getTimeFormat(firstTime);
                                lastTime = VisualUtils.getLastTimeFormat(lastTime);
                                SimpleDateFormat sdf3 = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                                String value = VisualUtils.getTimeFormat(m2value.toString());
                                b2 = DateUtil.isEffectiveDate((Date)sdf3.parse(value), (Date)sdf3.parse(firstTime), (Date)sdf3.parse(lastTime));
                                if (b2) {
                                    m2.put("id", entity.getId());
                                    ++i;
                                }
                            }
                            if (!StringUtils.isEmpty((String)timeControl.getCreateTime()) && timeControl.getCreateTime().contains(entry1.getVModel())) {
                                keyArray = (JSONArray)m1value;
                                jsonObj1 = keyArray.get(0);
                                jsonObj2 = keyArray.get(1);
                                long firstTime = (Long)jsonObj1;
                                long lastTime = (Long)jsonObj2;
                                String startTime = DateUtil.daFormat((Long)firstTime);
                                endTime = DateUtil.daFormat((Long)lastTime);
                                firstTimeDate = VisualUtils.getTimeFormat(startTime.substring(0, 10));
                                lastTimeDate = VisualUtils.getLastTimeFormat(endTime.substring(0, 10));
                                sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                                format = VisualUtils.getTimeFormat(m2value.toString());
                                b = DateUtil.isEffectiveDate((Date)sdf.parse(format), (Date)sdf.parse(firstTimeDate), (Date)sdf.parse(lastTimeDate));
                                if (b) {
                                    m2.put("id", entity.getId());
                                    ++i;
                                }
                            }
                            if (!StringUtils.isEmpty((String)timeControl.getModifyTime()) && timeControl.getModifyTime().contains(entry1.getVModel())) {
                                keyArray = (JSONArray)m1value;
                                jsonObj1 = keyArray.get(0);
                                jsonObj2 = keyArray.get(1);
                                long firstTime = (Long)jsonObj1;
                                long lastTime = (Long)jsonObj2;
                                String startTime = DateUtil.daFormat((Long)firstTime);
                                endTime = DateUtil.daFormat((Long)lastTime);
                                firstTimeDate = VisualUtils.getTimeFormat(startTime.substring(0, 10));
                                lastTimeDate = VisualUtils.getLastTimeFormat(endTime.substring(0, 10));
                                sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                                format = VisualUtils.getTimeFormat(m2value.toString());
                                b = DateUtil.isEffectiveDate((Date)sdf.parse(format), (Date)sdf.parse(firstTimeDate), (Date)sdf.parse(lastTimeDate));
                                if (b) {
                                    m2.put("id", entity.getId());
                                    ++i;
                                }
                            }
                            if (!StringUtils.isEmpty((String)timeControl.getDateRange()) && timeControl.getDateRange().contains(entry1.getVModel())) {
                                list1 = JsonUtil.getJsonToList((Object)m1value, String.class);
                                list2 = JsonUtil.getJsonToList((Object)m2value, String.class);
                                if (list1.size() == 2 && list2.size() == 2) {
                                    Date dayTimeStart2;
                                    Date dayTimeStart1;
                                    boolean cont;
                                    list1.add(0, ((String)list1.get(0)).substring(0, ((String)list1.get(0)).length() - 1));
                                    list2.add(0, ((String)list2.get(0)).substring(0, ((String)list2.get(0)).length() - 1));
                                    df = new SimpleDateFormat("yyyy-MM-dd");
                                    if (((String)list1.get(0)).length() > 10) {
                                        df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                                    }
                                    if (cont = DateUtil.isOverlap((Date)(dayTimeStart1 = df.parse((String)list1.get(0))), (Date)(dayTimeEnd1 = df.parse((String)list2.get(0))), (Date)(dayTimeStart2 = df.parse((String)list2.get(0))), (Date)(dayTimeEnd2 = df.parse((String)list2.get(2))))) {
                                        m2.put("id", entity.getId());
                                        ++i;
                                    }
                                }
                            }
                        }
                    }
                    if (i != searchList.size()) continue;
                    realList.add(m2);
                }
                continue;
            }
            m2.put("id", entity.getId());
            realList.add(m2);
        }
        return realList;
    }

    public static List<VisualdevModelDataEntity> stringToList(List<FieLdsModel> fieLdsModelList, List<VisualdevModelDataEntity> list) {
        for (FieLdsModel fieLdsModel : fieLdsModelList) {
            for (VisualdevModelDataEntity entity : list) {
                Map dataMap = JsonUtil.stringToMap((String)entity.getData());
                if (!"uploadFz".equals(fieLdsModel.getConfig().getKeyName()) && !"uploadImg".equals(fieLdsModel.getConfig().getKeyName())) continue;
                for (Map.Entry entry : dataMap.entrySet()) {
                    if (!((String)entry.getKey()).equals(fieLdsModel.getVModel())) continue;
                    entry.setValue(JsonUtil.getJsonToListMap((String)entry.getValue().toString()));
                }
            }
        }
        return list;
    }

    public static Object setSelect(List<String> fieldList, String fieldStr, FieLdsModel fieLdsModel) {
        if (fieLdsModel.getSlot() != null && fieLdsModel.getSlot().getOptions() != null) {
            String value = fieLdsModel.getConfig().getProps().getValue();
            String label = fieLdsModel.getConfig().getProps().getLabel();
            List options = JsonUtil.getJsonToListMap((String)fieLdsModel.getSlot().getOptions());
            if (fieldList != null && fieldList.size() > 0) {
                ArrayList<String> moreValue = new ArrayList<String>();
                for (String fieStr : fieldList) {
                    for (Map optMap : options) {
                        if (!fieStr.equals(optMap.get(value).toString())) continue;
                        moreValue.add(optMap.get(label).toString());
                    }
                }
                return moreValue;
            }
            for (Map optMap : options) {
                if (fieLdsModel.getSlot() == null || fieLdsModel.getSlot().getOptions() == null || optMap.get(value) == null || !fieldStr.equals(optMap.get(value).toString())) continue;
                return optMap.get(label).toString();
            }
        }
        return null;
    }

    public static Map<String, Object> relaField(String value, String type, ConfigModel configModel) {
        HashSet<String> keyList = new HashSet<String>(16);
        HashMap<String, Object> allKey = new HashMap<String, Object>(16);
        switch (type) {
            case "radio": 
            case "select": {
                if (!"dictionary".equals(configModel.getDataType())) break;
                keyList.add(value);
                break;
            }
            case "checkbox": {
                if (!"dictionary".equals(configModel.getDataType())) break;
                List<String> add = VisualUtils.analysisField(value);
                String addStr = value;
                if (add.size() > 0) {
                    for (String str : add) {
                        keyList.add(str);
                    }
                    break;
                }
                keyList.add(addStr);
                break;
            }
            case "comSelect": 
            case "depSelect": {
                if (value.contains(",")) {
                    String[] depSelects;
                    for (String depSelect : depSelects = value.split(",")) {
                        keyList.add(depSelect);
                    }
                    break;
                }
                keyList.add(value);
                break;
            }
            case "posSelect": {
                if (value.contains(",")) {
                    String[] posSelects;
                    for (String posSelect : posSelects = value.split(",")) {
                        keyList.add(posSelect);
                    }
                    break;
                }
                keyList.add(value);
                break;
            }
            case "userSelect": {
                if (value.contains(",")) {
                    String[] userSelects;
                    for (String userSelect : userSelects = value.split(",")) {
                        keyList.add(userSelect);
                    }
                    break;
                }
                keyList.add(value);
                break;
            }
            case "dicSelect": {
                keyList.add(value);
                break;
            }
            case "address": {
                List add = JsonUtil.getJsonToList((String)value, String.class);
                for (String str : add) {
                    keyList.add(str);
                }
                break;
            }
        }
        allKey.put(configModel.getKeyName(), keyList);
        return allKey;
    }

    public static Map<String, Object> relaFieldValue(Map<String, Object> dataMap, Map<String, Object> keyMap, String type, String key, String value, ConfigModel configModel, FieLdsModel model) throws IOException {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        switch (type) {
            case "radio": 
            case "select": {
                if ("dictionary".equals(configModel.getDataType()) && keyMap.containsKey(key)) {
                    result.put("value", keyMap.get(key));
                }
                if ("static".equals(configModel.getDataType())) {
                    List modelOpt = JsonUtil.getJsonToListMap((String)model.getSlot().getOptions());
                    for (Map map : modelOpt) {
                        if (!map.get(configModel.getProps().getValue()).toString().equals(value)) continue;
                        result.put("value", map.get(model.getConfig().getProps().getLabel()).toString());
                    }
                }
                if (!"dynamic".equals(configModel.getDataType())) break;
                DynamicUtil dynamicUtil = new DynamicUtil();
                dataMap = dynamicUtil.dynamicKeyData(model, dataMap);
                result.put("dataMap", dataMap);
                break;
            }
            case "checkbox": {
                if ("dictionary".equals(configModel.getDataType())) {
                    List<String> add = VisualUtils.analysisField(value);
                    String addStr = value;
                    StringBuilder addName = new StringBuilder();
                    if (add.size() > 0) {
                        for (String str : add) {
                            if (!keyMap.containsKey(str)) continue;
                            addName.append(keyMap.get(str));
                        }
                    } else if (keyMap.containsKey(addStr)) {
                        addName.append(keyMap.get(addStr));
                    }
                    if (addName.length() != 0) {
                        result.put("value", addName);
                    }
                }
                if ("static".equals(configModel.getDataType()) && model.getSlot() != null && model.getSlot().getOptions() != null) {
                    List modelOpt = JsonUtil.getJsonToListMap((String)model.getSlot().getOptions());
                    for (Map map : modelOpt) {
                        if (!map.get(model.getConfig().getProps().getValue()).toString().equals(value)) continue;
                        result.put("value", map.get(model.getConfig().getProps().getLabel()));
                    }
                }
                if (!"dynamic".equals(configModel.getDataType())) break;
                DynamicUtil dynamicUtil = new DynamicUtil();
                dataMap = dynamicUtil.dynamicKeyData(model, dataMap);
                result.put("dataMap", dataMap);
                break;
            }
            case "comSelect": 
            case "depSelect": {
                if (value.contains(",")) {
                    String[] depSelects = value.split(",");
                    String[] newDepSelects = new String[depSelects.length];
                    int i = 0;
                    for (String depSelect : depSelects) {
                        if (keyMap.containsKey(depSelect)) {
                            newDepSelects[i] = String.valueOf(keyMap.get(depSelect));
                        }
                        ++i;
                    }
                    result.put("value", newDepSelects);
                    break;
                }
                String str = value;
                if (!keyMap.containsKey(str)) break;
                result.put("value", keyMap.get(str));
                break;
            }
            case "posSelect": {
                if (value.contains(",")) {
                    String[] posSelects = value.split(",");
                    String[] newposSelects = new String[posSelects.length];
                    int i = 0;
                    for (String posSelect : posSelects) {
                        if (keyMap.containsKey(posSelect)) {
                            newposSelects[i] = String.valueOf(keyMap.get(posSelect));
                        }
                        ++i;
                    }
                    result.put("value", newposSelects);
                    break;
                }
                if (!keyMap.containsKey(value)) break;
                result.put("value", keyMap.get(value));
                break;
            }
            case "userSelect": {
                if (value.contains(",")) {
                    String[] userSelects = value.split(",");
                    String[] newuserSelects = new String[userSelects.length];
                    int i = 0;
                    for (String userSelect : userSelects) {
                        if (keyMap.containsKey(userSelect)) {
                            newuserSelects[i] = String.valueOf(keyMap.get(userSelect));
                        }
                        ++i;
                    }
                    result.put("value", newuserSelects);
                    break;
                }
                if (!keyMap.containsKey(value)) break;
                result.put("value", keyMap.get(value));
                break;
            }
            case "dicSelect": {
                if (!keyMap.containsKey(value)) break;
                result.put("value", keyMap.get(value));
                break;
            }
            case "address": {
                List add = JsonUtil.getJsonToList((String)value, String.class);
                StringBuilder addName = new StringBuilder();
                for (String str : add) {
                    if (!keyMap.containsKey(str)) continue;
                    addName.append(keyMap.get(str)).append("/");
                }
                if (addName.length() == 0) break;
                addName.deleteCharAt(addName.length() - 1);
                result.put("value", addName);
                break;
            }
            case "timeRange": {
                JSONArray jsonArrayTime = JsonUtil.getJsonToJsonArray((String)String.valueOf(value));
                jsonArrayTime = DateUtil.addCon((JSONArray)jsonArrayTime, (String)"timeRange", (String)"HH:mm:ss");
                result.put("value", jsonArrayTime.toString());
                break;
            }
            case "date": {
                DateTimeFormatter ftf = DateTimeFormatter.ofPattern(model.getFormat());
                try {
                    long time = Long.parseLong(String.valueOf(value));
                    String values = ftf.format(LocalDateTime.ofInstant(Instant.ofEpochMilli(time), ZoneId.systemDefault()));
                    result.put("value", values);
                }
                catch (Exception e) {
                    result.put("value", value);
                }
                break;
            }
            case "dateRange": {
                JSONArray jsonArray = JsonUtil.getJsonToJsonArray((String)String.valueOf(dataMap.get(key)));
                jsonArray = DateUtil.addCon((JSONArray)jsonArray, (String)"dateRange", (String)model.getFormat());
                result.put("value", jsonArray.toString());
                break;
            }
        }
        return result;
    }

    public static List<Map<String, Object>> toLowerKeyList(List<Map<String, Object>> mapList) {
        ArrayList<Map<String, Object>> newMapList = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> map : mapList) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
            Set<String> sets = map.keySet();
            for (String key : sets) {
                resultMap.put(key.toLowerCase(), map.get(key));
            }
            newMapList.add(resultMap);
        }
        return newMapList;
    }

    public static Map<String, Object> toLowerKey(Map<String, Object> map) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        Set<String> sets = map.keySet();
        for (String key : sets) {
            resultMap.put(key.toLowerCase(), map.get(key));
        }
        return resultMap;
    }

    public static VisualdevEntity delete(VisualdevEntity entity) {
        if (StringUtils.isNotEmpty((String)entity.getColumnData()) && entity.getType() != 5) {
            Map columnDataMap = JsonUtil.stringToMap((String)entity.getColumnData());
            List columnfield = JsonUtil.getJsonToList(columnDataMap.get("searchList"), FieLdsModel.class);
            columnDataMap.put("searchList", columnfield);
            entity.setColumnData(JsonUtil.getObjectToString((Object)columnDataMap));
        }
        Map formData = JsonUtil.stringToMap((String)entity.getFormData());
        List modelList = JsonUtil.getJsonToList(formData.get("fields"), FieLdsModel.class);
        formData.put("fields", modelList);
        entity.setFormData(JsonUtil.getObjectToString((Object)formData));
        return entity;
    }

    public static VisualdevEntity changeType(VisualdevEntity entity) {
        List list = JsonUtil.getJsonToListMap((String)entity.getVisualTables());
        if (list.size() > 0) {
            for (Map tableModel : list) {
                if (tableModel.get("fields") == null) continue;
                List fields = JsonUtil.getJsonToList((String)JsonUtil.getObjectToString(tableModel.get("fields")), TableFields.class);
                for (TableFields tableField : fields) {
                    String feildD = tableField.getField();
                    String feildL = tableField.getField().toLowerCase();
                    if (entity.getVisualTables() != null) {
                        entity.setVisualTables(entity.getVisualTables().replaceAll(feildD, feildL));
                    }
                    if (entity.getColumnData() != null) {
                        entity.setColumnData(entity.getColumnData().replaceAll(feildD, feildL));
                    }
                    if (entity.getFormData() == null) continue;
                    entity.setFormData(entity.getFormData().replaceAll(feildD, feildL));
                }
            }
        }
        return entity;
    }

    public static List<VisualdevModelDataEntity> setDataId(String keyName, List<VisualdevModelDataEntity> dataEntityList) {
        keyName = keyName.toLowerCase();
        for (VisualdevModelDataEntity entity : dataEntityList) {
            Map dataMap = JsonUtil.stringToMap((String)entity.getData());
            if (dataMap.get(keyName) == null) continue;
            entity.setId(String.valueOf(dataMap.get(keyName)));
        }
        return dataEntityList;
    }

    public static String getListResultSql(Boolean keyFlag, String feilds, String mainTable, String pKeyName, ColumnDataModel columnData) {
        VisualUtils.init();
        StringBuilder sql = new StringBuilder();
        if (DbTypeUtil.checkOracle((DbSourceOrDbLink)dbSourceOrDbLink).booleanValue() || DbTypeUtil.checkMySQL((DbSourceOrDbLink)dbSourceOrDbLink).booleanValue() || DbTypeUtil.checkDM((DbSourceOrDbLink)dbSourceOrDbLink).booleanValue() || DbTypeUtil.checkSQLServer((DbSourceOrDbLink)dbSourceOrDbLink).booleanValue() || DbTypeUtil.checkKingbase((DbSourceOrDbLink)dbSourceOrDbLink).booleanValue() || DbTypeUtil.checkPostgre((DbSourceOrDbLink)dbSourceOrDbLink).booleanValue()) {
            if (keyFlag.booleanValue()) {
                sql.append("select " + feilds + " from " + mainTable + " ORDER BY ");
            } else {
                sql.append("select " + pKeyName + "," + feilds + " from " + mainTable + " ORDER BY ");
            }
            if (!StringUtils.isEmpty((String)columnData.getDefaultSidx())) {
                sql.append(columnData.getDefaultSidx() + " " + columnData.getSort());
            } else {
                sql.append(pKeyName + " " + columnData.getSort());
            }
        }
        return sql.toString();
    }

    public static Map<String, Object> getMainTable(List<Map<String, Object>> tableMapList) {
        for (Map<String, Object> tableMap : tableMapList) {
            if (!tableMap.get("typeId").equals("1")) continue;
            return tableMap;
        }
        return null;
    }

    public static String getTimeFormat(String time) {
        return switch (time.length()) {
            case 16 -> time + ":00";
            case 19 -> time;
            case 21 -> time.substring(0, time.length() - 2);
            case 10 -> time + " 00:00:00";
            case 8 -> "2000-01-01 " + time;
            default -> "";
        };
    }

    public static String getLastTimeFormat(String time) {
        return switch (time.length()) {
            case 16 -> time + ":00";
            case 19 -> time;
            case 10 -> time + " 23:59:59";
            case 8 -> "2000-01-01 " + time;
            default -> "";
        };
    }
}

