/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.visualdev.onlinedev.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.database.model.entity.DbLinkEntity;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.model.FormModel;
import com.bringspring.common.model.visiual.ColumnDataModel;
import com.bringspring.common.model.visiual.FormDataField;
import com.bringspring.common.model.visiual.FormDataModel;
import com.bringspring.common.model.visiual.fields.FieLdsModel;
import com.bringspring.common.model.visiual.fields.props.PropsBeanModel;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.base.service.DblinkService;
import com.bringspring.system.base.util.JsonUtilEx;
import com.bringspring.visualdev.base.entity.VisualdevEntity;
import com.bringspring.visualdev.base.model.VisualWebTypeEnum;
import com.bringspring.visualdev.base.service.VisualdevService;
import com.bringspring.visualdev.onlinedev.entity.VisualdevModelDataEntity;
import com.bringspring.visualdev.onlinedev.mapper.VisualdevModelDataMapper;
import com.bringspring.visualdev.onlinedev.model.OnlineDevListModel.OnlineDevListDataVO;
import com.bringspring.visualdev.onlinedev.model.OnlineDevListModel.OnlineFieldsModel;
import com.bringspring.visualdev.onlinedev.model.OnlineDevListModel.VisualColumnSearchVO;
import com.bringspring.visualdev.onlinedev.model.PaginationModel;
import com.bringspring.visualdev.onlinedev.model.PaginationModelExport;
import com.bringspring.visualdev.onlinedev.model.VisualdevModelDataCrForm;
import com.bringspring.visualdev.onlinedev.model.VisualdevModelDataInfoVO;
import com.bringspring.visualdev.onlinedev.model.VisualdevModelDataUpForm;
import com.bringspring.visualdev.onlinedev.service.VisualDevListService;
import com.bringspring.visualdev.onlinedev.service.VisualdevModelDataService;
import com.bringspring.visualdev.onlinedev.util.OnlineDevDbUtil;
import com.bringspring.visualdev.onlinedev.util.onlineDevUtil.OnlineDevInfoUtils;
import com.bringspring.visualdev.onlinedev.util.onlineDevUtil.OnlineDevListUtils;
import com.bringspring.visualdev.onlinedev.util.onlineDevUtil.OnlinePublicUtils;
import com.bringspring.workflow.engine.enums.FlowTaskStatusEnum;
import com.bringspring.workflow.engine.util.FlowUtil;
import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VisualdevModelDataServiceImpl
extends ServiceImpl<VisualdevModelDataMapper, VisualdevModelDataEntity>
implements VisualdevModelDataService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private DblinkService dblinkService;
    @Autowired
    private VisualdevService visualdevService;
    @Autowired
    private VisualDevListService visualDevListService;

    @Override
    public List<VisualdevModelDataEntity> getList(String modelId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(VisualdevModelDataEntity::getVisualDevId, (Object)modelId);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<FormDataField> fieldList(String id) {
        VisualdevEntity entity = this.visualdevService.getInfo(id);
        FormDataModel formData = (FormDataModel)JsonUtil.getJsonToBean((String)entity.getFormData(), FormDataModel.class);
        List fieLdsModelList = JsonUtil.getJsonToList((String)formData.getFields(), FieLdsModel.class);
        ArrayList<FieLdsModel> childFieldModelList = new ArrayList<FieLdsModel>();
        ArrayList<FieLdsModel> mainFieldModelList = new ArrayList<FieLdsModel>();
        ArrayList<FormModel> models = new ArrayList<FormModel>();
        OnlinePublicUtils.recurseFiled(fieLdsModelList, mainFieldModelList, childFieldModelList, models);
        List<FormDataField> formDataFieldList = mainFieldModelList.stream().filter(fieLdsModel -> !"".equals(fieLdsModel.getVModel()) && StringUtils.isNotEmpty((String)fieLdsModel.getVModel()) && !"relationForm".equals(fieLdsModel.getConfig().getKeyName())).map(fieLdsModel -> {
            FormDataField formDataField = new FormDataField();
            formDataField.setLabel(fieLdsModel.getConfig().getLabel());
            formDataField.setVModel(fieLdsModel.getVModel());
            return formDataField;
        }).collect(Collectors.toList());
        return formDataFieldList;
    }

    @Override
    public List<Map<String, Object>> getPageList(VisualdevEntity entity, PaginationModel paginationModel) {
        String json = null;
        if (StringUtils.isNotEmpty((String)paginationModel.getKeyword())) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(paginationModel.getRelationField(), paginationModel.getKeyword());
            json = JsonUtil.getObjectToString(map);
        }
        paginationModel.setQueryJson(json);
        List<Map<String, Object>> dataList = this.visualDevListService.getRelationFormList(entity, paginationModel);
        return dataList;
    }

    @Override
    public List<Map<String, Object>> exportData(String[] keys, PaginationModelExport paginationModelExport, VisualdevEntity visualdevEntity) {
        List<OnlineDevListDataVO> noSwapDataList;
        PaginationModel paginationModel = new PaginationModel();
        BeanUtil.copyProperties((Object)((Object)paginationModelExport), (Object)((Object)paginationModel), (String[])new String[0]);
        ColumnDataModel columnDataModel = (ColumnDataModel)JsonUtil.getJsonToBean((String)visualdevEntity.getColumnData(), ColumnDataModel.class);
        ArrayList<VisualColumnSearchVO> searchVOList = new ArrayList();
        if (StringUtils.isNotEmpty((String)paginationModel.getQueryJson())) {
            Map keyJsonMap = JsonUtil.stringToMap((String)paginationModel.getQueryJson());
            searchVOList = JsonUtil.getJsonToList((String)columnDataModel.getSearchList(), VisualColumnSearchVO.class);
            searchVOList = searchVOList.stream().map(searchVO -> {
                searchVO.setValue(keyJsonMap.get(searchVO.getVModel()));
                return searchVO;
            }).filter(vo -> vo.getValue() != null && StringUtils.isNotEmpty((String)String.valueOf(vo.getValue()))).collect(Collectors.toList());
            boolean b = false;
            if (columnDataModel.getTreeRelation() != null) {
                b = keyJsonMap.keySet().stream().anyMatch(t -> t.equalsIgnoreCase(String.valueOf(columnDataModel.getTreeRelation())));
            }
            if (b && keyJsonMap.size() > searchVOList.size()) {
                String relation = String.valueOf(columnDataModel.getTreeRelation());
                VisualColumnSearchVO vo2 = new VisualColumnSearchVO();
                vo2.setSearchType("1");
                vo2.setVModel(relation);
                vo2.setValue(keyJsonMap.get(relation));
                searchVOList.add(vo2);
            }
        }
        if (OnlinePublicUtils.isUseTables(visualdevEntity.getVisualTables()).booleanValue()) {
            UserInfo userInfo = this.userProvider.get();
            String moduleId = paginationModel.getMenuId();
            String reg = "^[jsbos_]\\S*_jsbos\\S*";
            searchVOList.stream().filter(c -> c.getVModel().matches(reg)).forEach(cl -> {
                String s = cl.getVModel();
                String s1 = s.substring(s.lastIndexOf("jsbos_")).replace("jsbos_", "");
                cl.setVModel(s1);
            });
            noSwapDataList = this.visualDevListService.getListWithTable(visualdevEntity, paginationModel, userInfo, moduleId, searchVOList);
        } else {
            noSwapDataList = this.visualDevListService.getWithoutTableData(visualdevEntity.getId());
            noSwapDataList = this.visualDevListService.getList(noSwapDataList, searchVOList, paginationModel);
        }
        FormDataModel formDataModel = (FormDataModel)JsonUtil.getJsonToBean((String)visualdevEntity.getFormData(), FormDataModel.class);
        List swapDataVoList = JsonUtil.getJsonToList((String)formDataModel.getFields(), OnlineFieldsModel.class);
        List<OnlineFieldsModel> allFormDataModelList = new ArrayList<OnlineFieldsModel>();
        OnlinePublicUtils.recursionFields(swapDataVoList, allFormDataModelList);
        allFormDataModelList = allFormDataModelList.stream().filter(model -> model.getConfig().getKeyName() != null && StringUtils.isNotEmpty((String)model.getVModel())).collect(Collectors.toList());
        noSwapDataList = OnlineDevListUtils.getSwapList(noSwapDataList, allFormDataModelList, visualdevEntity.getId());
        List<Map<String, Object>> realList = noSwapDataList.stream().map(t -> t.getData()).collect(Collectors.toList());
        realList = realList.stream().map(rl -> {
            HashMap map = new HashMap();
            for (String key : keys) {
                map.put(key, rl.get(key));
            }
            return map;
        }).collect(Collectors.toList());
        return realList;
    }

    @Override
    public VisualdevModelDataEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(VisualdevModelDataEntity::getId, (Object)id);
        return (VisualdevModelDataEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public VisualdevModelDataInfoVO infoDataChange(String id, VisualdevEntity visualdevEntity) throws IOException, ParseException, DataException, SQLException {
        FormDataModel formDataModel = (FormDataModel)JsonUtil.getJsonToBean((String)visualdevEntity.getFormData(), FormDataModel.class);
        List modelList = JsonUtil.getJsonToList((String)formDataModel.getFields(), FieLdsModel.class);
        VisualdevModelDataEntity visualdevModelDataEntity = this.getInfo(id);
        ArrayList<FieLdsModel> childFieldModelList = new ArrayList<FieLdsModel>();
        List<Object> mainFieldModelList = new ArrayList<FieLdsModel>();
        ArrayList<FormModel> models = new ArrayList<FormModel>();
        OnlinePublicUtils.recurseFiled(modelList, mainFieldModelList, childFieldModelList, models);
        mainFieldModelList = mainFieldModelList.stream().map(fieLdsModel -> {
            if (ObjectUtil.isNotEmpty((Object)fieLdsModel.getProps()) && StringUtils.isNotEmpty((String)fieLdsModel.getProps().getProps())) {
                PropsBeanModel propsBeanModel = (PropsBeanModel)JsonUtil.getJsonToBean((String)fieLdsModel.getProps().getProps(), PropsBeanModel.class);
                fieLdsModel.getProps().setPropsModel(propsBeanModel);
            }
            return fieLdsModel;
        }).collect(Collectors.toList());
        if (visualdevModelDataEntity != null) {
            Map DataMap = JsonUtil.stringToMap((String)visualdevModelDataEntity.getData());
            Map<String, Object> childTableMap = DataMap.entrySet().stream().filter(m -> ((String)m.getKey()).contains("tableField")).collect(Collectors.toMap(e -> (String)e.getKey(), e -> ObjectUtil.isNotEmpty(e.getValue()) ? e.getValue() : ""));
            Map<String, Object> mainTableMap = DataMap.entrySet().stream().filter(m -> !((String)m.getKey()).contains("tableField")).collect(Collectors.toMap(e -> (String)e.getKey(), e -> ObjectUtil.isNotEmpty(e.getValue()) ? e.getValue() : ""));
            mainTableMap = OnlineDevInfoUtils.swapTableDataInfo(mainFieldModelList, mainTableMap, visualdevEntity.getId(), models);
            for (Map.Entry<String, Object> entry : childTableMap.entrySet()) {
                List listMap = JsonUtil.getJsonToListMap((String)String.valueOf(entry.getValue()));
                FieLdsModel fieLdsModel2 = childFieldModelList.stream().filter(child -> child.getVModel().equalsIgnoreCase((String)entry.getKey())).findFirst().orElse(null);
                if (!ObjectUtil.isNotEmpty((Object)fieLdsModel2)) continue;
                ArrayList<Map<String, Object>> tableValueList = new ArrayList<Map<String, Object>>();
                if (Objects.nonNull(listMap)) {
                    for (Map map : listMap) {
                        Map<String, Object> childFieldMap = OnlineDevInfoUtils.swapChildTableDataInfo(fieLdsModel2.getConfig().getChildren(), map, models);
                        tableValueList.add(childFieldMap);
                    }
                }
                HashMap<String, ArrayList<Map<String, Object>>> childFieldsMap = new HashMap<String, ArrayList<Map<String, Object>>>();
                childFieldsMap.put(entry.getKey(), tableValueList);
                mainTableMap.putAll(childFieldsMap);
            }
            String objectToString = JsonUtilEx.getObjectToString(mainTableMap);
            VisualdevModelDataInfoVO vo = new VisualdevModelDataInfoVO();
            vo.setData(objectToString);
            vo.setId(id);
            return vo;
        }
        return null;
    }

    @Override
    public ActionResult visualCreate(VisualdevEntity visualdevEntity, Map<String, Object> dataMap, VisualdevModelDataCrForm visualdevModelDataCrForm, String mainId) throws WorkFlowException {
        VisualdevModelDataEntity entity = new VisualdevModelDataEntity();
        entity.setData(JsonUtilEx.getObjectToString(dataMap));
        entity.setVisualDevId(visualdevEntity.getId());
        entity.setId(mainId);
        entity.setSortCode(RandomUtil.parses());
        entity.setCreatorTime(new Date());
        entity.setCreatorUserId(this.userProvider.get().getUserId());
        entity.setEnabledMark(1);
        this.save(entity);
        if (visualdevEntity.getWebType() != null && visualdevEntity.getWebType().equals(VisualWebTypeEnum.FLOW_FROM.getType())) {
            if (visualdevModelDataCrForm.getStatus().equals(FlowTaskStatusEnum.Handle.getCode())) {
                FlowUtil.saveOrSubmit((String)visualdevModelDataCrForm.getTaskId(), (String)visualdevModelDataCrForm.getFlowId(), (String)visualdevModelDataCrForm.getTemplateId(), (String)mainId, dataMap, (Integer)visualdevModelDataCrForm.getStatus());
                return ActionResult.success((String)MsgCode.SU006.get());
            }
            FlowUtil.saveOrSubmit((String)visualdevModelDataCrForm.getTaskId(), (String)visualdevModelDataCrForm.getFlowId(), (String)visualdevModelDataCrForm.getTemplateId(), (String)mainId, dataMap, (Integer)visualdevModelDataCrForm.getStatus());
            return ActionResult.success((String)MsgCode.SU002.get());
        }
        return ActionResult.success((String)MsgCode.SU001.get());
    }

    @Override
    public ActionResult visualUpdate(String id, VisualdevEntity visualdevEntity, Map<String, Object> map, VisualdevModelDataUpForm visualdevModelDataUpForm) throws WorkFlowException {
        if (StringUtils.isEmpty((String)visualdevEntity.getVisualTables()) || "[]".equals(visualdevEntity.getVisualTables())) {
            VisualdevModelDataEntity entity = new VisualdevModelDataEntity();
            entity.setData(JsonUtilEx.getObjectToString(map));
            entity.setVisualDevId(visualdevEntity.getId());
            entity.setId(id);
            entity.setLastModifyTime(new Date());
            entity.setLastModifyUserId(this.userProvider.get().getUserId());
            this.updateById(entity);
        }
        if (visualdevEntity.getWebType() != null && visualdevEntity.getWebType().equals(VisualWebTypeEnum.FLOW_FROM.getType())) {
            if (visualdevModelDataUpForm.getStatus().equals(FlowTaskStatusEnum.Handle.getCode())) {
                FlowUtil.saveOrSubmit((String)visualdevModelDataUpForm.getTaskId(), (String)visualdevModelDataUpForm.getFlowId(), (String)visualdevModelDataUpForm.getTemplateId(), (String)id, map, (Integer)visualdevModelDataUpForm.getStatus());
                return ActionResult.success((String)MsgCode.SU006.get());
            }
            return ActionResult.success((String)MsgCode.SU002.get());
        }
        return ActionResult.success((String)MsgCode.SU004.get());
    }

    @Override
    @DSTransactional
    public void delete(VisualdevModelDataEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    @Override
    public boolean tableDelete(String id, VisualdevEntity visualdevEntity) throws DataException, SQLException {
        DbLinkEntity linkEntity = this.dblinkService.getInfo(visualdevEntity.getDbLinkId());
        return OnlineDevDbUtil.deleteTable(id, visualdevEntity, linkEntity);
    }

    @Override
    public ActionResult tableDeleteMore(List<String> ids, VisualdevEntity visualdevEntity) throws DataException, SQLException {
        DbLinkEntity linkEntity = this.dblinkService.getInfo(visualdevEntity.getDbLinkId());
        return OnlineDevDbUtil.deleteTables(ids, visualdevEntity, linkEntity);
    }
}

