package com.bringspring.visualdev.portal.controller;

import cn.hutool.core.util.ObjectUtil;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.ListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.model.home.EmailVO;
import com.bringspring.common.model.home.FlowTodoCountVO;
import com.bringspring.common.model.home.FlowTodoVO;
import com.bringspring.common.model.home.NoticeVO;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.extend.service.EmailReceiveService;
import com.bringspring.system.message.entity.MessageReceiveEntity;
import com.bringspring.system.message.service.MessageService;
import com.bringspring.system.message.service.MessagereceiveService;
import com.bringspring.workflow.engine.entity.FlowEngineEntity;
import com.bringspring.workflow.engine.model.flowtask.FlowTaskListModel;
import com.bringspring.workflow.engine.model.flowtask.PaginationFlowTask;
import com.bringspring.workflow.engine.service.FlowDelegateService;
import com.bringspring.workflow.engine.service.FlowEngineService;
import com.bringspring.workflow.engine.service.FlowTaskService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 主页控制器
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月27日 上午9:18
 */
@Tag(name = "主页控制器", description = "Home")
@RestController
@RequestMapping("api/visualdev/Dashboard")
public class DashboardController {
    @Autowired
    private FlowTaskService flowTaskService;

    @Autowired
    private FlowDelegateService flowDelegateService;

    @Autowired
    private FlowEngineService flowEngineService;

    @Autowired
    private MessageService messageService;

    @Autowired
    private EmailReceiveService emailReceiveService;

    @Autowired
    private MessagereceiveService messagereceiveService;


    /**
     * 获取我的待办
     *
     * @return
     */
    @Operation(summary = "获取我的待办")
    @GetMapping("/FlowTodoCount")
    public ActionResult getFlowTodoCount() {
        FlowTodoCountVO vo = new FlowTodoCountVO();
        vo.setToBeReviewed(flowTaskService.getWaitList().size());
        vo.setEntrust(flowDelegateService.getList().size());
        vo.setFlowDone(flowTaskService.getTrialList().size());
        return ActionResult.success(vo);
    }

    /**
     * 获取通知公告
     *
     * @return
     */
    @Operation(summary = "获取通知公告")
    @GetMapping("/Notice")
    public ActionResult getNotice() {
        List<NoticeVO> list = JsonUtil.getJsonToList(messageService.getDashboardNoticeList(), NoticeVO.class);
        List<NoticeVO> listNew = new ArrayList<>();
        for (NoticeVO noticeVO : list) {
            MessageReceiveEntity oneByMessageId = messagereceiveService.getOneByMessageId(noticeVO.getId());
            if (ObjectUtil.isNotEmpty(oneByMessageId)) {
                noticeVO.setIsRead(oneByMessageId.getIsRead());
            }
            listNew.add(noticeVO);
        }
        ListVO<NoticeVO> voList = new ListVO<>();
        voList.setList(listNew);
        return ActionResult.success(voList);
    }

    /**
     * 获取未读邮件
     *
     * @return
     */
    @Operation(summary = "获取未读邮件")
    @GetMapping("/Email")
    public ActionResult getEmail() {
        List<EmailVO> list = JsonUtil.getJsonToList(emailReceiveService.getDashboardReceiveList(),EmailVO.class);
        ListVO<EmailVO> voList = new ListVO<>();
        voList.setList(list);
        return ActionResult.success(voList);
    }

    /**
     * 获取待办事项
     *
     * @return
     */
    @Operation(summary = "获取待办事项")
    @GetMapping("/FlowTodo")
    public ActionResult getFlowTodo() {
        PaginationFlowTask pagination = new PaginationFlowTask();
        List<FlowTaskListModel> waitList = flowTaskService.getWaitList(pagination);
        List<FlowEngineEntity> engineList = flowEngineService.getFlowList(waitList.stream().map(t -> t.getFlowId()).collect(Collectors.toList()));
        List<FlowTodoVO> list = new LinkedList<>();
        for (FlowTaskListModel taskEntity : waitList) {
            FlowTodoVO vo = JsonUtil.getJsonToBean(taskEntity, FlowTodoVO.class);
            FlowEngineEntity engine = engineList.stream().filter(t -> t.getId().equals(taskEntity.getFlowId())).findFirst().orElse(null);
            if (engine != null) {
                vo.setFormType(engine.getFormType());
                vo.setEnCode(engine.getEnCode());
            }
            vo.setTaskNodeId(taskEntity.getThisStepId());
            vo.setTaskOperatorId(taskEntity.getTaskOperatorId());
            vo.setType(2);
            list.add(vo);
        }
        PaginationVO paginationVO = JsonUtil.getJsonToBean(pagination, PaginationVO.class);
        return ActionResult.page(list, paginationVO);
    }

}
