/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.visualdev.generater.util.custom;

import com.baomidou.mybatisplus.generator.config.ConstVal;
import com.baomidou.mybatisplus.generator.config.builder.ConfigBuilder;
import com.baomidou.mybatisplus.generator.engine.AbstractTemplateEngine;
import com.bringspring.common.util.StringUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.jetbrains.annotations.NotNull;

public class CustomTemplateEngine
extends AbstractTemplateEngine {
    private static final String DOT_VM = ".vm";
    private VelocityEngine velocityEngine;
    private Map<String, Object> customParams;
    private String path;

    public CustomTemplateEngine(String path) {
        this.path = path;
    }

    public CustomTemplateEngine(Map<String, Object> customParams, String path) {
        this.customParams = customParams;
        this.path = path;
    }

    public CustomTemplateEngine init(ConfigBuilder configBuilder) {
        if (null == this.velocityEngine) {
            Properties p = new Properties();
            p.setProperty("resource.loader.file.path", this.path);
            p.setProperty("ISO-8859-1", "UTF-8");
            p.setProperty("output.encoding", "UTF-8");
            this.velocityEngine = new VelocityEngine(p);
        }
        return this;
    }

    public String writer(@NotNull Map<String, Object> objectMap, @NotNull String templateName, @NotNull String templateString) throws Exception {
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writer(@NotNull Map<String, Object> objectMap, @NotNull String templatePath, @NotNull File outputFile) throws Exception {
        if (!StringUtils.isEmpty((String)templatePath)) {
            Template template = this.velocityEngine.getTemplate(templatePath, ConstVal.UTF8);
            FileOutputStream fos = new FileOutputStream(outputFile);
            try {
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fos, ConstVal.UTF8);
                try {
                    BufferedWriter writer = new BufferedWriter(outputStreamWriter);
                    try {
                        if (this.customParams != null) {
                            objectMap.putAll(this.customParams);
                        }
                        template.merge((Context)new VelocityContext(objectMap), (Writer)writer);
                        writer.close();
                    }
                    finally {
                        if (Collections.singletonList(writer).get(0) != null) {
                            writer.close();
                        }
                    }
                }
                finally {
                    if (Collections.singletonList(outputStreamWriter).get(0) != null) {
                        outputStreamWriter.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(fos).get(0) != null) {
                    fos.close();
                }
            }
        }
    }

    public String templateFilePath(String filePath) {
        if (null != filePath && !filePath.contains(DOT_VM)) {
            StringBuilder fp = new StringBuilder();
            fp.append(filePath).append(DOT_VM);
            return fp.toString();
        }
        return filePath;
    }
}

