/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.visualdev.onlinedev.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.FileUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.enums.ExportModelTypeEnum;
import com.bringspring.common.util.enums.ModuleTypeEnum;
import com.bringspring.common.util.file.FileExport;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.visualdev.base.entity.VisualdevEntity;
import com.bringspring.visualdev.base.service.VisualdevService;
import com.bringspring.visualdev.onlinedev.model.BaseDevModelVO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Tag(name="0\u4ee3\u7801app\u65e0\u8868\u5f00\u53d1", description="ModelAppData")
@RestController
@RequestMapping(value={"/api/visualdev/OnlineDev/App"})
public class VisualdevModelAppController {
    @Autowired
    private VisualdevService visualdevService;
    @Autowired
    private FileExport fileExport;
    @Autowired
    private ConfigValueUtil configValueUtil;

    @Operation(summary="\u529f\u80fd\u5bfc\u51fa")
    @PostMapping(value={"/{modelId}/Actions/ExportData"})
    public ActionResult exportData(@PathVariable(value="modelId") String modelId) {
        VisualdevEntity visualdevEntity = this.visualdevService.getInfo(modelId);
        BaseDevModelVO vo = (BaseDevModelVO)JsonUtil.getJsonToBean((Object)visualdevEntity, BaseDevModelVO.class);
        vo.setModelType(ExportModelTypeEnum.App.getMessage());
        DownloadVO downloadVO = this.fileExport.exportFile((Object)vo, this.configValueUtil.getTemporaryFilePath(), visualdevEntity.getFullName(), ModuleTypeEnum.VISUAL_APP.getTableName());
        return ActionResult.success((Object)downloadVO);
    }

    @Operation(summary="\u529f\u80fd\u5bfc\u5165")
    @PostMapping(value={"/Model/Actions/ImportData"}, consumes={"multipart/form-data"})
    public ActionResult ImportData(@RequestPart(value="file") MultipartFile multipartFile) throws WorkFlowException {
        VisualdevEntity entity;
        if (FileUtil.existsSuffix((MultipartFile)multipartFile, (String)ModuleTypeEnum.VISUAL_APP.getTableName())) {
            return ActionResult.fail((String)MsgCode.IMP002.get());
        }
        String fileContent = FileUtil.getFileContent((MultipartFile)multipartFile, (String)this.configValueUtil.getTemporaryFilePath());
        BaseDevModelVO vo = (BaseDevModelVO)JsonUtil.getJsonToBean((String)fileContent, BaseDevModelVO.class);
        if (vo.getModelType() == null || !vo.getModelType().equals(ExportModelTypeEnum.App.getMessage())) {
            return ActionResult.fail((String)"\u8bf7\u5bfc\u5165\u5bf9\u5e94\u529f\u80fd\u7684json\u6587\u4ef6");
        }
        VisualdevEntity visualdevEntity = (VisualdevEntity)JsonUtil.getJsonToBean((Object)vo, VisualdevEntity.class);
        String modelId = visualdevEntity.getId();
        if (StringUtils.isNotEmpty((String)modelId) && (entity = this.visualdevService.getInfo(modelId)) != null) {
            return ActionResult.fail((String)"\u5df2\u5b58\u5728\u76f8\u540c\u529f\u80fd");
        }
        visualdevEntity.setCreatorTime(DateUtil.getNowDate());
        visualdevEntity.setLastModifyTime(null);
        this.visualdevService.create(visualdevEntity);
        return ActionResult.success((String)MsgCode.IMP001.get());
    }
}

