package com.bringspring.visualdev.base.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.util.Date;

/**
 *
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @author RKKJ开发平台组
 * @date 2021/3/16
 */
@Data
@TableName("BASE_VISUAL_DEVELOPMENT")
public class VisualdevEntity {


    @TableId("ID")
    private String id;


    @TableField("DESCRIPTION")
    private String description;


    /**
     * 名称
     */
    @TableField("FULL_NAME")
    private String fullName;


    /**
     * 编码
     */
    @TableField("ENCODE")
    private String enCode;


    /**
     * 状态(0-暂存（默认），1-发布)
     */
    @TableField("STATE")
    private Integer state;

    /**
     * 类型(1-应用开发,2-移动开发,3-流程表单,4-Web表单,5-App表单)
     */
    @TableField("TYPE")
    private Integer type;


    /**
     * 关联数据连接id
     */
    @TableField("DB_LINK_ID")
    private String dbLinkId;
    /**
     * 关联的表信息
     * 其中包含表信息以及字段信息
     */
    @TableField("LINKED_TABLE_JSON")
    @JSONField(name = "tables")
    private String visualTables;

    /**
     * 分类(数据字典维护)
     */
    @TableField("CATEGORY")
    private String category;

    /**
     * 表单配置JSON
     */
    @TableField("FORM_DATA")
    private String formData;

    /**
     * 列表配置JSON
     */
    @TableField("COLUMN_DATA")
    private String columnData;

    /**
     * 列表配置JSON
     */
    @TableField("APP_COLUMN_DATA")
    private String appColumnData;

    /**
     * 页面类型（1、纯表单，2、表单加列表，3、表单列表工作流）
     */
    @TableField("WEB_TYPE")
    private Integer webType;

    /**
     * 工作流模板JSON
     */
   /* @TableField("FLOW_TEMPLATE_JSON")
    private String flowTemplateJson;*/

    /**
     * 关联工作流连接id
     */
    @TableField("FLOW_ID")
    private String flowId;



    @TableField("SORT_CODE")
    private Long sortCode;


    @TableField("ENABLED_MARK")
    private Integer enabledMark;

    /**
     * 创建时间
     */
    @TableField(value = "CREATOR_TIME",fill = FieldFill.INSERT)
    private Date creatorTime;

    /**
     * 创建用户
     */
    @TableField(value = "CREATOR_USER_ID",fill = FieldFill.INSERT)
    private String creatorUserId;

    /**
     * 修改时间
     */
    @TableField(value = "LAST_MODIFY_TIME",fill = FieldFill.UPDATE)
    private Date lastModifyTime;

    /**
     * 修改用户
     */
    @TableField(value = "LAST_MODIFY_USER_ID",fill = FieldFill.UPDATE)
    private String lastModifyUserId;


    @TableField("DELETE_MARK")
    private Integer deleteMark;


    @TableField("DELETE_TIME")
    private Date deleteTime;


    @TableField("DELETE_USER_ID")
    private String deleteUserId;


}

