package com.bringspring.visualdev.base.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.common.model.FormAllModel;
import com.bringspring.common.model.visiual.FormCloumnUtil;
import com.bringspring.common.model.visiual.RecursionForm;
import com.bringspring.common.model.visiual.TableModel;
import com.bringspring.common.model.visiual.fields.FieLdsModel;
import com.bringspring.common.util.*;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.system.base.util.JsonUtilEx;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.visualdev.base.entity.VisualdevEntity;
import com.bringspring.visualdev.base.mapper.VisualdevMapper;
import com.bringspring.visualdev.base.model.PaginationVisualdev;
import com.bringspring.visualdev.base.model.VisualDevCrForm;
import com.bringspring.visualdev.base.model.VisualDevUpForm;
import com.bringspring.visualdev.base.model.VisualWebTypeEnum;
import com.bringspring.visualdev.base.service.VisualdevService;
import com.bringspring.workflow.engine.entity.FlowEngineEntity;
import com.bringspring.workflow.engine.entity.FlowEngineTemplateEntity;
import com.bringspring.workflow.engine.entity.FlowEngineVisibleEntity;
import com.bringspring.workflow.engine.model.flowengine.shuntjson.childnode.ChildNode;
import com.bringspring.workflow.engine.model.flowengine.shuntjson.childnode.Properties;
import com.bringspring.workflow.engine.service.FlowEngineService;
import com.bringspring.workflow.engine.service.FlowEngineTemplateService;
import com.bringspring.workflow.engine.service.FlowEngineVisibleService;
import com.bringspring.workflow.engine.util.VisualDevTableCre;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021/3/16
 */
@Service
public class VisualdevServiceImpl extends ServiceImpl<VisualdevMapper, VisualdevEntity> implements VisualdevService {

    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private CacheKeyUtil cacheKeyUtil;
    @Autowired
    private FlowEngineService flowEngineService;
    @Autowired
    private UserService userService;
    @Autowired
    private DictionaryDataService dictionaryDataService;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private VisualDevTableCre visualDevTableCre;

    @Autowired
    private FlowEngineTemplateService flowEngineTemplateService;

    @Autowired
    private FlowEngineVisibleService flowEngineVisibleService;

    @Override
    public List<VisualdevEntity> getList(PaginationVisualdev paginationVisualdev) {
        // 定义变量判断是否需要使用修改时间倒序
        boolean flag = false;
        QueryWrapper<VisualdevEntity> queryWrapper = new QueryWrapper<>();
        if (!StringUtils.isEmpty(paginationVisualdev.getKeyword())) {
            flag = true;
            queryWrapper.lambda().like(VisualdevEntity::getFullName, paginationVisualdev.getKeyword());
        }
        queryWrapper.lambda().eq(VisualdevEntity::getType, paginationVisualdev.getType());
        if (StringUtils.isNotEmpty(paginationVisualdev.getCategory())) {
            flag = true;
            queryWrapper.lambda().eq(VisualdevEntity::getCategory, paginationVisualdev.getCategory());
        }
        // 排序
        queryWrapper.lambda().orderByAsc(VisualdevEntity::getSortCode).orderByDesc(VisualdevEntity::getCreatorTime);
        if (flag) {
            queryWrapper.lambda().orderByDesc(VisualdevEntity::getLastModifyTime);
        }
        Page<VisualdevEntity> page = new Page<>(paginationVisualdev.getCurrentPage(), paginationVisualdev.getPageSize());
        IPage<VisualdevEntity> userPage = this.page(page, queryWrapper);
        return paginationVisualdev.setData(userPage.getRecords(), page.getTotal());
    }


    @Override
    public List<VisualdevEntity> getList() {
        QueryWrapper<VisualdevEntity> queryWrapper = new QueryWrapper<>();
        // 排序
        queryWrapper.lambda().orderByAsc(VisualdevEntity::getSortCode).orderByDesc(VisualdevEntity::getCreatorTime);
        return this.list(queryWrapper);
    }

    @Override
    public VisualdevEntity getInfo(String id) {
        QueryWrapper<VisualdevEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(VisualdevEntity::getId, id);
        return this.getOne(queryWrapper);
    }

    @Override
    public Boolean create(VisualdevEntity entity) throws WorkFlowException {
        if (StringUtils.isEmpty(entity.getId())) {
            entity.setId(RandomUtil.uuId());
        }
        //判断是否要创表
        List<TableModel> tableModels = JsonUtil.getJsonToList(entity.getVisualTables(), TableModel.class);
        Map<String, Object> formMap = JsonUtil.stringToMap(entity.getFormData());
        //无表需要创表
        if (tableModels.size() == 0) {
            List<FieLdsModel> list = JsonUtil.getJsonToList(formMap.get("fields"), FieLdsModel.class);
            JSONArray formJsonArray = JsonUtil.getJsonToJsonArray(String.valueOf(formMap.get("fields")));

            List<FormAllModel> formAllModel = new ArrayList<>();
            RecursionForm recursionForm = new RecursionForm();
            recursionForm.setTableModelList(JsonUtil.getJsonToList(entity.getVisualTables(), TableModel.class));
            recursionForm.setList(list);
            FormCloumnUtil.recursionForm(recursionForm, formAllModel);

            String tableName = "mt" + RandomUtil.uuId();

            String dbLinkId = entity.getDbLinkId();
            List<TableModel> tableModelList = visualDevTableCre.tableList(formJsonArray, formAllModel, tableName, dbLinkId);

            formMap.put("fields", formJsonArray);
            //更新
            entity.setFormData(JsonUtil.getObjectToString(formMap));
            entity.setVisualTables(JsonUtil.getObjectToString(tableModelList));
        }
        entity.setCreatorUserId(userProvider.get().getUserId());
        entity.setSortCode(RandomUtil.parses());
        if (ObjectUtil.isNotEmpty(entity.getWebType()) && VisualWebTypeEnum.FLOW_FROM.getType().equals(entity.getWebType())) {
            entity.setFlowId(entity.getId());
            if (entity.getType().equals(1) || entity.getType().equals(2)) {
                FlowEngineEntity flowEngineEntity = new FlowEngineEntity();
                flowEngineEntity.setId(entity.getId());
//                flowEngineEntity.setFlowTemplateJson(entity.getFlowTemplateJson());
                flowEngineEntity.setEnCode("visualDev" + entity.getEnCode());
                flowEngineEntity.setType(1);
                flowEngineEntity.setIcon("icon-ym icon-ym-node");
                flowEngineEntity.setIconBackground("#008cff");
                flowEngineEntity.setEnabledMark(1);
                flowEngineEntity.setFullName(entity.getFullName());
                flowEngineEntity.setCategory(dictionaryDataService.getInfo(entity.getCategory()).getEnCode());
                flowEngineEntity.setFormType(2);
                flowEngineEntity.setFlowTables(entity.getVisualTables());
                flowEngineEntity.setDbLinkId(entity.getDbLinkId());
                flowEngineEntity.setFormData(entity.getFormData());
                flowEngineService.create(flowEngineEntity);
                entity.setFlowId(flowEngineEntity.getId());
            }
        }
        List<FlowEngineTemplateEntity> templateList = flowEngineTemplateService.getListByFlowId(entity.getId());
        templateList.stream().forEach(template->{
            template.setId(RandomUtil.uuId());
            template.setEnCode("visualDev" + entity.getEnCode());
            template.setFullName(entity.getFullName());
        });
        flowEngineTemplateService.saveBatch(templateList);

        return this.save(entity);
    }

    @Override
    public Boolean createForm(VisualDevCrForm devCrForm) throws WorkFlowException {
        VisualdevEntity entity = JsonUtil.getJsonToBean(JsonUtilEx.getObjectToString(devCrForm), VisualdevEntity.class);
        if (StringUtils.isEmpty(entity.getId())) {
            entity.setId(RandomUtil.uuId());
        }
        //判断是否要创表
        List<TableModel> tableModels = JsonUtil.getJsonToList(entity.getVisualTables(), TableModel.class);
        Map<String, Object> formMap = JsonUtil.stringToMap(entity.getFormData());
        //无表需要创表
        if (tableModels.size() == 0) {
            List<FieLdsModel> list = JsonUtil.getJsonToList(formMap.get("fields"), FieLdsModel.class);
            JSONArray formJsonArray = JsonUtil.getJsonToJsonArray(String.valueOf(formMap.get("fields")));

            List<FormAllModel> formAllModel = new ArrayList<>();
            RecursionForm recursionForm = new RecursionForm();
            recursionForm.setTableModelList(JsonUtil.getJsonToList(entity.getVisualTables(), TableModel.class));
            recursionForm.setList(list);
            FormCloumnUtil.recursionForm(recursionForm, formAllModel);

            String tableName = "mt" + RandomUtil.uuId();

            String dbLinkId = entity.getDbLinkId();
            List<TableModel> tableModelList = visualDevTableCre.tableList(formJsonArray, formAllModel, tableName, dbLinkId);

            formMap.put("fields", formJsonArray);
            //更新
            entity.setFormData(JsonUtil.getObjectToString(formMap));
            entity.setVisualTables(JsonUtil.getObjectToString(tableModelList));
        }
        entity.setCreatorUserId(userProvider.get().getUserId());
        entity.setSortCode(RandomUtil.parses());
        //创建流程模板
        List<FlowEngineTemplateEntity> templateList = devCrForm.getTemplateList();
        if (CollectionUtil.isNotEmpty(templateList)) {
            templateList.stream().forEach(template -> {
                template.setId(RandomUtil.uuId());
                template.setFlowId(entity.getId());
                template.setEnCode("visualDev" + entity.getEnCode());
                template.setEnabledMark(entity.getEnabledMark());
                template.setVersion(StringUtils.isEmpty(template.getVersion()) ? "1" : template.getVersion());
                template.setCreatorTime(new Date());
                template.setCreatorUserId(userProvider.get().getUserId());
                flowEngineTemplateService.save(template);
            });
        }
        if (ObjectUtil.isNotEmpty(entity.getWebType()) && VisualWebTypeEnum.FLOW_FROM.getType().equals(entity.getWebType())) {
            entity.setFlowId(entity.getId());
            if (entity.getType().equals(1) || entity.getType().equals(2)) {
                FlowEngineEntity flowEngineEntity = new FlowEngineEntity();
                flowEngineEntity.setId(entity.getId());
//                flowEngineEntity.setFlowTemplateJson(entity.getFlowTemplateJson());
                flowEngineEntity.setEnCode("visualDev" + entity.getEnCode());
                flowEngineEntity.setType(1);
                flowEngineEntity.setIcon("icon-ym icon-ym-node");
                flowEngineEntity.setIconBackground("#008cff");
                flowEngineEntity.setEnabledMark(1);
                flowEngineEntity.setFullName(entity.getFullName());
                flowEngineEntity.setCategory(dictionaryDataService.getInfo(entity.getCategory()).getEnCode());
                flowEngineEntity.setFormType(2);
                flowEngineEntity.setFlowTables(entity.getVisualTables());
                flowEngineEntity.setDbLinkId(entity.getDbLinkId());
                flowEngineEntity.setFormData(entity.getFormData());
                flowEngineService.create(flowEngineEntity);
                entity.setFlowId(flowEngineEntity.getId());
            }
        }

             return this.save(entity);
    }

    @Override
    public boolean update(String id, VisualdevEntity entity) throws WorkFlowException {
        entity.setId(id);
        entity.setLastModifyUserId(userProvider.get().getUserId());

        //关联流程更新
        if (entity.getWebType() != null && VisualWebTypeEnum.FLOW_FROM.getType().equals(entity.getWebType())) {
            FlowEngineEntity flowEngineEntity = flowEngineService.getById(id);
            VisualdevEntity visualdevEntity = this.getInfo(id);
            //判断是否关联流程id
            if (visualdevEntity.getFlowId() == null) {
                entity.setFlowId(id);
            }
            //代码生成器 不生成流程引擎
            if (entity.getType().equals(1) || entity.getType().equals(2)) {
                if (flowEngineEntity == null) {
                    flowEngineEntity = new FlowEngineEntity();
                    flowEngineEntity.setId(id);
//                        flowEngineEntity.setFlowTemplateJson(entity.getFlowTemplateJson());
                    flowEngineEntity.setEnCode("visualDev" + entity.getEnCode());
                    flowEngineEntity.setType(1);
                    flowEngineEntity.setIcon("icon-ym icon-ym-node");
                    flowEngineEntity.setIconBackground("#008cff");
                    flowEngineEntity.setEnabledMark(1);
                    flowEngineEntity.setFormType(2);
                    flowEngineEntity.setFlowTables(entity.getVisualTables());
                    flowEngineEntity.setDbLinkId(entity.getDbLinkId());
                    flowEngineEntity.setFormData(entity.getFormData());
                    flowEngineEntity.setFullName(entity.getFullName());
                    flowEngineService.create(flowEngineEntity);
                }
                flowEngineEntity.setFullName(entity.getFullName());
//                    flowEngineEntity.setFlowTemplateJson(entity.getFlowTemplateJson());
                flowEngineEntity.setFlowTables(entity.getVisualTables());
                flowEngineEntity.setDbLinkId(entity.getDbLinkId());
                flowEngineEntity.setFormData(entity.getFormData());
                //同步更新流程状态与可见
                flowEngineEntity.setEnabledMark(entity.getState());
                flowEngineService.updateVisible(visualdevEntity.getId(), flowEngineEntity);
            }
        }
        return this.updateById(entity);
    }

    @Override
    public boolean updateForm(String id, VisualDevUpForm devUpForm) throws WorkFlowException {
        VisualdevEntity entity = JsonUtil.getJsonToBean(JsonUtilEx.getObjectToString(devUpForm), VisualdevEntity.class);
        entity.setId(id);
        entity.setLastModifyUserId(userProvider.get().getUserId());
        //关联流程更新
        if (entity.getWebType() != null && VisualWebTypeEnum.FLOW_FROM.getType().equals(entity.getWebType())) {
            FlowEngineEntity flowEngineEntity = flowEngineService.getById(id);
            VisualdevEntity visualdevEntity = this.getInfo(id);
            //判断是否关联流程id
            if (visualdevEntity.getFlowId() == null) {
                entity.setFlowId(id);
            }
            //创建流程模板
            List<FlowEngineTemplateEntity> templateList = devUpForm.getTemplateList();
                templateList.stream().forEach(flowTemplate->{
                    if (ObjectUtil.isEmpty(flowTemplate.getId())){
                        flowTemplate.setId(RandomUtil.uuId());
                        flowTemplate.setFlowId(entity.getId());
                        flowTemplate.setEnCode("visualDev" + entity.getEnCode());
                        flowTemplate.setEnabledMark(entity.getEnabledMark());
                        flowTemplate.setVersion(StringUtils.isEmpty(flowTemplate.getVersion()) ? "1" : flowTemplate.getVersion());
                        flowTemplate.setCreatorTime(new Date());
                        flowTemplate.setCreatorUserId(userProvider.get().getUserId());
                        flowEngineTemplateService.save(flowTemplate);
                    }
                    FlowEngineTemplateEntity jsonToBean = JsonUtil.getJsonToBean(flowTemplate, FlowEngineTemplateEntity.class);
                    jsonToBean.setLastModifyTime(new Date());
                    jsonToBean.setLastModifyUserId(userProvider.get().getUserId());
                    flowEngineTemplateService.updateById(jsonToBean);
                });

            //代码生成器 不生成流程引擎
            if (entity.getType().equals(1) || entity.getType().equals(2)) {
                if (flowEngineEntity == null) {
                    flowEngineEntity = new FlowEngineEntity();
                    flowEngineEntity.setId(id);
//                        flowEngineEntity.setFlowTemplateJson(entity.getFlowTemplateJson());
                    flowEngineEntity.setEnCode("visualDev" + entity.getEnCode());
                    flowEngineEntity.setType(1);
                    flowEngineEntity.setIcon("icon-ym icon-ym-node");
                    flowEngineEntity.setIconBackground("#008cff");
                    flowEngineEntity.setEnabledMark(1);
                    flowEngineEntity.setFormType(2);
                    flowEngineEntity.setFlowTables(entity.getVisualTables());
                    flowEngineEntity.setDbLinkId(entity.getDbLinkId());
                    flowEngineEntity.setFormData(entity.getFormData());
                    flowEngineEntity.setFullName(entity.getFullName());
                    flowEngineService.create(flowEngineEntity);
                }
                flowEngineEntity.setFullName(entity.getFullName());
//                    flowEngineEntity.setFlowTemplateJson(entity.getFlowTemplateJson());
                flowEngineEntity.setFlowTables(entity.getVisualTables());
                flowEngineEntity.setDbLinkId(entity.getDbLinkId());
                flowEngineEntity.setFormData(entity.getFormData());
                //同步更新流程状态与可见
                flowEngineEntity.setEnabledMark(entity.getState());
                flowEngineService.updateVisible(visualdevEntity.getId(), flowEngineEntity);
            }
        }
        return this.updateById(entity);
    }

    private List<FlowEngineVisibleEntity> visibleList(VisualdevEntity entity) {
        List<FlowEngineVisibleEntity> visibleList = new ArrayList<>();
        List<FlowEngineTemplateEntity> listByFlowId = flowEngineTemplateService.getListByFlowId(entity.getId());
        listByFlowId.stream().forEach(template -> {
            if (template.getFlowTemplateJson() != null) {
                ChildNode childNode = JsonUtil.getJsonToBean(template.getFlowTemplateJson(), ChildNode.class);
                Properties properties = childNode.getProperties();
                //可见的用户
                for (String user : properties.getInitiator()) {
                    FlowEngineVisibleEntity visible = new FlowEngineVisibleEntity();
                    visible.setTemplateId(template.getId());
                    visible.setOperatorId(user);
                    visible.setOperatorType("user");
                    visible.setCompanyId(template.getCompanyId());
                    visibleList.add(visible);
                }
                //可见的部门
                for (String position : properties.getInitiatePos()) {
                    FlowEngineVisibleEntity visible = new FlowEngineVisibleEntity();
                    visible.setTemplateId(template.getId());
                    visible.setOperatorId(position);
                    visible.setOperatorType("position");
                    visible.setCompanyId(template.getCompanyId());
                    visibleList.add(visible);
                }
                //可见的角色
                List<String> roleList = properties.getInitiateRole() != null ? properties.getInitiateRole() : new ArrayList<>();
                for (String role : roleList) {
                    FlowEngineVisibleEntity visible = new FlowEngineVisibleEntity();
                    visible.setTemplateId(template.getId());
                    visible.setOperatorId(role);
                    visible.setOperatorType("role");
                    visible.setCompanyId(template.getCompanyId());
                    visibleList.add(visible);
                }
                //可见的公司
//                String companyId = userInfo.getOrganizeId();
                FlowEngineVisibleEntity visible = new FlowEngineVisibleEntity();
                visible.setTemplateId(template.getId());
                visible.setOperatorId(template.getCompanyId());
                visible.setOperatorType("company");
                visible.setCompanyId(template.getCompanyId());
                visibleList.add(visible);

            }
        });
        return visibleList;
    }

    @Override
    public void delete(VisualdevEntity entity) throws WorkFlowException {
        if (entity != null) {
            if (StringUtils.isNotEmpty(entity.getFlowId())) {
                FlowEngineEntity flowEngineEntity = flowEngineService.getById(entity.getFlowId());
                if (flowEngineEntity != null) {
                    flowEngineService.delete(flowEngineEntity);
                }
            }
            this.removeById(entity.getId());
        }
    }

    @Override
    public Long getObjByEncode(String encode, Integer type) {
        QueryWrapper<VisualdevEntity> visualWrapper = new QueryWrapper<>();
        visualWrapper.lambda().eq(VisualdevEntity::getEnCode, encode).eq(VisualdevEntity::getType, type);
        Long count = this.baseMapper.selectCount(visualWrapper);
        return count;
    }

    @Override
    public Long getCountByName(String name, Integer type) {
        QueryWrapper<VisualdevEntity> visualWrapper = new QueryWrapper<>();
        visualWrapper.lambda().eq(VisualdevEntity::getFullName, name).eq(VisualdevEntity::getType, type);
        Long count = this.baseMapper.selectCount(visualWrapper);
        return count;
    }
}
