/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.workflow.engine.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.workflow.engine.entity.FlowCommentEntity;
import com.bringspring.workflow.engine.model.flowcomment.FlowCommentForm;
import com.bringspring.workflow.engine.model.flowcomment.FlowCommentInfoVO;
import com.bringspring.workflow.engine.model.flowcomment.FlowCommentListVO;
import com.bringspring.workflow.engine.model.flowcomment.FlowCommentPagination;
import com.bringspring.workflow.engine.service.FlowCommentService;
import com.bringspring.workflow.engine.util.ServiceAllUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6d41\u7a0b\u8bc4\u8bba"}, value="Comment")
@RestController
@RequestMapping(value={"/api/workflow/Engine/FlowComment"})
public class FlowCommentController {
    @Autowired
    private ServiceAllUtil serviceUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private FlowCommentService flowCommentService;

    @ApiOperation(value="\u83b7\u53d6\u6d41\u7a0b\u8bc4\u8bba\u5217\u8868")
    @GetMapping
    public ActionResult list(FlowCommentPagination pagination) {
        List<FlowCommentEntity> list = this.flowCommentService.getlist(pagination);
        List listVO = JsonUtil.getJsonToList(list, FlowCommentListVO.class);
        List<String> userId = list.stream().map(t -> t.getCreatorUserId()).collect(Collectors.toList());
        UserInfo userInfo = this.userProvider.get();
        List<UserEntity> userName = this.serviceUtil.getUserName(userId);
        for (FlowCommentListVO commentModel : listVO) {
            UserEntity userEntity = userName.stream().filter(t -> t.getId().equals(commentModel.getCreatorUserId())).findFirst().orElse(null);
            commentModel.setIsDel(commentModel.getCreatorUserId().equals(userInfo.getUserId()));
            commentModel.setCreatorUserName(userEntity != null ? userEntity.getRealName() : "");
            commentModel.setCreatorUserId(userEntity != null ? userEntity.getAccount() : "");
            if (userEntity == null) continue;
            commentModel.setCreatorUserHeadIcon(UploaderUtil.uploaderImg((String)userEntity.getHeadIcon()));
        }
        PaginationVO vo = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)pagination), PaginationVO.class);
        return ActionResult.page((List)listVO, (PaginationVO)vo);
    }

    @ApiOperation(value="\u83b7\u53d6\u6d41\u7a0b\u8bc4\u8bba\u4fe1\u606f")
    @GetMapping(value={"/{id}"})
    public ActionResult info(@PathVariable(value="id") String id) {
        FlowCommentEntity entity = this.flowCommentService.getInfo(id);
        FlowCommentInfoVO vo = (FlowCommentInfoVO)JsonUtil.getJsonToBean((Object)entity, FlowCommentInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u65b0\u5efa\u6d41\u7a0b\u8bc4\u8bba")
    @PostMapping
    public ActionResult create(@RequestBody @Valid FlowCommentForm commentForm) throws DataException {
        FlowCommentEntity entity = (FlowCommentEntity)JsonUtil.getJsonToBean((Object)commentForm, FlowCommentEntity.class);
        this.flowCommentService.create(entity);
        return ActionResult.success((String)MsgCode.SU002.get());
    }

    @ApiOperation(value="\u66f4\u65b0\u6d41\u7a0b\u8bc4\u8bba")
    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid FlowCommentForm commentForm) throws DataException {
        FlowCommentEntity info = this.flowCommentService.getInfo(id);
        if (info != null) {
            FlowCommentEntity entity = (FlowCommentEntity)JsonUtil.getJsonToBean((Object)commentForm, FlowCommentEntity.class);
            this.flowCommentService.update(id, entity);
            return ActionResult.success((String)MsgCode.SU004.get());
        }
        return ActionResult.fail((String)MsgCode.FA002.get());
    }

    @ApiOperation(value="\u5220\u9664\u6d41\u7a0b\u8bc4\u8bba")
    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        FlowCommentEntity entity = this.flowCommentService.getInfo(id);
        if (entity.getCreatorUserId().equals(this.userProvider.get().getUserId())) {
            this.flowCommentService.delete(entity);
            return ActionResult.success((String)MsgCode.SU003.get());
        }
        return ActionResult.success((String)MsgCode.FA003.get());
    }
}

