/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.workflow.engine.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.system.permission.entity.UserRelationEntity;
import com.bringspring.workflow.engine.entity.FlowEngineVisibleEntity;
import com.bringspring.workflow.engine.mapper.FlowEngineVisibleMapper;
import com.bringspring.workflow.engine.service.FlowEngineVisibleService;
import com.bringspring.workflow.engine.util.ServiceAllUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FlowEngineVisibleServiceImpl
extends ServiceImpl<FlowEngineVisibleMapper, FlowEngineVisibleEntity>
implements FlowEngineVisibleService {
    @Autowired
    private ServiceAllUtil serviceUtil;

    @Override
    public List<FlowEngineVisibleEntity> getList(String flowId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(FlowEngineVisibleEntity::getFlowId, (Object)flowId);
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(FlowEngineVisibleEntity::getSortCode)).orderByDesc(FlowEngineVisibleEntity::getCreatorTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<FlowEngineVisibleEntity> getVisibleFlowList(String userId) {
        ArrayList<String> userList = new ArrayList<String>();
        userList.add(userId);
        List<UserRelationEntity> list = this.serviceUtil.getListByUserIdAll(userList);
        List userRelationList = list.stream().map(u -> u.getObjectId()).collect(Collectors.toList());
        userRelationList.add(userId);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.lambda().in(FlowEngineVisibleEntity::getOperatorId, userRelationList);
        List flowList = this.list((Wrapper)wrapper);
        return flowList;
    }
}

