/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.workflow.engine.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtil;
import com.bringspring.system.base.util.JsonUtilEx;
import com.bringspring.workflow.engine.entity.FlowTaskNodeEntity;
import com.bringspring.workflow.engine.enums.FlowNodeEnum;
import com.bringspring.workflow.engine.mapper.FlowTaskNodeMapper;
import com.bringspring.workflow.engine.model.flowengine.shuntjson.nodejson.ChildNodeList;
import com.bringspring.workflow.engine.service.FlowTaskNodeService;
import com.bringspring.workflow.engine.util.FlowNature;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class FlowTaskNodeServiceImpl
extends ServiceImpl<FlowTaskNodeMapper, FlowTaskNodeEntity>
implements FlowTaskNodeService {
    @Override
    public List<FlowTaskNodeEntity> getListAll() {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(FlowTaskNodeEntity::getSortCode)).orderByDesc(FlowTaskNodeEntity::getCreatorTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<FlowTaskNodeEntity> getList(String taskId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(FlowTaskNodeEntity::getTaskId, (Object)taskId)).orderByAsc(FlowTaskNodeEntity::getSortCode)).orderByDesc(FlowTaskNodeEntity::getCreatorTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public FlowTaskNodeEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(FlowTaskNodeEntity::getId, (Object)id);
        return (FlowTaskNodeEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void deleteByTaskId(String taskId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(FlowTaskNodeEntity::getTaskId, (Object)taskId);
        this.remove((Wrapper)queryWrapper);
    }

    @Override
    public void create(List<FlowTaskNodeEntity> dataAll) {
        List startNodes = dataAll.stream().filter(t -> FlowNature.NodeStart.equals(t.getNodeType())).collect(Collectors.toList());
        if (startNodes.size() > 0) {
            String startNode = ((FlowTaskNodeEntity)startNodes.get(0)).getNodeCode();
            long num = 0L;
            long maxNum = 0L;
            ArrayList<Long> max = new ArrayList<Long>();
            ArrayList<FlowTaskNodeEntity> treeList = new ArrayList<FlowTaskNodeEntity>();
            this.nodeList(dataAll, startNode, treeList, num, max);
            List sortIdList = max.stream().sorted(Long::compareTo).collect(Collectors.toList());
            if (sortIdList.size() > 0) {
                maxNum = (Long)sortIdList.get(sortIdList.size() - 1);
            }
            String nodeNext = FlowNature.NodeEnd;
            for (FlowTaskNodeEntity entity : dataAll) {
                List nextEndList;
                ChildNodeList modelList;
                String type = entity.getNodeType();
                FlowTaskNodeEntity node = treeList.stream().filter(t -> t.getNodeCode().equals(entity.getNodeCode())).findFirst().orElse(null);
                List endCount = treeList.stream().filter(t -> StringUtil.isEmpty((String)t.getNodeNext())).collect(Collectors.toList());
                String next = entity.getNodeNext();
                List nextNum = treeList.stream().filter(t -> t.getNodeNext().equals(next)).collect(Collectors.toList());
                if (StringUtil.isEmpty((String)next)) {
                    entity.setNodeNext(nodeNext);
                }
                if (node != null) {
                    entity.setSortCode(node.getSortCode());
                    entity.setState(FlowNodeEnum.Process.getCode());
                    if (StringUtil.isEmpty((String)next)) {
                        entity.setNodeNext(nodeNext);
                    }
                }
                if ("empty".equals(type) || "timer".equals(type)) continue;
                if (endCount.size() > 1 && nodeNext.equals(entity.getNodeNext())) {
                    modelList = (ChildNodeList)JsonUtil.getJsonToBean((String)entity.getNodePropertyJson(), ChildNodeList.class);
                    nextEndList = endCount.stream().map(t -> t.getNodeCode()).collect(Collectors.toList());
                    nextEndList.remove(entity.getNodeCode());
                    modelList.getCustom().setInterflow(true);
                    modelList.getCustom().setInterflowId(String.join((CharSequence)",", nextEndList));
                    modelList.getCustom().setInterflowNextId(nodeNext);
                    entity.setNodePropertyJson(JsonUtilEx.getObjectToString((Object)modelList));
                }
                if (nextNum.size() > 1) {
                    modelList = (ChildNodeList)JsonUtil.getJsonToBean((String)entity.getNodePropertyJson(), ChildNodeList.class);
                    nextEndList = nextNum.stream().map(t -> t.getNodeCode()).collect(Collectors.toList());
                    nextEndList.remove(entity.getNodeCode());
                    modelList.getCustom().setInterflowId(String.join((CharSequence)",", nextEndList));
                    modelList.getCustom().setInterflowNextId(next);
                    modelList.getCustom().setInterflow(true);
                    entity.setNodePropertyJson(JsonUtilEx.getObjectToString((Object)modelList));
                }
                this.save(entity);
            }
            FlowTaskNodeEntity endround = new FlowTaskNodeEntity();
            endround.setId(RandomUtil.uuId());
            endround.setNodeCode(nodeNext);
            endround.setNodeName("\u7ed3\u675f");
            endround.setCompletion(FlowNature.ProcessCompletion);
            endround.setCreatorTime(new Date());
            endround.setSortCode(maxNum + 1L);
            endround.setTaskId(((FlowTaskNodeEntity)treeList.get(0)).getTaskId());
            endround.setNodePropertyJson(((FlowTaskNodeEntity)startNodes.get(0)).getNodePropertyJson());
            endround.setNodeType("endround");
            endround.setState(FlowNodeEnum.Process.getCode());
            this.save(endround);
        }
    }

    @Override
    public void create(FlowTaskNodeEntity entity) {
        this.save(entity);
    }

    @Override
    public void update(FlowTaskNodeEntity entity) {
        this.updateById(entity);
    }

    @Override
    public void update(String taskId) {
        UpdateWrapper wrapper = new UpdateWrapper();
        wrapper.lambda().eq(FlowTaskNodeEntity::getTaskId, (Object)taskId);
        wrapper.lambda().set(FlowTaskNodeEntity::getCompletion, (Object)FlowNodeEnum.Futility.getCode());
        wrapper.lambda().set(FlowTaskNodeEntity::getState, (Object)FlowNodeEnum.Futility.getCode());
        this.update((Wrapper)wrapper);
    }

    @Override
    public void updateCompletion(List<String> id, int start) {
        if (id.size() > 0) {
            UpdateWrapper wrapper = new UpdateWrapper();
            wrapper.lambda().in(FlowTaskNodeEntity::getId, id);
            wrapper.lambda().set(FlowTaskNodeEntity::getCompletion, (Object)start);
            this.update((Wrapper)wrapper);
        }
    }

    private void nodeList(List<FlowTaskNodeEntity> dataAll, String nodeCode, List<FlowTaskNodeEntity> treeList, long num, List<Long> max) {
        max.add(++num);
        List thisEntity = dataAll.stream().filter(t -> t.getNodeCode().contains(nodeCode)).collect(Collectors.toList());
        for (int i = 0; i < thisEntity.size(); ++i) {
            FlowTaskNodeEntity entity = (FlowTaskNodeEntity)thisEntity.get(i);
            entity.setSortCode(num);
            entity.setState(FlowNodeEnum.Process.getCode());
            treeList.add(entity);
            String[] nodeNext = entity.getNodeNext().split(",");
            if (nodeNext.length <= 0) continue;
            for (int k = 0; k < nodeNext.length; ++k) {
                String next = nodeNext[k];
                long nums = treeList.stream().filter(t -> t.getNodeCode().equals(next)).count();
                if (!StringUtil.isNotEmpty((String)next) || nums != 0L) continue;
                this.nodeList(dataAll, next, treeList, num, max);
            }
        }
    }
}

