/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.workflow.engine.util;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.database.model.DataSourceModel;
import com.bringspring.common.database.model.dto.PreparedStatementDTO;
import com.bringspring.common.database.model.entity.DbLinkEntity;
import com.bringspring.common.database.model.interfaces.DataSourceMod;
import com.bringspring.common.database.util.ConnUtil;
import com.bringspring.common.database.util.DbTypeUtil;
import com.bringspring.common.database.util.JdbcUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.model.FormAllModel;
import com.bringspring.common.model.FormColumnModel;
import com.bringspring.common.model.FormColumnTableModel;
import com.bringspring.common.model.FormEnum;
import com.bringspring.common.model.FormMastTableModel;
import com.bringspring.common.model.visiual.FormCloumnUtil;
import com.bringspring.common.model.visiual.RecursionForm;
import com.bringspring.common.model.visiual.TableModel;
import com.bringspring.common.model.visiual.fields.FieLdsModel;
import com.bringspring.common.model.visiual.fields.props.PropsBeanModel;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.PermissionEntityBase;
import com.bringspring.system.permission.entity.PositionEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.workflow.engine.model.DataModel;
import com.bringspring.workflow.engine.util.ServiceAllUtil;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FlowDataUtil {
    private static final Logger log = LoggerFactory.getLogger(FlowDataUtil.class);
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private DataSourceModel dataSourceModel;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private ServiceAllUtil serviceUtil;

    private Connection getTableConn(DbLinkEntity link) throws SQLException {
        Connection conn = null;
        if (link != null) {
            try {
                conn = ConnUtil.getConn((DataSourceMod)link);
            }
            catch (DataException e) {
                e.printStackTrace();
            }
        } else {
            String tenId = "";
            tenId = !Boolean.parseBoolean(this.configValueUtil.getMultiTenancy()) ? this.dataSourceModel.getDbName() : this.userProvider.get().getTenantDbConnectionString();
            try {
                conn = ConnUtil.getConn((DataSourceMod)this.dataSourceModel, (String)tenId);
            }
            catch (DataException e) {
                e.printStackTrace();
            }
        }
        if (conn == null) {
            throw new SQLException("\u8fde\u63a5\u6570\u636e\u5e93\u5931\u8d25");
        }
        return conn;
    }

    private List<Map<String, Object>> getTableList(Connection conn, String sql) throws WorkFlowException {
        try {
            List list = JdbcUtil.queryListLowercase((PreparedStatementDTO)new PreparedStatementDTO(conn, sql));
            return list;
        }
        catch (DataException e) {
            throw new WorkFlowException(e.getMessage());
        }
    }

    private Map<String, Object> getMast(Connection conn, String sql) throws WorkFlowException {
        try {
            Map mast = JdbcUtil.queryOne((PreparedStatementDTO)new PreparedStatementDTO(conn, sql));
            HashMap<String, Object> mastData = new HashMap<String, Object>(16);
            for (String key : mast.keySet()) {
                mastData.put(key.toLowerCase(), mast.get(key));
            }
            return mastData;
        }
        catch (DataException e) {
            throw new WorkFlowException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getKey(Connection conn, String mainTable) throws SQLException {
        String pKeyName = "id";
        String catalog = conn.getCatalog();
        ResultSet primaryKeyResultSet = conn.getMetaData().getPrimaryKeys(catalog, null, mainTable);
        try {
            while (primaryKeyResultSet.next()) {
                pKeyName = primaryKeyResultSet.getString("COLUMN_NAME");
            }
            primaryKeyResultSet.close();
            String string = pKeyName;
            return string;
        }
        finally {
            if (Collections.singletonList(primaryKeyResultSet).get(0) != null) {
                primaryKeyResultSet.close();
            }
        }
    }

    public Map<String, Object> info(DataModel dataModel) throws WorkFlowException {
        HashMap<String, Object> result = new HashMap();
        try {
            List<FieLdsModel> fieLdsModelList = dataModel.getFieLdsModelList();
            List<TableModel> tableModelList = dataModel.getTableModelList();
            RecursionForm recursionForm = new RecursionForm(fieLdsModelList, tableModelList);
            ArrayList<FormAllModel> formAllModel = new ArrayList<FormAllModel>();
            FormCloumnUtil.recursionForm((RecursionForm)recursionForm, formAllModel);
            result = this.infoDataList(dataModel, formAllModel);
        }
        catch (WorkFlowException e) {
            log.error("\u67e5\u8be2\u5f02\u5e38\uff1a" + e.getMessage());
            throw new WorkFlowException(e.getMessage());
        }
        return result;
    }

    private Map<String, Object> infoDataList(DataModel dataModel, List<FormAllModel> formAllModel) throws WorkFlowException {
        Map<Object, Object> result = new HashMap(16);
        List<TableModel> tableModelList = dataModel.getTableModelList();
        result = tableModelList.size() > 0 ? this.tableData(dataModel, formAllModel) : this.data(dataModel, formAllModel);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> tableData(DataModel dataModel, List<FormAllModel> formAllModel) throws WorkFlowException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        try {
            String mainId = dataModel.getMainId();
            DbLinkEntity link = dataModel.getLink();
            Connection conn = this.getTableConn(link);
            try {
                String tableModel;
                List<TableModel> tableList = dataModel.getTableModelList();
                Optional<TableModel> first = tableList.stream().filter(t -> "1".equals(t.getTypeId())).findFirst();
                if (!first.isPresent()) {
                    throw new WorkFlowException(MsgCode.COD001.get());
                }
                String mastTableName = first.get().getTable();
                List mastForm = formAllModel.stream().filter(t -> FormEnum.mast.getMessage().equals(t.getKeyName())).collect(Collectors.toList());
                List mastFile = mastForm.stream().filter(t -> StringUtil.isNotEmpty((String)t.getFormColumnModel().getFieLdsModel().getVModel())).map(t -> t.getFormColumnModel().getFieLdsModel().getVModel()).collect(Collectors.toList());
                String pKeyName = this.getKey(conn, mastTableName);
                mastFile.add(pKeyName);
                String mastInfo = " select " + String.join((CharSequence)",", mastFile) + " from " + mastTableName + " where " + pKeyName + " = '" + mainId + "'";
                Map<String, Object> mastData = this.getMast(conn, mastInfo);
                HashMap<String, Object> mastDataAll = new HashMap<String, Object>();
                for (String key : mastData.keySet()) {
                    Object value = mastData.get(key);
                    FormAllModel formAll = mastForm.stream().filter(t -> key.equals(t.getFormColumnModel().getFieLdsModel().getVModel().toLowerCase())).findFirst().orElse(null);
                    if (formAll == null) continue;
                    FieLdsModel fieLdsModel = formAll.getFormColumnModel().getFieLdsModel();
                    String dataKey = fieLdsModel.getVModel();
                    value = this.info(fieLdsModel, value, true);
                    mastDataAll.put(dataKey, value);
                }
                data.putAll(mastDataAll);
                List tableForm = formAllModel.stream().filter(t -> FormEnum.table.getMessage().equals(t.getKeyName())).collect(Collectors.toList());
                HashMap childData = new HashMap();
                for (FormAllModel model : tableForm) {
                    FormColumnTableModel childList = model.getChildList();
                    String tableName = childList.getTableName();
                    tableModel = childList.getTableModel();
                    String childKey = this.getKey(conn, tableName);
                    List childFile = childList.getChildList().stream().filter(t -> StringUtil.isNotEmpty((String)t.getFieLdsModel().getVModel())).map(t -> t.getFieLdsModel().getVModel()).collect(Collectors.toList());
                    Optional<TableModel> first1 = tableList.stream().filter(t -> t.getTable().equals(tableName)).findFirst();
                    if (!first1.isPresent()) {
                        throw new WorkFlowException(MsgCode.COD001.get());
                    }
                    TableModel table = first1.get();
                    String tableInfo = "select " + String.join((CharSequence)",", childFile) + " from " + tableName + " where " + table.getTableField() + "='" + mainId + "' order by " + childKey + " asc";
                    List<Map<String, Object>> tableDataList = this.getTableList(conn, tableInfo);
                    LinkedList tableDataAll = new LinkedList();
                    for (Map<String, Object> tableData : tableDataList) {
                        HashMap<String, Object> childDataOne = new HashMap<String, Object>();
                        for (String key : tableData.keySet()) {
                            Object value = tableData.get(key);
                            FieLdsModel fieLdsModel = childList.getChildList().stream().filter(t -> key.equals(t.getFieLdsModel().getVModel().toLowerCase())).map(t -> t.getFieLdsModel()).findFirst().orElse(null);
                            value = this.info(fieLdsModel, value, true);
                            String dataKey = fieLdsModel.getVModel();
                            childDataOne.put(dataKey, value);
                        }
                        tableDataAll.add(childDataOne);
                    }
                    childData.put(tableModel, tableDataAll);
                }
                data.putAll(childData);
                Map<String, List<FormAllModel>> mastTableAll = formAllModel.stream().filter(t -> FormEnum.mastTable.getMessage().equals(t.getKeyName())).collect(Collectors.groupingBy(e -> e.getFormMastTableModel().getTable()));
                for (String key : mastTableAll.keySet()) {
                    Optional<TableModel> first1 = tableList.stream().filter(t -> t.getTable().equals(key)).findFirst();
                    if (!first1.isPresent()) {
                        throw new WorkFlowException(MsgCode.COD001.get());
                    }
                    tableModel = first1.get();
                    String table = tableModel.getTable();
                    List<FormAllModel> mastTableList = mastTableAll.get(key);
                    List field = mastTableList.stream().filter(t -> StringUtil.isNotEmpty((String)t.getFormMastTableModel().getField())).map(t -> t.getFormMastTableModel().getField()).collect(Collectors.toList());
                    String mastTableInfo = "select " + String.join((CharSequence)",", field) + " from " + table + " where " + tableModel.getTableField() + "='" + mainId + "'";
                    Map<String, Object> dataAll = this.getMast(conn, mastTableInfo);
                    HashMap<String, Object> mastTable = new HashMap<String, Object>();
                    for (String mastKey : dataAll.keySet()) {
                        Object value = dataAll.get(mastKey);
                        FieLdsModel fieLdsModel = mastTableList.stream().filter(t -> mastKey.equals(t.getFormMastTableModel().getField().toLowerCase())).map(t -> t.getFormMastTableModel().getMastTable().getFieLdsModel()).findFirst().orElse(null);
                        value = this.info(fieLdsModel, value, true);
                        String dataKey = fieLdsModel.getVModel();
                        mastTable.put(dataKey, value);
                    }
                    data.putAll(mastTable);
                }
            }
            finally {
                if (Collections.singletonList(conn).get(0) != null) {
                    conn.close();
                }
            }
        }
        catch (SQLException e2) {
            log.error("\u67e5\u8be2\u5f02\u5e38\uff1a{}", (Object)e2.getMessage());
            throw new WorkFlowException(e2.getMessage());
        }
        return data;
    }

    private Map<String, Object> data(DataModel dataModel, List<FormAllModel> formAllModel) {
        Map<String, Object> dataMap = dataModel.getDataNewMap();
        HashMap<String, Object> result = new HashMap<String, Object>();
        List mastForm = formAllModel.stream().filter(t -> FormEnum.mast.getMessage().equals(t.getKeyName())).collect(Collectors.toList());
        List tableForm = formAllModel.stream().filter(t -> FormEnum.table.getMessage().equals(t.getKeyName())).collect(Collectors.toList());
        for (String key : dataMap.keySet()) {
            FormAllModel model = mastForm.stream().filter(t -> key.equals(t.getFormColumnModel().getFieLdsModel().getVModel())).findFirst().orElse(null);
            if (model != null) {
                FieLdsModel fieLdsModel = model.getFormColumnModel().getFieLdsModel();
                Object data = dataMap.get(key);
                data = this.info(fieLdsModel, data, false);
                result.put(key, data);
                continue;
            }
            FormAllModel childModel = tableForm.stream().filter(t -> key.equals(t.getChildList().getTableModel())).findFirst().orElse(null);
            if (childModel == null) continue;
            String childKeyName = childModel.getChildList().getTableModel();
            List childDataMap = (List)dataMap.get(key);
            ArrayList childdataAll = new ArrayList();
            for (Map child : childDataMap) {
                HashMap tablValue = new HashMap(16);
                for (String childKey : child.keySet()) {
                    FormColumnModel columnModel = childModel.getChildList().getChildList().stream().filter(t -> childKey.equals(t.getFieLdsModel().getVModel())).findFirst().orElse(null);
                    if (columnModel == null) continue;
                    FieLdsModel fieLdsModel = columnModel.getFieLdsModel();
                    Object childValue = child.get(childKey);
                    childValue = this.info(fieLdsModel, childValue, false);
                    tablValue.put(childKey, childValue);
                }
                childdataAll.add(tablValue);
            }
            result.put(childKeyName, childdataAll);
        }
        return result;
    }

    private Object info(FieLdsModel fieLdsModel, Object dataValue, boolean isTable) {
        Object value = dataValue;
        String keyName = fieLdsModel.getConfig().getKeyName();
        String format = fieLdsModel.getFormat();
        boolean multiple = fieLdsModel.getMultiple();
        String showLevel = fieLdsModel.getShowLevel();
        switch (keyName) {
            case "currOrganize": 
            case "currDept": {
                if (!ObjectUtil.isNotEmpty((Object)value)) break;
                OrganizeEntity organizeEntity = this.serviceUtil.getOrganizeInfo(String.valueOf(value));
                if ("all".equals(showLevel)) {
                    if (organizeEntity == null) break;
                    List<OrganizeEntity> organizeList = this.serviceUtil.getOrganizeId(organizeEntity.getId());
                    value = organizeList.stream().map(PermissionEntityBase::getFullName).collect(Collectors.joining("/"));
                    break;
                }
                if (organizeEntity == null) break;
                value = organizeEntity.getFullName();
                break;
            }
            case "createUser": 
            case "modifyUser": {
                UserEntity userEntity;
                if (!ObjectUtil.isNotEmpty((Object)value) || (userEntity = this.serviceUtil.getUserInfo(String.valueOf(value))) == null) break;
                value = userEntity.getRealName();
                break;
            }
            case "currPosition": {
                PositionEntity positionEntity;
                if (!ObjectUtil.isNotEmpty((Object)value) || (positionEntity = this.serviceUtil.getPositionInfo(String.valueOf(value))) == null) break;
                value = positionEntity.getFullName();
                break;
            }
            case "uploadFz": 
            case "uploadImg": {
                if (value == null) {
                    value = new ArrayList();
                    break;
                }
                if (!isTable) break;
                value = JsonUtil.getJsonToListMap((String)String.valueOf(value));
                break;
            }
            case "checkbox": 
            case "dateRange": 
            case "timeRange": {
                if (value == null) {
                    value = new ArrayList();
                    break;
                }
                if (!isTable) break;
                value = JsonUtil.getJsonToList((String)String.valueOf(value), String.class);
                break;
            }
            case "comSelect": 
            case "address": {
                if (!isTable) break;
                if (multiple) {
                    value = JsonUtil.getJsonToBean((String)String.valueOf(value), String[][].class);
                    break;
                }
                value = JsonUtil.getJsonToList((String)String.valueOf(value), String.class);
                break;
            }
            case "select": 
            case "userSelect": 
            case "depSelect": 
            case "posSelect": 
            case "treeSelect": {
                if (!isTable || !multiple) break;
                value = JsonUtil.getJsonToList((String)String.valueOf(value), String.class);
                break;
            }
            case "date": {
                if (!isTable) break;
                try {
                    SimpleDateFormat sdf = new SimpleDateFormat(format);
                    value = sdf.parse(String.valueOf(value)).getTime();
                }
                catch (Exception e) {
                    value = dataValue;
                }
                break;
            }
            case "slider": 
            case "switch": {
                if (!isTable) break;
                try {
                    value = Integer.valueOf(String.valueOf(value));
                }
                catch (Exception e) {
                    value = dataValue;
                }
                break;
            }
            case "cascader": {
                if (value == null) {
                    value = new ArrayList();
                    break;
                }
                if (!isTable) break;
                PropsBeanModel propsModel = (PropsBeanModel)JsonUtil.getJsonToBean((String)fieLdsModel.getProps().getProps(), PropsBeanModel.class);
                if (propsModel.getMultiple().booleanValue()) {
                    value = JsonUtil.getJsonToBean((String)String.valueOf(value), String[][].class);
                    break;
                }
                value = JsonUtil.getJsonToList((String)String.valueOf(value), String.class);
                break;
            }
        }
        return value;
    }

    public Map<String, Object> create(DataModel dataModel) throws WorkFlowException {
        try {
            List<FieLdsModel> fieLdsModelList = dataModel.getFieLdsModelList();
            List<TableModel> tableModelList = dataModel.getTableModelList();
            RecursionForm recursionForm = new RecursionForm(fieLdsModelList, tableModelList);
            ArrayList<FormAllModel> formAllModel = new ArrayList<FormAllModel>();
            FormCloumnUtil.recursionForm((RecursionForm)recursionForm, formAllModel);
            Map<String, Object> result = this.createDataList(dataModel, formAllModel);
            return result;
        }
        catch (Exception e) {
            log.error("\u65b0\u589e\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new WorkFlowException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> createDataList(DataModel dataModel, List<FormAllModel> formAllModel) throws SQLException {
        HashMap<String, Object> result = new HashMap(16);
        List<TableModel> tableModelList = dataModel.getTableModelList();
        UserEntity userEntity = this.serviceUtil.getUserInfo(this.userProvider.get().getUserId());
        dataModel.setUserEntity(userEntity);
        if (tableModelList.size() > 0) {
            boolean isOracle;
            DbLinkEntity link = dataModel.getLink();
            boolean bl = isOracle = DbTypeUtil.checkOracle((DataSourceMod)this.dataSourceModel) != false || DbTypeUtil.checkPostgre((DataSourceMod)this.dataSourceModel) != false;
            if (link != null) {
                isOracle = DbTypeUtil.checkOracle((DataSourceMod)link) != false || DbTypeUtil.checkPostgre((DataSourceMod)link) != false;
            }
            dataModel.setIsOracle(isOracle);
            Connection conn = this.getTableConn(link);
            try {
                conn.setAutoCommit(false);
                this.createTable(formAllModel, dataModel, conn, result);
                this.createMastTable(formAllModel, dataModel, conn, result);
                this.createMast(formAllModel, dataModel, conn, result);
            }
            finally {
                if (Collections.singletonList(conn).get(0) != null) {
                    conn.close();
                }
            }
        } else {
            result = this.createAll(dataModel, formAllModel);
        }
        return result;
    }

    private void createTable(List<FormAllModel> formAllModel, DataModel dataModel, Connection conn, Map<String, Object> result) throws SQLException {
        List<TableModel> tableModelList = dataModel.getTableModelList();
        Map<String, Object> dataNewMap = dataModel.getDataNewMap();
        Boolean isOracle = dataModel.getIsOracle();
        String mainId = dataModel.getMainId();
        UserEntity userEntity = dataModel.getUserEntity();
        List tableForm = formAllModel.stream().filter(t -> FormEnum.table.getMessage().equals(t.getKeyName())).collect(Collectors.toList());
        HashMap childMap = new HashMap();
        HashMap chidTable = new HashMap();
        tableForm.stream().forEach(t -> {
            FormColumnTableModel childListAll = t.getChildList();
            String tableModel = childListAll.getTableModel();
            List childList = childListAll.getChildList().stream().filter(g -> StringUtil.isNotEmpty((String)g.getFieLdsModel().getVModel())).collect(Collectors.toList());
            childMap.put(tableModel, childList);
            String tableName = childListAll.getTableName();
            Optional<TableModel> first = tableModelList.stream().filter(k -> k.getTable().equals(tableName)).findFirst();
            if (first.isPresent()) {
                TableModel childTable = first.get();
                chidTable.put(tableModel, childTable);
            }
        });
        for (String key : childMap.keySet()) {
            List chidList = dataNewMap.get(key) != null ? (List)dataNewMap.get(key) : new ArrayList();
            List formColumnModels = (List)childMap.get(key);
            HashMap<String, FieLdsModel> columMap = new HashMap<String, FieLdsModel>();
            for (FormColumnModel column : formColumnModels) {
                FieLdsModel fieLdsModel = column.getFieLdsModel();
                String vmodel = fieLdsModel.getVModel();
                columMap.put(vmodel, fieLdsModel);
            }
            TableModel tableModel = (TableModel)chidTable.get(key);
            String table = tableModel.getTable();
            String childKeyName = this.getKey(conn, table);
            Optional<TableModel> first = tableModelList.stream().filter(t -> t.getTable().equals(table)).findFirst();
            String mastKeyName = "";
            if (first.isPresent()) {
                mastKeyName = first.get().getTableField();
            }
            ArrayList<List<Object>> childDataAll = new ArrayList<List<Object>>();
            ArrayList childResultAll = new ArrayList();
            StringJoiner filedModel = new StringJoiner(",");
            StringJoiner filedValue = new StringJoiner(",");
            boolean isFile = true;
            for (Map objectMap : chidList) {
                ArrayList<Object> childData = new ArrayList<Object>();
                HashMap childOneResult = new HashMap(16);
                for (String childKey : columMap.keySet()) {
                    FieLdsModel fieLdsModel = (FieLdsModel)columMap.get(childKey);
                    String keyName = fieLdsModel.getConfig().getKeyName();
                    Object data = objectMap.get(childKey);
                    data = this.create(fieLdsModel, data, true, userEntity);
                    String value = isOracle != false && ("date".equals(keyName) || "modifyTime".equals(keyName) || "createTime".equals(keyName)) ? "to_date(?,'yyyy-mm-dd HH24:mi:ss')" : "?";
                    childData.add(data);
                    childOneResult.put(childKey, data);
                    if (!isFile) continue;
                    filedModel.add(childKey);
                    filedValue.add(value);
                }
                childData.add(RandomUtil.uuId());
                childData.add(mainId);
                if (isFile) {
                    filedModel.add(childKeyName);
                    filedValue.add("?");
                    filedModel.add(mastKeyName);
                    filedValue.add("?");
                }
                isFile = false;
                childResultAll.add(childOneResult);
                childDataAll.add(childData);
            }
            result.put(key, childResultAll);
            String[] del = new String[]{};
            String childSql = "insert into " + table + "(" + filedModel + ") values (" + filedValue + ")";
            this.sql(childSql, childDataAll, del, conn, false);
        }
    }

    private void createMastTable(List<FormAllModel> formAllModel, DataModel dataModel, Connection conn, Map<String, Object> result) throws SQLException {
        List<TableModel> tableModelList = dataModel.getTableModelList();
        Map<String, Object> dataNewMap = dataModel.getDataNewMap();
        Boolean isOracle = dataModel.getIsOracle();
        String mainId = dataModel.getMainId();
        UserEntity userEntity = dataModel.getUserEntity();
        Map<String, List<FormAllModel>> mastTableAll = formAllModel.stream().filter(t -> FormEnum.mastTable.getMessage().equals(t.getKeyName())).collect(Collectors.groupingBy(e -> e.getFormMastTableModel().getTable()));
        for (String key : mastTableAll.keySet()) {
            Optional<TableModel> first = tableModelList.stream().filter(t -> t.getTable().equals(key)).findFirst();
            if (!first.isPresent()) {
                throw new SQLException(MsgCode.COD001.get());
            }
            TableModel tableModel = first.get();
            String tableModelTable = tableModel.getTable();
            String childKeyName = this.getKey(conn, tableModelTable);
            String mastKeyName = tableModel.getTableField();
            List<FormAllModel> masTableList = mastTableAll.get(key);
            StringJoiner filedModel = new StringJoiner(",");
            StringJoiner filedValue = new StringJoiner(",");
            LinkedList<Object> mastData = new LinkedList<Object>();
            for (FormAllModel model : masTableList) {
                FormMastTableModel formMastTableModel = model.getFormMastTableModel();
                FormColumnModel mastTable = formMastTableModel.getMastTable();
                FieLdsModel fieLdsModel = mastTable.getFieLdsModel();
                String mostTableKey = fieLdsModel.getVModel();
                if (StringUtil.isEmpty((String)mostTableKey)) continue;
                String keyName = fieLdsModel.getConfig().getKeyName();
                Object data = dataNewMap.get(mostTableKey);
                data = this.create(fieLdsModel, data, true, userEntity);
                result.put(mostTableKey, data);
                mastData.add(data);
                String field = formMastTableModel.getField();
                String value = isOracle != false && ("date".equals(keyName) || "modifyTime".equals(keyName) || "createTime".equals(keyName)) ? "to_date(?,'yyyy-mm-dd HH24:mi:ss')" : "?";
                filedModel.add(field);
                filedValue.add(value);
            }
            mastData.add(RandomUtil.uuId());
            filedModel.add(childKeyName);
            filedValue.add("?");
            mastData.add(mainId);
            filedModel.add(mastKeyName);
            filedValue.add("?");
            String sql = "insert into " + tableModelTable + "(" + filedModel + ") values (" + filedValue + ")";
            LinkedList<List<Object>> data = new LinkedList<List<Object>>();
            data.add(mastData);
            this.sql(sql, data, new String[0], conn, false);
        }
    }

    private void createMast(List<FormAllModel> formAllModel, DataModel dataModel, Connection conn, Map<String, Object> result) throws SQLException {
        List<TableModel> tableModelList = dataModel.getTableModelList();
        Map<String, Object> dataNewMap = dataModel.getDataNewMap();
        Boolean isOracle = dataModel.getIsOracle();
        String mainId = dataModel.getMainId();
        UserEntity userEntity = dataModel.getUserEntity();
        Optional<TableModel> first = tableModelList.stream().filter(t -> "1".equals(t.getTypeId())).findFirst();
        if (!first.isPresent()) {
            throw new SQLException(MsgCode.COD001.get());
        }
        TableModel tableModel = first.get();
        String mastTableName = tableModel.getTable();
        List mastForm = formAllModel.stream().filter(t -> FormEnum.mast.getMessage().equals(t.getKeyName())).filter(t -> StringUtil.isNotEmpty((String)t.getFormColumnModel().getFieLdsModel().getVModel())).collect(Collectors.toList());
        StringJoiner filedModel = new StringJoiner(",");
        StringJoiner filedValue = new StringJoiner(",");
        LinkedList<Object> mastData = new LinkedList<Object>();
        for (FormAllModel model : mastForm) {
            FieLdsModel fieLdsModel = model.getFormColumnModel().getFieLdsModel();
            String keyName = fieLdsModel.getConfig().getKeyName();
            String field = fieLdsModel.getVModel();
            Object data = dataNewMap.get(field);
            data = this.create(fieLdsModel, data, true, userEntity);
            mastData.add(data);
            String value = isOracle != false && ("date".equals(keyName) || "modifyTime".equals(keyName) || "createTime".equals(keyName)) ? "to_date(?,'yyyy-mm-dd HH24:mi:ss')" : "?";
            filedModel.add(field);
            filedValue.add(value);
            result.put(field, data);
        }
        String keyName = this.getKey(conn, mastTableName);
        mastData.add(mainId);
        filedModel.add(keyName);
        filedValue.add("?");
        String sql = "insert into " + mastTableName + "(" + filedModel + ") values (" + filedValue + ")";
        LinkedList<List<Object>> data = new LinkedList<List<Object>>();
        data.add(mastData);
        this.sql(sql, data, new String[0], conn, true);
    }

    private Object create(FieLdsModel fieLdsModel, Object dataValue, boolean isTable, UserEntity userEntity) {
        String keyName = fieLdsModel.getConfig().getKeyName();
        String rule = fieLdsModel.getConfig().getRule();
        Object value = dataValue;
        switch (keyName) {
            case "createUser": {
                value = userEntity.getId();
                break;
            }
            case "createTime": {
                value = DateUtil.getNow((String)"+8");
                break;
            }
            case "currOrganize": 
            case "currDept": {
                value = userEntity.getOrganizeId();
                break;
            }
            case "modifyTime": {
                value = null;
                break;
            }
            case "modifyUser": {
                value = null;
                break;
            }
            case "currPosition": {
                value = userEntity.getPositionId();
                break;
            }
            case "billRule": {
                try {
                    value = this.serviceUtil.getBillNumber(rule);
                }
                catch (Exception e) {
                    value = null;
                }
                break;
            }
            case "date": {
                if (!isTable) break;
                try {
                    value = DateUtil.dateToString((Date)new Date(Long.valueOf(String.valueOf(dataValue))), (String)"yyyy-MM-dd HH:mm:ss");
                }
                catch (Exception exception) {}
                break;
            }
            case "numInput": {
                if (!isTable) break;
                try {
                    value = new BigDecimal(String.valueOf(dataValue));
                }
                catch (Exception exception) {}
                break;
            }
            default: {
                if (!isTable) break;
                if (value instanceof List) {
                    value = JsonUtil.getObjectToString((Object)value);
                    break;
                }
                if (!(value instanceof CharSequence) || !StrUtil.isEmpty((CharSequence)((CharSequence)value))) break;
                value = null;
            }
        }
        return value;
    }

    private Map<String, Object> createAll(DataModel dataModel, List<FormAllModel> formAllModel) {
        Map<String, Object> dataNewMap = dataModel.getDataNewMap();
        UserEntity userEntity = dataModel.getUserEntity();
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        List mastForm = formAllModel.stream().filter(t -> FormEnum.mast.getMessage().equals(t.getKeyName())).collect(Collectors.toList());
        List tableForm = formAllModel.stream().filter(t -> FormEnum.table.getMessage().equals(t.getKeyName())).collect(Collectors.toList());
        for (String key : dataNewMap.keySet()) {
            FormAllModel model = mastForm.stream().filter(t -> key.equals(t.getFormColumnModel().getFieLdsModel().getVModel())).findFirst().orElse(null);
            if (model != null) {
                FieLdsModel fieLdsModel = model.getFormColumnModel().getFieLdsModel();
                Object data = dataNewMap.get(key);
                data = this.create(fieLdsModel, data, false, userEntity);
                result.put(key, data);
                continue;
            }
            FormAllModel childModel = tableForm.stream().filter(t -> key.equals(t.getChildList().getTableModel())).findFirst().orElse(null);
            if (childModel == null) continue;
            List childList = childModel.getChildList().getChildList();
            List childDataMap = (List)dataNewMap.get(key);
            ArrayList childResult = new ArrayList();
            for (Map objectMap : childDataMap) {
                HashMap childOneResult = new HashMap(16);
                for (String childKey : objectMap.keySet()) {
                    FormColumnModel columnModel = childList.stream().filter(t -> childKey.equals(t.getFieLdsModel().getVModel())).findFirst().orElse(null);
                    if (columnModel == null) continue;
                    FieLdsModel fieLdsModel = columnModel.getFieLdsModel();
                    Object data = objectMap.get(childKey);
                    data = this.create(fieLdsModel, data, false, userEntity);
                    childOneResult.put(childKey, data);
                }
                childResult.add(childOneResult);
            }
            result.put(key, childResult);
        }
        return result;
    }

    public Map<String, Object> update(DataModel dataModel) throws WorkFlowException {
        try {
            List<FieLdsModel> fieLdsModelList = dataModel.getFieLdsModelList();
            List<TableModel> tableModelList = dataModel.getTableModelList();
            RecursionForm recursionForm = new RecursionForm(fieLdsModelList, tableModelList);
            ArrayList<FormAllModel> formAllModel = new ArrayList<FormAllModel>();
            FormCloumnUtil.recursionForm((RecursionForm)recursionForm, formAllModel);
            Map<String, Object> result = this.updateDataList(dataModel, formAllModel);
            return result;
        }
        catch (Exception e) {
            log.error("\u4fee\u6539\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new WorkFlowException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> updateDataList(DataModel dataModel, List<FormAllModel> formAllModel) throws SQLException {
        HashMap<String, Object> result = new HashMap(16);
        List<TableModel> tableModelList = dataModel.getTableModelList();
        UserEntity userEntity = this.serviceUtil.getUserInfo(this.userProvider.get().getUserId());
        dataModel.setUserEntity(userEntity);
        if (tableModelList.size() > 0) {
            boolean isOracle;
            DbLinkEntity link = dataModel.getLink();
            boolean bl = isOracle = DbTypeUtil.checkOracle((DataSourceMod)this.dataSourceModel) != false || DbTypeUtil.checkPostgre((DataSourceMod)this.dataSourceModel) != false;
            if (link != null) {
                isOracle = DbTypeUtil.checkOracle((DataSourceMod)link) != false || DbTypeUtil.checkPostgre((DataSourceMod)link) != false;
            }
            Connection conn = this.getTableConn(link);
            try {
                conn.setAutoCommit(false);
                dataModel.setIsOracle(isOracle);
                this.updateTable(formAllModel, dataModel, conn, result);
                this.updateMastTable(formAllModel, dataModel, conn, result);
                this.updateMast(formAllModel, dataModel, conn, result);
            }
            finally {
                if (Collections.singletonList(conn).get(0) != null) {
                    conn.close();
                }
            }
        } else {
            result = this.updateAll(dataModel, formAllModel);
        }
        return result;
    }

    private void updateTable(List<FormAllModel> formAllModel, DataModel dataModel, Connection conn, Map<String, Object> result) throws SQLException {
        List<TableModel> tableModelList = dataModel.getTableModelList();
        Map<String, Object> dataNewMap = dataModel.getDataNewMap();
        Boolean isOracle = dataModel.getIsOracle();
        String mainId = dataModel.getMainId();
        List tableForm = formAllModel.stream().filter(t -> FormEnum.table.getMessage().equals(t.getKeyName())).collect(Collectors.toList());
        HashMap childMap = new HashMap();
        HashMap chidTable = new HashMap();
        tableForm.stream().forEach(t -> {
            FormColumnTableModel childListAll = t.getChildList();
            String tableModel = childListAll.getTableModel();
            List childList = childListAll.getChildList().stream().filter(g -> StringUtil.isNotEmpty((String)g.getFieLdsModel().getVModel())).collect(Collectors.toList());
            childMap.put(tableModel, childList);
            String tableName = childListAll.getTableName();
            Optional<TableModel> first = tableModelList.stream().filter(k -> k.getTable().equals(tableName)).findFirst();
            if (first.isPresent()) {
                TableModel childTable = first.get();
                chidTable.put(tableModel, childTable);
            }
        });
        for (String key : childMap.keySet()) {
            List chidList = dataNewMap.get(key) != null ? (List)dataNewMap.get(key) : new ArrayList();
            List formColumnModels = (List)childMap.get(key);
            HashMap<String, FieLdsModel> columMap = new HashMap<String, FieLdsModel>();
            for (FormColumnModel column : formColumnModels) {
                FieLdsModel fieLdsModel = column.getFieLdsModel();
                String vmodel = fieLdsModel.getVModel();
                columMap.put(vmodel, fieLdsModel);
            }
            TableModel tableModel = (TableModel)chidTable.get(key);
            String table = tableModel.getTable();
            String childKeyName = this.getKey(conn, table);
            Optional<TableModel> first = tableModelList.stream().filter(t -> t.getTable().equals(table)).findFirst();
            if (!first.isPresent()) {
                throw new SQLException(MsgCode.COD001.get());
            }
            String mastKeyName = first.get().getTableField();
            ArrayList<List<Object>> childDataAll = new ArrayList<List<Object>>();
            ArrayList childResultAll = new ArrayList();
            StringJoiner filedModel = new StringJoiner(",");
            StringJoiner filedValue = new StringJoiner(",");
            boolean isFile = true;
            for (Map objectMap : chidList) {
                ArrayList<Object> childData = new ArrayList<Object>();
                HashMap childOneResult = new HashMap(16);
                for (String childKey : columMap.keySet()) {
                    FieLdsModel fieLdsModel = (FieLdsModel)columMap.get(childKey);
                    String keyName = fieLdsModel.getConfig().getKeyName();
                    Object data = objectMap.get(childKey);
                    data = this.update(fieLdsModel, data, true);
                    String value = isOracle != false && ("date".equals(keyName) || "modifyTime".equals(keyName) || "createTime".equals(keyName)) ? "to_date(?,'yyyy-mm-dd HH24:mi:ss')" : "?";
                    childData.add(data);
                    childOneResult.put(childKey, data);
                    if (!isFile) continue;
                    filedModel.add(childKey);
                    filedValue.add(value);
                }
                childData.add(RandomUtil.uuId());
                childData.add(mainId);
                if (isFile) {
                    filedModel.add(childKeyName);
                    filedValue.add("?");
                    filedModel.add(mastKeyName);
                    filedValue.add("?");
                }
                isFile = false;
                childResultAll.add(childOneResult);
                childDataAll.add(childData);
            }
            result.put(key, childResultAll);
            String[] del = new String[]{"delete from " + table + " where " + mastKeyName + " = ?", mainId};
            String childSql = "insert into " + table + "(" + filedModel + ") values (" + filedValue + ")";
            this.sql(childSql, childDataAll, del, conn, false);
        }
    }

    private void updateMastTable(List<FormAllModel> formAllModel, DataModel dataModel, Connection conn, Map<String, Object> result) throws SQLException {
        List<TableModel> tableModelList = dataModel.getTableModelList();
        Map<String, Object> dataNewMap = dataModel.getDataNewMap();
        Boolean isOracle = dataModel.getIsOracle();
        String mainId = dataModel.getMainId();
        Map<String, List<FormAllModel>> mastTableAll = formAllModel.stream().filter(t -> FormEnum.mastTable.getMessage().equals(t.getKeyName())).collect(Collectors.groupingBy(e -> e.getFormMastTableModel().getTable()));
        for (String key : mastTableAll.keySet()) {
            Optional<TableModel> first = tableModelList.stream().filter(t -> t.getTable().equals(key)).findFirst();
            if (!first.isPresent()) {
                throw new SQLException(MsgCode.COD001.get());
            }
            TableModel tableModel = first.get();
            String tableModelTable = tableModel.getTable();
            String childKeyName = this.getKey(conn, tableModelTable);
            String mastKeyName = tableModel.getTableField();
            List<FormAllModel> masTableList = mastTableAll.get(key);
            StringJoiner filed = new StringJoiner(",");
            LinkedList<Object> mastData = new LinkedList<Object>();
            for (FormAllModel model : masTableList) {
                FormMastTableModel formMastTableModel = model.getFormMastTableModel();
                FormColumnModel mastTable = formMastTableModel.getMastTable();
                FieLdsModel fieLdsModel = mastTable.getFieLdsModel();
                String mostTableKey = fieLdsModel.getVModel();
                String keyName = fieLdsModel.getConfig().getKeyName();
                Object data = dataNewMap.get(mostTableKey);
                data = this.update(fieLdsModel, data, true);
                result.put(mostTableKey, data);
                mastData.add(data);
                String field = formMastTableModel.getField();
                String value = isOracle != false && ("date".equals(keyName) || "modifyTime".equals(keyName) || "createTime".equals(keyName)) ? "to_date(?,'yyyy-mm-dd HH24:mi:ss')" : "?";
                filed.add(field + "=" + value);
            }
            mastData.add(RandomUtil.uuId());
            filed.add(childKeyName + "= ?");
            mastData.add(mainId);
            String sql = "update " + tableModelTable + " set " + filed + " where " + mastKeyName + "= ?";
            LinkedList<List<Object>> data = new LinkedList<List<Object>>();
            data.add(mastData);
            this.sql(sql, data, new String[0], conn, false);
        }
    }

    private void updateMast(List<FormAllModel> formAllModel, DataModel dataModel, Connection conn, Map<String, Object> result) throws SQLException {
        List<TableModel> tableModelList = dataModel.getTableModelList();
        Map<String, Object> dataNewMap = dataModel.getDataNewMap();
        Boolean isOracle = dataModel.getIsOracle();
        String mainId = dataModel.getMainId();
        Optional<TableModel> first = tableModelList.stream().filter(t -> "1".equals(t.getTypeId())).findFirst();
        if (!first.isPresent()) {
            throw new SQLException(MsgCode.COD001.get());
        }
        TableModel tableModel = first.get();
        String mastTableName = tableModel.getTable();
        List mastForm = formAllModel.stream().filter(t -> FormEnum.mast.getMessage().equals(t.getKeyName())).filter(t -> StringUtil.isNotEmpty((String)t.getFormColumnModel().getFieLdsModel().getVModel())).collect(Collectors.toList());
        StringJoiner filed = new StringJoiner(",");
        LinkedList<Object> mastData = new LinkedList<Object>();
        for (FormAllModel model : mastForm) {
            FieLdsModel fieLdsModel = model.getFormColumnModel().getFieLdsModel();
            String keyName = fieLdsModel.getConfig().getKeyName();
            String field = fieLdsModel.getVModel();
            Object data = dataNewMap.get(field);
            data = this.update(fieLdsModel, data, true);
            mastData.add(data);
            String value = isOracle != false && ("date".equals(keyName) || "modifyTime".equals(keyName) || "createTime".equals(keyName)) ? "to_date(?,'yyyy-mm-dd HH24:mi:ss')" : "?";
            filed.add(field + "=" + value);
            result.put(field, data);
        }
        mastData.add(mainId);
        String keyName = this.getKey(conn, mastTableName);
        String sql = "update " + mastTableName + " set " + filed + " where " + keyName + "= ?";
        LinkedList<List<Object>> data = new LinkedList<List<Object>>();
        data.add(mastData);
        this.sql(sql, data, new String[0], conn, true);
    }

    private Map<String, Object> updateAll(DataModel dataModel, List<FormAllModel> formAllModel) {
        Map<String, Object> dataNewMap = dataModel.getDataNewMap();
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        List mastForm = formAllModel.stream().filter(t -> FormEnum.mast.getMessage().equals(t.getKeyName())).collect(Collectors.toList());
        List tableForm = formAllModel.stream().filter(t -> FormEnum.table.getMessage().equals(t.getKeyName())).collect(Collectors.toList());
        for (String key : dataNewMap.keySet()) {
            FormAllModel model = mastForm.stream().filter(t -> key.equals(t.getFormColumnModel().getFieLdsModel().getVModel())).findFirst().orElse(null);
            if (model != null) {
                FieLdsModel fieLdsModel = model.getFormColumnModel().getFieLdsModel();
                Object data = dataNewMap.get(key);
                data = this.update(fieLdsModel, data, false);
                result.put(key, data);
                continue;
            }
            FormAllModel childModel = tableForm.stream().filter(t -> key.equals(t.getChildList().getTableModel())).findFirst().orElse(null);
            if (childModel == null) continue;
            List childDataMap = (List)dataNewMap.get(key);
            ArrayList childResult = new ArrayList();
            for (Map objectMap : childDataMap) {
                HashMap childOneResult = new HashMap(16);
                for (String childKey : objectMap.keySet()) {
                    FormColumnModel columnModel = childModel.getChildList().getChildList().stream().filter(t -> childKey.equals(t.getFieLdsModel().getVModel())).findFirst().orElse(null);
                    if (columnModel == null) continue;
                    FieLdsModel fieLdsModel = columnModel.getFieLdsModel();
                    Object data = objectMap.get(childKey);
                    data = this.update(fieLdsModel, data, false);
                    childOneResult.put(childKey, data);
                }
                childResult.add(childOneResult);
            }
            result.put(key, childResult);
        }
        return result;
    }

    private Object update(FieLdsModel fieLdsModel, Object dataValue, boolean isTable) {
        String keyName = fieLdsModel.getConfig().getKeyName();
        String rule = fieLdsModel.getConfig().getRule();
        UserInfo userInfo = this.userProvider.get();
        Object value = dataValue;
        switch (keyName) {
            case "createUser": {
                if (!ObjectUtil.isEmpty((Object)value)) {
                    UserEntity userEntity = this.serviceUtil.getByRealName(String.valueOf(value));
                    value = userEntity != null ? userEntity.getId() : userInfo.getUserId();
                    break;
                }
                value = userInfo.getUserId();
                break;
            }
            case "createTime": {
                if (!ObjectUtil.isEmpty((Object)value)) break;
                value = DateUtil.getNow((String)"+8");
                break;
            }
            case "currOrganize": 
            case "currDept": {
                if (!ObjectUtil.isEmpty((Object)value)) {
                    OrganizeEntity organizeEntity;
                    String posValue = String.valueOf(value);
                    if (posValue.contains("/")) {
                        posValue = posValue.substring(posValue.lastIndexOf("/") + 1);
                    }
                    value = (organizeEntity = this.serviceUtil.getOrganizeFullName(posValue)) != null ? organizeEntity.getId() : value;
                    break;
                }
                value = StringUtil.isNotEmpty((String)userInfo.getDepartmentId()) ? userInfo.getDepartmentId() : userInfo.getOrganizeId();
                break;
            }
            case "modifyTime": {
                value = DateUtil.getNow((String)"+8");
                break;
            }
            case "modifyUser": {
                value = userInfo.getUserId();
                break;
            }
            case "currPosition": {
                if (!ObjectUtil.isEmpty((Object)value)) {
                    PositionEntity positionEntity = this.serviceUtil.getPositionFullName(String.valueOf(value));
                    value = positionEntity != null ? positionEntity.getId() : "";
                    break;
                }
                value = userInfo.getPositionIds().length > 0 ? userInfo.getPositionIds()[0] : "";
                break;
            }
            case "billRule": {
                if (!ObjectUtil.isEmpty((Object)value)) break;
                try {
                    value = this.serviceUtil.getBillNumber(rule);
                }
                catch (Exception e) {
                    value = null;
                }
                break;
            }
            case "date": {
                if (!isTable) break;
                try {
                    value = DateUtil.dateToString((Date)new Date(Long.valueOf(String.valueOf(dataValue))), (String)"yyyy-MM-dd HH:mm:ss");
                }
                catch (Exception exception) {}
                break;
            }
            case "numInput": {
                if (!isTable) break;
                try {
                    value = new BigDecimal(String.valueOf(dataValue));
                }
                catch (Exception exception) {}
                break;
            }
            default: {
                if (!isTable || !(value instanceof List)) break;
                value = String.valueOf(value);
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sql(String sql, List<List<Object>> dataAll, String[] del, Connection conn, boolean isCommit) throws SQLException {
        try {
            if (del.length > 0) {
                PreparedStatement delete = conn.prepareStatement(del[0]);
                try {
                    delete.setObject(1, del[1]);
                    delete.addBatch();
                    delete.executeBatch();
                }
                finally {
                    if (Collections.singletonList(delete).get(0) != null) {
                        delete.close();
                    }
                }
            }
            PreparedStatement save = conn.prepareStatement(sql);
            try {
                for (List<Object> childData : dataAll) {
                    for (int i = 0; i < childData.size(); ++i) {
                        Object data = childData.get(i);
                        save.setObject(i + 1, data);
                    }
                    save.addBatch();
                    save.executeBatch();
                }
                if (isCommit) {
                    conn.commit();
                }
            }
            finally {
                if (Collections.singletonList(save).get(0) != null) {
                    save.close();
                }
            }
        }
        catch (SQLException e) {
            conn.rollback();
            throw new SQLException(e.getMessage());
        }
    }
}

