/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.workflow.engine.util;

import com.bringspring.common.base.Pagination;
import com.bringspring.common.database.model.entity.DbLinkEntity;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.StringUtil;
import com.bringspring.common.util.enums.DictionaryDataEnum;
import com.bringspring.system.base.entity.DictionaryDataEntity;
import com.bringspring.system.base.model.dbtable.DbTableCreate;
import com.bringspring.system.base.service.BillRuleService;
import com.bringspring.system.base.service.DataInterfaceService;
import com.bringspring.system.base.service.DbTableService;
import com.bringspring.system.base.service.DblinkService;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.system.message.model.message.SentMessageForm;
import com.bringspring.system.message.util.SentMessageUtil;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.PositionEntity;
import com.bringspring.system.permission.entity.RoleEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.entity.UserRelationEntity;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.PositionService;
import com.bringspring.system.permission.service.RoleService;
import com.bringspring.system.permission.service.UserRelationService;
import com.bringspring.system.permission.service.UserService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ServiceAllUtil {
    @Autowired
    private DblinkService dblinkService;
    @Autowired
    private DbTableService dbTableService;
    @Autowired
    private DictionaryDataService dictionaryDataService;
    @Autowired
    private UserRelationService userRelationService;
    @Autowired
    private UserService userService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private PositionService positionService;
    @Autowired
    private BillRuleService billRuleService;
    @Autowired
    private DataInterfaceService dataInterfaceService;
    @Autowired
    private SentMessageUtil sentMessageUtil;

    public DbLinkEntity getDbLink(String dbLink) {
        DbLinkEntity link = StringUtil.isNotEmpty((String)dbLink) ? this.dblinkService.getInfo(dbLink) : null;
        return link;
    }

    public void createTable(List<DbTableCreate> dbTable) throws DataException {
        for (DbTableCreate dbTableCreate : dbTable) {
            this.dbTableService.createTable(dbTableCreate);
        }
    }

    public List<DictionaryDataEntity> getDiList() {
        List dictionList = this.dictionaryDataService.getList(DictionaryDataEnum.FLOWWOEK_ENGINE.getDictionaryTypeId());
        return dictionList;
    }

    public List<DictionaryDataEntity> getDictionName(List<String> id) {
        List dictionList = this.dictionaryDataService.getDictionName(id);
        return dictionList;
    }

    public List<UserRelationEntity> getListByUserIdAll(List<String> id) {
        List list = this.userRelationService.getListByUserIdAll(id);
        return list;
    }

    public List<UserRelationEntity> getListByObjectIdAll(List<String> id) {
        List list = this.userRelationService.getListByObjectIdAll(id);
        return list;
    }

    public List<UserEntity> getUserName(List<String> id) {
        List list = this.userService.getUserName(id);
        return list;
    }

    public List<UserEntity> getUserName(List<String> id, Pagination pagination) {
        List list = this.userService.getUserName(id, pagination);
        return list;
    }

    public UserEntity getUserInfo(String id) {
        UserEntity entity = StringUtil.isNotEmpty((String)id) ? this.userService.getInfo(id) : null;
        return entity;
    }

    public UserEntity getByRealName(String realName) {
        UserEntity entity = StringUtil.isNotEmpty((String)realName) ? this.userService.getByRealName(realName) : null;
        return entity;
    }

    public String getBillNumber(String enCode) {
        String billNo = "";
        try {
            billNo = this.billRuleService.getBillNumber(enCode, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return billNo;
    }

    public void useBillNumber(String enCode) {
        this.billRuleService.useBillNumber(enCode);
    }

    public List<RoleEntity> getListByIds(List<String> id) {
        List list = this.roleService.getListByIds(id);
        return list;
    }

    public List<OrganizeEntity> getOrganizeName(List<String> id) {
        List list = this.organizeService.getOrganizeName(id);
        return list;
    }

    public OrganizeEntity getOrganizeInfo(String id) {
        OrganizeEntity entity = StringUtil.isNotEmpty((String)id) ? this.organizeService.getInfo(id) : null;
        return entity;
    }

    public OrganizeEntity getOrganizeFullName(String fullName) {
        OrganizeEntity entity = this.organizeService.getByFullName(fullName);
        return entity;
    }

    public List<OrganizeEntity> getOrganizeId(String organizeId) {
        ArrayList<OrganizeEntity> organizeList = new ArrayList<OrganizeEntity>();
        this.organizeService.getOrganizeId(organizeId, organizeList);
        Collections.reverse(organizeList);
        return organizeList;
    }

    public List<PositionEntity> getPositionName(List<String> id) {
        List list = this.positionService.getPositionName(id);
        return list;
    }

    public PositionEntity getPositionFullName(String fullName) {
        PositionEntity entity = this.positionService.getByFullName(fullName);
        return entity;
    }

    public PositionEntity getPositionInfo(String id) {
        PositionEntity entity = StringUtil.isNotEmpty((String)id) ? this.positionService.getInfo(id) : null;
        return entity;
    }

    public void infoToId(String interId, Map<String, String> parameterMap) {
        this.dataInterfaceService.infoToId(interId, null, parameterMap);
    }

    public void sendMessage(List<SentMessageForm> messageListAll) {
        for (SentMessageForm messageForm : messageListAll) {
            if (messageForm.getToUserIds().size() <= 0) continue;
            this.sentMessageUtil.sendMessage(messageForm);
        }
    }
}

