/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.workflow.engine.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.workflow.engine.entity.FlowEngineEntity;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.model.flowmonitor.FlowMonitorListVO;
import com.bringspring.workflow.engine.model.flowtask.FlowDeleteModel;
import com.bringspring.workflow.engine.model.flowtask.PaginationFlowTask;
import com.bringspring.workflow.engine.service.FlowEngineService;
import com.bringspring.workflow.engine.service.FlowTaskService;
import com.bringspring.workflow.engine.util.ServiceAllUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6d41\u7a0b\u76d1\u63a7"}, value="FlowMonitor")
@RestController
@RequestMapping(value={"/api/workflow/Engine/FlowMonitor"})
public class FlowMonitorController {
    @Autowired
    private FlowEngineService flowEngineService;
    @Autowired
    private FlowTaskService flowTaskService;
    @Autowired
    private ServiceAllUtil serviceUtil;

    @ApiOperation(value="\u83b7\u53d6\u6d41\u7a0b\u76d1\u63a7\u5217\u8868")
    @GetMapping
    public ActionResult<PageListVO<FlowMonitorListVO>> list(PaginationFlowTask paginationFlowTask) {
        List<FlowTaskEntity> list = this.flowTaskService.getMonitorList(paginationFlowTask);
        List<FlowEngineEntity> engineList = this.flowEngineService.getFlowList(list.stream().map(t -> t.getFlowId()).collect(Collectors.toList()));
        List<UserEntity> userList = this.serviceUtil.getUserName(list.stream().map(t -> t.getCreatorUserId()).collect(Collectors.toList()));
        LinkedList<FlowMonitorListVO> listVO = new LinkedList<FlowMonitorListVO>();
        for (FlowTaskEntity taskEntity : list) {
            FlowMonitorListVO vo = (FlowMonitorListVO)JsonUtil.getJsonToBean((Object)taskEntity, FlowMonitorListVO.class);
            UserEntity user = userList.stream().filter(t -> t.getId().equals(taskEntity.getCreatorUserId())).findFirst().orElse(null);
            vo.setUserName(user != null ? user.getRealName() + "/" + user.getAccount() : "");
            FlowEngineEntity engine = engineList.stream().filter(t -> t.getId().equals(taskEntity.getFlowId())).findFirst().orElse(null);
            if (engine == null) continue;
            vo.setFormData(engine.getFormData());
            vo.setFormType(engine.getFormType());
            listVO.add(vo);
        }
        PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)paginationFlowTask), PaginationVO.class);
        return ActionResult.page(listVO, (PaginationVO)paginationVO);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u6d41\u7a0b\u76d1\u63a7")
    @DeleteMapping
    public ActionResult delete(@RequestBody FlowDeleteModel deleteModel) throws WorkFlowException {
        String[] taskId = deleteModel.getIds().split(",");
        this.flowTaskService.delete(taskId);
        return ActionResult.success((String)MsgCode.SU003.get());
    }
}

