/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.workflow.engine.util;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.net.URLEncodeUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.context.SpringContext;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.message.model.message.SentMessageForm;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.workflow.engine.entity.FlowEngineEntity;
import com.bringspring.workflow.engine.entity.FlowTaskCirculateEntity;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.entity.FlowTaskNodeEntity;
import com.bringspring.workflow.engine.entity.FlowTaskOperatorEntity;
import com.bringspring.workflow.engine.entity.FlowTaskOperatorRecordEntity;
import com.bringspring.workflow.engine.enums.FlowMessageEnum;
import com.bringspring.workflow.engine.enums.FlowTaskStatusEnum;
import com.bringspring.workflow.engine.model.flowengine.FlowModel;
import com.bringspring.workflow.engine.model.flowengine.shuntjson.childnode.FuncConfig;
import com.bringspring.workflow.engine.model.flowengine.shuntjson.childnode.MsgConfig;
import com.bringspring.workflow.engine.model.flowengine.shuntjson.childnode.Properties;
import com.bringspring.workflow.engine.model.flowengine.shuntjson.childnode.TemplateJsonModel;
import com.bringspring.workflow.engine.model.flowengine.shuntjson.nodejson.ChildNodeList;
import com.bringspring.workflow.engine.model.flowmessage.FlowEventModel;
import com.bringspring.workflow.engine.model.flowmessage.FlowMessageModel;
import com.bringspring.workflow.engine.model.flowmessage.FlowMsgModel;
import com.bringspring.workflow.engine.model.flowtask.FlowContModel;
import com.bringspring.workflow.engine.service.FlowDelegateService;
import com.bringspring.workflow.engine.service.FlowEngineService;
import com.bringspring.workflow.engine.service.FlowTaskService;
import com.bringspring.workflow.engine.util.FlowNature;
import com.bringspring.workflow.engine.util.ServiceAllUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.ReflectionUtils;

@Component
public class FlowMsgUtil {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private FlowTaskService flowTaskService;
    @Autowired
    private ServiceAllUtil serviceUtil;
    @Autowired
    private FlowDelegateService flowDelegateService;
    @Autowired
    private FlowEngineService flowEngineService;

    public void message(FlowMsgModel flowMsgModel) {
        List<SentMessageForm> delegationMsg;
        Object messageModel;
        List<FlowTaskOperatorEntity> taskOperatorList;
        ArrayList<SentMessageForm> messageList;
        MsgConfig taskMsgConfig;
        Properties taskProperties;
        ChildNodeList taskChildNode;
        FlowTaskNodeEntity taskNode;
        ArrayList<SentMessageForm> messageList2;
        MsgConfig msgConfig;
        Map<String, List<FlowTaskOperatorEntity>> operatorMap;
        Properties properties;
        ChildNodeList childNode;
        Map<String, Object> data = flowMsgModel.getData();
        ArrayList<SentMessageForm> messageListAll = new ArrayList<SentMessageForm>();
        final FlowTaskEntity taskEntity = flowMsgModel.getTaskEntity();
        ArrayList<String> creatorUserId = new ArrayList<String>();
        if (taskEntity != null) {
            creatorUserId.add(taskEntity.getCreatorUserId());
        }
        final FlowTaskNodeEntity taskNodeEntity = flowMsgModel.getTaskNodeEntity();
        FlowEngineEntity engine = flowMsgModel.getEngine();
        List<FlowTaskNodeEntity> nodeList = flowMsgModel.getNodeList();
        List<FlowTaskOperatorEntity> operatorList = flowMsgModel.getOperatorList();
        List<FlowTaskCirculateEntity> circulateList = flowMsgModel.getCirculateList();
        FlowTaskNodeEntity startNode = nodeList.stream().filter(t -> FlowNature.NodeStart.equals(t.getNodeType())).findFirst().orElse(null);
        FlowTaskNodeEntity thisStepNode = nodeList.stream().filter(t -> taskEntity.getThisStepId().equals(t.getNodeCode())).findFirst().orElse(null);
        FlowTaskOperatorRecordEntity recordEntity = new FlowTaskOperatorRecordEntity();
        recordEntity.setTaskId(startNode != null ? startNode.getTaskId() : "");
        HashMap map = MapUtil.newHashMap();
        map.put("id", taskEntity.getProcessId());
        map.put("enCode", taskEntity.getFlowCode());
        map.put("flowId", taskEntity.getFlowId());
        map.put("formType", engine.getFormType());
        map.put("opType", 1);
        map.put("status", taskEntity.getStatus());
        if (ObjectUtil.isNull((Object)thisStepNode)) {
            map.put("taskNodeId", taskEntity.getThisStepId());
        }
        if (ObjectUtil.isNotNull((Object)thisStepNode)) {
            map.put("taskNodeId", thisStepNode.getId());
        }
        map.put("fullName", taskEntity.getFullName());
        map.put("isSub", true);
        map.put("taskId", taskEntity.getId());
        if (flowMsgModel.isWait()) {
            childNode = (ChildNodeList)JsonUtil.getJsonToBean((String)startNode.getNodePropertyJson(), ChildNodeList.class);
            properties = childNode.getProperties();
            MsgConfig taskMsgConfig2 = properties.getWaitMsgConfig();
            operatorMap = operatorList.stream().collect(Collectors.groupingBy(FlowTaskOperatorEntity::getTaskNodeId));
            for (String key : operatorMap.keySet()) {
                recordEntity.setTaskNodeId(key);
                ArrayList<SentMessageForm> messageList3 = new ArrayList<SentMessageForm>();
                List<FlowTaskOperatorEntity> taskOperatorList2 = operatorMap.get(key);
                FlowMessageModel messageModel2 = new FlowMessageModel();
                messageModel2.setData(data);
                messageModel2.setMsgConfig(taskMsgConfig2);
                messageModel2.setRecordEntity(recordEntity);
                messageModel2.setStatus(taskEntity.getStatus());
                messageModel2.setFullName(taskEntity.getFullName());
                messageModel2.setPageParameters(map);
                this.messageModel(taskOperatorList2, engine, messageModel2);
                this.setMessageList(messageList3, messageModel2);
                messageListAll.addAll(messageList3);
                for (FlowTaskOperatorEntity operator : taskOperatorList2) {
                    List<SentMessageForm> delegationMsg2 = this.delegationMsg(operator, messageModel2, engine);
                    messageListAll.addAll(delegationMsg2);
                }
            }
        }
        if (flowMsgModel.isEnd()) {
            childNode = (ChildNodeList)JsonUtil.getJsonToBean((String)startNode.getNodePropertyJson(), ChildNodeList.class);
            properties = childNode.getProperties();
            msgConfig = properties.getEndMsgConfig();
            messageList2 = new ArrayList<SentMessageForm>();
            Iterator<String> messageModel3 = new FlowMessageModel();
            ((FlowMessageModel)((Object)messageModel3)).setData(data);
            ((FlowMessageModel)((Object)messageModel3)).setTitle("\u5df2\u3010\u7ed3\u675f\u3011");
            ((FlowMessageModel)((Object)messageModel3)).setMsgConfig(msgConfig);
            ((FlowMessageModel)((Object)messageModel3)).setType(FlowMessageEnum.me.getCode());
            ((FlowMessageModel)((Object)messageModel3)).setRecordEntity(recordEntity);
            ((FlowMessageModel)((Object)messageModel3)).setStatus(taskEntity.getStatus());
            ((FlowMessageModel)((Object)messageModel3)).setFullName(taskEntity.getFullName());
            ((FlowMessageModel)((Object)messageModel3)).setPageParameters(map);
            ArrayList taskOperatorList3 = new ArrayList(){
                {
                    FlowTaskOperatorEntity operatorEntity = new FlowTaskOperatorEntity();
                    operatorEntity.setTaskId(childNode.getTaskId());
                    operatorEntity.setTaskNodeId(childNode.getTaskNodeId());
                    operatorEntity.setHandleId(taskEntity.getCreatorUserId());
                    this.add(operatorEntity);
                }
            };
            this.messageModel(taskOperatorList3, engine, (FlowMessageModel)((Object)messageModel3));
            this.setMessageList((List<SentMessageForm>)messageList2, (FlowMessageModel)((Object)messageModel3));
            messageListAll.addAll(messageList2);
        }
        if (flowMsgModel.isApprove()) {
            childNode = (ChildNodeList)JsonUtil.getJsonToBean((String)startNode.getNodePropertyJson(), ChildNodeList.class);
            properties = childNode.getProperties();
            msgConfig = properties.getApproveMsgConfig();
            operatorMap = operatorList.stream().collect(Collectors.groupingBy(FlowTaskOperatorEntity::getTaskNodeId));
            for (String key : operatorMap.keySet()) {
                recordEntity.setTaskNodeId(key);
                taskNode = nodeList.stream().filter(t -> t.getId().equals(key)).findFirst().orElse(null);
                taskChildNode = (ChildNodeList)JsonUtil.getJsonToBean((String)taskNode.getNodePropertyJson(), ChildNodeList.class);
                taskProperties = taskChildNode.getProperties();
                taskMsgConfig = taskProperties.getApproveMsgConfig();
                if (taskMsgConfig.getOn() == 2) {
                    taskMsgConfig = msgConfig;
                }
                messageList = new ArrayList<SentMessageForm>();
                taskOperatorList = operatorMap.get(key);
                messageModel = new FlowMessageModel();
                ((FlowMessageModel)messageModel).setData(data);
                ((FlowMessageModel)messageModel).setTitle("\u5df2\u88ab\u3010\u540c\u610f\u3011");
                ((FlowMessageModel)messageModel).setMsgConfig(taskMsgConfig);
                ((FlowMessageModel)messageModel).setRecordEntity(recordEntity);
                ((FlowMessageModel)messageModel).setStatus(taskEntity.getStatus());
                ((FlowMessageModel)messageModel).setFullName(taskEntity.getFullName());
                ((FlowMessageModel)messageModel).setPageParameters(map);
                this.messageModel(taskOperatorList, engine, (FlowMessageModel)messageModel);
                this.setMessageList(messageList, (FlowMessageModel)messageModel);
                messageListAll.addAll(messageList);
                for (FlowTaskOperatorEntity operator : taskOperatorList) {
                    delegationMsg = this.delegationMsg(operator, (FlowMessageModel)messageModel, engine);
                    messageListAll.addAll(delegationMsg);
                }
            }
        }
        if (flowMsgModel.isReject()) {
            childNode = (ChildNodeList)JsonUtil.getJsonToBean((String)startNode.getNodePropertyJson(), ChildNodeList.class);
            properties = childNode.getProperties();
            msgConfig = properties.getRejectMsgConfig();
            operatorMap = operatorList.stream().collect(Collectors.groupingBy(FlowTaskOperatorEntity::getTaskNodeId));
            for (String key : operatorMap.keySet()) {
                recordEntity.setTaskNodeId(key);
                taskNode = nodeList.stream().filter(t -> t.getId().equals(key)).findFirst().orElse(null);
                taskChildNode = (ChildNodeList)JsonUtil.getJsonToBean((String)taskNode.getNodePropertyJson(), ChildNodeList.class);
                taskProperties = taskChildNode.getProperties();
                taskMsgConfig = taskProperties.getRejectMsgConfig();
                if (taskMsgConfig.getOn() == 2) {
                    taskMsgConfig = msgConfig;
                }
                messageList = new ArrayList();
                taskOperatorList = operatorMap.get(key);
                messageModel = new FlowMessageModel();
                ((FlowMessageModel)messageModel).setData(data);
                ((FlowMessageModel)messageModel).setTitle("\u5df2\u88ab\u3010\u62d2\u7edd\u3011");
                ((FlowMessageModel)messageModel).setMsgConfig(taskMsgConfig);
                ((FlowMessageModel)messageModel).setRecordEntity(recordEntity);
                ((FlowMessageModel)messageModel).setStatus(taskEntity.getStatus());
                ((FlowMessageModel)messageModel).setFullName(taskEntity.getFullName());
                ((FlowMessageModel)messageModel).setPageParameters(map);
                this.messageModel(taskOperatorList, engine, (FlowMessageModel)messageModel);
                this.setMessageList(messageList, (FlowMessageModel)messageModel);
                messageListAll.addAll(messageList);
                for (FlowTaskOperatorEntity operator : taskOperatorList) {
                    delegationMsg = this.delegationMsg(operator, (FlowMessageModel)messageModel, engine);
                    messageListAll.addAll(delegationMsg);
                }
            }
        }
        if (flowMsgModel.isCopy()) {
            childNode = (ChildNodeList)JsonUtil.getJsonToBean((String)startNode.getNodePropertyJson(), ChildNodeList.class);
            properties = childNode.getProperties();
            msgConfig = properties.getCopyMsgConfig();
            Map<String, List<FlowTaskCirculateEntity>> circulateMap = circulateList.stream().collect(Collectors.groupingBy(FlowTaskCirculateEntity::getTaskNodeId));
            for (String key : circulateMap.keySet()) {
                recordEntity.setTaskNodeId(key);
                taskNode = nodeList.stream().filter(t -> t.getId().equals(key)).findFirst().orElse(null);
                taskChildNode = (ChildNodeList)JsonUtil.getJsonToBean((String)taskNode.getNodePropertyJson(), ChildNodeList.class);
                taskProperties = taskChildNode.getProperties();
                taskMsgConfig = taskProperties.getCopyMsgConfig();
                if (taskMsgConfig.getOn() == 2) {
                    taskMsgConfig = msgConfig;
                }
                messageList = new ArrayList();
                taskOperatorList = new ArrayList<FlowTaskOperatorEntity>();
                for (FlowTaskCirculateEntity circulateEntity : circulateMap.get(key)) {
                    FlowTaskOperatorEntity operatorEntity = (FlowTaskOperatorEntity)JsonUtil.getJsonToBean((Object)circulateEntity, FlowTaskOperatorEntity.class);
                    operatorEntity.setHandleId(circulateEntity.getObjectId());
                    taskOperatorList.add(operatorEntity);
                }
                messageModel = new FlowMessageModel();
                ((FlowMessageModel)messageModel).setData(data);
                ((FlowMessageModel)messageModel).setTitle("\u5df2\u88ab\u3010\u6284\u9001\u3011");
                ((FlowMessageModel)messageModel).setMsgConfig(taskMsgConfig);
                ((FlowMessageModel)messageModel).setRecordEntity(recordEntity);
                ((FlowMessageModel)messageModel).setStatus(taskEntity.getStatus());
                ((FlowMessageModel)messageModel).setType(FlowMessageEnum.circulate.getCode());
                ((FlowMessageModel)messageModel).setFullName(taskEntity.getFullName());
                ((FlowMessageModel)messageModel).setPageParameters(map);
                this.messageModel(taskOperatorList, engine, (FlowMessageModel)messageModel);
                this.setMessageList(messageList, (FlowMessageModel)messageModel);
                messageListAll.addAll(messageList);
                for (FlowTaskOperatorEntity operator : taskOperatorList) {
                    delegationMsg = this.delegationMsg(operator, (FlowMessageModel)messageModel, engine);
                    messageListAll.addAll(delegationMsg);
                }
            }
        }
        if (flowMsgModel.isLaunch()) {
            childNode = (ChildNodeList)JsonUtil.getJsonToBean((String)startNode.getNodePropertyJson(), ChildNodeList.class);
            properties = childNode.getProperties();
            msgConfig = properties.getLaunchMsgConfig();
            operatorMap = operatorList.stream().collect(Collectors.groupingBy(FlowTaskOperatorEntity::getTaskNodeId));
            for (String key : operatorMap.keySet()) {
                recordEntity.setTaskNodeId(key);
                taskNode = nodeList.stream().filter(t -> t.getId().equals(key)).findFirst().orElse(null);
                taskChildNode = (ChildNodeList)JsonUtil.getJsonToBean((String)taskNode.getNodePropertyJson(), ChildNodeList.class);
                taskProperties = taskChildNode.getProperties();
                taskMsgConfig = taskProperties.getLaunchMsgConfig();
                if (taskMsgConfig.getOn() == 2) {
                    taskMsgConfig = msgConfig;
                }
                messageList = new ArrayList();
                taskOperatorList = operatorMap.get(key);
                messageModel = new FlowMessageModel();
                ((FlowMessageModel)messageModel).setData(data);
                ((FlowMessageModel)messageModel).setTitle("\u8bf7\u53d1\u8d77\u3010\u5b50\u6d41\u7a0b\u3011");
                ((FlowMessageModel)messageModel).setMsgConfig(taskMsgConfig);
                ((FlowMessageModel)messageModel).setRecordEntity(recordEntity);
                ((FlowMessageModel)messageModel).setType(FlowMessageEnum.me.getCode());
                ((FlowMessageModel)messageModel).setStatus(FlowTaskStatusEnum.Draft.getCode());
                ((FlowMessageModel)messageModel).setFullName(taskEntity.getFullName());
                ((FlowMessageModel)messageModel).setPageParameters(map);
                this.messageModel(taskOperatorList, engine, (FlowMessageModel)messageModel);
                this.setMessageList(messageList, (FlowMessageModel)messageModel);
                messageListAll.addAll(messageList);
            }
        }
        if (flowMsgModel.isStart()) {
            ChildNodeList taskChildNode2 = (ChildNodeList)JsonUtil.getJsonToBean((String)taskNodeEntity.getNodePropertyJson(), ChildNodeList.class);
            Properties taskProperties2 = taskChildNode2.getProperties();
            msgConfig = taskProperties2.getRejectMsgConfig();
            if (msgConfig.getOn() == 2) {
                ChildNodeList childNode2 = (ChildNodeList)JsonUtil.getJsonToBean((String)startNode.getNodePropertyJson(), ChildNodeList.class);
                Properties properties2 = childNode2.getProperties();
                msgConfig = properties2.getRejectMsgConfig();
            }
            messageList2 = new ArrayList();
            FlowMessageModel meModel = new FlowMessageModel();
            meModel.setData(data);
            meModel.setTitle("\u5df2\u88ab\u3010\u62d2\u7edd\u3011");
            meModel.setRecordEntity(recordEntity);
            meModel.setStatus(taskEntity.getStatus());
            meModel.setMsgConfig(msgConfig);
            meModel.setType(FlowMessageEnum.me.getCode());
            meModel.setFullName(taskEntity.getFullName());
            ArrayList meOperatorList = new ArrayList(){
                {
                    FlowTaskOperatorEntity operatorEntity = new FlowTaskOperatorEntity();
                    operatorEntity.setTaskId(taskNodeEntity.getTaskId());
                    operatorEntity.setHandleId(taskEntity.getCreatorUserId());
                    this.add(operatorEntity);
                }
            };
            meModel.setPageParameters(map);
            this.messageModel(meOperatorList, engine, meModel);
            this.setMessageList(messageList2, meModel);
            messageListAll.addAll(messageList2);
        }
        this.serviceUtil.sendMessage(messageListAll);
    }

    private void messageModel(List<FlowTaskOperatorEntity> taskOperatorList, FlowEngineEntity engine, FlowMessageModel messageModel) {
        ArrayList<String> userList = new ArrayList<String>();
        HashMap<String, String> contMsg = new HashMap<String, String>();
        for (FlowTaskOperatorEntity taskOperator : taskOperatorList) {
            FlowContModel contModel = this.flowMessage(engine, taskOperator, messageModel);
            contMsg.put(taskOperator.getHandleId(), JsonUtil.getObjectToString((Object)contModel));
            userList.add(taskOperator.getHandleId());
            HashMap pageParameters = messageModel.getPageParameters();
            pageParameters.put("taskId", taskOperator.getId());
            messageModel.setPageParameters(pageParameters);
        }
        messageModel.setUserList(userList);
        messageModel.setContMsg(contMsg);
    }

    private FlowContModel flowMessage(FlowEngineEntity engine, FlowTaskOperatorEntity taskOperator, FlowMessageModel messageModel) {
        FlowContModel contModel = new FlowContModel();
        contModel.setEnCode(engine.getEnCode());
        contModel.setFlowId(engine.getId());
        contModel.setFormType(engine.getFormType());
        contModel.setTaskNodeId(taskOperator.getTaskNodeId());
        contModel.setTaskOperatorId(taskOperator.getId());
        contModel.setProcessId(taskOperator.getTaskId());
        contModel.setType(messageModel.getType());
        contModel.setStatus(messageModel.getStatus());
        return contModel;
    }

    private void setMessageList(List<SentMessageForm> messageList, FlowMessageModel flowMessageModel) {
        Map<String, Object> data = flowMessageModel.getData();
        MsgConfig msgConfig = flowMessageModel.getMsgConfig() != null ? flowMessageModel.getMsgConfig() : new MsgConfig();
        List<String> userList = flowMessageModel.getUserList();
        FlowTaskOperatorRecordEntity recordEntity = flowMessageModel.getRecordEntity();
        String templateId = msgConfig.getOn() == 0 ? "0" : msgConfig.getMsgId();
        ArrayList templateJson = msgConfig.getTemplateJson() != null ? msgConfig.getTemplateJson() : new ArrayList();
        SentMessageForm messageModel = new SentMessageForm();
        messageModel.setTemplateId(templateId);
        messageModel.setToUserIds(userList);
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        for (TemplateJsonModel templateJsonModel : templateJson) {
            String fieldId = templateJsonModel.getField();
            String relationField = templateJsonModel.getRelationField();
            String dataJson = data.get(relationField) != null ? String.valueOf(data.get(relationField)) : "";
            FlowEventModel eventModel = FlowEventModel.builder().dataJson(dataJson).record(recordEntity).relationField(relationField).build();
            dataJson = this.data(eventModel);
            parameterMap.put(fieldId, dataJson);
            String string = URLEncodeUtil.encode((String)JsonUtil.getObjectToString((Object)flowMessageModel.getPageParameters()));
        }
        messageModel.setType(Integer.valueOf(2));
        messageModel.setParameterMap(parameterMap);
        messageModel.setTitle(flowMessageModel.getFullName() + flowMessageModel.getTitle());
        HashMap<String, String> map = new HashMap<String, String>();
        map.putAll(flowMessageModel.getContMsg());
        map.put("id", flowMessageModel.getRecordEntity().getTaskId());
        messageModel.setBodyText(map);
        messageList.add(messageModel);
    }

    private String data(FlowEventModel eventModel) {
        FlowTaskOperatorRecordEntity record = eventModel.getRecord();
        String relationField = eventModel.getRelationField();
        String dataJson = eventModel.getDataJson();
        String userId = this.userProvider.get().getUserId();
        String value = dataJson;
        FlowTaskEntity taskEntity = this.flowTaskService.getInfoSubmit(record.getTaskId(), FlowTaskEntity::getFlowId, FlowTaskEntity::getFlowName, FlowTaskEntity::getFullName, FlowTaskEntity::getCreatorUserId);
        switch (relationField) {
            case "jsbosFlowId": {
                value = taskEntity.getFlowId();
                break;
            }
            case "jsbosTaskId": {
                value = record.getTaskId();
                break;
            }
            case "jsbosTaskNodeId": {
                value = record.getTaskNodeId();
                break;
            }
            case "jsbosFlowFullName": {
                value = taskEntity.getFlowName();
                break;
            }
            case "jsbosTaskFullName": {
                value = taskEntity.getFullName();
                break;
            }
            case "jsbosLaunchUserId": {
                value = taskEntity.getCreatorUserId();
                break;
            }
            case "jsbosLaunchUserName": {
                UserEntity createUser = taskEntity != null ? this.serviceUtil.getUserInfo(taskEntity.getCreatorUserId()) : null;
                value = createUser != null ? createUser.getRealName() : "";
                break;
            }
            case "jsbosFlowOperatorUserId": {
                value = userId;
                break;
            }
            case "jsbosFlowOperatorUserName": {
                UserEntity userEntity = this.serviceUtil.getUserInfo(userId);
                value = userEntity != null ? userEntity.getRealName() : "";
                break;
            }
        }
        return value;
    }

    public void event(Integer status, ChildNodeList childNode, FlowTaskOperatorRecordEntity record, FlowModel flowModel) throws WorkFlowException {
        boolean on = false;
        String interId = "";
        List<Object> templateJsonModelList = new ArrayList();
        FuncConfig config = null;
        if (childNode != null) {
            Properties properties = childNode.getProperties();
            switch (status) {
                case 1: {
                    config = properties.getInitFuncConfig();
                    break;
                }
                case 2: {
                    config = properties.getEndFuncConfig();
                    break;
                }
                case 3: {
                    config = properties.getFlowRecallFuncConfig();
                    break;
                }
                case 4: {
                    config = properties.getApproveFuncConfig();
                    break;
                }
                case 5: {
                    config = properties.getRejectFuncConfig();
                    break;
                }
                case 6: {
                    config = properties.getRecallFuncConfig();
                    break;
                }
            }
        }
        if (config != null) {
            on = config.isOn();
            interId = config.getInterfaceId();
            templateJsonModelList = config.getTemplateJson();
        }
        if (on && StringUtils.isNotEmpty((String)interId)) {
            Map<String, Object> data = flowModel.getFormData();
            HashMap<String, String> parameterMap = new HashMap<String, String>();
            for (TemplateJsonModel templateJsonModel : templateJsonModelList) {
                String fieldId = templateJsonModel.getField();
                String relationField = templateJsonModel.getRelationField();
                String dataJson = data.get(relationField) != null ? String.valueOf(data.get(relationField)) : "";
                FlowEventModel eventModel = FlowEventModel.builder().dataJson(dataJson).record(record).relationField(relationField).build();
                dataJson = this.data(eventModel);
                parameterMap.put(fieldId, "'" + dataJson + "'");
            }
            this.serviceUtil.infoToId(interId, parameterMap);
        }
        if (on && StringUtils.isEmpty((String)interId)) {
            String processId = flowModel.getProcessId();
            FlowEngineEntity engine = this.flowEngineService.getInfo(flowModel.getFlowId());
            String name = engine.getEnCode();
            try {
                String string = StrUtil.lowerFirst((CharSequence)name) + "ServiceImpl";
                Object bean = SpringContext.getBean((String)string);
                Class<?> clazz = bean.getClass();
                Method method3 = ReflectionUtils.findMethod(clazz, (String)"updateEnableMarkById", (Class[])new Class[]{processId.getClass(), status.getClass(), flowModel.getClass()});
                Object object = ReflectionUtils.invokeMethod((Method)method3, (Object)bean, (Object[])new Object[]{processId, status, flowModel});
            }
            catch (Exception exception) {
                throw new WorkFlowException("\u56de\u8c03\u66f4\u65b0\u4e1a\u52a1\u8868\u72b6\u6001\u62a5\u9519");
            }
        }
    }

    private List<SentMessageForm> delegationMsg(FlowTaskOperatorEntity operator, FlowMessageModel messageModel, FlowEngineEntity engine) {
        ArrayList<SentMessageForm> messageList = new ArrayList<SentMessageForm>();
        FlowTaskEntity taskEntity = this.flowTaskService.getInfoSubmit(operator.getTaskId(), FlowTaskEntity::getFlowId);
        List userList = this.flowDelegateService.getUser(null, taskEntity.getFlowId(), operator.getHandleId()).stream().map(t -> t.getToUserid()).collect(Collectors.toList());
        ArrayList<FlowTaskOperatorEntity> taskOperatorList = new ArrayList<FlowTaskOperatorEntity>();
        for (String user : userList) {
            FlowTaskOperatorEntity delegaOperator = (FlowTaskOperatorEntity)JsonUtil.getJsonToBean((Object)operator, FlowTaskOperatorEntity.class);
            delegaOperator.setHandleId(user);
            taskOperatorList.add(delegaOperator);
        }
        this.messageModel(taskOperatorList, engine, messageModel);
        this.setMessageList(messageList, messageModel);
        return messageList;
    }
}

