/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.workflow.form.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.workflow.engine.enums.FlowStatusEnum;
import com.bringspring.workflow.form.entity.SalesOrderEntity;
import com.bringspring.workflow.form.entity.SalesOrderEntryEntity;
import com.bringspring.workflow.form.model.salesorder.SalesOrderEntryEntityInfoModel;
import com.bringspring.workflow.form.model.salesorder.SalesOrderForm;
import com.bringspring.workflow.form.model.salesorder.SalesOrderInfoVO;
import com.bringspring.workflow.form.service.SalesOrderService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u9500\u552e\u8ba2\u5355"}, value="SalesOrder")
@RestController
@RequestMapping(value={"/api/workflow/Form/SalesOrder"})
public class SalesOrderController {
    @Autowired
    private SalesOrderService salesOrderService;

    @ApiOperation(value="\u83b7\u53d6\u9500\u552e\u8ba2\u5355\u4fe1\u606f")
    @GetMapping(value={"/{id}"})
    public ActionResult info(@PathVariable(value="id") String id) {
        SalesOrderEntity entity = this.salesOrderService.getInfo(id);
        List<SalesOrderEntryEntity> entityList = this.salesOrderService.getSalesEntryList(id);
        SalesOrderInfoVO vo = (SalesOrderInfoVO)JsonUtil.getJsonToBean((Object)entity, SalesOrderInfoVO.class);
        vo.setEntryList(JsonUtil.getJsonToList(entityList, SalesOrderEntryEntityInfoModel.class));
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u65b0\u5efa\u9500\u552e\u8ba2\u5355")
    @PostMapping
    public ActionResult create(@RequestBody SalesOrderForm salesOrderForm) throws WorkFlowException {
        SalesOrderEntity sales = (SalesOrderEntity)JsonUtil.getJsonToBean((Object)salesOrderForm, SalesOrderEntity.class);
        List salesEntryList = JsonUtil.getJsonToList(salesOrderForm.getEntryList(), SalesOrderEntryEntity.class);
        if (FlowStatusEnum.save.getMessage().equals(salesOrderForm.getStatus())) {
            this.salesOrderService.save(sales.getId(), sales, salesEntryList);
            return ActionResult.success((String)MsgCode.SU002.get());
        }
        this.salesOrderService.submit(sales.getId(), sales, salesEntryList, salesOrderForm.getCandidateList());
        return ActionResult.success((String)MsgCode.SU006.get());
    }

    @ApiOperation(value="\u4fee\u6539\u9500\u552e\u8ba2\u5355")
    @PutMapping(value={"/{id}"})
    public ActionResult update(@RequestBody SalesOrderForm salesOrderForm, @PathVariable(value="id") String id) throws WorkFlowException {
        SalesOrderEntity sales = (SalesOrderEntity)JsonUtil.getJsonToBean((Object)salesOrderForm, SalesOrderEntity.class);
        List salesEntryList = JsonUtil.getJsonToList(salesOrderForm.getEntryList(), SalesOrderEntryEntity.class);
        if (FlowStatusEnum.save.getMessage().equals(salesOrderForm.getStatus())) {
            this.salesOrderService.save(id, sales, salesEntryList);
            return ActionResult.success((String)MsgCode.SU002.get());
        }
        this.salesOrderService.submit(id, sales, salesEntryList, salesOrderForm.getCandidateList());
        return ActionResult.success((String)MsgCode.SU006.get());
    }
}

