/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.workflow.engine.controller;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.ListVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.model.FormAllModel;
import com.bringspring.common.model.FormEnum;
import com.bringspring.common.model.task.LocalTaskModel;
import com.bringspring.common.model.visiual.FormCloumnUtil;
import com.bringspring.common.model.visiual.FormDataField;
import com.bringspring.common.model.visiual.FormDataModel;
import com.bringspring.common.model.visiual.RecursionForm;
import com.bringspring.common.model.visiual.TableModel;
import com.bringspring.common.model.visiual.fields.FieLdsModel;
import com.bringspring.common.util.FileUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.enums.ModuleTypeEnum;
import com.bringspring.common.util.file.fileinfo.DataFileExport;
import com.bringspring.system.base.entity.DictionaryDataEntity;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.scheduletask.model.TaskMethodsVO;
import com.bringspring.workflow.engine.annotation.FlowCallBackMethod;
import com.bringspring.workflow.engine.entity.FlowEngineEntity;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.enums.FlowTaskStatusEnum;
import com.bringspring.workflow.engine.model.flowengine.FlowEngineCrForm;
import com.bringspring.workflow.engine.model.flowengine.FlowEngineInfoVO;
import com.bringspring.workflow.engine.model.flowengine.FlowEngineListVO;
import com.bringspring.workflow.engine.model.flowengine.FlowEngineModel;
import com.bringspring.workflow.engine.model.flowengine.FlowEngineSelectVO;
import com.bringspring.workflow.engine.model.flowengine.FlowEngineUpForm;
import com.bringspring.workflow.engine.model.flowengine.FlowExportModel;
import com.bringspring.workflow.engine.model.flowengine.FlowPageListVO;
import com.bringspring.workflow.engine.model.flowengine.FlowPagination;
import com.bringspring.workflow.engine.model.flowengine.PaginationFlowEngine;
import com.bringspring.workflow.engine.service.FlowEngineService;
import com.bringspring.workflow.engine.service.FlowTaskService;
import com.bringspring.workflow.engine.util.ServiceAllUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u6d41\u7a0b\u5f15\u64ce"}, value="FlowEngine")
@RestController
@RequestMapping(value={"/api/workflow/Engine/FlowEngine"})
public class FlowEngineController {
    @Autowired
    private FlowEngineService flowEngineService;
    @Autowired
    private FlowTaskService flowTaskService;
    @Autowired
    private DataFileExport fileExport;
    @Autowired
    private ServiceAllUtil serviceUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private ApplicationContext applicationContext;

    @ApiOperation(value="\u83b7\u53d6\u6d41\u7a0b\u5f15\u64ce\u5217\u8868")
    @GetMapping
    public ActionResult list(FlowPagination pagination) {
        List<FlowEngineEntity> list = this.flowEngineService.getPageList(pagination);
        List<DictionaryDataEntity> dictionList = this.serviceUtil.getDictionName(list.stream().map(t -> t.getCategory()).collect(Collectors.toList()));
        for (FlowEngineEntity entity : list) {
            DictionaryDataEntity dataEntity = dictionList.stream().filter(t -> t.getEnCode().equals(entity.getCategory())).findFirst().orElse(null);
            entity.setCategory(dataEntity != null ? dataEntity.getFullName() : "");
        }
        PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)pagination), PaginationVO.class);
        List listVO = JsonUtil.getJsonToList(list, FlowPageListVO.class);
        return ActionResult.page((List)listVO, (PaginationVO)paginationVO);
    }

    @ApiOperation(value="\u6d41\u7a0b\u5f15\u64ce\u4e0b\u62c9\u6846")
    @GetMapping(value={"/Selector"})
    public ActionResult<ListVO<FlowEngineListVO>> listSelect(Integer type) {
        PaginationFlowEngine pagination = new PaginationFlowEngine();
        pagination.setFormType(type);
        pagination.setEnabledMark(1);
        pagination.setType(0);
        List<FlowEngineListVO> treeList = this.flowEngineService.getTreeList(pagination, true);
        ListVO vo = new ListVO();
        vo.setList(treeList);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u8868\u5355\u4e3b\u8868\u5c5e\u6027")
    @GetMapping(value={"/{id}/FormDataFields"})
    public ActionResult<ListVO<FormDataField>> getFormDataField(@PathVariable(value="id") String id) throws WorkFlowException {
        FlowEngineEntity entity = this.flowEngineService.getInfo(id);
        ArrayList<FormDataField> formDataFieldList = new ArrayList<FormDataField>();
        if (entity.getFormType() == 1) {
            List list = JsonUtil.getJsonToList((String)entity.getFormData(), FlowEngineModel.class);
            for (FlowEngineModel model : list) {
                FormDataField formDataField = new FormDataField();
                formDataField.setLabel(model.getFiledName());
                formDataField.setVModel(model.getFiledId());
                formDataFieldList.add(formDataField);
            }
        } else {
            FormDataModel formData = (FormDataModel)JsonUtil.getJsonToBean((String)entity.getFormData(), FormDataModel.class);
            List list = JsonUtil.getJsonToList((String)formData.getFields(), FieLdsModel.class);
            List tableModelList = JsonUtil.getJsonToList((String)entity.getFlowTables(), TableModel.class);
            ArrayList formAllModel = new ArrayList();
            RecursionForm recursionForm = new RecursionForm(list, tableModelList);
            FormCloumnUtil.recursionForm((RecursionForm)recursionForm, formAllModel);
            List mast = formAllModel.stream().filter(t -> FormEnum.mast.getMessage().equals(t.getKeyName())).collect(Collectors.toList());
            for (FormAllModel model : mast) {
                FieLdsModel fieLdsModel = model.getFormColumnModel().getFieLdsModel();
                String vmodel = fieLdsModel.getVModel();
                String keyName = fieLdsModel.getConfig().getKeyName();
                if (!StringUtils.isNotEmpty((String)vmodel) || "relationForm".equals(keyName) || "relationFlow".equals(keyName)) continue;
                FormDataField formDataField = new FormDataField();
                formDataField.setLabel(fieLdsModel.getConfig().getLabel());
                formDataField.setVModel(fieLdsModel.getVModel());
                formDataFieldList.add(formDataField);
            }
        }
        ListVO listVO = new ListVO();
        listVO.setList(formDataFieldList);
        return ActionResult.success((Object)listVO);
    }

    @ApiOperation(value="\u8868\u5355\u5217\u8868")
    @GetMapping(value={"/{id}/FieldDataSelect"})
    public ActionResult<ListVO<FlowEngineSelectVO>> getFormData(@PathVariable(value="id") String id) {
        List flowTaskList = this.flowTaskService.getTaskList(id, FlowTaskEntity::getId, FlowTaskEntity::getFullName, FlowTaskEntity::getEnCode).stream().filter(t -> FlowTaskStatusEnum.Adopt.getCode().equals(t.getStatus())).collect(Collectors.toList());
        ArrayList<FlowEngineSelectVO> vo = new ArrayList<FlowEngineSelectVO>();
        for (FlowTaskEntity taskEntity : flowTaskList) {
            FlowEngineSelectVO selectVO = (FlowEngineSelectVO)JsonUtil.getJsonToBean((Object)taskEntity, FlowEngineSelectVO.class);
            selectVO.setFullName(taskEntity.getFullName() + "/" + taskEntity.getEnCode());
            vo.add(selectVO);
        }
        ListVO listVO = new ListVO();
        listVO.setList(vo);
        return ActionResult.success((Object)listVO);
    }

    @ApiOperation(value="\u53ef\u89c1\u5f15\u64ce\u4e0b\u62c9\u6846")
    @GetMapping(value={"/ListAll"})
    public ActionResult<ListVO<FlowEngineListVO>> listAll() {
        PaginationFlowEngine pagination = new PaginationFlowEngine();
        List<FlowEngineListVO> treeList = this.flowEngineService.getTreeList(pagination, false);
        ListVO vo = new ListVO();
        vo.setList(treeList);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u53ef\u89c1\u7684\u6d41\u7a0b\u5f15\u64ce\u5217\u8868")
    @GetMapping(value={"/PageListAll"})
    public ActionResult<PageListVO<FlowPageListVO>> listAll(FlowPagination pagination) {
        List<FlowEngineEntity> list = this.flowEngineService.getListAll(pagination, true);
        PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)pagination), PaginationVO.class);
        List listVO = JsonUtil.getJsonToList(list, FlowPageListVO.class);
        return ActionResult.page((List)listVO, (PaginationVO)paginationVO);
    }

    @ApiOperation(value="\u53ef\u89c1\u7684\u6d41\u7a0b\u5f15\u64ce\u5217\u8868")
    @GetMapping(value={"/PageListAllGroup"})
    public ActionResult listAllGroup(FlowPagination pagination) {
        List<FlowEngineEntity> list = this.flowEngineService.getListAll(pagination, false);
        Map<String, List<FlowEngineEntity>> collect = list.stream().collect(Collectors.groupingBy(FlowEngineEntity::getCategory));
        List returnList = CollectionUtil.list((boolean)false);
        for (String key : collect.keySet()) {
            HashMap map = MapUtil.newHashMap();
            map.put("enCode", key);
            map.put("data", collect.get(key));
            returnList.add(map);
        }
        return ActionResult.success((Object)returnList);
    }

    @ApiOperation(value="\u83b7\u53d6\u6d41\u7a0b\u5f15\u64ce\u4fe1\u606f")
    @GetMapping(value={"/{id}"})
    public ActionResult<FlowEngineInfoVO> info(@PathVariable(value="id") String id) throws WorkFlowException {
        FlowEngineEntity flowEntity = this.flowEngineService.getInfo(id);
        FlowEngineInfoVO vo = (FlowEngineInfoVO)JsonUtil.getJsonToBean((Object)flowEntity, FlowEngineInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u65b0\u5efa\u6d41\u7a0b\u5f15\u64ce")
    @PostMapping
    public ActionResult create(@RequestBody @Valid FlowEngineCrForm flowEngineCrForm) throws WorkFlowException {
        FlowEngineEntity flowEngineEntity = (FlowEngineEntity)JsonUtil.getJsonToBean((Object)flowEngineCrForm, FlowEngineEntity.class);
        if (this.flowEngineService.isExistByFullName(flowEngineEntity.getFullName(), flowEngineEntity.getId())) {
            return ActionResult.fail((String)"\u6d41\u7a0b\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
        }
        if (this.flowEngineService.isExistByEnCode(flowEngineEntity.getEnCode(), flowEngineEntity.getId())) {
            return ActionResult.fail((String)"\u6d41\u7a0b\u7f16\u7801\u4e0d\u80fd\u91cd\u590d");
        }
        this.flowEngineService.create(flowEngineEntity);
        return ActionResult.success((String)MsgCode.SU001.get());
    }

    @ApiOperation(value="\u66f4\u65b0\u6d41\u7a0b\u5f15\u64ce")
    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid FlowEngineUpForm flowEngineUpForm) throws WorkFlowException {
        FlowEngineEntity flowEngineEntity = (FlowEngineEntity)JsonUtil.getJsonToBean((Object)flowEngineUpForm, FlowEngineEntity.class);
        if (this.flowEngineService.isExistByFullName(flowEngineUpForm.getFullName(), id)) {
            return ActionResult.fail((String)"\u6d41\u7a0b\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
        }
        if (this.flowEngineService.isExistByEnCode(flowEngineUpForm.getEnCode(), id)) {
            return ActionResult.fail((String)"\u6d41\u7a0b\u7f16\u7801\u4e0d\u80fd\u91cd\u590d");
        }
        boolean flag = this.flowEngineService.updateVisible(id, flowEngineEntity);
        if (!flag) {
            return ActionResult.success((String)MsgCode.FA002.get());
        }
        return ActionResult.success((String)MsgCode.SU004.getDesc());
    }

    @ApiOperation(value="\u5220\u9664\u6d41\u7a0b\u5f15\u64ce")
    @DeleteMapping(value={"/{id}"})
    public ActionResult<String> delete(@PathVariable(value="id") String id) throws WorkFlowException {
        FlowEngineEntity entity = this.flowEngineService.getInfo(id);
        this.flowEngineService.delete(entity);
        return ActionResult.success((String)MsgCode.SU003.get());
    }

    @ApiOperation(value="\u590d\u5236\u6d41\u7a0b\u8868\u5355")
    @PostMapping(value={"/{id}/Actions/Copy"})
    public ActionResult copy(@PathVariable(value="id") String id) throws WorkFlowException {
        FlowEngineEntity flowEngineEntity = this.flowEngineService.getInfo(id);
        if (flowEngineEntity != null) {
            List tableModelList;
            String copyNum = UUID.randomUUID().toString().substring(0, 5);
            flowEngineEntity.setFullName(flowEngineEntity.getFullName() + ".\u526f\u672c" + copyNum);
            flowEngineEntity.setEnCode(flowEngineEntity.getEnCode() + copyNum);
            flowEngineEntity.setCreatorTime(new Date());
            flowEngineEntity.setId(null);
            if (flowEngineEntity.getFormType() != 1 && (tableModelList = JsonUtil.getJsonToList((String)flowEngineEntity.getFlowTables(), TableModel.class)).size() == 0) {
                throw new WorkFlowException(MsgCode.WF008.get());
            }
            this.flowEngineService.copy(flowEngineEntity);
            return ActionResult.success((String)MsgCode.SU007.get());
        }
        return ActionResult.fail((String)MsgCode.FA004.get());
    }

    @ApiOperation(value="\u66f4\u65b0\u6d41\u7a0b\u8868\u5355\u72b6\u6001")
    @PutMapping(value={"/{id}/Actions/State"})
    public ActionResult state(@PathVariable(value="id") String id) throws WorkFlowException {
        FlowEngineEntity entity = this.flowEngineService.getInfo(id);
        if (entity != null) {
            entity.setEnabledMark("1".equals(String.valueOf(entity.getEnabledMark())) ? 0 : 1);
            this.flowEngineService.update(id, entity);
            return ActionResult.success((String)"\u66f4\u65b0\u8868\u5355\u6210\u529f");
        }
        return ActionResult.fail((String)MsgCode.FA002.get());
    }

    @ApiOperation(value="\u53d1\u5e03\u6d41\u7a0b\u8bbe\u8ba1")
    @PostMapping(value={"/Release/{id}"})
    public ActionResult release(@PathVariable(value="id") String id) throws WorkFlowException {
        FlowEngineEntity entity = this.flowEngineService.getInfo(id);
        if (entity != null) {
            entity.setEnabledMark(1);
            this.flowEngineService.update(id, entity);
            return ActionResult.success((String)MsgCode.SU011.get());
        }
        return ActionResult.fail((String)MsgCode.FA011.get());
    }

    @ApiOperation(value="\u505c\u6b62\u6d41\u7a0b\u8bbe\u8ba1")
    @PostMapping(value={"/Stop/{id}"})
    public ActionResult stop(@PathVariable(value="id") String id) throws WorkFlowException {
        FlowEngineEntity entity = this.flowEngineService.getInfo(id);
        if (entity != null) {
            entity.setEnabledMark(0);
            this.flowEngineService.update(id, entity);
            return ActionResult.success((String)MsgCode.SU008.get());
        }
        return ActionResult.fail((String)MsgCode.FA008.get());
    }

    @ApiOperation(value="\u5de5\u4f5c\u6d41\u5bfc\u51fa")
    @GetMapping(value={"/{id}/Actions/ExportData"})
    public ActionResult exportData(@PathVariable(value="id") String id) throws WorkFlowException {
        FlowExportModel model = this.flowEngineService.exportData(id);
        DownloadVO downloadVO = this.fileExport.exportFile((Object)model, this.configValueUtil.getTemporaryFilePath(), model.getFlowEngine().getFullName(), ModuleTypeEnum.FLOW_FLOWENGINE.getTableName());
        return ActionResult.success((Object)downloadVO);
    }

    @ApiOperation(value="\u5de5\u4f5c\u6d41\u5bfc\u5165")
    @PostMapping(value={"/Actions/ImportData"}, consumes={"multipart/form-data"})
    public ActionResult ImportData(@RequestPart(value="file") MultipartFile multipartFile) throws WorkFlowException {
        if (FileUtil.existsSuffix((MultipartFile)multipartFile, (String)ModuleTypeEnum.FLOW_FLOWENGINE.getTableName())) {
            return ActionResult.fail((String)MsgCode.IMP002.get());
        }
        String fileContent = FileUtil.getFileContent((MultipartFile)multipartFile, (String)this.configValueUtil.getTemporaryFilePath());
        FlowExportModel vo = (FlowExportModel)JsonUtil.getJsonToBean((String)fileContent, FlowExportModel.class);
        return this.flowEngineService.ImportData(vo.getFlowEngine(), vo.getVisibleList());
    }

    @ApiOperation(value="\u83b7\u53d6\u6d41\u7a0b\u4efb\u52a1\u8c03\u5ea6\u5217\u8868")
    @GetMapping(value={"/FlowTaskMethods"})
    public ActionResult<List<TaskMethodsVO>> FlowTaskMethods() {
        String[] beanNames;
        List list = CollectionUtil.list((boolean)false);
        for (String beanName : beanNames = this.applicationContext.getBeanDefinitionNames()) {
            Method[] methods;
            Object obj = this.applicationContext.getBean(beanName);
            Class<?> clz = obj.getClass();
            if (AopUtils.isAopProxy((Object)obj) && ObjectUtil.isNotNull((Object)AopProxyUtils.getSingletonTarget((Object)obj))) {
                clz = AopProxyUtils.getSingletonTarget((Object)obj).getClass();
            }
            for (Method method : methods = clz.getDeclaredMethods()) {
                FlowCallBackMethod FlowAnnotation = method.getAnnotation(FlowCallBackMethod.class);
                if (FlowAnnotation == null) continue;
                String ids = clz.getName() + "." + method.getName();
                String id = StringUtils.isNotEmpty((String)FlowAnnotation.id()) ? FlowAnnotation.id() : ids;
                String name = FlowAnnotation.fullName();
                String description = FlowAnnotation.description();
                LocalTaskModel model = new LocalTaskModel();
                model.setFullName(name);
                model.setClz(obj);
                model.setMethodName(method.getName());
                model.setDescription(description);
                model.setId(id);
                model.setJobGroupName("jsbos");
                TaskMethodsVO taskMethodsVO = new TaskMethodsVO();
                taskMethodsVO.setId(model.getId());
                taskMethodsVO.setFullName(model.getFullName());
                taskMethodsVO.setDescription(model.getDescription());
                list.add(taskMethodsVO);
            }
        }
        return ActionResult.success((Object)list);
    }
}

