/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.workflow.engine.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.model.FormAllModel;
import com.bringspring.common.model.visiual.FormCloumnUtil;
import com.bringspring.common.model.visiual.FormDataModel;
import com.bringspring.common.model.visiual.RecursionForm;
import com.bringspring.common.model.visiual.TableModel;
import com.bringspring.common.model.visiual.fields.FieLdsModel;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.ReflectionUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.context.SpringContext;
import com.bringspring.system.base.entity.DictionaryDataEntity;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.workflow.engine.entity.FlowEngineEntity;
import com.bringspring.workflow.engine.entity.FlowEngineVisibleEntity;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.mapper.FlowEngineMapper;
import com.bringspring.workflow.engine.model.flowengine.FlowEngineListVO;
import com.bringspring.workflow.engine.model.flowengine.FlowExportModel;
import com.bringspring.workflow.engine.model.flowengine.FlowPagination;
import com.bringspring.workflow.engine.model.flowengine.PaginationFlowEngine;
import com.bringspring.workflow.engine.model.flowengine.shuntjson.childnode.ChildNode;
import com.bringspring.workflow.engine.model.flowengine.shuntjson.childnode.Properties;
import com.bringspring.workflow.engine.service.FlowEngineService;
import com.bringspring.workflow.engine.service.FlowEngineVisibleService;
import com.bringspring.workflow.engine.service.FlowTaskService;
import com.bringspring.workflow.engine.util.ServiceAllUtil;
import com.bringspring.workflow.engine.util.VisualDevTableCre;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FlowEngineServiceImpl
extends ServiceImpl<FlowEngineMapper, FlowEngineEntity>
implements FlowEngineService {
    @Autowired
    private FlowTaskService flowTaskService;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private ServiceAllUtil serviceUtil;
    @Autowired
    private VisualDevTableCre visualDevTableCre;
    @Autowired
    private FlowEngineVisibleService flowEngineVisibleService;
    @Autowired
    private AuthorizeService authorizeService;

    @Override
    public List<FlowEngineEntity> getPageList(FlowPagination pagination) {
        UserInfo userInfo = this.userProvider.get();
        boolean flag = false;
        PaginationFlowEngine engine = new PaginationFlowEngine();
        List idList = this.flowEngineVisibleService.getAllCompanyVisibleFlowList(userInfo.getUserId(), pagination.getMenuId()).stream().map(FlowEngineVisibleEntity::getFlowId).collect(Collectors.toList());
        QueryWrapper wrapper = new QueryWrapper();
        engine.setFormType(2);
        engine.setType(1);
        List<FlowEngineEntity> getList = this.getList(engine);
        List id = getList.stream().map(FlowEngineEntity::getId).collect(Collectors.toList());
        QueryWrapper queryWrapper = new QueryWrapper();
        if (com.bringspring.common.util.StringUtils.isNotEmpty((String)pagination.getKeyword())) {
            flag = true;
            queryWrapper.lambda().like(FlowEngineEntity::getFullName, (Object)pagination.getKeyword());
        }
        if (idList.size() > 0) {
            queryWrapper.lambda().in(FlowEngineEntity::getId, idList);
        }
        if (com.bringspring.common.util.StringUtils.isNotEmpty((String)pagination.getCategory())) {
            flag = true;
            queryWrapper.lambda().eq(FlowEngineEntity::getCategory, (Object)pagination.getCategory());
        }
        if (!userInfo.getIsAdministrator().booleanValue() && ObjectUtil.isEmpty(idList)) {
            return new ArrayList<FlowEngineEntity>();
        }
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(FlowEngineEntity::getSortCode)).orderByDesc(FlowEngineEntity::getCreatorTime);
        if (flag) {
            queryWrapper.lambda().orderByDesc(FlowEngineEntity::getLastModifyTime);
        }
        Page page = new Page(pagination.getCurrentPage(), pagination.getPageSize());
        IPage userPage = this.page((IPage)page, (Wrapper)queryWrapper);
        return pagination.setData(userPage.getRecords(), page.getTotal());
    }

    @Override
    public List<FlowEngineEntity> getList(PaginationFlowEngine pagination) {
        boolean flag = false;
        QueryWrapper queryWrapper = new QueryWrapper();
        if (ObjectUtil.isNotEmpty((Object)pagination.getType())) {
            flag = true;
            queryWrapper.lambda().eq(FlowEngineEntity::getType, (Object)pagination.getType());
        }
        if (com.bringspring.common.util.StringUtils.isNotEmpty((String)pagination.getKeyword())) {
            flag = true;
            queryWrapper.lambda().like(FlowEngineEntity::getFullName, (Object)pagination.getKeyword());
        }
        if (ObjectUtil.isNotEmpty((Object)pagination.getFormType())) {
            flag = true;
            queryWrapper.lambda().eq(FlowEngineEntity::getFormType, (Object)pagination.getFormType());
        }
        if (ObjectUtil.isNotEmpty((Object)pagination.getEnabledMark())) {
            flag = true;
            queryWrapper.lambda().eq(FlowEngineEntity::getEnabledMark, (Object)pagination.getEnabledMark());
        }
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(FlowEngineEntity::getSortCode)).orderByDesc(FlowEngineEntity::getCreatorTime);
        if (flag) {
            queryWrapper.lambda().orderByDesc(FlowEngineEntity::getLastModifyTime);
        }
        queryWrapper.lambda().select(new SFunction[]{FlowEngineEntity::getId, FlowEngineEntity::getEnCode, FlowEngineEntity::getFullName, FlowEngineEntity::getFormType, FlowEngineEntity::getType, FlowEngineEntity::getIcon, FlowEngineEntity::getCategory, FlowEngineEntity::getIconBackground, FlowEngineEntity::getVisibleType, FlowEngineEntity::getCreatorUserId, FlowEngineEntity::getSortCode, FlowEngineEntity::getEnabledMark, FlowEngineEntity::getCreatorTime});
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<FlowEngineEntity> getList() {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(FlowEngineEntity::getSortCode)).orderByDesc(FlowEngineEntity::getCreatorTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<FlowEngineEntity> getListAll(FlowPagination pagination, boolean isPage) {
        boolean flag = false;
        UserInfo userInfo = this.userProvider.get();
        List id = this.flowEngineVisibleService.getVisibleFlowList(userInfo.getUserId()).stream().map(FlowEngineVisibleEntity::getFlowId).collect(Collectors.toList());
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.lambda().eq(FlowEngineVisibleEntity::getOperatorId, (Object)userInfo.getOrganizeId());
        List companyList = this.flowEngineVisibleService.list((Wrapper)wrapper);
        QueryWrapper queryWrapper = new QueryWrapper();
        if (CollectionUtil.isNotEmpty(id)) {
            ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(FlowEngineEntity::getEnabledMark, (Object)1)).eq(FlowEngineEntity::getVisibleType, (Object)1)).and(w -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)w.in(!id.isEmpty(), FlowEngineEntity::getId, (Collection)id);
            });
        }
        if (CollectionUtil.isEmpty((Collection)companyList)) {
            return new ArrayList<FlowEngineEntity>();
        }
        if (com.bringspring.common.util.StringUtils.isNotEmpty((String)pagination.getKeyword())) {
            flag = true;
            queryWrapper.lambda().like(FlowEngineEntity::getFullName, (Object)pagination.getKeyword());
        }
        if (com.bringspring.common.util.StringUtils.isNotEmpty((String)pagination.getCategory())) {
            flag = true;
            queryWrapper.lambda().eq(FlowEngineEntity::getCategory, (Object)pagination.getCategory());
        }
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(FlowEngineEntity::getSortCode)).orderByDesc(FlowEngineEntity::getCreatorTime);
        if (flag) {
            queryWrapper.lambda().orderByDesc(FlowEngineEntity::getLastModifyTime);
        }
        queryWrapper.lambda().select(new SFunction[]{FlowEngineEntity::getId, FlowEngineEntity::getEnCode, FlowEngineEntity::getFullName, FlowEngineEntity::getFormType, FlowEngineEntity::getType, FlowEngineEntity::getIcon, FlowEngineEntity::getCategory, FlowEngineEntity::getIconBackground, FlowEngineEntity::getVisibleType, FlowEngineEntity::getCreatorUserId, FlowEngineEntity::getSortCode, FlowEngineEntity::getEnabledMark, FlowEngineEntity::getCreatorTime});
        if (isPage) {
            Page page = new Page(pagination.getCurrentPage(), pagination.getPageSize());
            IPage userPage = this.page((IPage)page, (Wrapper)queryWrapper);
            return pagination.setData(userPage.getRecords(), page.getTotal());
        }
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<FlowEngineEntity> getFlowFormList() {
        List<FlowEngineEntity> data = this.getListAll(new FlowPagination(), false);
        return data;
    }

    @Override
    public List<FlowEngineEntity> getFlowFormTypeList() {
        ArrayList<Integer> visibleType = new ArrayList<Integer>();
        visibleType.add(0);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(FlowEngineEntity::getEnabledMark, (Object)1);
        queryWrapper.lambda().in(FlowEngineEntity::getVisibleType, visibleType);
        queryWrapper.lambda().eq(FlowEngineEntity::getType, (Object)0);
        queryWrapper.lambda().select(new SFunction[]{FlowEngineEntity::getId});
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<FlowEngineEntity> getFlowList(List<String> id) {
        List<FlowEngineEntity> list = new ArrayList<FlowEngineEntity>();
        if (id.size() > 0) {
            QueryWrapper queryWrapper = new QueryWrapper();
            ((LambdaQueryWrapper)queryWrapper.lambda().in(FlowEngineEntity::getId, id)).orderByDesc(FlowEngineEntity::getCreatorTime);
            list = this.list((Wrapper)queryWrapper);
        }
        return list;
    }

    @Override
    public FlowEngineEntity getInfo(String id) throws WorkFlowException {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(FlowEngineEntity::getId, (Object)id);
        FlowEngineEntity flowEngineEntity = (FlowEngineEntity)this.getOne((Wrapper)queryWrapper);
        if (flowEngineEntity == null) {
            throw new WorkFlowException(MsgCode.WF113.get());
        }
        return flowEngineEntity;
    }

    @Override
    public FlowEngineEntity getInfoByEnCode(String enCode) throws WorkFlowException {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(FlowEngineEntity::getEnCode, (Object)enCode)).eq(FlowEngineEntity::getEnabledMark, (Object)1);
        FlowEngineEntity flowEngineEntity = (FlowEngineEntity)this.getOne((Wrapper)queryWrapper);
        if (flowEngineEntity == null) {
            throw new WorkFlowException(MsgCode.WF113.get());
        }
        return flowEngineEntity;
    }

    @Override
    public boolean isExistByFullName(String fullName, String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(FlowEngineEntity::getFullName, (Object)fullName);
        queryWrapper.lambda().eq(FlowEngineEntity::getType, (Object)0);
        if (!StringUtils.isEmpty((CharSequence)id)) {
            queryWrapper.lambda().ne(FlowEngineEntity::getId, (Object)id);
        }
        return this.count((Wrapper)queryWrapper) > 0L;
    }

    @Override
    public boolean isExistByEnCode(String enCode, String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(FlowEngineEntity::getEnCode, (Object)enCode);
        if (!StringUtils.isEmpty((CharSequence)id)) {
            queryWrapper.lambda().ne(FlowEngineEntity::getId, (Object)id);
        }
        return this.count((Wrapper)queryWrapper) > 0L;
    }

    @Override
    public void delete(FlowEngineEntity entity) throws WorkFlowException {
        List<FlowTaskEntity> taskNodeList = this.flowTaskService.getTaskList(entity.getId(), FlowTaskEntity::getId);
        if (taskNodeList.size() > 0) {
            throw new WorkFlowException("\u5f15\u64ce\u5728\u4f7f\u7528\uff0c\u4e0d\u53ef\u5220\u9664");
        }
        this.removeById((Serializable)((Object)entity.getId()));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(FlowEngineVisibleEntity::getFlowId, (Object)entity.getId());
        this.flowEngineVisibleService.remove((Wrapper)queryWrapper);
        Object service = SpringContext.getBean((String)"appDataServiceImpl");
        Class[] types = new Class[]{String.class};
        Object[] datas = new Object[]{entity.getId()};
        ReflectionUtil.invokeMethod((Object)service, (String)"delete", (Class[])types, (Object[])datas);
    }

    @Override
    @DSTransactional
    public void create(FlowEngineEntity entity) throws WorkFlowException {
        List<FlowEngineVisibleEntity> visibleList = this.visibleList(entity);
        if (entity.getId() == null) {
            entity.setId(RandomUtil.uuId());
        }
        entity.setVersion(com.bringspring.common.util.StringUtils.isEmpty((String)entity.getVersion()) ? "1" : entity.getVersion());
        this.table(entity, false);
        entity.setCreatorUserId(this.userProvider.get().getUserId());
        entity.setVisibleType(visibleList.size() == 0 ? 0 : 1);
        this.save(entity);
        if (entity.getFlowTemplateJson() != null) {
            for (int i = 0; i < visibleList.size(); ++i) {
                visibleList.get(i).setId(RandomUtil.uuId());
                visibleList.get(i).setFlowId(entity.getId());
                visibleList.get(i).setSortCode(RandomUtil.parses());
                this.flowEngineVisibleService.save(visibleList.get(i));
            }
        }
    }

    @Override
    @DSTransactional
    public void copy(FlowEngineEntity entity) throws WorkFlowException {
        try {
            entity.setVersion("1");
            this.create(entity);
        }
        catch (WorkFlowException e) {
            this.log.error(e.getMessage());
            throw new WorkFlowException(MsgCode.WF103.get());
        }
    }

    @Override
    @DSTransactional
    public boolean updateVisible(String id, FlowEngineEntity entity) throws WorkFlowException {
        List<FlowEngineVisibleEntity> visibleList = this.visibleList(entity);
        entity.setId(id);
        entity.setLastModifyTime(new Date());
        entity.setLastModifyUserId(this.userProvider.get().getUserId());
        entity.setVisibleType(visibleList.size() == 0 ? 0 : 1);
        String num = "1";
        FlowEngineEntity info = this.getInfo(id);
        BigDecimal b1 = new BigDecimal(com.bringspring.common.util.StringUtils.isEmpty((String)info.getVersion()) ? "0" : info.getVersion());
        BigDecimal b2 = new BigDecimal(num);
        entity.setVersion(String.valueOf(b1.add(b2)));
        this.table(entity, true);
        boolean flag = this.updateById(entity);
        if (flag) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().eq(FlowEngineVisibleEntity::getFlowId, (Object)entity.getId());
            this.flowEngineVisibleService.remove((Wrapper)queryWrapper);
            if (entity.getFlowTemplateJson() != null) {
                ChildNode childNode = (ChildNode)JsonUtil.getJsonToBean((String)entity.getFlowTemplateJson(), ChildNode.class);
                Properties properties = childNode.getProperties();
                for (int i = 0; i < visibleList.size(); ++i) {
                    visibleList.get(i).setId(RandomUtil.uuId());
                    visibleList.get(i).setFlowId(entity.getId());
                    visibleList.get(i).setSortCode(Long.parseLong(i + ""));
                    this.flowEngineVisibleService.save(visibleList.get(i));
                }
            }
        }
        return flag;
    }

    @Override
    @DSTransactional
    public void update(String id, FlowEngineEntity entity) throws WorkFlowException {
        String num = "1";
        FlowEngineEntity info = this.getInfo(id);
        BigDecimal b1 = new BigDecimal(com.bringspring.common.util.StringUtils.isEmpty((String)info.getVersion()) ? "0" : info.getVersion());
        BigDecimal b2 = new BigDecimal(num);
        entity.setVersion(String.valueOf(b1.add(b2)));
        entity.setId(id);
        entity.setLastModifyTime(new Date());
        entity.setLastModifyUserId(this.userProvider.get().getUserId());
        this.table(entity, true);
        this.updateById(entity);
    }

    @Override
    public boolean first(String id) {
        boolean isOk = false;
        FlowEngineEntity upEntity = (FlowEngineEntity)this.getById((Serializable)((Object)id));
        Long upSortCode = upEntity.getSortCode() == null ? 0L : upEntity.getSortCode();
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().lt(FlowEngineEntity::getSortCode, (Object)upSortCode)).eq(FlowEngineEntity::getCategory, (Object)upEntity.getCategory())).orderByDesc(FlowEngineEntity::getSortCode);
        List downEntity = this.list((Wrapper)queryWrapper);
        if (downEntity.size() > 0) {
            Long temp = upEntity.getSortCode();
            upEntity.setSortCode(((FlowEngineEntity)downEntity.get(0)).getSortCode());
            ((FlowEngineEntity)downEntity.get(0)).setSortCode(temp);
            this.updateById(downEntity.get(0));
            this.updateById(upEntity);
            isOk = true;
        }
        return isOk;
    }

    @Override
    public boolean next(String id) {
        boolean isOk = false;
        FlowEngineEntity downEntity = (FlowEngineEntity)this.getById((Serializable)((Object)id));
        Long upSortCode = downEntity.getSortCode() == null ? 0L : downEntity.getSortCode();
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().gt(FlowEngineEntity::getSortCode, (Object)upSortCode)).eq(FlowEngineEntity::getCategory, (Object)downEntity.getCategory())).orderByAsc(FlowEngineEntity::getSortCode);
        List upEntity = this.list((Wrapper)queryWrapper);
        if (upEntity.size() > 0) {
            Long temp = downEntity.getSortCode();
            downEntity.setSortCode(((FlowEngineEntity)upEntity.get(0)).getSortCode());
            ((FlowEngineEntity)upEntity.get(0)).setSortCode(temp);
            this.updateById(upEntity.get(0));
            this.updateById(downEntity);
            isOk = true;
        }
        return isOk;
    }

    @Override
    public List<FlowEngineListVO> getTreeList(PaginationFlowEngine pagination, boolean isList) {
        List<FlowEngineEntity> data = isList ? this.getList(pagination) : this.getFlowFormList();
        List<DictionaryDataEntity> dictionList = this.serviceUtil.getDiList();
        Map<String, List<FlowEngineEntity>> dataList = data.stream().collect(Collectors.groupingBy(FlowEngineEntity::getCategory));
        LinkedList<FlowEngineListVO> listVOS = new LinkedList<FlowEngineListVO>();
        for (DictionaryDataEntity entity : dictionList) {
            FlowEngineListVO model = new FlowEngineListVO();
            model.setFullName(entity.getFullName());
            model.setId(entity.getId());
            ArrayList childList = dataList.get(entity.getEnCode()) != null ? dataList.get(entity.getEnCode()) : new ArrayList();
            model.setNum(childList.size());
            if (childList.size() > 0) {
                model.setChildren(JsonUtil.getJsonToList(childList, FlowEngineListVO.class));
            }
            listVOS.add(model);
        }
        return listVOS;
    }

    private List<FlowEngineVisibleEntity> visibleList(FlowEngineEntity entity) {
        ArrayList<FlowEngineVisibleEntity> visibleList = new ArrayList<FlowEngineVisibleEntity>();
        UserInfo userInfo = this.userProvider.get();
        if (entity.getFlowTemplateJson() != null) {
            FlowEngineVisibleEntity visible;
            ChildNode childNode = (ChildNode)JsonUtil.getJsonToBean((String)entity.getFlowTemplateJson(), ChildNode.class);
            Properties properties = childNode.getProperties();
            for (String string : properties.getInitiator()) {
                visible = new FlowEngineVisibleEntity();
                visible.setOperatorId(string);
                visible.setOperatorType("user");
                visibleList.add(visible);
            }
            for (String string : properties.getInitiatePos()) {
                visible = new FlowEngineVisibleEntity();
                visible.setOperatorId(string);
                visible.setOperatorType("position");
                visibleList.add(visible);
            }
            ArrayList roleList = properties.getInitiateRole() != null ? properties.getInitiateRole() : new ArrayList();
            for (String role : roleList) {
                FlowEngineVisibleEntity visible2 = new FlowEngineVisibleEntity();
                visible2.setOperatorId(role);
                visible2.setOperatorType("role");
                visibleList.add(visible2);
            }
            String string = userInfo.getOrganizeId();
            visible = new FlowEngineVisibleEntity();
            visible.setOperatorId(string);
            visible.setOperatorType("company");
            visibleList.add(visible);
        }
        return visibleList;
    }

    @Override
    public FlowExportModel exportData(String id) throws WorkFlowException {
        FlowEngineEntity entity = this.getInfo(id);
        List<FlowEngineVisibleEntity> visibleList = this.flowEngineVisibleService.getVisibleFlowList(entity.getId());
        FlowExportModel model = new FlowExportModel();
        model.setFlowEngine(entity);
        model.setVisibleList(visibleList);
        return model;
    }

    @Override
    @DSTransactional
    public ActionResult ImportData(FlowEngineEntity entity, List<FlowEngineVisibleEntity> visibleList) throws WorkFlowException {
        List<FlowEngineVisibleEntity> companyList = this.visibleList(entity);
        visibleList.addAll(companyList);
        if (entity != null) {
            if (this.isExistByFullName(entity.getFullName(), null)) {
                return ActionResult.fail((String)"\u6d41\u7a0b\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
            }
            if (this.isExistByEnCode(entity.getEnCode(), null)) {
                return ActionResult.fail((String)"\u6d41\u7a0b\u7f16\u7801\u4e0d\u80fd\u91cd\u590d");
            }
            try {
                entity.setVisibleType(1);
                this.save(entity);
                if (visibleList != null) {
                    for (int i = 0; i < visibleList.size(); ++i) {
                        visibleList.get(i).setId(RandomUtil.uuId());
                        visibleList.get(i).setFlowId(entity.getId());
                        visibleList.get(i).setSortCode(RandomUtil.parses());
                        this.flowEngineVisibleService.save(visibleList.get(i));
                    }
                }
            }
            catch (Exception e) {
                throw new WorkFlowException(MsgCode.IMP003.get());
            }
            return ActionResult.success((String)MsgCode.IMP001.get());
        }
        return ActionResult.fail((String)"\u5bfc\u5165\u6570\u636e\u683c\u5f0f\u4e0d\u6b63\u786e");
    }

    private void table(FlowEngineEntity flowEngineEntity, boolean isData) throws WorkFlowException {
        if (flowEngineEntity.getFormType() != 1) {
            FlowEngineEntity info;
            List infoTable;
            FormDataModel formData = (FormDataModel)JsonUtil.getJsonToBean((String)flowEngineEntity.getFormData(), FormDataModel.class);
            List list = JsonUtil.getJsonToList((String)formData.getFields(), FieLdsModel.class);
            List tableModelList = JsonUtil.getJsonToList((String)flowEngineEntity.getFlowTables(), TableModel.class);
            if (isData && tableModelList.size() == 0 && (infoTable = JsonUtil.getJsonToList((String)(info = this.getInfo(flowEngineEntity.getId())).getFlowTables(), TableModel.class)).size() == 0) {
                throw new WorkFlowException(MsgCode.WF008.get());
            }
            RecursionForm recursionForm = new RecursionForm(list, tableModelList);
            ArrayList<FormAllModel> formAllModel = new ArrayList<FormAllModel>();
            if (FormCloumnUtil.repetition((RecursionForm)recursionForm, formAllModel)) {
                throw new WorkFlowException("\u5b50\u8868\u91cd\u590d");
            }
            if (tableModelList.size() == 0) {
                Map data = JsonUtil.stringToMap((String)flowEngineEntity.getFormData());
                JSONArray jsonArray = JsonUtil.getJsonToJsonArray((String)formData.getFields());
                List<TableModel> tableModels = this.visualDevTableCre.tableList(jsonArray, formAllModel, "wform_" + flowEngineEntity.getEnCode() + "_" + RandomUtil.enUuid(), flowEngineEntity.getDbLinkId());
                data.put("fields", jsonArray);
                flowEngineEntity.setFormData(JsonUtil.getObjectToString((Object)data));
                flowEngineEntity.setFlowTables(JsonUtil.getObjectToString(tableModels));
            }
        }
    }
}

