/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.workflow.engine.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.permission.entity.UserRelationEntity;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.workflow.engine.entity.FlowEngineVisibleEntity;
import com.bringspring.workflow.engine.mapper.FlowEngineVisibleMapper;
import com.bringspring.workflow.engine.service.FlowEngineVisibleService;
import com.bringspring.workflow.engine.util.ServiceAllUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FlowEngineVisibleServiceImpl
extends ServiceImpl<FlowEngineVisibleMapper, FlowEngineVisibleEntity>
implements FlowEngineVisibleService {
    @Autowired
    private ServiceAllUtil serviceUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private FlowEngineVisibleService flowEngineVisibleService;

    @Override
    public List<FlowEngineVisibleEntity> getList(String flowId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(FlowEngineVisibleEntity::getFlowId, (Object)flowId);
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(FlowEngineVisibleEntity::getSortCode)).orderByDesc(FlowEngineVisibleEntity::getCreatorTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<FlowEngineVisibleEntity> getVisibleFlowList(String userId) {
        ArrayList<String> userList = new ArrayList<String>();
        userList.add(userId);
        UserInfo userInfo = this.userProvider.get();
        List<UserRelationEntity> list = this.serviceUtil.getListByUserIdAll(userList);
        List userRelationList = list.stream().map(u -> u.getObjectId()).collect(Collectors.toList());
        userRelationList.add(userId);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.lambda().in(FlowEngineVisibleEntity::getOperatorId, userRelationList);
        List userIdList = this.list((Wrapper)wrapper);
        QueryWrapper subQueryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)subQueryWrapper.lambda().select(new SFunction[]{FlowEngineVisibleEntity::getFlowId}).ne(FlowEngineVisibleEntity::getOperatorType, (Object)"company")).groupBy(FlowEngineVisibleEntity::getFlowId);
        List excludedFlowIds = this.flowEngineVisibleService.list((Wrapper)subQueryWrapper).stream().map(FlowEngineVisibleEntity::getFlowId).collect(Collectors.toList());
        QueryWrapper Wrapper2 = new QueryWrapper();
        ((LambdaQueryWrapper)Wrapper2.lambda().notIn(!excludedFlowIds.isEmpty(), FlowEngineVisibleEntity::getFlowId, excludedFlowIds)).eq(FlowEngineVisibleEntity::getOperatorId, (Object)userInfo.getOrganizeId());
        List flowList = this.list((Wrapper)Wrapper2);
        flowList.addAll(userIdList);
        return flowList;
    }

    @Override
    public List<FlowEngineVisibleEntity> getAllCompanyVisibleFlowList(String userId, String menuId) {
        UserInfo userInfo = this.userProvider.get();
        QueryWrapper queryWrapper = new QueryWrapper();
        if (!userInfo.getIsAdministrator().booleanValue()) {
            if (Objects.nonNull(menuId) && !this.userProvider.get().getIsAdministrator().booleanValue()) {
                Object companyAuth = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, menuId, "flow_engine_visible"));
                if (ObjectUtil.isEmpty((Object)companyAuth)) {
                    return new ArrayList<FlowEngineVisibleEntity>();
                }
                queryWrapper = (QueryWrapper)companyAuth;
            }
        } else {
            return new ArrayList<FlowEngineVisibleEntity>();
        }
        return this.list((Wrapper)queryWrapper);
    }
}

