/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.workflow.engine.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.workflow.engine.entity.FlowDelegateEntity;
import com.bringspring.workflow.engine.entity.FlowTaskOperatorEntity;
import com.bringspring.workflow.engine.enums.FlowNodeEnum;
import com.bringspring.workflow.engine.mapper.FlowTaskOperatorMapper;
import com.bringspring.workflow.engine.service.FlowDelegateService;
import com.bringspring.workflow.engine.service.FlowTaskOperatorService;
import com.bringspring.workflow.engine.util.FlowNature;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FlowTaskOperatorServiceImpl
extends ServiceImpl<FlowTaskOperatorMapper, FlowTaskOperatorEntity>
implements FlowTaskOperatorService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private FlowDelegateService flowDelegateService;

    @Override
    public List<FlowTaskOperatorEntity> getList(String taskId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(FlowTaskOperatorEntity::getTaskId, (Object)taskId)).orderByDesc(FlowTaskOperatorEntity::getCreatorTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public FlowTaskOperatorEntity getInfo(String id) throws WorkFlowException {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(FlowTaskOperatorEntity::getId, (Object)id);
        FlowTaskOperatorEntity entity = (FlowTaskOperatorEntity)this.getOne((Wrapper)queryWrapper);
        if (entity == null) {
            throw new WorkFlowException(MsgCode.WF123.get());
        }
        return entity;
    }

    @Override
    public FlowTaskOperatorEntity getOperatorInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(FlowTaskOperatorEntity::getId, (Object)id);
        FlowTaskOperatorEntity entity = (FlowTaskOperatorEntity)this.getOne((Wrapper)queryWrapper);
        return entity;
    }

    @Override
    public FlowTaskOperatorEntity getInfo(String taskId, String nodeNo) {
        QueryWrapper queryWrapper = new QueryWrapper();
        UserInfo userInfo = this.userProvider.get();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(FlowTaskOperatorEntity::getTaskId, (Object)taskId)).eq(FlowTaskOperatorEntity::getNodeCode, (Object)nodeNo)).eq(FlowTaskOperatorEntity::getHandleId, (Object)userInfo.getUserId())).eq(FlowTaskOperatorEntity::getCompletion, (Object)FlowNature.ProcessCompletion);
        return (FlowTaskOperatorEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public FlowTaskOperatorEntity getInfoBy(String taskId, String nodeNo) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(FlowTaskOperatorEntity::getTaskId, (Object)taskId)).eq(FlowTaskOperatorEntity::getNodeCode, (Object)nodeNo)).eq(FlowTaskOperatorEntity::getCompletion, (Object)FlowNature.ProcessCompletion);
        return (FlowTaskOperatorEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void deleteByTaskId(String taskId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(FlowTaskOperatorEntity::getTaskId, (Object)taskId);
        this.remove((Wrapper)queryWrapper);
    }

    @Override
    public void deleteByNodeId(String nodeId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(FlowTaskOperatorEntity::getTaskNodeId, (Object)nodeId)).eq(FlowTaskOperatorEntity::getCompletion, (Object)FlowNature.ProcessCompletion);
        this.remove((Wrapper)queryWrapper);
    }

    @Override
    public void create(List<FlowTaskOperatorEntity> entitys) {
        for (FlowTaskOperatorEntity entity : entitys) {
            this.save(entity);
        }
    }

    @Override
    public void create(FlowTaskOperatorEntity entity) {
        this.save(entity);
    }

    @Override
    public void update(FlowTaskOperatorEntity entity) {
        this.updateById(entity);
    }

    @Override
    public void update(String taskNodeId, List<String> userId, String completion) {
        if (userId.size() > 0) {
            UpdateWrapper updateWrapper = new UpdateWrapper();
            updateWrapper.lambda().eq(FlowTaskOperatorEntity::getTaskNodeId, (Object)taskNodeId);
            updateWrapper.lambda().in(FlowTaskOperatorEntity::getHandleId, userId);
            updateWrapper.lambda().set(FlowTaskOperatorEntity::getCompletion, (Object)FlowNature.AuditCompletion);
            this.update((Wrapper)updateWrapper);
        }
    }

    @Override
    public void update(String taskNodeId, String type) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.lambda().eq(FlowTaskOperatorEntity::getTaskNodeId, (Object)taskNodeId);
        updateWrapper.lambda().eq(FlowTaskOperatorEntity::getType, (Object)type);
        updateWrapper.lambda().set(FlowTaskOperatorEntity::getCompletion, (Object)FlowNature.AuditCompletion);
        this.update((Wrapper)updateWrapper);
    }

    @Override
    public void updateByCounterSign(String taskNodeId) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((LambdaUpdateWrapper)updateWrapper.lambda().eq(FlowTaskOperatorEntity::getTaskNodeId, (Object)taskNodeId)).set(FlowTaskOperatorEntity::getCompletion, (Object)FlowNature.AuditCompletion);
        this.update((Wrapper)updateWrapper);
    }

    @Override
    public void update(String taskId) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.lambda().eq(FlowTaskOperatorEntity::getTaskId, (Object)taskId);
        updateWrapper.lambda().set(FlowTaskOperatorEntity::getState, (Object)FlowNodeEnum.Futility.getCode());
        this.update((Wrapper)updateWrapper);
    }

    @Override
    public List<FlowTaskOperatorEntity> press(String taskId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(FlowTaskOperatorEntity::getCompletion, (Object)FlowNature.ProcessCompletion)).eq(FlowTaskOperatorEntity::getTaskId, (Object)taskId)).eq(FlowTaskOperatorEntity::getState, (Object)FlowNodeEnum.Process.getCode());
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public void updateReject(String taskId, Set<String> taskNodeId) {
        if (taskNodeId.size() > 0) {
            UpdateWrapper updateWrapper = new UpdateWrapper();
            updateWrapper.lambda().eq(FlowTaskOperatorEntity::getTaskId, (Object)taskId);
            updateWrapper.lambda().in(FlowTaskOperatorEntity::getTaskNodeId, taskNodeId);
            updateWrapper.lambda().set(FlowTaskOperatorEntity::getState, (Object)FlowNodeEnum.Futility.getCode());
            this.update((Wrapper)updateWrapper);
        }
    }

    @Override
    public void deleteList(List<String> idAll) {
        if (idAll.size() > 0) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().in(FlowTaskOperatorEntity::getId, idAll);
            this.remove((Wrapper)queryWrapper);
        }
    }

    @Override
    public List<FlowTaskOperatorEntity> getParentId(String parentId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(FlowTaskOperatorEntity::getParentId, (Object)parentId);
        queryWrapper.lambda().orderByDesc(FlowTaskOperatorEntity::getCreatorTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public void updateTaskOperatorState(List<String> idAll) {
        if (idAll.size() > 0) {
            UpdateWrapper queryWrapper = new UpdateWrapper();
            queryWrapper.lambda().in(FlowTaskOperatorEntity::getId, idAll);
            queryWrapper.lambda().set(FlowTaskOperatorEntity::getState, (Object)FlowNodeEnum.Futility.getCode());
            queryWrapper.lambda().set(FlowTaskOperatorEntity::getCompletion, (Object)FlowNature.RejectCompletion);
            this.update((Wrapper)queryWrapper);
        }
    }

    @Override
    public List<FlowTaskOperatorEntity> getBatchList() {
        UserInfo userInfo = this.userProvider.get();
        List userList = this.flowDelegateService.getUser(userInfo.getUserId()).stream().map(FlowDelegateEntity::getCreatorUserId).collect(Collectors.toList());
        userList.add(userInfo.getUserId());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().in(FlowTaskOperatorEntity::getHandleId, userList);
        queryWrapper.lambda().eq(FlowTaskOperatorEntity::getCompletion, (Object)FlowNature.ProcessCompletion);
        queryWrapper.lambda().eq(FlowTaskOperatorEntity::getState, (Object)FlowNature.ProcessCompletion);
        queryWrapper.lambda().select(new SFunction[]{FlowTaskOperatorEntity::getTaskId});
        return this.list((Wrapper)queryWrapper);
    }
}

