package com.bringspring.workflow.engine.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.util.Date;

/**
 * 流程可见
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月27日 上午9:18
 */
@Data
@TableName("FLOW_ENGINE_VISIBLE")
public class FlowEngineVisibleEntity {
    /**
     * 可见主键
     */
    @TableId("ID")
    private String id;

    /**
     * 流程主键
     */
    @TableField("FLOW_ID")
    private String flowId;

    /**
     * 经办类型
     */
    @TableField("OPERATOR_TYPE")
    private String operatorType;

    /**
     * 经办主键
     */
    @TableField("OPERATOR_ID")
    private String operatorId;

    /**
     * 排序码
     */
    @TableField("SORT_CODE")
    private Long sortCode;

    /**
     * 创建时间
     */
    @TableField(value = "CREATOR_TIME",fill = FieldFill.INSERT)
    private Date creatorTime;

    /**
     * 创建用户
     */
    @TableField(value = "CREATOR_USER_ID",fill = FieldFill.INSERT)
    private String creatorUserId;
}
