package com.bringspring.workflow.engine.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.util.Date;

/**
 * 流程任务
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月27日 上午9:18
 */
@Data
@TableName("FLOW_TASK")
public class FlowTaskEntity {
    /**
     * 任务主键
     */
    @TableId("ID")
    private String id;

    /**
     * 实例进程
     */
    @TableField("PROCESS_ID")
    private String processId;

    /**
     * 任务编码
     */
    @TableField("ENCODE")
    private String enCode;

    /**
     * 任务标题
     */
    @TableField("FULL_NAME")
    private String fullName;

    /**
     * 紧急程度
     */
    @TableField("FLOW_URGENT")
    private Integer flowUrgent;

    /**
     * 流程主键
     */
    @TableField("FLOW_ID")
    private String flowId;

    /**
     * 流程编码
     */
    @TableField("FLOW_CODE")
    private String flowCode;

    /**
     * 流程名称
     */
    @TableField("FLOW_NAME")
    private String flowName;

    /**
     * 流程类型
     */
    @TableField("FLOW_TYPE")
    private Integer flowType;


    @TableField(exist = false)
    private String handleOpinion;

    /**
     * 流程分类
     */
    @TableField("FLOW_CATEGORY")
    private String flowCategory;

    /**
     * 流程表单
     */
    @TableField("FLOW_FORM")
    private String flowForm;

    /**
     * 表单内容
     */
    @TableField("FLOW_FORM_CONTENT_JSON")
    private String flowFormContentJson;

    /**
     * 流程模板
     */
    @TableField("FLOW_TEMPLATE_JSON")
    private String flowTemplateJson;

    /**
     * 流程版本
     */
    @TableField("FLOW_VERSION")
    private String flowVersion;

    /**
     * 开始时间
     */
    @TableField(value = "START_TIME")
    private Date startTime;

    /**
     * 结束时间
     */
    @TableField(value = "END_TIME")
    private Date endTime;

    /**
     * 当前步骤
     */
    @TableField("THIS_STEP")
    private String thisStep;

    /**
     * 当前步骤Id
     */
    @TableField(value = "THIS_STEP_ID")
    private String thisStepId;

    /**
     * 重要等级
     */
    @TableField("GRADE")
    private String grade;

    /**
     * 任务状态 0-草稿、1-处理、2-通过、3-驳回、4-撤销、5-终止
     */
    @TableField("STATUS")
    private Integer status;

    /**
     * 完成情况
     */
    @TableField("COMPLETION")
    private Integer completion;

    /**
     * 描述
     */
    @TableField("DESCRIPTION")
    private String description;

    /**
     * 父节点id
     */
    @TableField("PARENT_ID")
    private String parentId;

    /**
     * 是否批量（0：否，1：是）
     */
    @TableField("IS_BATCH")
    private Integer isBatch;

    /**
     * 同步异步（0：同步，1：异步）
     */
    @TableField(value = "IS_ASYNC")
    private Integer isAsync;
    /**
     * 排序码
     */
    @TableField("SORT_CODE")
    private Long sortCode;

    /**
     * 有效标志
     */
    @TableField("ENABLED_MARK")
    private Integer enabledMark;


    /**
     * 创建时间
     */
    @TableField(value = "CREATOR_TIME", fill = FieldFill.INSERT)
    private Date creatorTime;

    /**
     * 创建用户
     */
    @TableField(value = "CREATOR_USER_ID", fill = FieldFill.INSERT)
    private String creatorUserId;

    /**
     * 修改时间
     */
    @TableField(value = "LAST_MODIFY_TIME", fill = FieldFill.INSERT_UPDATE)
    private Date lastModifyTime;

    /**
     * 修改用户
     */
    @TableField(value = "LAST_MODIFY_USER_ID", fill = FieldFill.INSERT_UPDATE)
    private String lastModifyUserId;

    /**
     * 删除标志
     */
    @TableField("DELETE_MARK")
    private Integer deleteMark;

    /**
     * 删除时间
     */
    @TableField("DELETE_TIME")
    private Date deleteTime;

    /**
     * 删除用户
     */
    @TableField("DELETE_USER_ID")
    private String deleteUserId;
}
