package com.bringspring.workflow.engine.model.flowengine;


import lombok.Data;

import java.util.List;
import java.util.Map;

/**
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021/3/15 9:17
 */
@Data
public class FlowModel {
    /**
     * 判断新增
     **/
    private String id;
    /**
     * 引擎id
     **/
    private String flowId;
    /**
     * 流程主键
     **/
    private String processId;
    /**
     * 流程标题
     **/
    private String flowTitle;
    /**
     * 紧急程度
     **/
    private Integer flowUrgent;
    /**
     * 流水号
     **/
    private String billNo;
    /**
     * 提交表单对象
     **/
    private Object formEntity;
    /**
     * 审核表单数据
     **/
    private Map<String, Object> formData;
    /**
     * 加签类型 before-在我之前，after-在我之后
     **/
    private String freeApproverType;
    /**
     * 加签人
     **/
    private String freeApproverUserId;
    /**
     *  0.保存 1.提交
     **/
    private Integer status;
    /**
     * 意见
     **/
    private String handleOpinion;
    /**
     * 签名
     **/
    private String signImg;

    /**
     * 附件
     */
    private List<Object> handleFiles;
    /**
     * 抄送人
     **/
    private String copyIds;
    /**
     * 子流程
     **/
    private String parentId;
    /**
     * 创建人
     **/
    private String userId;
    /**
     * 当前经办id
     **/
    private String operatorId;
    /**
     * 同步异步
     **/
    private Boolean isAsync = false;
    /**
     * 候选人
     **/
    private Map<String, List<String>> candidateList;
    /**
     * 指派节点
     **/
    private String nodeCode;

    /**
     * 自定义字段
     */
    private String customFiled;

    /**
     * 驳回步骤 1.上一步骤 0.返回开始
     */
    private String rejectStep;

    /**
     *驳回节点选择驳回步骤
     */
    private String rejectAgreeStep;

    /**
     * 被退回的节点重新提交时的方式
     */
    private String rejectAuditType;



}
