package com.bringspring.workflow.engine.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.bringspring.workflow.engine.entity.FlowEngineVisibleEntity;

import java.util.List;

/**
 * 流程可见
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月27日 上午9:18
 */
public interface FlowEngineVisibleService extends IService<FlowEngineVisibleEntity> {

    /**
     * 列表
     *
     * @param flowId 流程主键
     * @return
     */
    List<FlowEngineVisibleEntity> getList(String flowId);

    /**
     * 可见流程列表
     *
     * @param userId 用户主键
     * @return
     */
    List<FlowEngineVisibleEntity> getVisibleFlowList(String userId);

    /**
     * 根据所属公司、数据权限查看流程列表
     * @param userId
     * @param menuId
     * @return
     */
    List<FlowEngineVisibleEntity> getAllCompanyVisibleFlowList(String userId,String menuId);



}
