package com.bringspring.workflow.engine.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.entity.UserRelationEntity;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.workflow.engine.entity.FlowEngineVisibleEntity;
import com.bringspring.workflow.engine.mapper.FlowEngineVisibleMapper;
import com.bringspring.workflow.engine.service.FlowEngineVisibleService;
import com.bringspring.workflow.engine.util.ServiceAllUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 流程可见
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月27日 上午9:18
 */
@Service
public class FlowEngineVisibleServiceImpl extends ServiceImpl<FlowEngineVisibleMapper, FlowEngineVisibleEntity> implements FlowEngineVisibleService {

    @Autowired
    private ServiceAllUtil serviceUtil;

    @Autowired
    private UserProvider userProvider;

    @Autowired
    private AuthorizeService authorizeService;

    @Autowired
    private FlowEngineVisibleService flowEngineVisibleService;

    @Override
    public List<FlowEngineVisibleEntity> getList(String flowId) {
        QueryWrapper<FlowEngineVisibleEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(FlowEngineVisibleEntity::getFlowId, flowId);
        queryWrapper.lambda().orderByAsc(FlowEngineVisibleEntity::getSortCode).orderByDesc(FlowEngineVisibleEntity::getCreatorTime);
        return this.list(queryWrapper);
    }

    @Override
    public List<FlowEngineVisibleEntity> getVisibleFlowList(String userId) {
        List<String> userList = new ArrayList<>();
        userList.add(userId);
        UserInfo userInfo = userProvider.get();
        List<UserRelationEntity> list = serviceUtil.getListByUserIdAll(userList);
        List<String> userRelationList = list.stream().map(u -> u.getObjectId()).collect(Collectors.toList());
        userRelationList.add(userId);
        QueryWrapper<FlowEngineVisibleEntity> wrapper = new QueryWrapper<>();
        wrapper.lambda().in(FlowEngineVisibleEntity::getOperatorId, userRelationList);
        List<FlowEngineVisibleEntity> userIdList = this.list(wrapper);
        // 查询满足条件的 FlowEngineVisibleEntity 对象
        QueryWrapper<FlowEngineVisibleEntity> subQueryWrapper = new QueryWrapper<>();
        subQueryWrapper.lambda()
                .select(FlowEngineVisibleEntity::getFlowId)
                .ne(FlowEngineVisibleEntity::getOperatorType, "company")
                .groupBy(FlowEngineVisibleEntity::getFlowId);
        List<String> excludedFlowIds = flowEngineVisibleService.list(subQueryWrapper)
                .stream()
                .map(FlowEngineVisibleEntity::getFlowId)
                .collect(Collectors.toList());
            // 构建查询条件，用于获取满足特定条件的 FlowEngineVisibleEntity 对象
            QueryWrapper<FlowEngineVisibleEntity> Wrapper = new QueryWrapper<>();
            Wrapper.lambda()
                    .notIn(!excludedFlowIds.isEmpty(),FlowEngineVisibleEntity::getFlowId, excludedFlowIds)
                    .eq(FlowEngineVisibleEntity::getOperatorId, userInfo.getOrganizeId());


        List<FlowEngineVisibleEntity> flowList = this.list(Wrapper);
        flowList.addAll(userIdList);
        return flowList;
    }

    @Override
    public List<FlowEngineVisibleEntity> getAllCompanyVisibleFlowList(String userId, String menuId) {
        UserInfo userInfo = userProvider.get();
        QueryWrapper<FlowEngineVisibleEntity> queryWrapper = new QueryWrapper<>();
        //按照数据权限查询数据
        if (!userInfo.getIsAdministrator()) {
            if (Objects.nonNull(menuId)) {
                if (!userProvider.get().getIsAdministrator()) {
                    Object companyAuth = authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, menuId, "flow_engine_visible"));
                    if (ObjectUtil.isEmpty(companyAuth)) {
                        return new ArrayList<>();
                    }
                    queryWrapper = (QueryWrapper<FlowEngineVisibleEntity>) companyAuth;

                }
            }
        } else {
            return new ArrayList<>();
        }

        return list(queryWrapper);
    }

}
