package com.bringspring.workflow.engine.entity;


import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.util.Date;

/**
 * 流程引擎
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2024年8月7日 上午10:37
 */
@Data
@TableName("FLOW_ENGINE_TEMPLATE")
public class FlowEngineTemplateEntity {
    /**
     * 流程模板主键
     */
    @TableId("ID")
    private String id;

    /**
     * 流程引擎id
     */
    @TableField("FLOW_ID")
    private String flowId;

    /**
     * 流程编码
     */
    @TableField("ENCODE")
    private String enCode;

    @TableField("COMPANY_ID")
    private String companyId;

    /**
     * 流程名称
     */
    @TableField("FULL_NAME")
    private String fullName;

    /**
     * 可见类型 0-全部可见、1-指定经办
     */
    @TableField("VISIBLE_TYPE")
    private Integer visibleType;


    @TableField("VERSION")
    private String version;

    /**
     * 流程模板
     */
    @TableField("FLOW_TEMPLATE_JSON")
    private String flowTemplateJson;

    /**
     * 排序码
     */
    @TableField("SORT_CODE")
    private Long sortCode;

    /**
     * 有效标志
     */
    @TableField("ENABLED_MARK")
    private Integer enabledMark;

    /**
     * 创建时间
     */
    @TableField(value = "CREATOR_TIME",fill = FieldFill.INSERT)
    private Date creatorTime;

    /**
     * 创建用户
     */
    @TableField(value = "CREATOR_USER_ID",fill = FieldFill.INSERT)
    private String creatorUserId;

    /**
     * 修改时间
     */
    @TableField(value = "LAST_MODIFY_TIME",fill = FieldFill.UPDATE)
    private Date lastModifyTime;

    /**
     * 修改用户
     */
    @TableField(value = "LAST_MODIFY_USER_ID",fill = FieldFill.UPDATE)
    private String lastModifyUserId;

    /**
     * 删除标志
     */
    @TableField("DELETE_MARK")
    private Integer deleteMark;

    /**
     * 删除时间
     */
    @TableField("DELETE_TIME")
    private Date deleteTime;

    /**
     * 删除用户
     */
    @TableField("DELETE_USER_ID")
    private String deleteUserId;


}
