package com.bringspring.workflow.engine.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.model.FormAllModel;
import com.bringspring.common.model.visiual.FormCloumnUtil;
import com.bringspring.common.model.visiual.FormDataModel;
import com.bringspring.common.model.visiual.RecursionForm;
import com.bringspring.common.model.visiual.TableModel;
import com.bringspring.common.model.visiual.fields.FieLdsModel;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.ReflectionUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.context.SpringContext;
import com.bringspring.system.base.entity.DictionaryDataEntity;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.workflow.engine.entity.FlowEngineEntity;
import com.bringspring.workflow.engine.entity.FlowEngineTemplateEntity;
import com.bringspring.workflow.engine.entity.FlowEngineVisibleEntity;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.mapper.FlowEngineMapper;
import com.bringspring.workflow.engine.model.flowengine.FlowEngineListVO;
import com.bringspring.workflow.engine.model.flowengine.FlowExportModel;
import com.bringspring.workflow.engine.model.flowengine.FlowPagination;
import com.bringspring.workflow.engine.model.flowengine.PaginationFlowEngine;
import com.bringspring.workflow.engine.model.flowengine.shuntjson.childnode.ChildNode;
import com.bringspring.workflow.engine.model.flowengine.shuntjson.childnode.Properties;
import com.bringspring.workflow.engine.service.FlowEngineService;
import com.bringspring.workflow.engine.service.FlowEngineTemplateService;
import com.bringspring.workflow.engine.service.FlowEngineVisibleService;
import com.bringspring.workflow.engine.service.FlowTaskService;
import com.bringspring.workflow.engine.util.ServiceAllUtil;
import com.bringspring.workflow.engine.util.VisualDevTableCre;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 流程引擎
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月27日 上午9:18
 */
@Service
public class FlowEngineServiceImpl extends ServiceImpl<FlowEngineMapper, FlowEngineEntity> implements FlowEngineService {

    @Autowired
    private FlowTaskService flowTaskService;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private ServiceAllUtil serviceUtil;
    @Autowired
    private VisualDevTableCre visualDevTableCre;
    @Autowired
    private FlowEngineVisibleService flowEngineVisibleService;
    @Autowired
    private AuthorizeService authorizeService;

    @Autowired
    private FlowEngineTemplateService flowEngineTemplateService;

    @Override
    public List<FlowEngineEntity> getPageList(FlowPagination pagination) {
        UserInfo userInfo = userProvider.get();
        // 定义变量判断是否需要使用修改时间倒序
        boolean flag = false;
        PaginationFlowEngine engine = new PaginationFlowEngine();
        List<String> idList = flowEngineVisibleService.getAllCompanyVisibleFlowList(userInfo.getUserId(), pagination.getMenuId()).stream()
                .map(FlowEngineVisibleEntity::getFlowId).collect(Collectors.toList());
        engine.setFormType(2);
        engine.setType(1);
        List<FlowEngineEntity> getList = getList(engine);
        List<String> id = getList.stream().map(FlowEngineEntity::getId).collect(Collectors.toList());
        QueryWrapper<FlowEngineEntity> queryWrapper = new QueryWrapper<>();
        if (StringUtils.isNotEmpty(pagination.getKeyword())) {
            flag = true;
            queryWrapper.lambda().like(FlowEngineEntity::getFullName, pagination.getKeyword());
        }
        if (ObjectUtil.isNotEmpty(pagination.getFormType())) {
            queryWrapper.lambda().eq(FlowEngineEntity::getFormType, pagination.getFormType());
        }
        if (idList.size() > 0) {
            queryWrapper.lambda().in(FlowEngineEntity::getId, idList);
        }
        if (StringUtils.isNotEmpty(pagination.getCategory())) {
            flag = true;
            queryWrapper.lambda().eq(FlowEngineEntity::getCategory, pagination.getCategory());
        }
        if (!userInfo.getIsAdministrator() && ObjectUtil.isEmpty(idList)) {
            return new ArrayList<>();
        }
        //排序
        queryWrapper.lambda().orderByAsc(FlowEngineEntity::getSortCode).orderByDesc(FlowEngineEntity::getCreatorTime);
        if (flag) {
            queryWrapper.lambda().orderByDesc(FlowEngineEntity::getLastModifyTime);
        }
        Page<FlowEngineEntity> page = new Page<>(pagination.getCurrentPage(), pagination.getPageSize());
        IPage<FlowEngineEntity> userPage = this.page(page, queryWrapper);
        return pagination.setData(userPage.getRecords(), page.getTotal());
    }

    @Override
    public List<FlowEngineEntity> getList(PaginationFlowEngine pagination) {
        // 定义变量判断是否需要使用修改时间倒序
        boolean flag = false;
        QueryWrapper<FlowEngineEntity> queryWrapper = new QueryWrapper<>();

        if (ObjectUtil.isNotEmpty(pagination.getType())) {
            flag = true;
            queryWrapper.lambda().eq(FlowEngineEntity::getType, pagination.getType());
        }
        if (StringUtils.isNotEmpty(pagination.getKeyword())) {
            flag = true;
            queryWrapper.lambda().like(FlowEngineEntity::getFullName, pagination.getKeyword());
        }
        if (ObjectUtil.isNotEmpty(pagination.getFormType())) {
            flag = true;
            queryWrapper.lambda().eq(FlowEngineEntity::getFormType, pagination.getFormType());
        }
        if (ObjectUtil.isNotEmpty(pagination.getEnabledMark())) {
            flag = true;
            queryWrapper.lambda().eq(FlowEngineEntity::getEnabledMark, pagination.getEnabledMark());
        }
        //排序
        queryWrapper.lambda().orderByAsc(FlowEngineEntity::getSortCode).orderByDesc(FlowEngineEntity::getCreatorTime);
        if (flag) {
            queryWrapper.lambda().orderByDesc(FlowEngineEntity::getLastModifyTime);
        }
        queryWrapper.lambda().select(
                FlowEngineEntity::getId, FlowEngineEntity::getEnCode,
                FlowEngineEntity::getFullName, FlowEngineEntity::getFormType,
                FlowEngineEntity::getType, FlowEngineEntity::getIcon,
                FlowEngineEntity::getCategory, FlowEngineEntity::getIconBackground,
                FlowEngineEntity::getCreatorTime, FlowEngineEntity::getCreatorUserId,
                FlowEngineEntity::getSortCode, FlowEngineEntity::getEnabledMark

//                FlowEngineEntity::getVisibleType
        );
        return this.list(queryWrapper);
    }

    @Override
    public List<FlowEngineEntity> getList() {
        QueryWrapper<FlowEngineEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().orderByAsc(FlowEngineEntity::getSortCode).orderByDesc(FlowEngineEntity::getCreatorTime);
        return this.list(queryWrapper);
    }

    @Override
    public List<FlowEngineEntity> getListAll(FlowPagination pagination, boolean isPage) {
        // 定义变量判断是否需要使用修改时间倒序
        boolean flag = false;
        UserInfo userInfo = userProvider.get();
        List<String> id = flowEngineVisibleService.getVisibleFlowList(userInfo.getUserId()).stream().map(FlowEngineVisibleEntity::getFlowId).collect(Collectors.toList());
        QueryWrapper<FlowEngineVisibleEntity> wrapper = new QueryWrapper<>();
        wrapper.lambda().eq(FlowEngineVisibleEntity::getOperatorId, userInfo.getOrganizeId());
        List<FlowEngineVisibleEntity> companyList = flowEngineVisibleService.list(wrapper);

        QueryWrapper<FlowEngineEntity> queryWrapper = new QueryWrapper<>();

        if (CollectionUtil.isNotEmpty(id)) {
            //获取可见范围为1的引擎id
            queryWrapper.lambda().eq(FlowEngineEntity::getEnabledMark, 1)
                    .and(w -> w.in(!id.isEmpty(), FlowEngineEntity::getId, id));
        }

        if (CollectionUtil.isEmpty(companyList)) {
            return new ArrayList<>();
        }

        if (StringUtils.isNotEmpty(pagination.getKeyword())) {
            flag = true;
            queryWrapper.lambda().like(FlowEngineEntity::getFullName, pagination.getKeyword());


        }
        if (StringUtils.isNotEmpty(pagination.getCategory())) {
            flag = true;
            queryWrapper.lambda().eq(FlowEngineEntity::getCategory, pagination.getCategory());
        }
        queryWrapper.lambda().orderByAsc(FlowEngineEntity::getSortCode).orderByDesc(FlowEngineEntity::getCreatorTime);
        if (flag) {
            queryWrapper.lambda().orderByDesc(FlowEngineEntity::getLastModifyTime);
        }
        queryWrapper.lambda().select(
                FlowEngineEntity::getId, FlowEngineEntity::getEnCode,
                FlowEngineEntity::getFullName, FlowEngineEntity::getFormType,
                FlowEngineEntity::getType, FlowEngineEntity::getIcon,
                FlowEngineEntity::getCategory, FlowEngineEntity::getIconBackground,
                FlowEngineEntity::getCreatorTime, FlowEngineEntity::getCreatorUserId,
                FlowEngineEntity::getSortCode, FlowEngineEntity::getEnabledMark
        );

        if (isPage) {
            Page<FlowEngineEntity> page = new Page<>(pagination.getCurrentPage(), pagination.getPageSize());
            IPage<FlowEngineEntity> userPage = this.page(page, queryWrapper);
            return pagination.setData(userPage.getRecords(), page.getTotal());
        } else {
            return this.list(queryWrapper);
        }
    }

    @Override
    public List<FlowEngineEntity> getFlowFormList() {
        List<FlowEngineEntity> data = getListAll(new FlowPagination(), false);
        return data;
    }

    @Override
    public List<FlowEngineEntity> getFlowFormTypeList() {
        List<Integer> visibleType = new ArrayList<>();
        visibleType.add(0);
        QueryWrapper<FlowEngineEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(FlowEngineEntity::getEnabledMark, 1);
//        queryWrapper.lambda().in(FlowEngineEntity::getVisibleType, visibleType);
        queryWrapper.lambda().eq(FlowEngineEntity::getType, 0);
        queryWrapper.lambda().select(FlowEngineEntity::getId);
        return this.list(queryWrapper);
    }

    @Override
    public List<FlowEngineEntity> getFlowList(List<String> id) {
        List<FlowEngineEntity> list = new ArrayList<>();
        if (id.size() > 0) {
            QueryWrapper<FlowEngineEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.lambda().in(FlowEngineEntity::getId, id).orderByDesc(FlowEngineEntity::getCreatorTime);
            list = this.list(queryWrapper);
        }
        return list;
    }

    @Override
    public FlowEngineEntity getInfo(String id) throws WorkFlowException {
        QueryWrapper<FlowEngineEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(FlowEngineEntity::getId, id);
        FlowEngineEntity flowEngineEntity = this.getOne(queryWrapper);
        if (flowEngineEntity == null) {
            throw new WorkFlowException(MsgCode.WF113.get());
        }
        return flowEngineEntity;
    }

    @Override
    public FlowEngineEntity getInfoByEnCode(String enCode) throws WorkFlowException {
        QueryWrapper<FlowEngineEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(FlowEngineEntity::getEnCode, enCode).eq(FlowEngineEntity::getEnabledMark, 1);
        FlowEngineEntity flowEngineEntity = this.getOne(queryWrapper);
        if (flowEngineEntity == null) {
            throw new WorkFlowException(MsgCode.WF113.get());
        }
        return flowEngineEntity;
    }

    @Override
    public boolean isExistByFullName(String fullName, String id) {
        QueryWrapper<FlowEngineEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(FlowEngineEntity::getFullName, fullName);
        queryWrapper.lambda().eq(FlowEngineEntity::getType, 0);
        if (!com.alibaba.druid.util.StringUtils.isEmpty(id)) {
            queryWrapper.lambda().ne(FlowEngineEntity::getId, id);
        }
        return this.count(queryWrapper) > 0 ? true : false;
    }

    @Override
    public boolean isExistByEnCode(String enCode, String id) {
        QueryWrapper<FlowEngineEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(FlowEngineEntity::getEnCode, enCode);
        if (!com.alibaba.druid.util.StringUtils.isEmpty(id)) {
            queryWrapper.lambda().ne(FlowEngineEntity::getId, id);
        }
        return this.count(queryWrapper) > 0 ? true : false;
    }

    @Override
    public void delete(FlowEngineEntity entity) throws WorkFlowException {
        List<FlowTaskEntity> taskNodeList = flowTaskService.getTaskList(entity.getId(), FlowTaskEntity::getId);
        if (taskNodeList.size() > 0) {
            throw new WorkFlowException("引擎在使用，不可删除");
        }
        this.removeById(entity.getId());
        QueryWrapper<FlowEngineVisibleEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(FlowEngineVisibleEntity::getFlowId, entity.getId());
        flowEngineVisibleService.remove(queryWrapper);

        QueryWrapper<FlowEngineTemplateEntity> wrapper = new QueryWrapper<>();
        wrapper.lambda().eq(FlowEngineTemplateEntity::getFlowId, entity.getId());
        flowEngineTemplateService.remove(wrapper);
        Object service = SpringContext.getBean("appDataServiceImpl");
        Class[] types = new Class[]{String.class};
        Object[] datas = new Object[]{entity.getId()};
        ReflectionUtil.invokeMethod(service, "delete", types, datas);
    }

    @Override
    @DSTransactional
    public void create(FlowEngineEntity entity) throws WorkFlowException {
        List<FlowEngineVisibleEntity> visibleList = visibleList(entity);
        List<FlowEngineTemplateEntity> listByFlowId = flowEngineTemplateService.getListByFlowId(entity.getId());
        listByFlowId.stream().forEach(template -> {
            template.setVisibleType(visibleList.size() == 0 ? 0 : 1);
        });
        flowEngineTemplateService.updateBatchById(listByFlowId);
        listByFlowId.stream().forEach(template -> {
            if (template.getFlowTemplateJson() != null) {
                for (int i = 0; i < visibleList.size(); i++) {
                    //通过可见列表的模板id去做匹配
                    if (visibleList.get(i).getTemplateId().equals(template.getId())) {
                        visibleList.get(i).setId(RandomUtil.uuId());
                        visibleList.get(i).setFlowId(entity.getId());
                        visibleList.get(i).setSortCode(RandomUtil.parses());
                        flowEngineVisibleService.save(visibleList.get(i));
                    }

                }
            }
        });

        entity.setVersion(StringUtils.isEmpty(entity.getVersion()) ? "1" : entity.getVersion());
        this.table(entity, false);
        entity.setCreatorUserId(userProvider.get().getUserId());
        this.save(entity);


    }

    @Override
    @DSTransactional
    public void copy(FlowEngineEntity entity) throws WorkFlowException {
        try {
            entity.setVersion("1");
            this.create(entity);
        } catch (WorkFlowException e) {
            log.error(e.getMessage());
            throw new WorkFlowException(MsgCode.WF103.get());
        }
    }


    @Override
    @DSTransactional
    public boolean updateVisible(String id, FlowEngineEntity entity) throws WorkFlowException {
        List<FlowEngineVisibleEntity> visibleList = visibleList(entity);
        List<FlowEngineTemplateEntity> listByFlowId = flowEngineTemplateService.getListByFlowId(entity.getId());
        entity.setLastModifyTime(new Date());
        entity.setLastModifyUserId(userProvider.get().getUserId());
        String num = "1";
        FlowEngineEntity info = getInfo(id);
        BigDecimal b1 = new BigDecimal(StringUtils.isEmpty(info.getVersion()) ? "0" : info.getVersion());
        BigDecimal b2 = new BigDecimal(num);
        entity.setVersion(String.valueOf(b1.add(b2)));
        this.table(entity, true);
        boolean flag = this.updateById(entity);
        if (flag == true) {
            QueryWrapper<FlowEngineVisibleEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.lambda().eq(FlowEngineVisibleEntity::getFlowId, entity.getId());
            flowEngineVisibleService.remove(queryWrapper);
            listByFlowId.stream().forEach(template -> {
                template.setVisibleType(visibleList.size() == 0 ? 0 : 1);
                if (template.getFlowTemplateJson() != null) {
                    for (int i = 0; i < visibleList.size(); i++) {
                        if (template.getId().equals(visibleList.get(i).getTemplateId())) {
                            visibleList.get(i).setId(RandomUtil.uuId());
                            visibleList.get(i).setFlowId(entity.getId());
                            visibleList.get(i).setSortCode(Long.parseLong(i + ""));
                            visibleList.get(i).setCompanyId(template.getCompanyId());
                            flowEngineVisibleService.save(visibleList.get(i));
                        }
                    }
                }
            });
            flowEngineTemplateService.updateBatchById(listByFlowId);
        }
        return flag;
    }

    @Override
    @DSTransactional
    public void update(String id, FlowEngineEntity entity) throws WorkFlowException {
        String num = "1";
        FlowEngineEntity info = getInfo(id);
        BigDecimal b1 = new BigDecimal(StringUtils.isEmpty(info.getVersion()) ? "0" : info.getVersion());
        BigDecimal b2 = new BigDecimal(num);
        entity.setVersion(String.valueOf(b1.add(b2)));
        entity.setId(id);
        entity.setLastModifyTime(new Date());
        entity.setLastModifyUserId(userProvider.get().getUserId());
        this.table(entity, true);
        this.updateById(entity);
    }

    @Override
    public boolean first(String id) {
        boolean isOk = false;
        //获取要上移的那条数据的信息
        FlowEngineEntity upEntity = this.getById(id);
        Long upSortCode = upEntity.getSortCode() == null ? 0 : upEntity.getSortCode();
        //查询上几条记录
        QueryWrapper<FlowEngineEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda()
                .lt(FlowEngineEntity::getSortCode, upSortCode)
                .eq(FlowEngineEntity::getCategory, upEntity.getCategory())
                .orderByDesc(FlowEngineEntity::getSortCode);
        List<FlowEngineEntity> downEntity = this.list(queryWrapper);
        if (downEntity.size() > 0) {
            //交换两条记录的sort值
            Long temp = upEntity.getSortCode();
            upEntity.setSortCode(downEntity.get(0).getSortCode());
            downEntity.get(0).setSortCode(temp);
            updateById(downEntity.get(0));
            updateById(upEntity);
            isOk = true;
        }
        return isOk;
    }

    @Override
    public boolean next(String id) {
        boolean isOk = false;
        //获取要下移的那条数据的信息
        FlowEngineEntity downEntity = this.getById(id);
        Long upSortCode = downEntity.getSortCode() == null ? 0 : downEntity.getSortCode();
        //查询下几条记录
        QueryWrapper<FlowEngineEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda()
                .gt(FlowEngineEntity::getSortCode, upSortCode)
                .eq(FlowEngineEntity::getCategory, downEntity.getCategory())
                .orderByAsc(FlowEngineEntity::getSortCode);
        List<FlowEngineEntity> upEntity = this.list(queryWrapper);
        if (upEntity.size() > 0) {
            //交换两条记录的sort值
            Long temp = downEntity.getSortCode();
            downEntity.setSortCode(upEntity.get(0).getSortCode());
            upEntity.get(0).setSortCode(temp);
            updateById(upEntity.get(0));
            updateById(downEntity);
            isOk = true;
        }
        return isOk;
    }

    @Override
    public List<FlowEngineListVO> getTreeList(PaginationFlowEngine pagination, boolean isList) {
        List<FlowEngineEntity> data = isList ? getList(pagination) : getFlowFormList();
        List<DictionaryDataEntity> dictionList = serviceUtil.getDiList();
        Map<String, List<FlowEngineEntity>> dataList = data.stream().collect(Collectors.groupingBy(FlowEngineEntity::getCategory));
        List<FlowEngineListVO> listVOS = new LinkedList<>();
        for (DictionaryDataEntity entity : dictionList) {
            FlowEngineListVO model = new FlowEngineListVO();
            model.setFullName(entity.getFullName());
            model.setId(entity.getId());
            List<FlowEngineEntity> childList = dataList.get(entity.getEnCode()) != null ? dataList.get(entity.getEnCode()) : new ArrayList<>();
            model.setNum(childList.size());
            if (childList.size() > 0) {
                model.setChildren(JsonUtil.getJsonToList(childList, FlowEngineListVO.class));
            }
            listVOS.add(model);
        }
        return listVOS;
    }


    private List<FlowEngineVisibleEntity> visibleList(FlowEngineEntity entity) {
        List<FlowEngineVisibleEntity> visibleList = new ArrayList<>();
        List<FlowEngineTemplateEntity> listByFlowId = flowEngineTemplateService.getListByFlowId(entity.getId());
        listByFlowId.stream().forEach(template -> {
            if (template.getFlowTemplateJson() != null) {
                ChildNode childNode = JsonUtil.getJsonToBean(template.getFlowTemplateJson(), ChildNode.class);
                Properties properties = childNode.getProperties();
                //可见的用户
                for (String user : properties.getInitiator()) {
                    FlowEngineVisibleEntity visible = new FlowEngineVisibleEntity();
                    visible.setTemplateId(template.getId());
                    visible.setOperatorId(user);
                    visible.setOperatorType("user");
                    visible.setCompanyId(template.getCompanyId());
                    visibleList.add(visible);
                }
                //可见的部门
                for (String position : properties.getInitiatePos()) {
                    FlowEngineVisibleEntity visible = new FlowEngineVisibleEntity();
                    visible.setTemplateId(template.getId());
                    visible.setOperatorId(position);
                    visible.setOperatorType("position");
                    visible.setCompanyId(template.getCompanyId());
                    visibleList.add(visible);
                }
                //可见的角色
                List<String> roleList = properties.getInitiateRole() != null ? properties.getInitiateRole() : new ArrayList<>();
                for (String role : roleList) {
                    FlowEngineVisibleEntity visible = new FlowEngineVisibleEntity();
                    visible.setTemplateId(template.getId());
                    visible.setOperatorId(role);
                    visible.setOperatorType("role");
                    visible.setCompanyId(template.getCompanyId());
                    visibleList.add(visible);
                }
                //可见的公司
//                String companyId = userInfo.getOrganizeId();
                FlowEngineVisibleEntity visible = new FlowEngineVisibleEntity();
                visible.setTemplateId(template.getId());
                visible.setOperatorId(template.getCompanyId());
                visible.setOperatorType("company");
                visible.setCompanyId(template.getCompanyId());
                visibleList.add(visible);

            }
        });
        return visibleList;
    }

    //用于流程导入时，此时模板还为存表，需在可见表存入相对应模板的id
    private List<FlowEngineVisibleEntity> importVisibleList(List<FlowEngineTemplateEntity> templateList) {
        List<FlowEngineVisibleEntity> visibleList = new ArrayList<>();
        templateList.stream().forEach(template -> {
            if (template.getFlowTemplateJson() != null) {
                ChildNode childNode = JsonUtil.getJsonToBean(template.getFlowTemplateJson(), ChildNode.class);
                Properties properties = childNode.getProperties();
                //可见的用户
                for (String user : properties.getInitiator()) {
                    FlowEngineVisibleEntity visible = new FlowEngineVisibleEntity();
                    visible.setTemplateId(template.getId());
                    visible.setOperatorId(user);
                    visible.setOperatorType("user");
                    visible.setCompanyId(template.getCompanyId());
                    visibleList.add(visible);
                }
                //可见的部门
                for (String position : properties.getInitiatePos()) {
                    FlowEngineVisibleEntity visible = new FlowEngineVisibleEntity();
                    visible.setTemplateId(template.getId());
                    visible.setOperatorId(position);
                    visible.setOperatorType("position");
                    visible.setCompanyId(template.getCompanyId());
                    visibleList.add(visible);
                }
                //可见的角色
                List<String> roleList = properties.getInitiateRole() != null ? properties.getInitiateRole() : new ArrayList<>();
                for (String role : roleList) {
                    FlowEngineVisibleEntity visible = new FlowEngineVisibleEntity();
                    visible.setTemplateId(template.getId());
                    visible.setOperatorId(role);
                    visible.setOperatorType("role");
                    visible.setCompanyId(template.getCompanyId());
                    visibleList.add(visible);
                }
                //可见的公司
                if (!template.getCompanyId().equals("2")){
                    FlowEngineVisibleEntity visible = new FlowEngineVisibleEntity();
                    visible.setTemplateId(template.getId());
                    visible.setOperatorId(template.getCompanyId());
                    visible.setOperatorType("company");
                    visible.setCompanyId(template.getCompanyId());
                    visibleList.add(visible);
                }
            }
        });
        return visibleList;
    }

    @Override
    public FlowExportModel exportData(String id) throws WorkFlowException {
        FlowEngineEntity entity = getInfo(id);
        List<FlowEngineVisibleEntity> visibleList = flowEngineVisibleService.getVisibleFlowList(entity.getId());
        List<FlowEngineTemplateEntity> templateList = flowEngineTemplateService.getListByFlowId(entity.getId());
        FlowExportModel model = new FlowExportModel();
        model.setFlowEngine(entity);
        model.setVisibleList(visibleList);
        model.setTemplateList(templateList);
        return model;
    }

    @Override
    @DSTransactional
    public ActionResult ImportData(FlowEngineEntity entity, List<FlowEngineVisibleEntity> visibleList, List<FlowEngineTemplateEntity> templateList) throws WorkFlowException {
        List<FlowEngineVisibleEntity> companyList = importVisibleList(templateList);
        visibleList.addAll(companyList);
        if (entity != null) {
            if (isExistByFullName(entity.getFullName(), null)) {
                return ActionResult.fail("流程名称不能重复");
            }
            if (isExistByEnCode(entity.getEnCode(), null)) {
                return ActionResult.fail("流程编码不能重复");
            }
            try {
                this.save(entity);
                if (CollectionUtil.isNotEmpty(templateList)) {
                    templateList.stream().forEach(template -> {
                        template.setVisibleType(visibleList.size() == 0 ? 0 : 1);
                        template.setEnCode(entity.getEnCode());
                        if (CollectionUtil.isNotEmpty(visibleList)) {
                            for (int i = 0; i < visibleList.size(); i++) {
                                if (template.getId().equals(visibleList.get(i).getTemplateId())) {
                                    visibleList.get(i).setId(RandomUtil.uuId());
                                    visibleList.get(i).setFlowId(entity.getId());
                                    visibleList.get(i).setSortCode(RandomUtil.parses());
                                    flowEngineVisibleService.save(visibleList.get(i));
                                }
                            }
                        }
                    });
                }
            } catch (Exception e) {
                throw new WorkFlowException(MsgCode.IMP003.get());
            }
            flowEngineTemplateService.saveBatch(templateList);
            return ActionResult.success(MsgCode.IMP001.get());
        }

        return ActionResult.fail("导入数据格式不正确");
    }

    /**
     * 无表创建有表
     *
     * @param flowEngineEntity
     * @param isData
     * @throws WorkFlowException
     */
    private void table(FlowEngineEntity flowEngineEntity, boolean isData) throws WorkFlowException {
        if (flowEngineEntity.getFormType() != 1) {
            FormDataModel formData = JsonUtil.getJsonToBean(flowEngineEntity.getFormData(), FormDataModel.class);
            List<FieLdsModel> list = JsonUtil.getJsonToList(formData.getFields(), FieLdsModel.class);
            List<TableModel> tableModelList = JsonUtil.getJsonToList(flowEngineEntity.getFlowTables(), TableModel.class);
            //更新的时候查询
            if (isData && tableModelList.size() == 0) {
                FlowEngineEntity info = getInfo(flowEngineEntity.getId());
                List<TableModel> infoTable = JsonUtil.getJsonToList(info.getFlowTables(), TableModel.class);
                if (infoTable.size() == 0) {
                    throw new WorkFlowException(MsgCode.WF008.get());
                }
            }
            RecursionForm recursionForm = new RecursionForm(list, tableModelList);
            List<FormAllModel> formAllModel = new ArrayList<>();
            if (FormCloumnUtil.repetition(recursionForm, formAllModel)) {
                throw new WorkFlowException("子表重复");
            }
            if (tableModelList.size() == 0) {
                Map<String, Object> data = JsonUtil.stringToMap(flowEngineEntity.getFormData());
                JSONArray jsonArray = JsonUtil.getJsonToJsonArray(formData.getFields());
                List<TableModel> tableModels = visualDevTableCre.tableList(jsonArray, formAllModel, "wform_" + flowEngineEntity.getEnCode() + "_" + RandomUtil.enUuid(), flowEngineEntity.getDbLinkId());
                data.put("fields", jsonArray);
                flowEngineEntity.setFormData(JsonUtil.getObjectToString(data));
                flowEngineEntity.setFlowTables(JsonUtil.getObjectToString(tableModels));
            }
        }
    }


}
