package com.bringspring.workflow.engine.util;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.net.URLEncodeUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.context.SpringContext;
import com.bringspring.system.base.exception.BaseException;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.base.service.SysConfigService;
import com.bringspring.system.message.model.message.SentMessageForm;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.annotation.FlowCallBackMethod;
import com.bringspring.workflow.engine.entity.FlowEngineEntity;
import com.bringspring.workflow.engine.entity.FlowTaskCirculateEntity;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.entity.FlowTaskNodeEntity;
import com.bringspring.workflow.engine.entity.FlowTaskOperatorEntity;
import com.bringspring.workflow.engine.entity.FlowTaskOperatorRecordEntity;
import com.bringspring.workflow.engine.enums.FlowMessageEnum;
import com.bringspring.workflow.engine.enums.FlowTaskStatusEnum;
import com.bringspring.workflow.engine.model.flowengine.FlowModel;
import com.bringspring.workflow.engine.model.flowengine.shuntjson.childnode.FuncConfig;
import com.bringspring.workflow.engine.model.flowengine.shuntjson.childnode.MsgConfig;
import com.bringspring.workflow.engine.model.flowengine.shuntjson.childnode.Properties;
import com.bringspring.workflow.engine.model.flowengine.shuntjson.childnode.TemplateJsonModel;
import com.bringspring.workflow.engine.model.flowengine.shuntjson.nodejson.ChildNodeList;
import com.bringspring.workflow.engine.model.flowmessage.FlowEventModel;
import com.bringspring.workflow.engine.model.flowmessage.FlowMessageModel;
import com.bringspring.workflow.engine.model.flowmessage.FlowMsgModel;
import com.bringspring.workflow.engine.model.flowtask.FlowContModel;
import com.bringspring.workflow.engine.service.FlowDelegateService;
import com.bringspring.workflow.engine.service.FlowEngineService;
import com.bringspring.workflow.engine.service.FlowTaskService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ReflectionUtils;

import java.lang.reflect.Method;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author ：RKKJ开发平台组
 * @version: V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date ：2022/3/30 11:45
 */
@Component
@Slf4j
public class FlowMsgUtil {

    @Autowired
    private UserProvider userProvider;
    @Autowired
    private FlowTaskService flowTaskService;
    @Autowired
    private ServiceAllUtil serviceUtil;
    @Autowired
    private FlowDelegateService flowDelegateService;

    @Autowired
    private FlowEngineService flowEngineService;

    @Autowired
    private SysConfigService sysConfigService;

    @Autowired
    private BaseDataUtil baseDataUtil;
    /**
     * 发送消息
     *
     * @param flowMsgModel
     */
    public void message(FlowMsgModel flowMsgModel) {
        Map<String, Object> data = flowMsgModel.getData();
        List<SentMessageForm> messageListAll = new ArrayList<>();
        FlowTaskEntity taskEntity = flowMsgModel.getTaskEntity();
        List<String> creatorUserId = new ArrayList<>();
        if (taskEntity != null) {
            creatorUserId.add(taskEntity.getCreatorUserId());
        }
        FlowTaskNodeEntity taskNodeEntity = flowMsgModel.getTaskNodeEntity();
        FlowEngineEntity engine = flowMsgModel.getEngine();
        List<FlowTaskNodeEntity> nodeList = flowMsgModel.getNodeList();
        List<FlowTaskOperatorEntity> operatorList = flowMsgModel.getOperatorList();
        List<FlowTaskCirculateEntity> circulateList = flowMsgModel.getCirculateList();
        FlowTaskNodeEntity startNode = nodeList.stream().filter(t -> FlowNature.NodeStart.equals(t.getNodeType())).findFirst().orElse(null);
        FlowTaskNodeEntity thisStepNode = nodeList.stream().filter(t -> taskEntity.getThisStepId().equals(t.getNodeCode())).findFirst().orElse(null);
        FlowTaskOperatorRecordEntity recordEntity = new FlowTaskOperatorRecordEntity();
        recordEntity.setTaskId(startNode != null ? startNode.getTaskId() : "");
        HashMap map = MapUtil.newHashMap();
        map.put("id", taskEntity.getProcessId());
        map.put("processID", taskEntity.getProcessId());
        map.put("taskId", taskEntity.getId());
        map.put("enCode", taskEntity.getFlowCode());
        map.put("flowId", taskEntity.getFlowId());
        map.put("formType", engine.getFormType());
        map.put("opType", 1);
        map.put("status", taskEntity.getStatus());
        if (ObjectUtil.isNull(thisStepNode)) {
            map.put("taskNodeId", taskEntity.getThisStepId());
        }
        if (ObjectUtil.isNotNull(thisStepNode)) {
            map.put("taskNodeId", thisStepNode.getId());
        }

        map.put("fullName", taskEntity.getFullName());
        map.put("isSub", true);

        //等待
        if (flowMsgModel.isWait()&&!flowMsgModel.getRejectAuditType().equals("1")) {
            ChildNodeList childNode = JsonUtil.getJsonToBean(startNode.getNodePropertyJson(), ChildNodeList.class);
            Properties properties = childNode.getProperties();
            MsgConfig taskMsgConfig = properties.getWaitMsgConfig();
            Map<String, List<FlowTaskOperatorEntity>> operatorMap = operatorList.stream().collect(Collectors.groupingBy(FlowTaskOperatorEntity::getTaskNodeId));
            for (String key : operatorMap.keySet()) {
                recordEntity.setTaskNodeId(key);
                List<SentMessageForm> messageList = new ArrayList<>();
                List<FlowTaskOperatorEntity> taskOperatorList = operatorMap.get(key);
                FlowMessageModel messageModel = new FlowMessageModel();
                messageModel.setData(data);
                messageModel.setTitle("待您审批");
                messageModel.setPcUrl("/#/workFlow/flowTodo?processId="+taskEntity.getProcessId()+ "&flowId=" + taskEntity.getFlowId());
                messageModel.setAppUrl("/#/pages/workFlow/flowCenter/index?type=1&processId=" + taskEntity.getProcessId() + "&flowId=" + taskEntity.getFlowId());
                messageModel.setMsgConfig(taskMsgConfig);
                messageModel.setRecordEntity(recordEntity);
                messageModel.setCreatorUser(taskEntity.getCreatorUserId());
                messageModel.setStatus(taskEntity.getStatus());
                messageModel.setFullName(taskEntity.getFullName());
                messageModel.setPageParameters(map);
                messageModel.setTaskEntity(taskEntity);
                this.messageModel(taskOperatorList, engine, messageModel);
                this.setMessageList(messageList, messageModel);
                messageListAll.addAll(messageList);
                for (FlowTaskOperatorEntity operator : taskOperatorList) {
                    List<SentMessageForm> delegationMsg = this.delegationMsg(operator, messageModel, engine);
                    messageListAll.addAll(delegationMsg);
                }
            }
        }else {
            ChildNodeList childNode = JsonUtil.getJsonToBean(startNode.getNodePropertyJson(), ChildNodeList.class);
            Properties properties = childNode.getProperties();
            MsgConfig taskMsgConfig = properties.getWaitMsgConfig();
            Map<String, List<FlowTaskOperatorEntity>> operatorMap = operatorList.stream().filter(operator->operator.getNodeCode().equals(flowMsgModel.getRejectCode())).collect(Collectors.groupingBy(FlowTaskOperatorEntity::getTaskNodeId));
            for (String key : operatorMap.keySet()) {
                recordEntity.setTaskNodeId(key);
                List<SentMessageForm> messageList = new ArrayList<>();
                List<FlowTaskOperatorEntity> taskOperatorList = operatorMap.get(key);

                FlowMessageModel messageModel = new FlowMessageModel();
                messageModel.setData(data);
                messageModel.setTitle("待您审批");
                messageModel.setPcUrl("/#/workFlow/flowTodo?processId="+taskEntity.getProcessId()+ "&flowId=" + taskEntity.getFlowId());
                messageModel.setAppUrl("/#/pages/workFlow/flowCenter/index?type=1&processId=" + taskEntity.getProcessId() + "&flowId=" + taskEntity.getFlowId());
                messageModel.setMsgConfig(taskMsgConfig);
                messageModel.setRecordEntity(recordEntity);
                messageModel.setCreatorUser(taskEntity.getCreatorUserId());
                messageModel.setStatus(taskEntity.getStatus());
                messageModel.setFullName(taskEntity.getFullName());
                messageModel.setPageParameters(map);
                messageModel.setTaskEntity(taskEntity);
                this.messageModel(taskOperatorList, engine, messageModel);
                this.setMessageList(messageList, messageModel);
                messageListAll.addAll(messageList);
                for (FlowTaskOperatorEntity operator : taskOperatorList) {
                    List<SentMessageForm> delegationMsg = this.delegationMsg(operator, messageModel, engine);
                    messageListAll.addAll(delegationMsg);
                }
            }
        }

        //结束
        if (flowMsgModel.isEnd()) {
            //发起人
            ChildNodeList childNode = JsonUtil.getJsonToBean(startNode.getNodePropertyJson(), ChildNodeList.class);
            Properties properties = childNode.getProperties();
            MsgConfig msgConfig = properties.getEndMsgConfig();
            List<SentMessageForm> messageList = new ArrayList<>();
            FlowMessageModel messageModel = new FlowMessageModel();
            messageModel.setData(data);
            messageModel.setTitle("已【结束】");
            messageModel.setPcUrl("/#/workFlow/flowLaunch?processId="+taskEntity.getProcessId()+ "&flowId=" + taskEntity.getFlowId());
            messageModel.setAppUrl("/#/pages/workFlow/flowCenter/index?type=0&processId=" + taskEntity.getProcessId() + "&flowId=" + taskEntity.getFlowId());
            messageModel.setMsgConfig(msgConfig);
            messageModel.setType(FlowMessageEnum.me.getCode());
            messageModel.setRecordEntity(recordEntity);
            messageModel.setStatus(taskEntity.getStatus());
            messageModel.setCreatorUser(taskEntity.getCreatorUserId());
            messageModel.setFullName(taskEntity.getFullName());
            messageModel.setPageParameters(map);
            messageModel.setTaskEntity(taskEntity);
            List<FlowTaskOperatorEntity> taskOperatorList = new ArrayList() {{
                FlowTaskOperatorEntity operatorEntity = new FlowTaskOperatorEntity();
                operatorEntity.setTaskId(childNode.getTaskId());
                operatorEntity.setTaskNodeId(childNode.getTaskNodeId());
                operatorEntity.setHandleId(taskEntity.getCreatorUserId());
                add(operatorEntity);
            }};
            this.messageModel(taskOperatorList, engine, messageModel);
            this.setMessageList(messageList, messageModel);
            messageListAll.addAll(messageList);
        }
        //同意
        if (flowMsgModel.isApprove()) {
            ChildNodeList childNode = JsonUtil.getJsonToBean(startNode.getNodePropertyJson(), ChildNodeList.class);
            Properties properties = childNode.getProperties();
            MsgConfig msgConfig = properties.getApproveMsgConfig();
            Map<String, List<FlowTaskOperatorEntity>> operatorMap = operatorList.stream().collect(Collectors.groupingBy(FlowTaskOperatorEntity::getTaskNodeId));
            for (String key : operatorMap.keySet()) {
                recordEntity.setTaskNodeId(key);
                //默认获取当前节点
                FlowTaskNodeEntity taskNode = nodeList.stream().filter(t -> t.getId().equals(key)).findFirst().orElse(null);
                ChildNodeList taskChildNode = JsonUtil.getJsonToBean(taskNode.getNodePropertyJson(), ChildNodeList.class);
                Properties taskProperties = taskChildNode.getProperties();
                MsgConfig taskMsgConfig = taskProperties.getApproveMsgConfig();
                if (taskMsgConfig.getOn() == 2) {
                    taskMsgConfig = msgConfig;
                }

                List<SentMessageForm> messageList = new ArrayList<>();
                List<FlowTaskOperatorEntity> taskOperatorList = operatorMap.get(key);
                FlowMessageModel messageModel = new FlowMessageModel();
                messageModel.setData(data);
                messageModel.setTitle("已被【同意】");
                messageModel.setPcUrl("/#/workFlow/flowLaunch?processId="+taskEntity.getProcessId()+ "&flowId=" + taskEntity.getFlowId());
                messageModel.setAppUrl("/#/pages/workFlow/flowCenter/index?type=0&processId=" + taskEntity.getProcessId() + "&flowId=" + taskEntity.getFlowId());
                messageModel.setMsgConfig(taskMsgConfig);
                messageModel.setRecordEntity(recordEntity);
                messageModel.setStatus(taskEntity.getStatus());
                messageModel.setFullName(taskEntity.getFullName());
                messageModel.setCreatorUser(taskEntity.getCreatorUserId());
                messageModel.setPageParameters(map);
                messageModel.setTaskEntity(taskEntity);
                this.messageModel(taskOperatorList, engine, messageModel);
                this.setMessageList(messageList, messageModel);
                messageListAll.addAll(messageList);
                for (FlowTaskOperatorEntity operator : taskOperatorList) {
                    List<SentMessageForm> delegationMsg = this.delegationMsg(operator, messageModel, engine);
                    messageListAll.addAll(delegationMsg);
                }
            }
        }
        //拒绝
        if (flowMsgModel.isReject()) {
            ChildNodeList childNode = JsonUtil.getJsonToBean(startNode.getNodePropertyJson(), ChildNodeList.class);
            Properties properties = childNode.getProperties();
            MsgConfig msgConfig = properties.getRejectMsgConfig();
            Map<String, List<FlowTaskOperatorEntity>> operatorMap = operatorList.stream().collect(Collectors.groupingBy(FlowTaskOperatorEntity::getTaskNodeId));
            for (String key : operatorMap.keySet()) {
                recordEntity.setTaskNodeId(key);
                //默认获取当前节点
                FlowTaskNodeEntity taskNode = nodeList.stream().filter(t -> t.getId().equals(key)).findFirst().orElse(null);
                ChildNodeList taskChildNode = JsonUtil.getJsonToBean(taskNode.getNodePropertyJson(), ChildNodeList.class);
                Properties taskProperties = taskChildNode.getProperties();
                MsgConfig taskMsgConfig = taskProperties.getRejectMsgConfig();
                if (taskMsgConfig.getOn() == 2) {
                    taskMsgConfig = msgConfig;
                }
                List<SentMessageForm> messageList = new ArrayList<>();
                List<FlowTaskOperatorEntity> taskOperatorList = operatorMap.get(key);
                FlowMessageModel messageModel = new FlowMessageModel();
                messageModel.setData(data);
                messageModel.setTitle("已被【驳回】");
                messageModel.setPcUrl("/#/workFlow/flowTodo?processId="+taskEntity.getProcessId()+ "&flowId=" + taskEntity.getFlowId());
                messageModel.setAppUrl("/#/pages/workFlow/flowCenter/index?type=1&processId=" + taskEntity.getProcessId() + "&flowId=" + taskEntity.getFlowId());
                messageModel.setMsgConfig(taskMsgConfig);
                messageModel.setRecordEntity(recordEntity);
                messageModel.setStatus(taskEntity.getStatus());
                messageModel.setFullName(taskEntity.getFullName());
                messageModel.setCreatorUser(taskEntity.getCreatorUserId());
                messageModel.setPageParameters(map);
                messageModel.setTaskEntity(taskEntity);
                this.messageModel(taskOperatorList, engine, messageModel);
                this.setMessageList(messageList, messageModel);
                messageListAll.addAll(messageList);
                for (FlowTaskOperatorEntity operator : taskOperatorList) {
                    List<SentMessageForm> delegationMsg = this.delegationMsg(operator, messageModel, engine);
                    messageListAll.addAll(delegationMsg);
                }
            }
        }
        //抄送
        if (flowMsgModel.isCopy()) {
            ChildNodeList childNode = JsonUtil.getJsonToBean(startNode.getNodePropertyJson(), ChildNodeList.class);
            Properties properties = childNode.getProperties();
            MsgConfig msgConfig = properties.getCopyMsgConfig();
            Map<String, List<FlowTaskCirculateEntity>> circulateMap = circulateList.stream().collect(Collectors.groupingBy(FlowTaskCirculateEntity::getTaskNodeId));
            for (String key : circulateMap.keySet()) {
                recordEntity.setTaskNodeId(key);
                //默认获取当前节点
                FlowTaskNodeEntity taskNode = nodeList.stream().filter(t -> t.getId().equals(key)).findFirst().orElse(null);
                ChildNodeList taskChildNode = JsonUtil.getJsonToBean(taskNode.getNodePropertyJson(), ChildNodeList.class);
                Properties taskProperties = taskChildNode.getProperties();
                MsgConfig taskMsgConfig = taskProperties.getCopyMsgConfig();
                if (taskMsgConfig.getOn() == 2) {
                    taskMsgConfig = msgConfig;
                }
                List<SentMessageForm> messageList = new ArrayList<>();
                List<FlowTaskOperatorEntity> taskOperatorList = new ArrayList<>();
                for (FlowTaskCirculateEntity circulateEntity : circulateMap.get(key)) {
                    FlowTaskOperatorEntity operatorEntity = JsonUtil.getJsonToBean(circulateEntity, FlowTaskOperatorEntity.class);
                    operatorEntity.setHandleId(circulateEntity.getObjectId());
                    taskOperatorList.add(operatorEntity);
                }
                FlowMessageModel messageModel = new FlowMessageModel();
                messageModel.setData(data);
                messageModel.setTitle("已被【抄送】");
                messageModel.setPcUrl("/#/workFlow/flowCirculate?processId="+taskEntity.getProcessId()+ "&flowId=" + taskEntity.getFlowId());
                messageModel.setAppUrl("/#/pages/workFlow/flowCenter/index?type=3&processId=" + taskEntity.getProcessId() + "&flowId=" + taskEntity.getFlowId());
                messageModel.setMsgConfig(taskMsgConfig);
                messageModel.setRecordEntity(recordEntity);
                messageModel.setStatus(taskEntity.getStatus());
                messageModel.setType(FlowMessageEnum.circulate.getCode());
                messageModel.setCreatorUser(taskEntity.getCreatorUserId());
                messageModel.setFullName(taskEntity.getFullName());
                messageModel.setPageParameters(map);
                messageModel.setTaskEntity(taskEntity);
                this.messageModel(taskOperatorList, engine, messageModel);
                this.setMessageList(messageList, messageModel);
                messageListAll.addAll(messageList);
                for (FlowTaskOperatorEntity operator : taskOperatorList) {
                    List<SentMessageForm> delegationMsg = this.delegationMsg(operator, messageModel, engine);
                    messageListAll.addAll(delegationMsg);
                }
            }
        }
        //子流程
        if (flowMsgModel.isLaunch()) {
            ChildNodeList childNode = JsonUtil.getJsonToBean(startNode.getNodePropertyJson(), ChildNodeList.class);
            Properties properties = childNode.getProperties();
            MsgConfig msgConfig = properties.getLaunchMsgConfig();
            Map<String, List<FlowTaskOperatorEntity>> operatorMap = operatorList.stream().collect(Collectors.groupingBy(FlowTaskOperatorEntity::getTaskNodeId));
            for (String key : operatorMap.keySet()) {
                recordEntity.setTaskNodeId(key);
                //默认获取当前节点
                FlowTaskNodeEntity taskNode = nodeList.stream().filter(t -> t.getId().equals(key)).findFirst().orElse(null);
                ChildNodeList taskChildNode = JsonUtil.getJsonToBean(taskNode.getNodePropertyJson(), ChildNodeList.class);
                Properties taskProperties = taskChildNode.getProperties();
                MsgConfig taskMsgConfig = taskProperties.getLaunchMsgConfig();
                if (taskMsgConfig.getOn() == 2) {
                    taskMsgConfig = msgConfig;
                }
                List<SentMessageForm> messageList = new ArrayList<>();
                List<FlowTaskOperatorEntity> taskOperatorList = operatorMap.get(key);
                FlowMessageModel messageModel = new FlowMessageModel();
                messageModel.setData(data);
                messageModel.setTitle("请发起【子流程】");
                messageModel.setMsgConfig(taskMsgConfig);
                messageModel.setRecordEntity(recordEntity);
                messageModel.setType(FlowMessageEnum.me.getCode());
                messageModel.setStatus(FlowTaskStatusEnum.Draft.getCode());
                messageModel.setFullName(taskEntity.getFullName());
                messageModel.setCreatorUser(taskEntity.getCreatorUserId());
                messageModel.setPageParameters(map);
                messageModel.setTaskEntity(taskEntity);
                this.messageModel(taskOperatorList, engine, messageModel);
                this.setMessageList(messageList, messageModel);
                messageListAll.addAll(messageList);
            }
        }
        //发起人
        if (flowMsgModel.isStart()) {
            ChildNodeList taskChildNode = JsonUtil.getJsonToBean(taskNodeEntity.getNodePropertyJson(), ChildNodeList.class);
            Properties taskProperties = taskChildNode.getProperties();
            MsgConfig msgConfig = taskProperties.getRejectMsgConfig();
            if (msgConfig.getOn() == 2) {
                ChildNodeList childNode = JsonUtil.getJsonToBean(startNode.getNodePropertyJson(), ChildNodeList.class);
                Properties properties = childNode.getProperties();
                msgConfig = properties.getRejectMsgConfig();
            }
            List<SentMessageForm> messageList = new ArrayList<>();
            FlowMessageModel meModel = new FlowMessageModel();
            meModel.setData(data);
            meModel.setTitle("已被【驳回】");
            meModel.setPcUrl("/#/workFlow/flowLaunch?processId="+taskEntity.getProcessId()+ "&flowId=" + taskEntity.getFlowId());
            meModel.setAppUrl("/#/pages/workFlow/flowCenter/index?type=0&processId=" + taskEntity.getProcessId() + "&flowId=" + taskEntity.getFlowId());
            meModel.setRecordEntity(recordEntity);
            meModel.setStatus(taskEntity.getStatus());
            meModel.setMsgConfig(msgConfig);
            meModel.setType(FlowMessageEnum.me.getCode());
            meModel.setFullName(taskEntity.getFullName());
            meModel.setCreatorUser(taskEntity.getCreatorUserId());
            meModel.setTaskEntity(taskEntity);
            List<FlowTaskOperatorEntity> meOperatorList = new ArrayList() {{
                FlowTaskOperatorEntity operatorEntity = new FlowTaskOperatorEntity();
                operatorEntity.setTaskId(taskNodeEntity.getTaskId());
                operatorEntity.setHandleId(taskEntity.getCreatorUserId());
                add(operatorEntity);
            }};
            meModel.setPageParameters(map);
            this.messageModel(meOperatorList, engine, meModel);

            this.setMessageList(messageList, meModel);
            messageListAll.addAll(messageList);
        }
        serviceUtil.sendFlowMessage(messageListAll);
    }

    /**
     * 封装站内信消息
     *
     * @param taskOperatorList
     * @param engine
     * @param messageModel
     */
    private void messageModel(List<FlowTaskOperatorEntity> taskOperatorList, FlowEngineEntity engine, FlowMessageModel messageModel) {
        List<String> userList = new ArrayList<>();
        Map<String, String> contMsg = new HashMap<>();
        for (FlowTaskOperatorEntity taskOperator : taskOperatorList) {
            FlowContModel contModel = this.flowMessage(engine, taskOperator, messageModel);
            contMsg.put(taskOperator.getHandleId(), JsonUtil.getObjectToString(contModel));
            userList.add(taskOperator.getHandleId());
            HashMap pageParameters = messageModel.getPageParameters();

            pageParameters.put("taskOperatorId", taskOperator.getId());

            messageModel.setPageParameters(pageParameters);
        }
        messageModel.setUserList(userList);
        messageModel.setContMsg(contMsg);
    }

    /**
     * 封装站内信对象
     *
     * @param engine
     * @param taskOperator
     * @return
     */
    private FlowContModel flowMessage(FlowEngineEntity engine, FlowTaskOperatorEntity taskOperator, FlowMessageModel messageModel) {
        FlowContModel contModel = new FlowContModel();
        contModel.setEnCode(engine.getEnCode());
        contModel.setFlowId(engine.getId());
        contModel.setTaskId(taskOperator.getTaskId());
        contModel.setProcessId(messageModel.getTaskEntity().getProcessId());
        contModel.setFormType(engine.getFormType());
        contModel.setFlowName(engine.getFullName());
        contModel.setFullName(messageModel.getFullName());
        contModel.setTaskNodeId(taskOperator.getTaskNodeId());
        contModel.setTaskOperatorId(taskOperator.getId());
        contModel.setType(messageModel.getType());
        contModel.setStatus(messageModel.getStatus());
        return contModel;
    }

    /**
     * 整合发送消息
     *
     * @param messageList
     * @param flowMessageModel
     */
    private void setMessageList(List<SentMessageForm> messageList, FlowMessageModel flowMessageModel) {
        Map<String, Object> data = flowMessageModel.getData();
        MsgConfig msgConfig = flowMessageModel.getMsgConfig() != null ? flowMessageModel.getMsgConfig() : new MsgConfig();
        List<String> userList = flowMessageModel.getUserList();
        FlowTaskOperatorRecordEntity recordEntity = flowMessageModel.getRecordEntity();
        String templateId = msgConfig.getOn() == 0 ? "0" : msgConfig.getMsgId();
        List<TemplateJsonModel> templateJson = msgConfig.getTemplateJson() != null ? msgConfig.getTemplateJson() : new ArrayList<>();
        SentMessageForm messageModel = new SentMessageForm();
        messageModel.setTemplateId(templateId);
        messageModel.setToUserIds(userList);
        Map<String, String> parameterMap = new HashMap<>();
        for (TemplateJsonModel templateJsonModel : templateJson) {
            String fieldId = templateJsonModel.getField();
            String relationField = templateJsonModel.getRelationField();
            String dataJson = data.get(relationField) != null ? String.valueOf(data.get(relationField)) : "";
            FlowEventModel eventModel = FlowEventModel.builder().dataJson(dataJson).record(recordEntity).relationField(relationField).build();
            dataJson = this.data(eventModel);
            parameterMap.put(fieldId, dataJson);
            String parameters = URLEncodeUtil.encode(JsonUtil.getObjectToString(flowMessageModel.getPageParameters()));
            String url = null;
            try {
                url = sysConfigService.getSystemAddress("app");
            } catch (BaseException e) {
                e.printStackTrace();
            }
            // 2024/2/29 企业微信消息AppConfig文件
            parameterMap.put("AppUrl", url + "#/pages/login/index?isweixin=1&qyhCorpId=wwc0366cea7d993696&&qyhAgentId=1000034&redirect=" + URLEncodeUtil.encodePathSegment("/pages/workFlow/flowBefore/index?config=" + parameters));
        }
        messageModel.setType(2);
        messageModel.setPcUrl(flowMessageModel.getPcUrl());
        messageModel.setAppUrl(flowMessageModel.getAppUrl());
//        messageModel.setJumpType(flowMessageModel.getJumpType());
//        messageModel.setJumpType(flowMessageModel.getJumpType());
        String messageTime = DateUtil.dateFormat(new Date());
        messageModel.setMessageTime(messageTime);
        messageModel.setCreatorUser(baseDataUtil.userSelectValue(flowMessageModel.getCreatorUser()));
        messageModel.setParameterMap(parameterMap);
        messageModel.setTitle(flowMessageModel.getFullName() + flowMessageModel.getTitle());
        messageModel.setBodyText(flowMessageModel.getContMsg());
        Map<String, String> map = new HashMap<>();
        map.putAll(flowMessageModel.getContMsg());
//        map.put("id", flowMessageModel.getRecordEntity().getTaskId());
        messageModel.setBodyText(map);
        messageList.add(messageModel);
    }

    /**
     * @return
     */
    private String data(FlowEventModel eventModel) {
        FlowTaskOperatorRecordEntity record = eventModel.getRecord();
        String relationField = eventModel.getRelationField();
        String dataJson = eventModel.getDataJson();
        String userId = userProvider.get().getUserId();
        String value = dataJson;
        FlowTaskEntity taskEntity = flowTaskService.getInfoSubmit(record.getTaskId(), FlowTaskEntity::getFlowId
                , FlowTaskEntity::getFlowName, FlowTaskEntity::getFullName, FlowTaskEntity::getCreatorUserId);
        switch (relationField) {
            case "jsbosFlowId":
                value = taskEntity.getFlowId();
                break;
            case "jsbosTaskId":
                value = record.getTaskId();
                break;
            case "jsbosTaskNodeId":
                value = record.getTaskNodeId();
                break;
            case "jsbosFlowFullName":
                value = taskEntity.getFlowName();
                break;
            case "jsbosTaskFullName":
                value = taskEntity.getFullName();
                break;
            case "jsbosLaunchUserId":
                value = taskEntity.getCreatorUserId();
                break;
            case "jsbosLaunchUserName":
                UserEntity createUser = taskEntity != null ? serviceUtil.getUserInfo(taskEntity.getCreatorUserId()) : null;
                value = createUser != null ? createUser.getRealName() : "";
                break;
            case "jsbosFlowOperatorUserId":
                value = userId;
                break;
            case "jsbosFlowOperatorUserName":
                UserEntity userEntity = serviceUtil.getUserInfo(userId);
                value = userEntity != null ? userEntity.getRealName() : "";
                break;
            default:
                break;
        }
        return value;
    }


    //--------------------------------------------事件处理---------------------------------------------------------

    /**
     * 流程事件
     *
     * @param status    事件状态 1.发起 2.结束 3.发起撤回 4同意 5拒绝 6节点撤回
     * @param childNode 节点数据
     * @param record    审批数据
     */

    public void event(Integer status, ChildNodeList childNode, FlowTaskOperatorRecordEntity record, FlowModel flowModel) throws WorkFlowException {
        boolean on = false;
        String interId = "";
        String flowCallBackMethod = "";
        List<TemplateJsonModel> templateJsonModelList = new ArrayList<>();
        FuncConfig config = null;
        //属性
        if (childNode != null) {
            Properties properties = childNode.getProperties();
            switch (status) {
                case 1:
                    config = properties.getInitFuncConfig();
                    break;
                case 2:
                    config = properties.getEndFuncConfig();
                    break;
                case 3:
                    config = properties.getFlowRecallFuncConfig();
                    break;
                case 4:
                    config = properties.getApproveFuncConfig();
                    break;
                case 5:
                    config = properties.getRejectFuncConfig();
                    break;
                case 6:
                    config = properties.getRecallFuncConfig();
                    break;
                default:
                    break;
            }
        }
        if (config != null) {
            on = config.isOn();
            interId = config.getInterfaceId();
            flowCallBackMethod = config.getFlowCallBackMethod();
            templateJsonModelList = config.getTemplateJson();
        }
        if (on && StringUtils.isNotEmpty(interId)) {
            Map<String, Object> data = flowModel.getFormData();
            Map<String, String> parameterMap = new HashMap<>();
            for (TemplateJsonModel templateJsonModel : templateJsonModelList) {
                String fieldId = templateJsonModel.getField();
                String relationField = templateJsonModel.getRelationField();
                String dataJson = data.get(relationField) != null ? String.valueOf(data.get(relationField)) : "";
                FlowEventModel eventModel = FlowEventModel.builder().dataJson(dataJson).record(record).relationField(relationField).build();
                dataJson = data(eventModel);
                parameterMap.put(fieldId, "'" + dataJson + "'");
            }
            serviceUtil.infoToId(interId, parameterMap);
        }
        //开启了事件，但是没有关联接口则更新状态
        if (StringUtils.isEmpty(interId)) {
            if (on) {
                //业务功能id
                String processId = flowModel.getProcessId();
                FlowEngineEntity engine = flowEngineService.getInfo(flowModel.getFlowId());
                String serviceName = "";
                String methodName = "";
                if (StrUtil.isNotBlank(flowCallBackMethod)){
                    String[] split = flowCallBackMethod.split("\\.");
                    serviceName = split[split.length-2];
                    serviceName = StrUtil.lowerFirst(serviceName);
                    methodName = split[split.length-1];
                }else {
                    String name = engine.getEnCode();
                    serviceName = StrUtil.lowerFirst(name) + "ServiceImpl";
                    methodName = "updateEnableMarkById";
                }

                try {
                    Object bean = SpringContext.getBean(serviceName);
                    if (ObjectUtil.isNotEmpty(bean)) {
                        Class<?> clazz = bean.getClass();
                        Method method = ReflectionUtils.findMethod(clazz, methodName, processId.getClass(), status.getClass(), flowModel.getClass());
                        if (ObjectUtil.isEmpty(method)) {
                            // 如果方法不存在，记录日志并返回
                            log.error("Method updateEnableMarkById not found in bean {}", serviceName);
                            return;
                        }
                        try {
                            Object result = ReflectionUtils.invokeMethod(method, bean, processId, status, flowModel);
                        } catch (Exception e) {
                            // 处理异常
                            log.error("Error occurred while invoking method updateEnableMarkById", e);
                            e.printStackTrace();
                            throw new WorkFlowException("回调更新业务表状态报错!");
                        }
                    }
                } catch (NoSuchBeanDefinitionException e) {
                    // 处理Bean未找到的异常
                    e.printStackTrace();
                    log.error("Bean {} not found in the application context", serviceName);
                }
                  /* String processId = flowModel.getProcessId();
                FlowEngineEntity engine = flowEngineService.getInfo(flowModel.getFlowId());
                String name = engine.getEnCode();
                try {
                    String sericeName = StrUtil.lowerFirst(name) + "ServiceImpl";
                    Object bean = SpringContext.getBean(sericeName);
                    if (ObjectUtil.isNotEmpty(bean)){
                        Class<?> clazz = bean.getClass();
                        Method method3 = ReflectionUtils.findMethod(clazz, "updateEnableMarkById", processId.getClass(), status.getClass(), flowModel.getClass());
                        if (ObjectUtil.isEmpty(method3)) {
                            return;
                        }
                        Object result3 = ReflectionUtils.invokeMethod(method3, bean, processId, status, flowModel);
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                    throw new WorkFlowException("回调更新业务表状态报错!");
                }*/
            }
        }
    }


    /**
     * 封装委托消息
     *
     * @param operator
     * @param messageModel
     * @param engine
     * @return
     */
    private List<SentMessageForm> delegationMsg(FlowTaskOperatorEntity operator, FlowMessageModel messageModel, FlowEngineEntity engine) {
        List<SentMessageForm> messageList = new ArrayList<>();
        FlowTaskEntity taskEntity = flowTaskService.getInfoSubmit(operator.getTaskId(), FlowTaskEntity::getFlowId);
        List<String> userList = flowDelegateService.getUser(null, taskEntity.getFlowId(), operator.getHandleId()).stream().map(t -> t.getToUserid()).collect(Collectors.toList());
        List<FlowTaskOperatorEntity> taskOperatorList = new ArrayList<>();
        for (String user : userList) {
            FlowTaskOperatorEntity delegaOperator = JsonUtil.getJsonToBean(operator, FlowTaskOperatorEntity.class);
            delegaOperator.setHandleId(user);
            taskOperatorList.add(delegaOperator);
        }
        this.messageModel(taskOperatorList, engine, messageModel);
        this.setMessageList(messageList, messageModel);
        return messageList;
    }

}
