package com.bringspring.workflow.form.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 销售订单明细
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月29日 上午9:18
 */
@Data
@TableName("wform_salesorderentry")
public class SalesOrderEntryEntity {
    /**
     * 发货明细主键
     */
    @TableId("ID")
    private String id;

    /**
     * 订单主键
     */
    @TableField("SALESORDERID")
    private String salesOrderId;

    /**
     * 商品名称
     */
    @TableField("GOODSNAME")
    private String goodsName;

    /**
     * 规格型号
     */
    @TableField("SPECIFICATIONS")
    private String specifications;

    /**
     * 单位
     */
    @TableField("UNIT")
    private String unit;

    /**
     * 数量
     */
    @TableField("QTY")
    private BigDecimal qty;

    /**
     * 单价
     */
    @TableField("PRICE")
    private BigDecimal price;

    /**
     * 金额
     */
    @TableField("AMOUNT")
    private BigDecimal amount;

    /**
     * 描述
     */
    @TableField("DESCRIPTION")
    private String description;


    /**
     * 排序码
     */
    @TableField("SORT_CODE")
    private Long sortCode;
}
