/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.workflow.engine.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.permission.entity.UserRelationEntity;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.workflow.engine.entity.FlowEngineVisibleEntity;
import com.bringspring.workflow.engine.mapper.FlowEngineVisibleMapper;
import com.bringspring.workflow.engine.service.FlowEngineVisibleService;
import com.bringspring.workflow.engine.util.ServiceAllUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FlowEngineVisibleServiceImpl
extends ServiceImpl<FlowEngineVisibleMapper, FlowEngineVisibleEntity>
implements FlowEngineVisibleService {
    @Autowired
    private ServiceAllUtil serviceUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private FlowEngineVisibleService flowEngineVisibleService;
    @Autowired
    private FlowEngineVisibleMapper flowEngineVisibleMapper;

    @Override
    public List<FlowEngineVisibleEntity> getList(String flowId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(FlowEngineVisibleEntity::getFlowId, (Object)flowId);
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(FlowEngineVisibleEntity::getSortCode)).orderByDesc(FlowEngineVisibleEntity::getCreatorTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<FlowEngineVisibleEntity> getVisibleFlowList(String userId) {
        ArrayList<String> userList = new ArrayList<String>();
        userList.add(userId);
        UserInfo userInfo = this.userProvider.get();
        List<UserRelationEntity> list = this.serviceUtil.getListByUserIdAll(userList);
        List userRelationList = list.stream().map(u -> u.getObjectId()).collect(Collectors.toList());
        userRelationList.add(userId);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.lambda().in(FlowEngineVisibleEntity::getOperatorId, userRelationList);
        List userIdList = this.list((Wrapper)wrapper);
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(FlowEngineVisibleEntity::getOperatorId, (Object)userInfo.getOrganizeId())).eq(FlowEngineVisibleEntity::getOperatorType, (Object)"company");
        List results = this.flowEngineVisibleMapper.selectList((Wrapper)queryWrapper);
        userIdList.addAll(results);
        return userIdList;
    }

    @Override
    public List<String> getListByFlowId(String flowId, String userId) {
        ArrayList<String> userList = new ArrayList<String>();
        ArrayList<String> templateIdList = new ArrayList<String>();
        userList.add(userId);
        UserInfo userInfo = this.userProvider.get();
        List<UserRelationEntity> list = this.serviceUtil.getListByUserIdAll(userList);
        List userRelationList = list.stream().map(u -> u.getObjectId()).collect(Collectors.toList());
        userRelationList.add(userId);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.lambda().in(FlowEngineVisibleEntity::getOperatorId, userRelationList);
        List userIdList = this.list((Wrapper)wrapper);
        List<FlowEngineVisibleEntity> visibleList = this.getVisibleList(flowId);
        List<String> templateIds = userIdList.stream().filter(user -> user.getFlowId().equals(flowId)).map(FlowEngineVisibleEntity::getTemplateId).distinct().collect(Collectors.toList());
        List companyId = visibleList.stream().filter(visible -> visible.getOperatorId().equals(userInfo.getOrganizeId())).map(FlowEngineVisibleEntity::getTemplateId).collect(Collectors.toList());
        templateIdList.addAll(templateIds);
        templateIds.addAll(companyId);
        return templateIds;
    }

    public List<FlowEngineVisibleEntity> getVisibleList(String flowId) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.lambda().eq(FlowEngineVisibleEntity::getFlowId, (Object)flowId);
        return this.list((Wrapper)wrapper);
    }

    @Override
    public List<FlowEngineVisibleEntity> getAllCompanyVisibleFlowList(String userId, String menuId) {
        UserInfo userInfo = this.userProvider.get();
        QueryWrapper queryWrapper = new QueryWrapper();
        if (!userInfo.getIsAdministrator().booleanValue()) {
            if (Objects.nonNull(menuId) && !this.userProvider.get().getIsAdministrator().booleanValue()) {
                Object companyAuth = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, menuId, "flow_engine_visible"));
                if (ObjectUtil.isEmpty((Object)companyAuth)) {
                    return new ArrayList<FlowEngineVisibleEntity>();
                }
                queryWrapper = (QueryWrapper)companyAuth;
            }
        } else {
            return new ArrayList<FlowEngineVisibleEntity>();
        }
        return this.list((Wrapper)queryWrapper);
    }
}

