/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.workflow.engine.controller;

import cn.hutool.core.util.ObjectUtil;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.entity.FlowEngineEntity;
import com.bringspring.workflow.engine.entity.FlowEngineTemplateEntity;
import com.bringspring.workflow.engine.model.flowengine.FlowPagination;
import com.bringspring.workflow.engine.model.flowenginetemplate.FlowTemplatePageListVO;
import com.bringspring.workflow.engine.service.FlowEngineService;
import com.bringspring.workflow.engine.service.FlowEngineTemplateService;
import com.bringspring.workflow.engine.service.FlowEngineTemplateVersionService;
import com.bringspring.workflow.engine.service.FlowEngineVisibleService;
import com.bringspring.workflow.engine.util.ServiceAllUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6d41\u7a0b\u6a21\u677f"}, value="FlowEngineTemplate")
@RestController
@RequestMapping(value={"/api/workflow/Engine/FlowEngineTemplate"})
public class FlowTemplateController {
    @Autowired
    private FlowEngineService flowEngineService;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private FlowEngineTemplateService flowEngineTemplateService;
    @Autowired
    private FlowEngineVisibleService flowEngineVisibleService;
    @Autowired
    private FlowEngineTemplateVersionService flowEngineTemplateVersionService;
    @Autowired
    private ServiceAllUtil serviceUtil;
    @Autowired
    private BaseDataUtil baseDataUtil;

    @ApiOperation(value="\u83b7\u53d6\u6d41\u7a0b\u6a21\u677f\u5217\u8868")
    @GetMapping
    public ActionResult list(FlowPagination pagination) {
        List<FlowEngineTemplateEntity> pageList = this.flowEngineTemplateService.getPageList(pagination);
        PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)pagination), PaginationVO.class);
        List listVO = JsonUtil.getJsonToList(pageList, FlowTemplatePageListVO.class);
        for (FlowTemplatePageListVO templatePageListVO : listVO) {
            UserEntity userInfo;
            OrganizeEntity organizeInfo;
            FlowEngineEntity engineEntity = (FlowEngineEntity)this.flowEngineService.getById((Serializable)((Object)templatePageListVO.getFlowId()));
            if (ObjectUtil.isNotEmpty((Object)engineEntity)) {
                templatePageListVO.setFormType(engineEntity.getFormType());
                templatePageListVO.setType(engineEntity.getType());
                templatePageListVO.setFlowEngineName(engineEntity.getFullName());
                templatePageListVO.setCategory(engineEntity.getCategory());
                templatePageListVO.setCategoryName(this.baseDataUtil.getDictName(templatePageListVO.getCategory(), "WorkFlowCategory"));
            }
            if (ObjectUtil.isNotEmpty((Object)(organizeInfo = this.serviceUtil.getOrganizeInfo(templatePageListVO.getCompanyId())))) {
                templatePageListVO.setCompanyName(organizeInfo.getShortName());
            }
            if (!ObjectUtil.isNotEmpty((Object)templatePageListVO.getLastModifyUserId()) || !ObjectUtil.isNotEmpty((Object)(userInfo = this.serviceUtil.getUserInfo(templatePageListVO.getLastModifyUserId())))) continue;
            templatePageListVO.setLastModifyUserName(userInfo.getRealName());
        }
        return ActionResult.page((List)listVO, (PaginationVO)paginationVO);
    }
}

