/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.workflow.engine.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.base.exception.BaseException;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.base.service.SysConfigService;
import com.bringspring.system.msgcenter.enums.TermTypeEnum;
import com.bringspring.system.msgcenter.model.BusinessKeys;
import com.bringspring.system.msgcenter.model.CustomKeysLink;
import com.bringspring.system.msgcenter.model.LinkMsgKeys;
import com.bringspring.system.msgcenter.model.TaskMsg;
import com.bringspring.system.msgcenter.util.SendTaskMsgUtils;
import com.bringspring.workflow.engine.entity.FlowCommentEntity;
import com.bringspring.workflow.engine.entity.FlowEngineEntity;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.mapper.FlowCommentMapper;
import com.bringspring.workflow.engine.model.flowcomment.FlowCommentPagination;
import com.bringspring.workflow.engine.service.FlowCommentService;
import com.bringspring.workflow.engine.service.FlowEngineService;
import com.bringspring.workflow.engine.service.FlowTaskService;
import com.bringspring.workflow.engine.util.ServiceAllUtil;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FlowCommentServiceImpl
extends ServiceImpl<FlowCommentMapper, FlowCommentEntity>
implements FlowCommentService {
    private static final Logger log = LoggerFactory.getLogger(FlowCommentServiceImpl.class);
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private SysConfigService sysConfigService;
    @Autowired
    private SendTaskMsgUtils sendTaskMsgUtils;
    @Autowired
    private FlowTaskService flowTaskService;
    @Autowired
    private ServiceAllUtil serviceAllUtil;
    @Autowired
    private FlowEngineService flowEngineService;

    @Override
    public List<FlowCommentEntity> getlist(FlowCommentPagination pagination) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(FlowCommentEntity::getTaskId, (Object)pagination.getTaskId());
        queryWrapper.lambda().orderByDesc(FlowCommentEntity::getCreatorTime);
        Page page = new Page(pagination.getCurrentPage(), pagination.getPageSize());
        IPage userIPage = this.page((IPage)page, (Wrapper)queryWrapper);
        return pagination.setData(userIPage.getRecords(), page.getTotal());
    }

    @Override
    public FlowCommentEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(FlowCommentEntity::getId, (Object)id);
        return (FlowCommentEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    @DSTransactional
    public void create(FlowCommentEntity entity) throws WorkFlowException {
        entity.setCreatorTime(new Date());
        entity.setCreatorUserId(this.userProvider.get().getUserId());
        entity.setId(RandomUtil.uuId());
        this.send(entity);
        this.save(entity);
    }

    @Override
    @DSTransactional
    public void update(String id, FlowCommentEntity entity) {
        entity.setId(id);
        this.updateById(entity);
    }

    @Override
    public void delete(FlowCommentEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    public void send(FlowCommentEntity entity) throws WorkFlowException {
        List toUserIds = CollectionUtil.list((boolean)false);
        toUserIds.addAll(entity.getRemindUserId());
        String taskCode = "\u6d41\u7a0b\u8bc4\u8bba\u6d88\u606f\u63d0\u9192";
        String sendCode = "FlowCommentTemplate";
        HashMap keys = MapUtil.newHashMap();
        FlowTaskEntity taskEntity = this.flowTaskService.getDraftTaskByProcessId(entity.getTaskId());
        FlowEngineEntity engine = this.flowEngineService.getInfo(taskEntity.getFlowId());
        keys.put("title", taskEntity.getFullName() + "\u6709\u65b0\u7684\u6d41\u7a0b\u8bc4\u8bba");
        keys.put("content", this.serviceAllUtil.getUserInfo(entity.getCreatorUserId()).getRealName() + "\u5728\u8bc4\u8bba\u4e2d\u63d0\u9192\u4e86\u4f60");
        keys.put("creatorUser", this.serviceAllUtil.getUserInfo(entity.getCreatorUserId()).getRealName());
        keys.put("MessageTime", DateUtil.getNow());
        HashMap map = MapUtil.newHashMap();
        map.put("id", taskEntity.getProcessId());
        map.put("processId", taskEntity.getProcessId());
        map.put("taskId", taskEntity.getId());
        map.put("enCode", taskEntity.getFlowCode());
        map.put("flowId", taskEntity.getFlowId());
        map.put("formType", engine.getFormType());
        map.put("opType", 3);
        map.put("fullName", taskEntity.getFullName());
        map.put("status", taskEntity.getStatus());
        map.put("type", 4);
        map.put("isSub", true);
        String localTime = System.currentTimeMillis() + "";
        String appUrl = "/#/pages/workFlow/flowCenter/index?type=4&processId=" + taskEntity.getProcessId() + "&flowId=" + taskEntity.getFlowId() + "&localTime=" + localTime;
        String pcUrl = "/#/workFlow/flowRelation?processId=" + taskEntity.getProcessId() + "&flowId=" + taskEntity.getFlowId() + "&localTime=" + localTime;
        String termType = TermTypeEnum.TERM_APP_PC.getCode();
        String typeDesc = "";
        this.sendMessageNew(taskCode, sendCode, keys, null, appUrl, pcUrl, CollectionUtil.join((Iterable)toUserIds, (CharSequence)","), termType, typeDesc, map);
    }

    public void sendMessageNew(String taskCode, String sendCode, HashMap<String, String> keys, String linkUrl, String appUrl, String pcUrl, String userId, String termType, String typeDesc, HashMap map) {
        log.info("code:{},\u63a5\u6536\u4eba:{}", (Object)sendCode, (Object)userId);
        TaskMsg taskMsg = new TaskMsg();
        taskMsg.setTaskCode(taskCode);
        taskMsg.setSendCode(sendCode);
        LinkMsgKeys linkMsgKeys = new LinkMsgKeys();
        linkMsgKeys.setKeys(keys);
        if (StrUtil.isEmpty((CharSequence)linkUrl)) {
            try {
                linkUrl = this.sysConfigService.getConfigByKeyName("sysMobileUrl").getKeyValue();
            }
            catch (BaseException e) {
                e.printStackTrace();
            }
        }
        linkMsgKeys.setLinkUrl("");
        CustomKeysLink customKeysLink = new CustomKeysLink();
        customKeysLink.setTermType(termType);
        customKeysLink.setTermTypeDesc(typeDesc);
        customKeysLink.setPcUrl(pcUrl);
        customKeysLink.setAppUrl(appUrl);
        customKeysLink.setOtherKey((Map)map);
        taskMsg.setCustomKey(customKeysLink);
        taskMsg.setBusinessKey((BusinessKeys)linkMsgKeys);
        taskMsg.setToUserIds(userId);
        try {
            this.sendTaskMsgUtils.sendTaskMsg(taskMsg);
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u6d88\u606f\u5f02\u5e38:" + e.getMessage());
            e.printStackTrace();
        }
    }
}

