/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.workflow.engine.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.database.model.DataSourceModel;
import com.bringspring.common.database.model.interfaces.DataSourceMod;
import com.bringspring.common.database.util.DbTypeUtil;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.PageUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.entity.UserRelationEntity;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.workflow.engine.entity.FlowDelegateEntity;
import com.bringspring.workflow.engine.entity.FlowEngineTemplateEntity;
import com.bringspring.workflow.engine.entity.FlowEngineVisibleEntity;
import com.bringspring.workflow.engine.entity.FlowTaskCirculateEntity;
import com.bringspring.workflow.engine.entity.FlowTaskDeleteRecordEntity;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.entity.FlowTaskNodeEntity;
import com.bringspring.workflow.engine.entity.FlowTaskOperatorEntity;
import com.bringspring.workflow.engine.entity.FlowTaskOperatorRecordEntity;
import com.bringspring.workflow.engine.enums.FlowTaskStatusEnum;
import com.bringspring.workflow.engine.mapper.FlowTaskMapper;
import com.bringspring.workflow.engine.model.flowbefore.FlowBatchModel;
import com.bringspring.workflow.engine.model.flowtask.FlowTaskListModel;
import com.bringspring.workflow.engine.model.flowtask.PaginationFlowTask;
import com.bringspring.workflow.engine.service.FlowDelegateService;
import com.bringspring.workflow.engine.service.FlowEngineTemplateService;
import com.bringspring.workflow.engine.service.FlowEngineVisibleService;
import com.bringspring.workflow.engine.service.FlowTaskCirculateService;
import com.bringspring.workflow.engine.service.FlowTaskDeleteRecordService;
import com.bringspring.workflow.engine.service.FlowTaskNodeService;
import com.bringspring.workflow.engine.service.FlowTaskOperatorRecordService;
import com.bringspring.workflow.engine.service.FlowTaskOperatorService;
import com.bringspring.workflow.engine.service.FlowTaskService;
import com.bringspring.workflow.engine.util.FlowMsgUtil;
import com.bringspring.workflow.engine.util.FlowNature;
import com.bringspring.workflow.engine.util.ServiceAllUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FlowTaskServiceImpl
extends ServiceImpl<FlowTaskMapper, FlowTaskEntity>
implements FlowTaskService {
    private static final Logger log = LoggerFactory.getLogger(FlowTaskServiceImpl.class);
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private ServiceAllUtil serviceUtil;
    @Autowired
    private FlowDelegateService flowDelegateService;
    @Autowired
    private FlowTaskNodeService flowTaskNodeService;
    @Autowired
    private FlowTaskOperatorService flowTaskOperatorService;
    @Autowired
    private FlowTaskOperatorRecordService flowTaskOperatorRecordService;
    @Autowired
    private FlowTaskCirculateService flowTaskCirculateService;
    @Autowired
    private DataSourceModel dataSourceModel;
    @Autowired
    private FlowTaskService flowTaskService;
    @Autowired
    private FlowEngineVisibleService flowEngineVisibleService;
    @Autowired
    private UserService userService;
    @Autowired
    private FlowMsgUtil flowMsgUtil;
    @Autowired
    private FlowTaskDeleteRecordService flowTaskDeleteRecordService;
    @Autowired
    private FlowEngineTemplateService flowEngineTemplateService;

    @Override
    public List<FlowTaskEntity> getMonitorList(PaginationFlowTask paginationFlowTask) {
        Page page;
        IPage flowTaskEntityPage;
        String companyId;
        String creatorUserId;
        String flowCategory;
        String flowId;
        String endTime;
        String keyWord;
        boolean flag = false;
        UserInfo userInfo = this.userProvider.get();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().select(new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getFlowId, FlowTaskEntity::getTemplateId}).gt(FlowTaskEntity::getStatus, (Object)FlowTaskStatusEnum.Draft.getCode());
        List taskList = this.flowTaskService.list((Wrapper)queryWrapper);
        List flowIdList = taskList.stream().map(t -> t.getTemplateId()).distinct().collect(Collectors.toList());
        if (!userInfo.getIsAdministrator().booleanValue()) {
            List<FlowEngineVisibleEntity> visibleFlowList = this.flowEngineVisibleService.getAllCompanyVisibleFlowList(userInfo.getUserId(), paginationFlowTask.getMenuId());
            if (CollectionUtil.isNotEmpty(visibleFlowList)) {
                List collect = visibleFlowList.stream().map(visible -> visible.getTemplateId()).collect(Collectors.toList());
                List filterIdList = collect.stream().filter(t -> flowIdList.contains(t)).collect(Collectors.toList());
                queryWrapper.lambda().in(FlowTaskEntity::getTemplateId, filterIdList);
            } else {
                return new ArrayList<FlowTaskEntity>();
            }
        }
        String string = keyWord = paginationFlowTask.getKeyword() != null ? paginationFlowTask.getKeyword() : null;
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)keyWord)) {
            flag = true;
            queryWrapper.lambda().and(t -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)t.like(FlowTaskEntity::getEnCode, (Object)keyWord)).or()).like(FlowTaskEntity::getFullName, (Object)keyWord);
            });
        }
        String startTime = paginationFlowTask.getStartTime() != null ? paginationFlowTask.getStartTime() : null;
        String string2 = endTime = paginationFlowTask.getEndTime() != null ? paginationFlowTask.getEndTime() : null;
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)startTime) && !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)endTime)) {
            flag = true;
            Date startTimes = DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)Long.parseLong(startTime)) + " 00:00:00"));
            Date endTimes = DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)Long.parseLong(endTime)) + " 23:59:59"));
            ((LambdaQueryWrapper)queryWrapper.lambda().ge(FlowTaskEntity::getCreatorTime, (Object)startTimes)).le(FlowTaskEntity::getCreatorTime, (Object)endTimes);
        }
        if (ObjectUtil.isNotNull((Object)paginationFlowTask.getStatus())) {
            flag = true;
            queryWrapper.lambda().eq(FlowTaskEntity::getStatus, (Object)paginationFlowTask.getStatus());
        }
        String string3 = flowId = paginationFlowTask.getFlowId() != null ? paginationFlowTask.getFlowId() : null;
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)flowId)) {
            flag = true;
            queryWrapper.lambda().eq(FlowTaskEntity::getFlowId, (Object)flowId);
        }
        String string4 = flowCategory = paginationFlowTask.getFlowCategory() != null ? paginationFlowTask.getFlowCategory() : null;
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)flowCategory)) {
            flag = true;
            queryWrapper.lambda().eq(FlowTaskEntity::getFlowCategory, (Object)flowCategory);
        }
        String string5 = creatorUserId = paginationFlowTask.getCreatorUserId() != null ? paginationFlowTask.getCreatorUserId() : null;
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)creatorUserId)) {
            flag = true;
            queryWrapper.lambda().eq(FlowTaskEntity::getCreatorUserId, (Object)creatorUserId);
        }
        String string6 = companyId = paginationFlowTask.getCompanyId() != null ? paginationFlowTask.getCompanyId() : null;
        if (ObjectUtil.isNotEmpty((Object)companyId)) {
            flag = true;
            List<FlowEngineTemplateEntity> listByCompanyId = this.flowEngineTemplateService.getListByCompanyId(companyId);
            List templateIdList = listByCompanyId.stream().map(t -> t.getId()).collect(Collectors.toList());
            queryWrapper.lambda().in(FlowTaskEntity::getTemplateId, templateIdList);
        }
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(FlowTaskEntity::getSortCode)).orderByDesc(FlowTaskEntity::getCreatorTime);
        if (flag) {
            queryWrapper.lambda().orderByDesc(FlowTaskEntity::getLastModifyTime);
        }
        if (!(flowTaskEntityPage = this.page((IPage)(page = new Page(paginationFlowTask.getCurrentPage(), paginationFlowTask.getPageSize())), (Wrapper)queryWrapper)).getRecords().isEmpty()) {
            List ids = flowTaskEntityPage.getRecords().stream().map(m -> m.getId()).collect(Collectors.toList());
            queryWrapper = new QueryWrapper();
            queryWrapper.lambda().in(FlowTaskEntity::getId, ids);
            ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(FlowTaskEntity::getSortCode)).orderByDesc(FlowTaskEntity::getCreatorTime);
            if (flag) {
                queryWrapper.lambda().orderByDesc(FlowTaskEntity::getLastModifyTime);
            }
            flowTaskEntityPage.setRecords(this.list((Wrapper)queryWrapper));
        }
        return paginationFlowTask.setData(flowTaskEntityPage.getRecords(), page.getTotal());
    }

    public List<FlowTaskEntity> getLaunchListNoPage(PaginationFlowTask paginationFlowTask) {
        String flowCategory;
        String flowName;
        String endTime;
        String keyWord;
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().select(FlowTaskEntity.class, i -> !i.getProperty().equals("flowTemplateJson") && !i.getProperty().equals("flowFormContentJson"));
        String userId = this.userProvider.get().getUserId();
        queryWrapper.lambda().select(new SFunction[]{FlowTaskEntity::getId});
        if (paginationFlowTask.getIsAll() == null || paginationFlowTask.getIsAll() == 0) {
            queryWrapper.lambda().eq(FlowTaskEntity::getCreatorUserId, (Object)userId);
        }
        String string = keyWord = paginationFlowTask.getKeyword() != null ? paginationFlowTask.getKeyword() : null;
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)keyWord)) {
            queryWrapper.lambda().and(t -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)t.like(FlowTaskEntity::getEnCode, (Object)keyWord)).or()).like(FlowTaskEntity::getFullName, (Object)keyWord);
            });
        }
        if (CollectionUtil.isNotEmpty(paginationFlowTask.getProcessIdList())) {
            queryWrapper.lambda().in(FlowTaskEntity::getProcessId, paginationFlowTask.getProcessIdList());
        }
        String startTime = paginationFlowTask.getStartTime() != null ? paginationFlowTask.getStartTime() : null;
        String string2 = endTime = paginationFlowTask.getEndTime() != null ? paginationFlowTask.getEndTime() : null;
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)startTime) && !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)endTime)) {
            Date startTimes = DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)Long.parseLong(startTime)) + " 00:00:00"));
            Date endTimes = DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)Long.parseLong(endTime)) + " 23:59:59"));
            ((LambdaQueryWrapper)queryWrapper.lambda().ge(FlowTaskEntity::getCreatorTime, (Object)startTimes)).le(FlowTaskEntity::getCreatorTime, (Object)endTimes);
        }
        String string3 = flowName = paginationFlowTask.getFlowId() != null ? paginationFlowTask.getFlowId() : null;
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)flowName)) {
            queryWrapper.lambda().eq(FlowTaskEntity::getFlowId, (Object)flowName);
        }
        if (ObjectUtil.isNotNull((Object)paginationFlowTask.getStatus())) {
            queryWrapper.lambda().eq(FlowTaskEntity::getStatus, (Object)paginationFlowTask.getStatus());
        }
        String string4 = flowCategory = paginationFlowTask.getFlowCategory() != null ? paginationFlowTask.getFlowCategory() : null;
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)flowCategory)) {
            queryWrapper.lambda().eq(FlowTaskEntity::getFlowCategory, (Object)flowCategory);
        }
        if ("asc".equals(paginationFlowTask.getSort().toLowerCase())) {
            ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(FlowTaskEntity::getStatus)).orderByAsc(FlowTaskEntity::getStartTime);
        } else {
            ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().orderByDesc(FlowTaskEntity::getLastModifyTime)).orderByDesc(FlowTaskEntity::getStartTime)).orderByAsc(FlowTaskEntity::getStatus);
        }
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<FlowTaskEntity> getLaunchList(PaginationFlowTask paginationFlowTask) {
        String flowCategory;
        String flowName;
        String endTime;
        String keyWord;
        QueryWrapper queryWrapper = new QueryWrapper();
        String userId = this.userProvider.get().getUserId();
        queryWrapper.lambda().select(new SFunction[]{FlowTaskEntity::getId});
        if (paginationFlowTask.getIsAll() == null || paginationFlowTask.getIsAll() == 0) {
            queryWrapper.lambda().eq(FlowTaskEntity::getCreatorUserId, (Object)userId);
        }
        String string = keyWord = paginationFlowTask.getKeyword() != null ? paginationFlowTask.getKeyword() : null;
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)keyWord)) {
            queryWrapper.lambda().and(t -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)t.like(FlowTaskEntity::getEnCode, (Object)keyWord)).or()).like(FlowTaskEntity::getFullName, (Object)keyWord);
            });
        }
        if (CollectionUtil.isNotEmpty(paginationFlowTask.getProcessIdList())) {
            queryWrapper.lambda().in(FlowTaskEntity::getProcessId, paginationFlowTask.getProcessIdList());
        }
        String startTime = paginationFlowTask.getStartTime() != null ? paginationFlowTask.getStartTime() : null;
        String string2 = endTime = paginationFlowTask.getEndTime() != null ? paginationFlowTask.getEndTime() : null;
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)startTime) && !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)endTime)) {
            Date startTimes = DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)Long.parseLong(startTime)) + " 00:00:00"));
            Date endTimes = DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)Long.parseLong(endTime)) + " 23:59:59"));
            ((LambdaQueryWrapper)queryWrapper.lambda().ge(FlowTaskEntity::getCreatorTime, (Object)startTimes)).le(FlowTaskEntity::getCreatorTime, (Object)endTimes);
        }
        String string3 = flowName = paginationFlowTask.getFlowId() != null ? paginationFlowTask.getFlowId() : null;
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)flowName)) {
            queryWrapper.lambda().eq(FlowTaskEntity::getFlowId, (Object)flowName);
        }
        if (ObjectUtil.isNotNull((Object)paginationFlowTask.getStatus())) {
            queryWrapper.lambda().eq(FlowTaskEntity::getStatus, (Object)paginationFlowTask.getStatus());
        }
        String string4 = flowCategory = paginationFlowTask.getFlowCategory() != null ? paginationFlowTask.getFlowCategory() : null;
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)flowCategory)) {
            queryWrapper.lambda().eq(FlowTaskEntity::getFlowCategory, (Object)flowCategory);
        }
        if ("asc".equals(paginationFlowTask.getSort().toLowerCase())) {
            ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(FlowTaskEntity::getStatus)).orderByAsc(FlowTaskEntity::getStartTime);
        } else {
            ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().orderByDesc(FlowTaskEntity::getLastModifyTime)).orderByDesc(FlowTaskEntity::getStartTime)).orderByAsc(FlowTaskEntity::getStatus);
        }
        Page page = new Page(paginationFlowTask.getCurrentPage(), paginationFlowTask.getPageSize());
        IPage flowTaskEntityPage = this.page((IPage)page, (Wrapper)queryWrapper);
        if (!flowTaskEntityPage.getRecords().isEmpty()) {
            List ids = flowTaskEntityPage.getRecords().stream().map(m -> m.getId()).collect(Collectors.toList());
            queryWrapper = new QueryWrapper();
            queryWrapper.lambda().in(FlowTaskEntity::getId, ids);
            if ("asc".equals(paginationFlowTask.getSort().toLowerCase())) {
                ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(FlowTaskEntity::getLastModifyTime)).orderByAsc(FlowTaskEntity::getStartTime)).orderByAsc(FlowTaskEntity::getStatus);
            } else {
                ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().orderByDesc(FlowTaskEntity::getLastModifyTime)).orderByDesc(FlowTaskEntity::getStartTime)).orderByAsc(FlowTaskEntity::getStatus);
            }
            flowTaskEntityPage.setRecords(this.list((Wrapper)queryWrapper));
        }
        return paginationFlowTask.setData(flowTaskEntityPage.getRecords(), page.getTotal());
    }

    @Override
    public List<FlowTaskListModel> getWaitList(PaginationFlowTask paginationFlowTask) {
        List<FlowTaskListModel> result = this.getWaitListAll(paginationFlowTask);
        return paginationFlowTask.setData(PageUtil.getPage((int)((int)paginationFlowTask.getCurrentPage()), (int)((int)paginationFlowTask.getPageSize()), result), result.size());
    }

    @Override
    public List<FlowTaskListModel> getBatchWaitList(PaginationFlowTask paginationFlowTask) {
        paginationFlowTask.setIsBatch(1);
        List<FlowTaskListModel> result = this.getWaitListAll(paginationFlowTask);
        return paginationFlowTask.setData(PageUtil.getPage((int)((int)paginationFlowTask.getCurrentPage()), (int)((int)paginationFlowTask.getPageSize()), result), result.size());
    }

    @Override
    public List<FlowTaskListModel> getWaitListAll(PaginationFlowTask paginationFlowTask) {
        Integer isBatch;
        String nodeCode;
        String creatorUserId;
        String flowCategory;
        String flowId;
        String endTime;
        String keyWord;
        String userId = "";
        userId = ObjectUtil.isNotEmpty((Object)paginationFlowTask.getUserId()) ? paginationFlowTask.getUserId() : this.userProvider.get().getUserId();
        StringBuilder dbSql = new StringBuilder();
        dbSql.append(" AND (");
        StringJoiner joiner = new StringJoiner(",");
        joiner.add("'" + userId + "'");
        List<FlowDelegateEntity> flowDelegateList = this.flowDelegateService.getUser(userId);
        for (FlowDelegateEntity delegateEntity : flowDelegateList) {
            joiner.add("'" + delegateEntity.getCreatorUserId() + "'");
        }
        dbSql.append("o.HANDLE_ID in (" + joiner.toString() + " ) )");
        String string = keyWord = paginationFlowTask.getKeyword() != null ? paginationFlowTask.getKeyword() : null;
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)keyWord)) {
            dbSql.append(" AND (t.ENCODE like '%" + keyWord + "%' or t.FULL_NAME like '%" + keyWord + "%') ");
        }
        String startTime = paginationFlowTask.getStartTime() != null ? paginationFlowTask.getStartTime() : null;
        String string2 = endTime = paginationFlowTask.getEndTime() != null ? paginationFlowTask.getEndTime() : null;
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)startTime) && !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)endTime)) {
            String endTimes;
            String startTimes;
            if (DbTypeUtil.checkOracle((DataSourceMod)this.dataSourceModel).booleanValue()) {
                startTimes = DateUtil.daFormatYmd((Long)Long.parseLong(startTime)) + " 00:00:00";
                endTimes = DateUtil.daFormatYmd((Long)Long.parseLong(endTime)) + " 23:59:59";
                dbSql.append(" AND o.CREATOR_TIME Between TO_DATE('" + startTimes + "','yyyy-mm-dd HH24:mi:ss') AND TO_DATE('" + endTimes + "','yyyy-mm-dd HH24:mi:ss') ");
            } else {
                startTimes = DateUtil.daFormatYmd((Long)Long.parseLong(startTime)) + " 00:00:00";
                endTimes = DateUtil.daFormatYmd((Long)Long.parseLong(endTime)) + " 23:59:59";
                dbSql.append(" AND o.CREATOR_TIME Between '" + startTimes + "' AND '" + endTimes + "' ");
            }
        }
        String string3 = flowId = paginationFlowTask.getFlowId() != null ? paginationFlowTask.getFlowId() : null;
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)flowId)) {
            if (flowId.contains(",")) {
                String[] flowIdList;
                StringBuilder sbFlowId = new StringBuilder();
                for (String i : flowIdList = flowId.split(",")) {
                    sbFlowId.append("'").append(i).append("', ");
                }
                if (sbFlowId.length() > 2) {
                    sbFlowId.setLength(sbFlowId.length() - 2);
                }
                dbSql.append(" AND t.FLOW_ID in (" + sbFlowId + ")");
            } else {
                dbSql.append(" AND t.FLOW_ID = '" + flowId + "'");
            }
        }
        String string4 = flowCategory = paginationFlowTask.getFlowCategory() != null ? paginationFlowTask.getFlowCategory() : null;
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)flowCategory)) {
            dbSql.append(" AND t.FLOW_CATEGORY = '" + flowCategory + "'");
        }
        String string5 = creatorUserId = paginationFlowTask.getCreatorUserId() != null ? paginationFlowTask.getCreatorUserId() : null;
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)creatorUserId)) {
            dbSql.append(" AND t.CREATOR_USER_ID = '" + creatorUserId + "'");
        }
        String string6 = nodeCode = paginationFlowTask.getNodeCode() != null ? paginationFlowTask.getNodeCode() : null;
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)nodeCode)) {
            dbSql.append(" AND o.Node_Code = '" + nodeCode + "'");
        }
        Integer n = isBatch = paginationFlowTask.getIsBatch() != null ? paginationFlowTask.getIsBatch() : null;
        if (!ObjectUtil.isEmpty((Object)isBatch)) {
            dbSql.append(" AND t.IS_BATCH = " + isBatch + " ");
        }
        StringBuilder orderBy = new StringBuilder();
        if ("desc".equals(paginationFlowTask.getSort().toLowerCase())) {
            orderBy.append(" Order by CREATOR_TIME DESC");
        } else {
            orderBy.append(" Order by CREATOR_TIME ASC");
        }
        String sql = dbSql.toString() + " " + orderBy.toString();
        List<FlowTaskListModel> data = ((FlowTaskMapper)this.baseMapper).getWaitList(sql);
        LinkedList<FlowTaskListModel> result = new LinkedList<FlowTaskListModel>();
        for (FlowTaskListModel entity : data) {
            List list = StringUtils.isNotEmpty((String)entity.getDescription()) ? JsonUtil.getJsonToList((String)entity.getDescription(), Date.class) : new ArrayList();
            boolean delegate = true;
            boolean isuser = entity.getHandleId().equals(userId);
            entity.setFullName(!isuser ? entity.getFullName() + "(\u59d4\u6258)" : entity.getFullName());
            List flowList = flowDelegateList.stream().filter(t -> t.getFlowId().equals(entity.getFlowId())).collect(Collectors.toList());
            if (!isuser) {
                boolean bl = delegate = flowList.stream().filter(t -> t.getCreatorUserId().equals(entity.getHandleId())).count() > 0L;
            }
            if (!delegate) continue;
            result.add(entity);
            Date date = new Date();
            boolean del = list.stream().filter(t -> t.getTime() > date.getTime()).count() > 0L;
            if (!del) continue;
            result.remove(entity);
        }
        return result;
    }

    @Override
    public List<FlowTaskEntity> getListByRelation(PaginationFlowTask paginationFlowTask) {
        List myAddSignList;
        List myList;
        List uniqueList;
        String creatorUserId;
        String flowCategory;
        String flowId;
        String endTime;
        String keyWord;
        UserInfo userInfo = this.userProvider.get();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().select(FlowTaskEntity.class, i -> !i.getProperty().equals("flowTemplateJson") && !i.getProperty().equals("flowFormContentJson"));
        String userId = userInfo.getUserId();
        String string = keyWord = paginationFlowTask.getKeyword() != null ? paginationFlowTask.getKeyword() : null;
        if (ObjectUtil.isNotEmpty((Object)keyWord)) {
            queryWrapper.lambda().and(t -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)t.like(FlowTaskEntity::getEnCode, (Object)keyWord)).or()).like(FlowTaskEntity::getFullName, (Object)keyWord);
            });
        }
        if (ObjectUtil.isNotNull((Object)paginationFlowTask.getStatus())) {
            queryWrapper.lambda().eq(FlowTaskEntity::getStatus, (Object)paginationFlowTask.getStatus());
        }
        String startTime = paginationFlowTask.getStartTime() != null ? paginationFlowTask.getStartTime() : null;
        String string2 = endTime = paginationFlowTask.getEndTime() != null ? paginationFlowTask.getEndTime() : null;
        if (ObjectUtil.isNotEmpty((Object)startTime) && ObjectUtil.isNotEmpty((Object)endTime)) {
            String endTimes;
            String startTimes;
            if (DbTypeUtil.checkOracle((DataSourceMod)this.dataSourceModel).booleanValue()) {
                startTimes = DateUtil.daFormatYmd((Long)Long.parseLong(startTime)) + " 00:00:00";
                endTimes = DateUtil.daFormatYmd((Long)Long.parseLong(endTime)) + " 23:59:59";
                ((LambdaQueryWrapper)queryWrapper.lambda().ge(FlowTaskEntity::getCreatorTime, (Object)startTimes)).le(FlowTaskEntity::getCreatorTime, (Object)endTimes);
            } else {
                startTimes = DateUtil.daFormatYmd((Long)Long.parseLong(startTime)) + " 00:00:00";
                endTimes = DateUtil.daFormatYmd((Long)Long.parseLong(endTime)) + " 23:59:59";
                ((LambdaQueryWrapper)queryWrapper.lambda().ge(FlowTaskEntity::getCreatorTime, (Object)startTimes)).le(FlowTaskEntity::getCreatorTime, (Object)endTimes);
            }
        }
        String string3 = flowId = paginationFlowTask.getFlowId() != null ? paginationFlowTask.getFlowId() : null;
        if (ObjectUtil.isNotEmpty((Object)flowId)) {
            queryWrapper.lambda().eq(FlowTaskEntity::getFlowId, (Object)flowId);
        }
        String string4 = flowCategory = paginationFlowTask.getFlowCategory() != null ? paginationFlowTask.getFlowCategory() : null;
        if (ObjectUtil.isNotEmpty((Object)flowCategory)) {
            queryWrapper.lambda().eq(FlowTaskEntity::getFlowCategory, (Object)flowCategory);
        }
        String string5 = creatorUserId = paginationFlowTask.getCreatorUserId() != null ? paginationFlowTask.getCreatorUserId() : null;
        if (ObjectUtil.isNotEmpty((Object)creatorUserId)) {
            queryWrapper.lambda().eq(FlowTaskEntity::getCreatorUserId, (Object)creatorUserId);
        }
        if ("asc".equals(paginationFlowTask.getSort().toLowerCase())) {
            ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(FlowTaskEntity::getStatus)).orderByAsc(FlowTaskEntity::getStartTime);
        } else {
            ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().orderByDesc(FlowTaskEntity::getLastModifyTime)).orderByDesc(FlowTaskEntity::getStartTime)).orderByAsc(FlowTaskEntity::getStatus);
        }
        List launchList = JsonUtil.getJsonToList(this.getLaunchListNoPage(paginationFlowTask), FlowTaskListModel.class);
        List<FlowTaskListModel> waitList = this.getWaitListAll(paginationFlowTask);
        List trialList = JsonUtil.getJsonToList(this.getTrialListNoPage(paginationFlowTask), FlowTaskListModel.class);
        List circulateList = JsonUtil.getJsonToList(this.getCirculateListNoPage(paginationFlowTask), FlowTaskListModel.class);
        List<FlowTaskOperatorRecordEntity> listByAddSign = this.flowTaskOperatorRecordService.getListByAddSign(userId);
        List taskIdList = listByAddSign.stream().map(t -> t.getTaskId()).collect(Collectors.toList());
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.lambda().in(FlowTaskEntity::getId, taskIdList);
        List addSignList = new ArrayList();
        if (CollectionUtil.isNotEmpty(taskIdList)) {
            addSignList = this.list((Wrapper)wrapper);
        }
        if (!CollectionUtil.isNotEmpty(uniqueList = (myList = Stream.of(launchList, waitList, trialList, circulateList, myAddSignList = JsonUtil.getJsonToList(addSignList, FlowTaskListModel.class)).flatMap(Collection::stream).collect(Collectors.toList())).stream().collect(Collectors.toMap(FlowTaskListModel::getId, item -> item, (existing, replacement) -> existing)).values().stream().collect(Collectors.toList()))) {
            return new ArrayList<FlowTaskEntity>();
        }
        List ids = uniqueList.stream().map(FlowTaskListModel::getId).collect(Collectors.toList());
        queryWrapper.lambda().in(FlowTaskEntity::getId, ids);
        if ("asc".equalsIgnoreCase(paginationFlowTask.getSort())) {
            queryWrapper.lambda().orderByAsc(FlowTaskEntity::getLastModifyTime, (Object[])new SFunction[]{FlowTaskEntity::getStartTime, FlowTaskEntity::getStatus});
        } else {
            ((LambdaQueryWrapper)queryWrapper.lambda().orderByDesc(FlowTaskEntity::getLastModifyTime, (Object[])new SFunction[]{FlowTaskEntity::getStartTime})).orderByAsc(FlowTaskEntity::getStatus);
        }
        Page page = new Page(paginationFlowTask.getCurrentPage(), paginationFlowTask.getPageSize());
        IPage userIPage = this.page((IPage)page, (Wrapper)queryWrapper);
        return paginationFlowTask.setData(userIPage.getRecords(), userIPage.getTotal());
    }

    public List<FlowTaskListModel> getTrialListNoPage(PaginationFlowTask paginationFlowTask) {
        String handleEndTime;
        String creatorUserId;
        String flowCategory;
        String flowId;
        String endTime;
        String keyWord;
        String userId = this.userProvider.get().getUserId();
        HashMap<String, Object> queryParam = new HashMap<String, Object>(16);
        StringBuilder dbSql = new StringBuilder();
        String string = keyWord = paginationFlowTask.getKeyword() != null ? paginationFlowTask.getKeyword() : null;
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)keyWord)) {
            dbSql.append(" AND (t.ENCODE like '%" + keyWord + "%' or t.Full_Name like '%" + keyWord + "%') ");
        }
        String startTime = paginationFlowTask.getStartTime() != null ? paginationFlowTask.getStartTime() : null;
        String string2 = endTime = paginationFlowTask.getEndTime() != null ? paginationFlowTask.getEndTime() : null;
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)startTime) && !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)endTime)) {
            String endTimes;
            String startTimes;
            if (DbTypeUtil.checkOracle((DataSourceMod)this.dataSourceModel).booleanValue()) {
                startTimes = DateUtil.daFormatYmd((Long)Long.parseLong(startTime)) + " 00:00:00";
                endTimes = DateUtil.daFormatYmd((Long)Long.parseLong(endTime)) + " 23:59:59";
                dbSql.append(" AND t.CREATOR_TIME Between TO_DATE('" + startTimes + "','yyyy-mm-dd HH24:mi:ss') AND TO_DATE('" + endTimes + "','yyyy-mm-dd HH24:mi:ss') ");
            } else {
                startTimes = DateUtil.daFormatYmd((Long)Long.parseLong(startTime)) + " 00:00:00";
                endTimes = DateUtil.daFormatYmd((Long)Long.parseLong(endTime)) + " 23:59:59";
                dbSql.append(" AND t.CREATOR_TIME Between '" + startTimes + "' AND '" + endTimes + "' ");
            }
        }
        String string3 = flowId = paginationFlowTask.getFlowId() != null ? paginationFlowTask.getFlowId() : null;
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)flowId)) {
            dbSql.append(" AND t.FLOW_ID = '" + flowId + "' ");
        }
        String string4 = flowCategory = paginationFlowTask.getFlowCategory() != null ? paginationFlowTask.getFlowCategory() : null;
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)flowCategory)) {
            dbSql.append(" AND t.FLOW_CATEGORY = '" + flowCategory + "' ");
        }
        String string5 = creatorUserId = paginationFlowTask.getCreatorUserId() != null ? paginationFlowTask.getCreatorUserId() : null;
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)creatorUserId)) {
            dbSql.append(" AND t.CREATOR_USER_ID = '" + creatorUserId + "' ");
        }
        StringBuilder orderBy = new StringBuilder();
        if ("desc".equals(paginationFlowTask.getSort().toLowerCase())) {
            orderBy.append(" Order by CREATOR_TIME DESC");
        } else {
            orderBy.append(" Order by CREATOR_TIME ASC");
        }
        String sql = dbSql.toString() + " " + orderBy.toString();
        queryParam.put("handleId", userId);
        queryParam.put("sql", dbSql.toString());
        List<FlowTaskListModel> data = ((FlowTaskMapper)this.baseMapper).getTrialList(queryParam);
        Map uniqueData = data.stream().collect(Collectors.toMap(FlowTaskListModel::getId, Function.identity(), (item1, item2) -> item1.getHandleTime().compareTo(item2.getHandleTime()) > 0 ? item1 : item2));
        if (ObjectUtil.isNotEmpty((Object)paginationFlowTask.getSort())) {
            String sort = paginationFlowTask.getSort();
            String[] sortParts = sort.split(",");
            String sortField = sortParts[0];
            boolean ascending = "asc".equals(sortField);
            Comparator<FlowTaskListModel> comparator = Comparator.comparing(FlowTaskListModel::getCreatorTime);
            if (!ascending) {
                comparator = comparator.reversed();
            }
            data = uniqueData.values().stream().sorted(comparator).collect(Collectors.toList());
        }
        String handleBeginTime = paginationFlowTask.getHandleStartTime() != null ? paginationFlowTask.getHandleStartTime() : null;
        String string6 = handleEndTime = paginationFlowTask.getHandleEndTime() != null ? paginationFlowTask.getHandleEndTime() : null;
        if (ObjectUtil.isNotEmpty((Object)handleBeginTime) && ObjectUtil.isNotEmpty((Object)handleEndTime)) {
            handleBeginTime = DateUtil.daFormatYmd((Long)Long.parseLong(handleBeginTime)) + " 00:00:00";
            handleEndTime = DateUtil.daFormatYmd((Long)Long.parseLong(handleEndTime)) + " 23:59:59";
            DateTime beginDate = DateUtil.parseDateTime((CharSequence)handleBeginTime);
            DateTime endDate = DateUtil.parseDateTime((CharSequence)handleEndTime);
            List filteredData = data.stream().filter(arg_0 -> FlowTaskServiceImpl.lambda$getTrialListNoPage$19((Date)beginDate, (Date)endDate, arg_0)).collect(Collectors.toList());
            data = filteredData;
        }
        return data;
    }

    @Override
    public List<FlowTaskListModel> getTrialList(PaginationFlowTask paginationFlowTask) {
        String handleEndTime;
        String creatorUserId;
        String flowCategory;
        String flowId;
        String endTime;
        String keyWord;
        String userId = this.userProvider.get().getUserId();
        HashMap<String, Object> queryParam = new HashMap<String, Object>(16);
        StringBuilder dbSql = new StringBuilder();
        String string = keyWord = paginationFlowTask.getKeyword() != null ? paginationFlowTask.getKeyword() : null;
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)keyWord)) {
            dbSql.append(" AND (t.ENCODE like '%" + keyWord + "%' or t.Full_Name like '%" + keyWord + "%') ");
        }
        String startTime = paginationFlowTask.getStartTime() != null ? paginationFlowTask.getStartTime() : null;
        String string2 = endTime = paginationFlowTask.getEndTime() != null ? paginationFlowTask.getEndTime() : null;
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)startTime) && !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)endTime)) {
            String endTimes;
            String startTimes;
            if (DbTypeUtil.checkOracle((DataSourceMod)this.dataSourceModel).booleanValue()) {
                startTimes = DateUtil.daFormatYmd((Long)Long.parseLong(startTime)) + " 00:00:00";
                endTimes = DateUtil.daFormatYmd((Long)Long.parseLong(endTime)) + " 23:59:59";
                dbSql.append(" AND t.CREATOR_TIME Between TO_DATE('" + startTimes + "','yyyy-mm-dd HH24:mi:ss') AND TO_DATE('" + endTimes + "','yyyy-mm-dd HH24:mi:ss') ");
            } else {
                startTimes = DateUtil.daFormatYmd((Long)Long.parseLong(startTime)) + " 00:00:00";
                endTimes = DateUtil.daFormatYmd((Long)Long.parseLong(endTime)) + " 23:59:59";
                dbSql.append(" AND t.CREATOR_TIME Between '" + startTimes + "' AND '" + endTimes + "' ");
            }
        }
        String string3 = flowId = paginationFlowTask.getFlowId() != null ? paginationFlowTask.getFlowId() : null;
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)flowId)) {
            dbSql.append(" AND t.FLOW_ID = '" + flowId + "' ");
        }
        String string4 = flowCategory = paginationFlowTask.getFlowCategory() != null ? paginationFlowTask.getFlowCategory() : null;
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)flowCategory)) {
            dbSql.append(" AND t.FLOW_CATEGORY = '" + flowCategory + "' ");
        }
        String string5 = creatorUserId = paginationFlowTask.getCreatorUserId() != null ? paginationFlowTask.getCreatorUserId() : null;
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)creatorUserId)) {
            dbSql.append(" AND t.CREATOR_USER_ID = '" + creatorUserId + "' ");
        }
        StringBuilder orderBy = new StringBuilder();
        if ("desc".equals(paginationFlowTask.getSort().toLowerCase())) {
            orderBy.append(" Order by CREATOR_TIME DESC");
        } else {
            orderBy.append(" Order by CREATOR_TIME ASC");
        }
        String sql = dbSql.toString() + " " + orderBy.toString();
        queryParam.put("handleId", userId);
        queryParam.put("sql", dbSql.toString());
        List<FlowTaskListModel> data = ((FlowTaskMapper)this.baseMapper).getTrialList(queryParam);
        Map uniqueData = data.stream().collect(Collectors.toMap(FlowTaskListModel::getId, Function.identity(), (item1, item2) -> item1.getHandleTime().compareTo(item2.getHandleTime()) > 0 ? item1 : item2));
        if (ObjectUtil.isNotEmpty((Object)paginationFlowTask.getSort())) {
            String sort = paginationFlowTask.getSort();
            String[] sortParts = sort.split(",");
            String sortField = sortParts[0];
            boolean ascending = "asc".equals(sortField);
            Comparator<FlowTaskListModel> comparator = Comparator.comparing(FlowTaskListModel::getCreatorTime);
            if (!ascending) {
                comparator = comparator.reversed();
            }
            data = uniqueData.values().stream().sorted(comparator).collect(Collectors.toList());
        }
        String handleBeginTime = paginationFlowTask.getHandleStartTime() != null ? paginationFlowTask.getHandleStartTime() : null;
        String string6 = handleEndTime = paginationFlowTask.getHandleEndTime() != null ? paginationFlowTask.getHandleEndTime() : null;
        if (ObjectUtil.isNotEmpty((Object)handleBeginTime) && ObjectUtil.isNotEmpty((Object)handleEndTime)) {
            handleBeginTime = DateUtil.daFormatYmd((Long)Long.parseLong(handleBeginTime)) + " 00:00:00";
            handleEndTime = DateUtil.daFormatYmd((Long)Long.parseLong(handleEndTime)) + " 23:59:59";
            DateTime beginDate = DateUtil.parseDateTime((CharSequence)handleBeginTime);
            DateTime endDate = DateUtil.parseDateTime((CharSequence)handleEndTime);
            List filteredData = data.stream().filter(arg_0 -> FlowTaskServiceImpl.lambda$getTrialList$21((Date)beginDate, (Date)endDate, arg_0)).collect(Collectors.toList());
            data = filteredData;
        }
        return paginationFlowTask.setData(PageUtil.getPage((int)((int)paginationFlowTask.getCurrentPage()), (int)((int)paginationFlowTask.getPageSize()), data), data.size());
    }

    @Override
    public List<FlowTaskListModel> getTrialList() {
        String userId = this.userProvider.get().getUserId();
        HashMap<String, Object> queryParam = new HashMap<String, Object>(16);
        StringBuilder dbSql = new StringBuilder();
        queryParam.put("handleId", userId);
        queryParam.put("sql", dbSql.toString());
        List<FlowTaskListModel> data = ((FlowTaskMapper)this.baseMapper).getTrialList(queryParam);
        return data;
    }

    @Override
    public List<FlowTaskEntity> getWaitList() {
        String userId = this.userProvider.get().getUserId();
        StringBuilder dbSql = new StringBuilder();
        dbSql.append(" AND (");
        dbSql.append("o.Handle_Id = '" + userId + "' ");
        List<FlowDelegateEntity> flowDelegateList = this.flowDelegateService.getUser(userId);
        if (flowDelegateList.size() > 0) {
            dbSql.append(" OR ");
            for (int i = 0; i < flowDelegateList.size(); ++i) {
                FlowDelegateEntity delegateEntity = flowDelegateList.get(i);
                dbSql.append(" o.Handle_Id = '" + delegateEntity.getCreatorUserId() + "' ");
                if (flowDelegateList.size() - 1 <= i) continue;
                dbSql.append(" OR ");
            }
            dbSql.append(")");
        } else {
            dbSql.append(")");
        }
        List<FlowTaskListModel> data = ((FlowTaskMapper)this.baseMapper).getWaitList(dbSql.toString());
        List result = JsonUtil.getJsonToList(data, FlowTaskEntity.class);
        return result;
    }

    @Override
    public List<FlowTaskEntity> getDashboardWaitList() {
        String userId = this.userProvider.get().getUserId();
        StringBuilder dbSql = new StringBuilder();
        dbSql.append(" AND (");
        dbSql.append("o.Handle_Id = '" + userId + "' ");
        List<FlowDelegateEntity> flowDelegateList = this.flowDelegateService.getUser(userId);
        if (flowDelegateList.size() > 0) {
            dbSql.append(" OR ");
            for (int i = 0; i < flowDelegateList.size(); ++i) {
                FlowDelegateEntity delegateEntity = flowDelegateList.get(i);
                dbSql.append(" o.Handle_Id = '" + delegateEntity.getCreatorUserId() + "' ");
                if (flowDelegateList.size() - 1 <= i) continue;
                dbSql.append(" OR ");
            }
            dbSql.append(")");
        } else {
            dbSql.append(")");
        }
        List<FlowTaskListModel> data = ((FlowTaskMapper)this.baseMapper).getWaitList(dbSql.toString());
        List result = JsonUtil.getJsonToList(data, FlowTaskEntity.class);
        return result;
    }

    @Override
    public List<FlowTaskEntity> getAllWaitList() {
        String userId = this.userProvider.get().getUserId();
        StringBuilder dbSql = new StringBuilder();
        dbSql.append(" AND (");
        dbSql.append("o.Handle_Id = '" + userId + "' )  Order by CREATOR_TIME DESC");
        List<FlowTaskListModel> data = ((FlowTaskMapper)this.baseMapper).getWaitList(dbSql.toString());
        List result = JsonUtil.getJsonToList(data, FlowTaskEntity.class);
        return result;
    }

    public List<FlowTaskListModel> getCirculateListNoPage(PaginationFlowTask paginationFlowTask) {
        String creatorUserId;
        String flowCategory;
        String flowId;
        String endTime;
        String keyWord;
        String userId = this.userProvider.get().getUserId();
        ArrayList<String> userIdList = new ArrayList<String>();
        userIdList.add(userId);
        List<UserRelationEntity> list = this.serviceUtil.getListByUserIdAll(userIdList);
        List userRelationList = list.stream().map(u -> u.getObjectId()).collect(Collectors.toList());
        String[] objectId = (String.join((CharSequence)",", userRelationList) + "," + userId).split(",");
        StringBuilder dbSql = new StringBuilder();
        dbSql.append(" AND (");
        for (int i = 0; i < objectId.length; ++i) {
            dbSql.append("c.OBJECT_ID = '" + objectId[i] + "'");
            if (objectId.length - 1 <= i) continue;
            dbSql.append(" OR ");
        }
        dbSql.append(")");
        String string = keyWord = paginationFlowTask.getKeyword() != null ? paginationFlowTask.getKeyword() : null;
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)keyWord)) {
            dbSql.append(" AND (t.ENCODE like  '%" + keyWord + "%' " + " or t.FULL_NAME like" + " '%" + keyWord + "%') ");
        }
        String startTime = paginationFlowTask.getStartTime() != null ? paginationFlowTask.getStartTime() : null;
        String string2 = endTime = paginationFlowTask.getEndTime() != null ? paginationFlowTask.getEndTime() : null;
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)startTime) && !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)endTime)) {
            String endTimes;
            String startTimes;
            if (DbTypeUtil.checkOracle((DataSourceMod)this.dataSourceModel).booleanValue()) {
                startTimes = DateUtil.daFormatYmd((Long)Long.parseLong(startTime)) + " 00:00:00";
                endTimes = DateUtil.daFormatYmd((Long)Long.parseLong(endTime)) + " 23:59:59";
                dbSql.append(" AND c.CREATOR_TIME Between TO_DATE('" + startTimes + "','yyyy-mm-dd HH24:mi:ss') AND TO_DATE('" + endTimes + "','yyyy-mm-dd HH24:mi:ss') ");
            } else {
                startTimes = DateUtil.daFormatYmd((Long)Long.parseLong(startTime)) + " 00:00:00";
                endTimes = DateUtil.daFormatYmd((Long)Long.parseLong(endTime)) + " 23:59:59";
                dbSql.append(" AND c.CREATOR_TIME Between  '" + startTimes + "' AND '" + endTimes + "' ");
            }
        }
        String string3 = flowId = paginationFlowTask.getFlowId() != null ? paginationFlowTask.getFlowId() : null;
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)flowId)) {
            dbSql.append(" AND t.FLOW_ID = '" + flowId + "'");
        }
        String string4 = flowCategory = paginationFlowTask.getFlowCategory() != null ? paginationFlowTask.getFlowCategory() : null;
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)flowCategory)) {
            dbSql.append(" AND t.FLOW_CATEGORY = '" + flowCategory + "'");
        }
        String string5 = creatorUserId = paginationFlowTask.getCreatorUserId() != null ? paginationFlowTask.getCreatorUserId() : null;
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)creatorUserId)) {
            dbSql.append(" AND t.CREATOR_USER_ID = '" + creatorUserId + "'");
        }
        if ("desc".equals(paginationFlowTask.getSort().toLowerCase())) {
            dbSql.append(" Order by CREATOR_TIME DESC");
        } else {
            dbSql.append(" Order by CREATOR_TIME DESC");
        }
        List<FlowTaskListModel> data = ((FlowTaskMapper)this.baseMapper).getCirculateList(dbSql.toString());
        for (FlowTaskListModel task : data) {
            List<FlowTaskOperatorEntity> operatorList = this.flowTaskOperatorService.getAllByNodeId(task.getId(), task.getThisNodeId());
            if (!CollectionUtil.isNotEmpty(operatorList)) continue;
            if (operatorList.size() > 1) {
                ArrayList strings = new ArrayList();
                operatorList.stream().forEach(operator -> {
                    UserEntity userInfo = this.userService.getInfo(operator.getHandleId());
                    strings.add(userInfo.getRealName());
                });
                String handleName = strings.stream().collect(Collectors.joining(","));
                task.setThisNode(task.getThisNode() + "-" + handleName);
                continue;
            }
            UserEntity userEntity = this.userService.getInfo(operatorList.get(0).getHandleId());
            if (task.getThisNode().equals(userEntity.getRealName())) continue;
            task.setThisNode(task.getThisNode() + "-" + userEntity.getRealName());
        }
        return data;
    }

    @Override
    public List<FlowTaskListModel> getCirculateList(PaginationFlowTask paginationFlowTask) {
        String creatorUserId;
        String flowCategory;
        String flowId;
        String endTime;
        String keyWord;
        String userId = this.userProvider.get().getUserId();
        ArrayList<String> userIdList = new ArrayList<String>();
        userIdList.add(userId);
        List<UserRelationEntity> list = this.serviceUtil.getListByUserIdAll(userIdList);
        List userRelationList = list.stream().map(u -> u.getObjectId()).collect(Collectors.toList());
        String[] objectId = (String.join((CharSequence)",", userRelationList) + "," + userId).split(",");
        StringBuilder dbSql = new StringBuilder();
        dbSql.append(" AND (");
        for (int i = 0; i < objectId.length; ++i) {
            dbSql.append("c.OBJECT_ID = '" + objectId[i] + "'");
            if (objectId.length - 1 <= i) continue;
            dbSql.append(" OR ");
        }
        dbSql.append(")");
        String string = keyWord = paginationFlowTask.getKeyword() != null ? paginationFlowTask.getKeyword() : null;
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)keyWord)) {
            dbSql.append(" AND (t.ENCODE like  '%" + keyWord + "%' " + " or t.FULL_NAME like" + " '%" + keyWord + "%') ");
        }
        String startTime = paginationFlowTask.getStartTime() != null ? paginationFlowTask.getStartTime() : null;
        String string2 = endTime = paginationFlowTask.getEndTime() != null ? paginationFlowTask.getEndTime() : null;
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)startTime) && !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)endTime)) {
            String endTimes;
            String startTimes;
            if (DbTypeUtil.checkOracle((DataSourceMod)this.dataSourceModel).booleanValue()) {
                startTimes = DateUtil.daFormatYmd((Long)Long.parseLong(startTime)) + " 00:00:00";
                endTimes = DateUtil.daFormatYmd((Long)Long.parseLong(endTime)) + " 23:59:59";
                dbSql.append(" AND c.CREATOR_TIME Between TO_DATE('" + startTimes + "','yyyy-mm-dd HH24:mi:ss') AND TO_DATE('" + endTimes + "','yyyy-mm-dd HH24:mi:ss') ");
            } else {
                startTimes = DateUtil.daFormatYmd((Long)Long.parseLong(startTime)) + " 00:00:00";
                endTimes = DateUtil.daFormatYmd((Long)Long.parseLong(endTime)) + " 23:59:59";
                dbSql.append(" AND c.CREATOR_TIME Between  '" + startTimes + "' AND '" + endTimes + "' ");
            }
        }
        String string3 = flowId = paginationFlowTask.getFlowId() != null ? paginationFlowTask.getFlowId() : null;
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)flowId)) {
            dbSql.append(" AND t.FLOW_ID = '" + flowId + "'");
        }
        String string4 = flowCategory = paginationFlowTask.getFlowCategory() != null ? paginationFlowTask.getFlowCategory() : null;
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)flowCategory)) {
            dbSql.append(" AND t.FLOW_CATEGORY = '" + flowCategory + "'");
        }
        String string5 = creatorUserId = paginationFlowTask.getCreatorUserId() != null ? paginationFlowTask.getCreatorUserId() : null;
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)creatorUserId)) {
            dbSql.append(" AND t.CREATOR_USER_ID = '" + creatorUserId + "'");
        }
        if ("desc".equals(paginationFlowTask.getSort().toLowerCase())) {
            dbSql.append(" Order by CREATOR_TIME DESC");
        } else {
            dbSql.append(" Order by CREATOR_TIME DESC");
        }
        List<FlowTaskListModel> data = ((FlowTaskMapper)this.baseMapper).getCirculateList(dbSql.toString());
        for (FlowTaskListModel task : data) {
            List<FlowTaskOperatorEntity> operatorList = this.flowTaskOperatorService.getAllByNodeId(task.getId(), task.getThisNodeId());
            if (!CollectionUtil.isNotEmpty(operatorList)) continue;
            if (operatorList.size() > 1) {
                ArrayList strings = new ArrayList();
                operatorList.stream().forEach(operator -> {
                    UserEntity userInfo = this.userService.getInfo(operator.getHandleId());
                    strings.add(userInfo.getRealName());
                });
                String handleName = strings.stream().collect(Collectors.joining(","));
                task.setThisNode(task.getThisNode() + "-" + handleName);
                continue;
            }
            UserEntity userEntity = this.userService.getInfo(operatorList.get(0).getHandleId());
            if (task.getThisNode().equals(userEntity.getRealName())) continue;
            task.setThisNode(task.getThisNode() + "-" + userEntity.getRealName());
        }
        return paginationFlowTask.setData(PageUtil.getPage((int)((int)paginationFlowTask.getCurrentPage()), (int)((int)paginationFlowTask.getPageSize()), data), data.size());
    }

    @Override
    public FlowTaskEntity getInfo(String id) throws WorkFlowException {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(FlowTaskEntity::getId, (Object)id);
        FlowTaskEntity entity = (FlowTaskEntity)this.getOne((Wrapper)queryWrapper);
        if (entity == null) {
            throw new WorkFlowException(MsgCode.WF115.get());
        }
        return entity;
    }

    @Override
    public FlowTaskEntity getDraftTaskByProcessId(String processId) throws WorkFlowException {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(FlowTaskEntity::getProcessId, (Object)processId)).orderByDesc(FlowTaskEntity::getId);
        List list = this.list((Wrapper)queryWrapper);
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            return (FlowTaskEntity)list.get(0);
        }
        return null;
    }

    @Override
    public void update(FlowTaskEntity entity) {
        this.updateById(entity);
    }

    @Override
    public void create(FlowTaskEntity entity) {
        this.save(entity);
    }

    @Override
    public FlowTaskEntity getInfoSubmit(String id, SFunction<FlowTaskEntity, ?> ... columns) {
        List<FlowTaskEntity> list = this.getInfosSubmit(new String[]{id}, columns);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public List<FlowTaskEntity> getInfosSubmit(String[] ids, SFunction<FlowTaskEntity, ?> ... columns) {
        List resultList = Collections.emptyList();
        if (ids == null || ids.length == 0) {
            return resultList;
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (ids.length == 1) {
            queryWrapper.select(columns).and(t -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)t.eq(FlowTaskEntity::getId, (Object)ids[0]);
            });
            resultList = this.list((Wrapper)queryWrapper);
            if (resultList.isEmpty()) {
                queryWrapper = new LambdaQueryWrapper();
                queryWrapper.select(columns).and(t -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)t.eq(FlowTaskEntity::getProcessId, (Object)ids[0]);
                });
                resultList = this.list((Wrapper)queryWrapper);
            }
        } else {
            queryWrapper.select(new SFunction[]{FlowTaskEntity::getId}).and(t -> ((LambdaQueryWrapper)((LambdaQueryWrapper)t.in(FlowTaskEntity::getId, (Object[])ids)).or()).in(FlowTaskEntity::getProcessId, (Object[])ids));
            List resultIds = this.listObjs((Wrapper)queryWrapper, t -> t.toString());
            if (!resultIds.isEmpty()) {
                queryWrapper = new LambdaQueryWrapper();
                queryWrapper.select(columns).in(FlowTaskEntity::getId, (Collection)resultIds);
                resultList = this.list((Wrapper)queryWrapper);
            }
        }
        return resultList;
    }

    @Override
    public void delete(final FlowTaskEntity entity) throws WorkFlowException {
        if (!this.checkStatus(entity.getStatus())) {
            throw new WorkFlowException(MsgCode.WF116.get());
        }
        ArrayList idList = new ArrayList(){
            {
                this.add(entity.getId());
            }
        };
        this.flowMsgUtil.deleteEvent(7, entity);
        this.saveDeleteTaskRecord(entity);
        this.deleteAll(idList, true, true);
    }

    public void saveDeleteTaskRecord(FlowTaskEntity entity) {
        FlowTaskDeleteRecordEntity deleteRecordEntity = new FlowTaskDeleteRecordEntity();
        deleteRecordEntity.setId(RandomUtil.uuId());
        deleteRecordEntity.setTaskId(entity.getId());
        deleteRecordEntity.setProcessId(entity.getProcessId());
        deleteRecordEntity.setFullName(entity.getFullName());
        deleteRecordEntity.setEncode(entity.getFlowCode());
        deleteRecordEntity.setDeleteUserId(this.userProvider.get().getUserId());
        deleteRecordEntity.setDeleteTime(new Date());
        this.flowTaskDeleteRecordService.save(deleteRecordEntity);
    }

    @Override
    public void deleteChild(FlowTaskEntity entity) {
        List<FlowTaskEntity> flowTaskList = this.getChildList(entity.getId(), FlowTaskEntity::getId);
        List<String> idList = flowTaskList.stream().map(FlowTaskEntity::getId).collect(Collectors.toList());
        this.deleteAll(idList, true, true);
    }

    @Override
    public void delete(String[] ids) throws WorkFlowException {
        if (ids.length > 0) {
            boolean isDel;
            List<FlowTaskEntity> flowTaskList = this.getOrderStaList(Arrays.asList(ids));
            boolean bl = isDel = flowTaskList.stream().filter(t -> t.getFlowType() == 1).count() > 0L;
            if (isDel) {
                throw new WorkFlowException(MsgCode.WF117.get());
            }
            boolean bl2 = isDel = flowTaskList.stream().filter(t -> !FlowNature.ParentId.equals(t.getParentId()) && StringUtils.isNotEmpty((String)t.getParentId())).count() > 0L;
            if (isDel) {
                throw new WorkFlowException(MsgCode.WF118.get());
            }
            List<String> idList = Arrays.asList(ids);
            this.deleteAll(idList, true, true);
        }
    }

    @Override
    public List<FlowTaskEntity> getTaskList(String id, SFunction<FlowTaskEntity, ?> ... columns) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(FlowTaskEntity::getFlowId, (Object)id);
        queryWrapper.lambda().select(columns);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<FlowTaskEntity> getOrderStaList(List<String> id) {
        List<FlowTaskEntity> list = new ArrayList<FlowTaskEntity>();
        if (id.size() > 0) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().in(FlowTaskEntity::getId, id);
            list = this.list((Wrapper)queryWrapper);
        }
        return list;
    }

    @Override
    public List<FlowTaskEntity> getChildList(String id, SFunction<FlowTaskEntity, ?> ... columns) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().select(columns).in(FlowTaskEntity::getParentId, new Object[]{id});
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<FlowTaskEntity> getTaskFlowList(String flowId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(FlowTaskEntity::getFlowId, (Object)flowId);
        ArrayList list = new ArrayList(){
            {
                this.add(2);
                this.add(5);
            }
        };
        queryWrapper.lambda().notIn(FlowTaskEntity::getStatus, (Collection)list);
        queryWrapper.lambda().eq(FlowTaskEntity::getIsBatch, (Object)1);
        queryWrapper.lambda().select(new SFunction[]{FlowTaskEntity::getId});
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<FlowTaskEntity> getFlowList(String flowId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(FlowTaskEntity::getFlowId, (Object)flowId);
        queryWrapper.lambda().select(new SFunction[]{FlowTaskEntity::getId});
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<FlowBatchModel> batchFlowSelector() {
        List<FlowTaskOperatorEntity> operatorList = this.flowTaskOperatorService.getBatchList();
        List<String> taskIdList = operatorList.stream().map(FlowTaskOperatorEntity::getTaskId).collect(Collectors.toList());
        List<FlowTaskEntity> taskList = this.getOrderStaList(taskIdList);
        Map<String, List<FlowTaskEntity>> flowIdList = taskList.stream().filter(t -> ObjectUtil.isNotEmpty((Object)t.getIsBatch()) && t.getIsBatch() == 1).collect(Collectors.groupingBy(FlowTaskEntity::getFlowId));
        ArrayList<FlowBatchModel> batchFlowList = new ArrayList();
        for (String key : flowIdList.keySet()) {
            List<FlowTaskEntity> flowTaskList = flowIdList.get(key);
            List flowTask = flowTaskList.stream().map(FlowTaskEntity::getId).collect(Collectors.toList());
            if (flowTaskList.size() <= 0) continue;
            String flowName = flowTaskList.stream().map(FlowTaskEntity::getFlowName).distinct().collect(Collectors.joining(","));
            String flowId = flowTaskList.stream().map(FlowTaskEntity::getFlowId).distinct().collect(Collectors.joining(","));
            Long count = operatorList.stream().filter(t -> flowTask.contains(t.getTaskId())).count();
            FlowBatchModel batchModel = new FlowBatchModel();
            batchModel.setNum(count);
            batchModel.setId(flowId);
            batchModel.setFullName(flowName + "(" + count + ")");
            batchFlowList.add(batchModel);
        }
        batchFlowList = batchFlowList.stream().sorted(Comparator.comparing(FlowBatchModel::getNum).reversed()).collect(Collectors.toList());
        return batchFlowList;
    }

    @Override
    public List<FlowTaskEntity> getListByVersionId(String versionId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().select(new SFunction[]{FlowTaskEntity::getId}).eq(FlowTaskEntity::getVersionId, (Object)versionId);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<FlowTaskEntity> getListByTemplateId(String templateId, List<Date> dateList) {
        if (CollectionUtil.isEmpty(dateList) || dateList.size() != 2) {
            return new ArrayList<FlowTaskEntity>();
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        Date startDate = dateList.get(0);
        Date endDate = dateList.get(1);
        ((LambdaQueryWrapper)queryWrapper.lambda().select(new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStartTime, FlowTaskEntity::getEndTime, FlowTaskEntity::getStatus}).eq(FlowTaskEntity::getTemplateId, (Object)templateId)).between(FlowTaskEntity::getStartTime, (Object)startDate, (Object)endDate);
        return this.list((Wrapper)queryWrapper);
    }

    private boolean checkStatus(int status) {
        return status == FlowTaskStatusEnum.Draft.getCode() || status == FlowTaskStatusEnum.Reject.getCode() || status == FlowTaskStatusEnum.Revoke.getCode();
    }

    private void deleteAll(List<String> idList, boolean isRecord, boolean isCirculate) {
        ArrayList<String> idAll = new ArrayList<String>();
        this.deleTaskAll(idList, idAll);
        if (idAll.size() > 0) {
            QueryWrapper task = new QueryWrapper();
            task.lambda().in(FlowTaskEntity::getId, idAll);
            this.remove((Wrapper)task);
            QueryWrapper node = new QueryWrapper();
            node.lambda().in(FlowTaskNodeEntity::getTaskId, idAll);
            this.flowTaskNodeService.remove((Wrapper)node);
            QueryWrapper operator = new QueryWrapper();
            operator.lambda().in(FlowTaskOperatorEntity::getTaskId, idAll);
            this.flowTaskOperatorService.remove((Wrapper)operator);
            if (isRecord) {
                QueryWrapper record = new QueryWrapper();
                record.lambda().in(FlowTaskOperatorRecordEntity::getTaskId, idAll);
                this.flowTaskOperatorRecordService.remove((Wrapper)record);
            }
            if (isCirculate) {
                QueryWrapper circulate = new QueryWrapper();
                circulate.lambda().in(FlowTaskCirculateEntity::getTaskId, idAll);
                this.flowTaskCirculateService.remove((Wrapper)circulate);
            }
        }
    }

    private void deleTaskAll(List<String> idList, List<String> idAll) {
        idAll.addAll(idList);
        for (String id : idList) {
            List<FlowTaskEntity> taskAll = this.getChildList(id, FlowTaskEntity::getId);
            List<String> list = taskAll.stream().map(FlowTaskEntity::getId).collect(Collectors.toList());
            this.deleTaskAll(list, idAll);
        }
    }

    private static /* synthetic */ boolean lambda$getTrialList$21(Date beginDate, Date endDate, FlowTaskListModel task) {
        Date taskHandleTime = task.getHandleTime();
        return taskHandleTime != null && !taskHandleTime.before(beginDate) && !taskHandleTime.after(endDate);
    }

    private static /* synthetic */ boolean lambda$getTrialListNoPage$19(Date beginDate, Date endDate, FlowTaskListModel task) {
        Date taskHandleTime = task.getHandleTime();
        return taskHandleTime != null && !taskHandleTime.before(beginDate) && !taskHandleTime.after(endDate);
    }
}

