package com.bringspring.workflow.form.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.util.Date;

/**
 * 流程表单【请假申请】
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月27日 上午9:18
 */
@Data
@TableName("wform_leaveapply")
public class LeaveApplyEntity {
    /**
     * 主键
     */
    @TableId("ID")
    private String id;

    /**
     * 流程主键
     */
    @TableField("FLOWID")
    private String flowId;

    /**
     * 流程标题
     */
    @TableField("FLOWTITLE")
    private String flowTitle;

    /**
     * 紧急程度
     */
    @TableField("FLOWURGENT")
    private Integer flowUrgent;

    /**
     * 单据编码
     */
    @TableField("BILLNO")
    private String billNo;

    /**
     * 申请人员
     */
    @TableField("APPLYUSER")
    private String applyUser;

    /**
     * 申请日期
     */
    @TableField("APPLYDATE")
    private Date applyDate;

    /**
     * 申请部门
     */
    @TableField("APPLYDEPT")
    private String applyDept;

    /**
     * 申请职位
     */
    @TableField("APPLYPOST")
    private String applyPost;

    /**
     * 请假类别
     */
    @TableField("LEAVETYPE")
    private String leaveType;

    /**
     * 请假原因
     */
    @TableField("LEAVEREASON")
    private String leaveReason;

    /**
     * 请假时间
     */
    @TableField("LEAVESTARTTIME")
    private Date leaveStartTime;

    /**
     * 结束时间
     */
    @TableField("LEAVEENDTIME")
    private Date leaveEndTime;

    /**
     * 请假天数
     */
    @TableField("LEAVEDAYCOUNT")
    private String leaveDayCount;

    /**
     * 请假小时
     */
    @TableField("LEAVEHOUR")
    private String leaveHour;

    /**
     * 相关附件
     */
    @TableField("FILEJSON")
    private String fileJson;

    /**
     * 备注
     */
    @TableField("DESCRIPTION")
    private String description;
}
