package com.bringspring.workflow.engine.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.util.Date;

/**
 * 流程经办
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月27日 上午9:18
 */
@Data
@TableName("FLOW_TASK_OPERATOR")
public class FlowTaskOperatorEntity {
    /**
     * 节点经办主键
     */
    @TableId("ID")
    private String id;

    /**
     * 经办对象
     */
    @TableField("HANDLE_TYPE")
    private String handleType;

    /**
     * 节点类型
     */
    @TableField("Type")
    private String type;

    /**
     * 经办主键
     */
    @TableField("HANDLE_ID")
    private String handleId;

    /**
     * 处理状态 0-拒绝、1-同意
     */
    @TableField(value = "HANDLE_STATUS",fill = FieldFill.UPDATE)
    private Integer handleStatus;

    /**
     * 处理时间
     */
    @TableField(value = "HANDLE_TIME",fill = FieldFill.UPDATE)
    private Date handleTime;

    /**
     * 节点编码
     */
    @TableField("NODE_CODE")
    private String nodeCode;

    /**
     * 节点意见
     */
    @TableField(exist = false)
    private String handleOpinion;

    /**
     * 节点名称
     */
    @TableField("NODE_NAME")
    private String nodeName;

    /**
     * 是否完成
     */
    @TableField("COMPLETION")
    private Integer completion;

    /**
     * 描述
     */
    @TableField("DESCRIPTION")
    private String description;

    /**
     * 创建时间
     */
    @TableField(value = "CREATOR_TIME",fill = FieldFill.INSERT)
    private Date creatorTime;

    /**
     * 节点主键
     */
    @TableField("TASK_NODE_ID")
    private String taskNodeId;

    /**
     * 任务主键
     */
    @TableField("TASK_ID")
    private String taskId;

    /**
     * 状态 0.新流程 -1.无用数据
     */
    @TableField("STATE")
    private Integer state;

    /**
     * 父节点id
     */
    @TableField("PARENT_ID")
    private String parentId;

    /**
     * 草稿数据
     */
    @TableField(value = "DRAFT_DATA",fill = FieldFill.UPDATE)
    private String draftData;
}
