package com.bringspring.workflow.engine.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.entity.UserRelationEntity;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.workflow.engine.entity.FlowEngineVisibleEntity;
import com.bringspring.workflow.engine.mapper.FlowEngineVisibleMapper;
import com.bringspring.workflow.engine.service.FlowEngineVisibleService;
import com.bringspring.workflow.engine.util.ServiceAllUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 流程可见
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月27日 上午9:18
 */
@Service
public class FlowEngineVisibleServiceImpl extends ServiceImpl<FlowEngineVisibleMapper, FlowEngineVisibleEntity> implements FlowEngineVisibleService {

    @Autowired
    private ServiceAllUtil serviceUtil;

    @Autowired
    private UserProvider userProvider;

    @Autowired
    private AuthorizeService authorizeService;

    @Autowired
    private FlowEngineVisibleService flowEngineVisibleService;

    @Autowired
    private FlowEngineVisibleMapper flowEngineVisibleMapper;

    @Override
    public List<FlowEngineVisibleEntity> getList(String flowId) {
        QueryWrapper<FlowEngineVisibleEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(FlowEngineVisibleEntity::getFlowId, flowId);
        queryWrapper.lambda().orderByAsc(FlowEngineVisibleEntity::getSortCode).orderByDesc(FlowEngineVisibleEntity::getCreatorTime);
        return this.list(queryWrapper);
    }

    @Override
    public List<FlowEngineVisibleEntity> getVisibleFlowList(String userId) {
        List<String> userList = new ArrayList<>();
        userList.add(userId);
        UserInfo userInfo = userProvider.get();
        List<UserRelationEntity> list = serviceUtil.getListByUserIdAll(userList);
        List<String> userRelationList = list.stream().map(u -> u.getObjectId()).collect(Collectors.toList());
        userRelationList.add(userId);
        QueryWrapper<FlowEngineVisibleEntity> wrapper = new QueryWrapper<>();
        wrapper.lambda().in(FlowEngineVisibleEntity::getOperatorId, userRelationList);
        List<FlowEngineVisibleEntity> userIdList = this.list(wrapper);

        QueryWrapper<FlowEngineVisibleEntity> subQueryWrapper = new QueryWrapper<>();
        subQueryWrapper.select("select min(id) id from flow_engine_visible ")
                .groupBy("flow_id", "company_id")
                .having("COUNT(flow_id) < 2");

        QueryWrapper<FlowEngineVisibleEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.inSql("id", subQueryWrapper.getSqlSelect() + subQueryWrapper.getSqlSegment());
        queryWrapper.lambda().eq(FlowEngineVisibleEntity::getOperatorId, userInfo.getOrganizeId())
                .eq(FlowEngineVisibleEntity::getOperatorType, "company")
                .or()
                .eq(FlowEngineVisibleEntity::getCompanyId, "1");
        ;

        // 执行查询
        List<FlowEngineVisibleEntity> results = flowEngineVisibleMapper.selectList(queryWrapper);
        userIdList.addAll(results);

        return userIdList;
    }

    @Override
    public List<String> getListByFlowId(String flowId, String userId) {
        List<String> userList = new ArrayList<>();
        List<String> templateIdList = new ArrayList<>();
        userList.add(userId);
        UserInfo userInfo = userProvider.get();
        List<UserRelationEntity> list = serviceUtil.getListByUserIdAll(userList);
        List<String> userRelationList = list.stream().map(u -> u.getObjectId()).collect(Collectors.toList());
        userRelationList.add(userId);
        QueryWrapper<FlowEngineVisibleEntity> wrapper = new QueryWrapper<>();
        wrapper.lambda().in(FlowEngineVisibleEntity::getOperatorId, userRelationList);
        List<FlowEngineVisibleEntity> userIdList = this.list(wrapper);
        List<FlowEngineVisibleEntity> visibleList = this.getVisibleList(flowId);
        List<String> templateIds = userIdList.stream()
                .filter(user -> user.getFlowId().equals(flowId))
                .map(FlowEngineVisibleEntity::getTemplateId)
                .distinct()
                .collect(Collectors.toList());
        List<String> companyId = visibleList.stream().filter(visible -> visible.getOperatorId().equals(userInfo.getOrganizeId()) || ("1").equals(visible.getCompanyId()))
                .map(FlowEngineVisibleEntity::getTemplateId)
                .collect(Collectors.toList());
        templateIdList.addAll(templateIds);
        templateIdList.addAll(companyId);


        return templateIdList;
    }

    public List<FlowEngineVisibleEntity> getVisibleList(String flowId) {
        QueryWrapper<FlowEngineVisibleEntity> wrapper = new QueryWrapper<>();
        wrapper.lambda().eq(FlowEngineVisibleEntity::getFlowId, flowId);
        return this.list(wrapper);
    }


    @Override
    public List<FlowEngineVisibleEntity> getAllCompanyVisibleFlowList(String userId, String menuId) {
        UserInfo userInfo = userProvider.get();
        QueryWrapper<FlowEngineVisibleEntity> queryWrapper = new QueryWrapper<>();
        //按照数据权限查询数据
        if (!userInfo.getIsAdministrator()) {
            if (Objects.nonNull(menuId)) {
                if (!userProvider.get().getIsAdministrator()) {
                    Object companyAuth = authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, menuId, "flow_engine_visible"));
                    if (ObjectUtil.isEmpty(companyAuth)) {
                        return new ArrayList<>();
                    }
                    queryWrapper = (QueryWrapper<FlowEngineVisibleEntity>) companyAuth;

                }
            }
        } else {
            return new ArrayList<>();
        }

        return list(queryWrapper);
    }

}
