package com.bringspring.workflow.engine.controller;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.filter.RepeatSubmit;
import com.bringspring.common.util.CacheUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.workflow.engine.entity.*;
import com.bringspring.workflow.engine.enums.FlowNodeEnum;
import com.bringspring.workflow.engine.model.FlowHandleModel;
import com.bringspring.workflow.engine.model.flowbefore.FlowBatchModel;
import com.bringspring.workflow.engine.model.flowbefore.FlowBeforeInfoVO;
import com.bringspring.workflow.engine.model.flowbefore.FlowBeforeListVO;
import com.bringspring.workflow.engine.model.flowbefore.FlowSummary;
import com.bringspring.workflow.engine.model.flowcandidate.FlowCandidateUserModel;
import com.bringspring.workflow.engine.model.flowcandidate.FlowCandidateVO;
import com.bringspring.workflow.engine.model.flowengine.FlowModel;
import com.bringspring.workflow.engine.model.flowengine.shuntjson.childnode.ChildNode;
import com.bringspring.workflow.engine.model.flowengine.shuntjson.nodejson.ChildNodeList;
import com.bringspring.workflow.engine.model.flowengine.shuntjson.nodejson.ConditionList;
import com.bringspring.workflow.engine.model.flowtask.FlowTaskListModel;
import com.bringspring.workflow.engine.model.flowtask.PaginationFlowTask;
import com.bringspring.workflow.engine.service.*;
import com.bringspring.workflow.engine.util.FlowJsonUtil;
import com.bringspring.workflow.engine.util.FlowNature;
import com.bringspring.workflow.engine.util.ServiceAllUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static com.bringspring.common.constant.CacheConsts.SHORT_CACHE;

/**
 * 待我审核
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月27日 上午9:18
 */
@Api(tags = "待我审核", value = "FlowBefore")
@RestController
@RequestMapping("/api/workflow/Engine/FlowBefore")
public class FlowBeforeController {


    @Autowired
    private ServiceAllUtil serviceUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private CacheUtil cacheUtil;
    @Autowired
    private FlowTaskService flowTaskService;
    @Autowired
    private FlowTaskOperatorService flowTaskOperatorService;
    @Autowired
    private FlowTaskOperatorRecordService flowTaskOperatorRecordService;
    @Autowired
    private FlowTaskNodeService flowTaskNodeService;
    @Autowired
    private FlowEngineService flowEngineService;
    @Autowired
    private FlowTaskNewService flowTaskNewService;
    @Autowired
    private UserService userService;
    @Autowired
    private FlowEngineTemplateService flowEngineTemplateService;

    /**
     * 获取待我审核列表
     *
     * @param category           分类
     * @param paginationFlowTask
     * @return
     */
    @ApiOperation("获取待我审核列表(有带分页)，1-待办事宜，2-已办事宜，3-抄送事宜,4-批量审批")
    @GetMapping("/List/{category}")
    public ActionResult list(@PathVariable("category") String category, PaginationFlowTask paginationFlowTask) {
        List<FlowTaskListModel> data = new ArrayList<>();
        if (FlowNature.WAIT.equals(category)) {
            data = flowTaskService.getWaitList(paginationFlowTask);
        } else if (FlowNature.TRIAL.equals(category)) {
            data = flowTaskService.getTrialList(paginationFlowTask);
        } else if (FlowNature.CIRCULATE.equals(category)) {
            data = flowTaskService.getCirculateList(paginationFlowTask);
        } else if (FlowNature.BATCH.equals(category)) {
            data = flowTaskService.getBatchWaitList(paginationFlowTask);
        }
        List<FlowBeforeListVO> listVO = new LinkedList<>();
        List<UserEntity> userList = serviceUtil.getUserName(data.stream().map(t -> t.getCreatorUserId()).collect(Collectors.toList()));
        List<FlowEngineEntity> engineList = flowEngineService.getFlowList(data.stream().map(t -> t.getFlowId()).collect(Collectors.toList()));
        boolean isBatch = FlowNature.BATCH.equals(category);
        for (FlowTaskListModel task : data) {
            FlowBeforeListVO vo = JsonUtil.getJsonToBean(task, FlowBeforeListVO.class);
            //用户名称赋值
            UserEntity user = userList.stream().filter(t -> t.getId().equals(vo.getCreatorUserId())).findFirst().orElse(null);
            vo.setUserName(user != null ? user.getRealName() : "");
            FlowEngineEntity engine = engineList.stream().filter(t -> t.getId().equals(vo.getFlowId())).findFirst().orElse(null);
            if (engine != null) {
                vo.setFormType(engine.getFormType());
            }

            if (!ObjectUtil.isNull(user)) {
                String userCompany = userService.getUserCompanyShortName(user.getId());
                vo.setCompanyName(userCompany);
            }
            if (isBatch) {
                ChildNodeList childNode = JsonUtil.getJsonToBean(vo.getApproversProperties(), ChildNodeList.class);
                vo.setApproversProperties(JsonUtil.getObjectToString(childNode.getProperties()));
            }
//            vo.setFlowVersion(StringUtil.isEmpty(vo.getFlowVersion()) ? "" : "v" + vo.getFlowVersion());
            vo.setFlowVersion(StringUtils.isEmpty(vo.getFlowVersion()) ? "" : "v" + vo.getFlowVersion());
            listVO.add(vo);
        }
        PaginationVO paginationVO = JsonUtil.getJsonToBean(paginationFlowTask, PaginationVO.class);
        return ActionResult.page(listVO, paginationVO);
    }

    /**
     * 获取待我审批信息
     *
     * @param id 主键值
     * @return
     */
    @ApiOperation("获取待我审批信息")
    @GetMapping("/{id}")
    public ActionResult info(@PathVariable("id") String id, String taskNodeId, String taskOperatorId) throws WorkFlowException {
        FlowBeforeInfoVO vo = flowTaskNewService.getBeforeInfo(id, taskNodeId, taskOperatorId);
        return ActionResult.success(vo);
    }
    /**
     * 查询最新的任务ID
     *
     * @param processId 业务主键值
     * @return
     */
    @ApiOperation("获取待我审批信息")
    @GetMapping("/getDraftTaskByProcessId/{processId}")
    public ActionResult getDraftTaskByProcessId(@PathVariable("processId") String processId) throws WorkFlowException {
        FlowTaskEntity draftTaskByProcessId = flowTaskService.getDraftTaskByProcessId(processId);
        return ActionResult.success(draftTaskByProcessId);
    }
    /**
     * 待我审核-审核
     *
     * @param id              待办主键值
     * @param flowHandleModel 流程经办
     * @return
     */
    @ApiOperation("待我审核-审核")
    @PostMapping("/Audit/{id}")
    @RepeatSubmit
    @DSTransactional
    public ActionResult audit(@PathVariable("id") String id, @RequestBody FlowHandleModel flowHandleModel) throws WorkFlowException {
        FlowTaskOperatorEntity operator = flowTaskOperatorService.getInfo(id);
        FlowTaskEntity flowTask = flowTaskService.getInfo(operator.getTaskId());
        flowTaskNewService.permissions(operator.getHandleId(), flowTask, operator, "");
        if (FlowNature.ProcessCompletion.equals(operator.getCompletion())) {
            FlowModel flowModel = JsonUtil.getJsonToBean(flowHandleModel, FlowModel.class);
            flowModel.setFlowId(String.valueOf(flowModel.getFormData().get("flowId")));
            UserInfo userInfo = userProvider.get();
            String rejecttKey = userInfo.getTenantId() + id;
            if (cacheUtil.exists(SHORT_CACHE, rejecttKey)) {
                throw new WorkFlowException(MsgCode.WF005.get());
            }
            cacheUtil.insert(SHORT_CACHE, rejecttKey, id, 10);
            flowTaskNewService.audit(flowTask, operator, flowModel);
            return ActionResult.success("审核成功");
        } else {
            return ActionResult.fail(MsgCode.WF005.get());
        }
    }

    /**
     * 保存草稿
     *
     * @param id              待办主键值
     * @param flowHandleModel 流程经办
     * @return
     */
    @DSTransactional
    @ApiOperation("保存草稿")
    @PostMapping("/SaveAudit/{id}")
    public ActionResult saveAudit(@PathVariable("id") String id, @RequestBody FlowHandleModel flowHandleModel) throws WorkFlowException {
        FlowTaskOperatorEntity flowTaskOperatorEntity = flowTaskOperatorService.getInfo(id);
        if (flowTaskOperatorEntity != null) {
            FlowTaskEntity flowTaskEntity = flowTaskService.getInfo(flowTaskOperatorEntity.getTaskId());
            FlowEngineEntity engine = flowEngineService.getInfo(flowTaskEntity.getFlowId());
            Map<String, Object> formDataAll = flowHandleModel.getFormData();
            if (FlowNature.CUSTOM.equals(engine.getFormType())) {
                Object data = formDataAll.get("data");
                if (data != null) {
                    formDataAll = JsonUtil.stringToMap(String.valueOf(data));
                }
            }
            flowTaskOperatorEntity.setDraftData(JsonUtil.getObjectToString(formDataAll));
            flowTaskOperatorService.updateById(flowTaskOperatorEntity);
            return ActionResult.success(MsgCode.SU002.get());
        }
        return ActionResult.fail(MsgCode.FA001.get());
    }
    /**
     * 加签
     *
     * @param taskOperatorId  待办主键值
     * @param flowHandleModel 流程经办
     * @return
     */
    @ApiOperation("加签")
    @PostMapping("/freeApproval/{taskOperatorId}")
    public ActionResult freeApproval(@PathVariable("taskOperatorId") String taskOperatorId, @RequestBody FlowHandleModel flowHandleModel) throws WorkFlowException {
        FlowTaskOperatorEntity operator = flowTaskOperatorService.getInfo(taskOperatorId);
        FlowTaskEntity flowTask = flowTaskService.getInfo(operator.getTaskId());
        flowTaskNewService.permissions(operator.getHandleId(), flowTask, operator, "");
        flowTaskNewService.freeApproval(operator,flowHandleModel);
        return ActionResult.success("加签成功");
    }
    /**
     * 审批汇总
     *
     * @param id       待办主键值
     * @param category 类型
     * @return
     */
    @ApiOperation("审批汇总")
    @GetMapping("/RecordList/{id}")
    public ActionResult recordList(@PathVariable("id") String id, String category, String type) {
        List<FlowSummary> flowSummaries = flowTaskNewService.recordList(id, category, type);
        return ActionResult.success(flowSummaries);
    }

    /**
     * 待我审核驳回
     *
     * @param taskOperatorId  待办主键值
     * @param flowHandleModel 经办信息
     * @return
     */
    @ApiOperation("待我审核驳回")
    @RepeatSubmit
    @PostMapping("/Reject/{taskOperatorId}")
    public ActionResult reject(@PathVariable("taskOperatorId") String taskOperatorId, @RequestBody FlowHandleModel flowHandleModel) throws WorkFlowException {
        FlowTaskOperatorEntity operator = flowTaskOperatorService.getInfo(taskOperatorId);
        FlowTaskEntity flowTask = flowTaskService.getInfo(operator.getTaskId());
        flowTaskNewService.permissions(operator.getHandleId(), flowTask, operator, "");
        if (FlowNature.ProcessCompletion.equals(operator.getCompletion())) {
            FlowModel flowModel = JsonUtil.getJsonToBean(flowHandleModel, FlowModel.class);
            flowModel.setFlowId(String.valueOf(flowModel.getFormData().get("flowId")));
            UserInfo userInfo = userProvider.get();
            String rejecttKey = userInfo.getTenantId() + taskOperatorId;
            if (cacheUtil.exists(SHORT_CACHE, rejecttKey)) {
                throw new WorkFlowException(MsgCode.WF112.get());
            }
            cacheUtil.insert(SHORT_CACHE, rejecttKey, taskOperatorId, 10);
            flowModel.setProcessId(flowTask.getProcessId());
            flowTaskNewService.reject(flowTask, operator, flowModel);
            return ActionResult.success("驳回成功");
        } else {
            return ActionResult.fail("已审核完成");
        }
    }

    /**
     * 待我审核转办
     *
     * @param taskOperatorId  主键值
     * @param flowHandleModel 经办信息
     * @return
     */
    @ApiOperation("待我审核转办")
    @PostMapping("/Transfer/{taskOperatorId}")
    public ActionResult transfer(@PathVariable("taskOperatorId") String taskOperatorId, @RequestBody FlowHandleModel flowHandleModel) throws WorkFlowException {
        FlowTaskOperatorEntity operator = flowTaskOperatorService.getInfo(taskOperatorId);
        FlowTaskEntity flowTask = flowTaskService.getInfo(operator.getTaskId());
        flowTaskNewService.permissions(operator.getHandleId(), flowTask, operator, "");
        operator.setHandleId(flowHandleModel.getFreeApproverUserId());
        operator.setHandleOpinion(flowHandleModel.getHandleOpinion());
        flowTaskNewService.transfer(operator);
        return ActionResult.success("转办成功");
    }

    /**
     * 待我审核撤回审核
     * 注意：在撤销流程时要保证你的下一节点没有处理这条记录；如已处理则无法撤销流程。
     *
     * @param id              主键值
     * @param flowHandleModel 实体对象
     * @return
     */
    @ApiOperation("待我审核撤回审核")
    @PostMapping("/Recall/{id}")
    public ActionResult recall(@PathVariable("id") String id, @RequestBody FlowHandleModel flowHandleModel) throws WorkFlowException {
        FlowTaskOperatorRecordEntity operatorRecord = flowTaskOperatorRecordService.getInfo(id);
        List<FlowTaskNodeEntity> nodeList = flowTaskNodeService.getList(operatorRecord.getTaskId()).stream().filter(t -> FlowNodeEnum.Process.getCode().equals(t.getState())).collect(Collectors.toList());
        FlowTaskNodeEntity taskNode = nodeList.stream().filter(t -> t.getId().equals(operatorRecord.getTaskNodeId())).findFirst().orElse(null);
        if (taskNode != null) {
            FlowModel flowModel = JsonUtil.getJsonToBean(flowHandleModel, FlowModel.class);
            flowModel.setFlowId(String.valueOf(flowModel.getFormData().get("flowId")));
            flowTaskNewService.recall(id, operatorRecord, flowModel);
            return ActionResult.success("撤回成功");
        }
        return ActionResult.fail("撤回失败");
    }

    /**
     * 待我审核终止审核
     *
     * @param taskId          主键值
     * @param flowHandleModel 流程经办
     * @return
     */
    @ApiOperation("待我审核终止审核")
    @PostMapping("/Cancel/{taskId}")
    public ActionResult cancel(@PathVariable("taskId") String taskId, @RequestBody FlowHandleModel flowHandleModel) throws WorkFlowException {
        FlowTaskEntity flowTaskEntity = flowTaskService.getInfo(taskId);
        if (flowTaskEntity != null) {
        FlowModel flowModel = JsonUtil.getJsonToBean(flowHandleModel, FlowModel.class);
        flowModel.setFlowId(flowTaskEntity.getFlowId());
        flowTaskNewService.cancel(flowTaskEntity, flowModel);
        return ActionResult.success(MsgCode.SU009.get());
        }
        return ActionResult.fail(MsgCode.FA009.get());
    }

    /**
     * 指派人
     *
     * @param id              主键值
     * @param flowHandleModel 流程经办
     * @return
     */
    @ApiOperation("指派人")
    @PostMapping("/Assign/{id}")
    public ActionResult assign(@PathVariable("id") String id, @RequestBody FlowHandleModel flowHandleModel) throws WorkFlowException {
        FlowModel flowModel = JsonUtil.getJsonToBean(flowHandleModel, FlowModel.class);
        boolean isOk = flowTaskNewService.assign(id, flowModel);
        return isOk ? ActionResult.success("指派成功") : ActionResult.fail("指派失败");
    }

    /**
     * 获取候选人
     *
     * @param flowHandleModel 数据
     * @return
     */
    @ApiOperation("获取候选人节点")
    @PostMapping("/Candidates/{id}")
    public ActionResult candidates(@PathVariable("id") String id, @RequestBody FlowHandleModel flowHandleModel) throws WorkFlowException {
        List<FlowCandidateVO> candidate = flowTaskNewService.candidates(id, flowHandleModel);
        return ActionResult.success(candidate);
    }

    /**
     * 获取候选人
     *
     * @param flowHandleModel 数据
     * @return
     */
    @ApiOperation("获取候选人")
    @PostMapping("/CandidateUser/{id}")
    public ActionResult candidateUser(@PathVariable("id") String id, @RequestBody FlowHandleModel flowHandleModel) throws WorkFlowException {
        List<FlowCandidateUserModel> candidate = flowTaskNewService.candidateUser(id, flowHandleModel);
        PaginationVO paginationVO = JsonUtil.getJsonToBean(flowHandleModel, PaginationVO.class);
        return ActionResult.page(candidate, paginationVO);
    }

    /**
     * 批量审批引擎
     *
     * @return
     */
    @ApiOperation("批量审批引擎")
    @GetMapping("/BatchFlowSelector")
    public ActionResult batchFlowSelector() {
        List<FlowBatchModel> batchFlowList = flowTaskService.batchFlowSelector();
        return ActionResult.success(batchFlowList);
    }

    /**
     * 引擎节点
     *
     * @param id 主键值
     * @return
     * @throws WorkFlowException
     */
    @ApiOperation("引擎节点")
    @GetMapping("/NodeSelector/{id}")
    public ActionResult nodeSelector(@PathVariable("id") String id,@RequestParam("templateId") String templateId) throws WorkFlowException {
        FlowEngineEntity engine = flowEngineService.getInfo(id);
        //通过模板获取flowTemplateJson
        FlowEngineTemplateEntity template = flowEngineTemplateService.getById(templateId);
        List<FlowBatchModel> batchList = new ArrayList<>();
        ChildNode childNodeAll = JsonUtil.getJsonToBean(template.getFlowTemplateJson(), ChildNode.class);
        //获取流程节点
        List<ChildNodeList> nodeListAll = new ArrayList<>();
        List<ConditionList> conditionListAll = new ArrayList<>();
        //递归获取条件数据和节点数据
        FlowJsonUtil.getTemplateAll(childNodeAll, nodeListAll, conditionListAll);
        for (ChildNodeList childNodeList : nodeListAll) {
            if (!FlowNature.NodeStart.equals(childNodeList.getCustom().getType())) {
                FlowBatchModel batchModel = new FlowBatchModel();
                batchModel.setFullName(childNodeList.getProperties().getTitle());
                batchModel.setId(childNodeList.getCustom().getNodeId());
                batchList.add(batchModel);
            }
        }
        return ActionResult.success(batchList);
    }

    /**
     * 批量审批
     *
     * @param flowHandleModel 数据
     * @return
     * @throws WorkFlowException
     */
    @ApiOperation("批量审批")
    @PostMapping("/BatchOperation")
    public ActionResult batchOperation(@RequestBody FlowHandleModel flowHandleModel) throws WorkFlowException {
        flowTaskNewService.batch(flowHandleModel);
        return ActionResult.success("批量操作完成");
    }

    /**
     * 批量获取候选人
     *
     * @param taskOperatorId 代办数据
     * @return
     * @throws WorkFlowException
     */
    @ApiOperation("批量获取候选人")
    @GetMapping("/BatchCandidate")
    public ActionResult batchCandidate(String flowId, String taskOperatorId) throws WorkFlowException {
        List<FlowCandidateVO> candidate = flowTaskNewService.batchCandidates(flowId, taskOperatorId);
        return ActionResult.success(candidate);
    }

    /**
     * 消息跳转工作流
     *
     * @param id 代办id
     * @return
     * @throws WorkFlowException
     */
    @ApiOperation("消息跳转工作流")
    @GetMapping("/{id}/Info")
    public ActionResult taskOperatorId(@PathVariable("id") String id) throws WorkFlowException {
        FlowTaskOperatorEntity operator = flowTaskOperatorService.getInfo(id);
        FlowTaskEntity flowTask = flowTaskService.getInfo(operator.getTaskId());
        flowTaskNewService.permissions(operator.getHandleId(), flowTask, operator, "");
        return ActionResult.success();
    }

}
