/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.workflow.job;

import com.bringspring.common.database.data.DataSourceContextHolder;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.context.SpringContext;
import com.bringspring.workflow.engine.model.flowengine.FlowModel;
import com.bringspring.workflow.engine.service.FlowTaskNewService;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkJob
implements Job {
    private static final Logger log = LoggerFactory.getLogger(WorkJob.class);

    public void execute(JobExecutionContext context) {
        System.out.println("\u8fdb\u5165\u8c03\u5ea6");
        JobDataMap dataMap = context.getMergedJobDataMap();
        FlowModel model = dataMap.get((Object)"model") != null ? (FlowModel)dataMap.get((Object)"model") : null;
        String type = dataMap.getString("type");
        String id = dataMap.getString("id");
        String tenantId = dataMap.getString("tenantId");
        String tenantDbConnectionString = dataMap.getString("tenantDbConnectionString");
        try {
            if (model != null) {
                if (StringUtils.isNotEmpty((String)tenantId)) {
                    DataSourceContextHolder.setDatasource((String)tenantId, (String)tenantDbConnectionString);
                }
                FlowTaskNewService taskService = (FlowTaskNewService)SpringContext.getBean(FlowTaskNewService.class);
                if ("1".equals(type)) {
                    taskService.audit(id, model);
                } else {
                    taskService.reject(id, model);
                }
            }
        }
        catch (Exception e) {
            log.error("\u5de5\u4f5c\u6d41\u8c03\u5ea6\u62a5\u9519:" + e.getMessage());
        }
    }
}

