package com.bringspring.workflow.engine.model.flowengine.shuntjson.childnode;

/**
 * 审核自动同意规则
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 */
public enum AgreeRule {

    /**
     * 审批人为发起人
     */
    isCreator("isCreator"),
    /**
     * 审批人与上一审批节点处理人相同
     */
    isPreviousApprover("isPreviousApprover"),
    /**
     * 审批人审批过
     */
    isApprover("isApprover"),
    /**
     * 无审核人时
     */
    noApprover("noApprover");

    private String rule;

    AgreeRule(String rule) {
        this.rule = rule;
    }

    public String getRule() {
        return rule;
    }

    public void setRule(String rule) {
        this.rule = rule;
    }
}
