package com.bringspring.workflow.engine.model.flowbefore;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021/3/15 9:18
 */
@Data
public class FlowBeforeListVO {
    @ApiModelProperty(value = "流程编码")
    private String enCode;
    @ApiModelProperty(value = "发起人员")
    private String creatorUserId;
    @ApiModelProperty(value = "接收时间")
    private Long creatorTime;
    @ApiModelProperty(value = "经办节点")
    private String thisStep;
    @ApiModelProperty(value = "节点id")
    private String thisStepId;
    @ApiModelProperty(value = "当前节点")
    private String thisNode;
    @ApiModelProperty(value = "当前节点id")
    private String thisNodeId;
    @ApiModelProperty(value = "所属分类")
    private String flowCategory;
    @ApiModelProperty(value = "流程标题")
    private String fullName;
    @ApiModelProperty(value = "所属流程")
    private String flowName;
    @ApiModelProperty(value = "流程状态", example = "1")
    private Integer status;
    @ApiModelProperty(value = "发起时间")
    private Long startTime;
    @ApiModelProperty(value = "处理时间")
    private Long endTime;
    @ApiModelProperty(value = "主键id")
    private String id;
    @ApiModelProperty(value = "操作ID")
    private String taskOperatorId;
    @ApiModelProperty(value = "用户名称")
    private String userName;
    @ApiModelProperty(value = "备注")
    private String description;
    @ApiModelProperty(value = "流程编码")
    private String flowCode;
    @ApiModelProperty(value = "流程主键")
    private String flowId;
    @ApiModelProperty(value = "实例进程")
    private String processId;
    @ApiModelProperty(value = "表单类型 1-系统表单、2-动态表单")
    private Integer formType;
    @ApiModelProperty(value = "紧急程度")
    private Integer flowUrgent;
    @ApiModelProperty(value = "节点")
    private String nodeName;
    @ApiModelProperty(value = "办理时间")
    private Long handleTime;
    @ApiModelProperty(value = "节点对象")
    private String approversProperties;
    @ApiModelProperty(value = "版本")
    private String flowVersion;
    private String companyName;

}
