package com.bringspring.workflow.engine.service.impl;


import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.workflow.engine.entity.FlowEngineTemplateEntity;
import com.bringspring.workflow.engine.mapper.FlowEngineTemplateMapper;
import com.bringspring.workflow.engine.service.FlowEngineTemplateService;
import org.springframework.stereotype.Service;

import java.util.List;


/**
 * 流程模板
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2024年8月7日 上午10:46
 */
@Service
public class FlowEngineTemplateServiceImpl extends ServiceImpl<FlowEngineTemplateMapper, FlowEngineTemplateEntity> implements FlowEngineTemplateService {


    @Override
    public List<FlowEngineTemplateEntity> getListByFlowId(String flowId) {
        QueryWrapper<FlowEngineTemplateEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(FlowEngineTemplateEntity::getFlowId,flowId);
        return this.list(queryWrapper);
    }
}
