package com.bringspring.workflow.engine.util;

import com.bringspring.common.base.Pagination;
import com.bringspring.common.database.model.entity.DbLinkEntity;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.enums.DictionaryDataEnum;
import com.bringspring.system.base.entity.DictionaryDataEntity;
import com.bringspring.system.base.model.dbtable.DbTableCreate;
import com.bringspring.system.base.service.BillRuleService;
import com.bringspring.system.base.service.DataInterfaceService;
import com.bringspring.system.base.service.DbTableService;
import com.bringspring.system.base.service.DblinkService;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.system.base.service.MessageTemplateService;
import com.bringspring.system.message.model.message.SentMessageForm;
import com.bringspring.system.message.util.SentMessageUtil;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.PositionEntity;
import com.bringspring.system.permission.entity.RoleEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.entity.UserRelationEntity;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.PositionService;
import com.bringspring.system.permission.service.RoleService;
import com.bringspring.system.permission.service.UserRelationService;
import com.bringspring.system.permission.service.UserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * @author ：RKKJ开发平台组
 * @version: V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date ：2022/4/9 13:28
 */
@Component
public class ServiceAllUtil {

    Logger logger = LoggerFactory.getLogger(ServiceAllUtil.class);


    @Autowired
    private DblinkService dblinkService;
    @Autowired
    private DbTableService dbTableService;
    @Autowired
    private DictionaryDataService dictionaryDataService;
    @Autowired
    private UserRelationService userRelationService;
    @Autowired
    private UserService userService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private PositionService positionService;
    @Autowired
    private BillRuleService billRuleService;
    @Autowired
    private DataInterfaceService dataInterfaceService;
    @Autowired
    private SentMessageUtil sentMessageUtil;
    @Autowired
    private MessageTemplateService messageTemplateService;


    //--------------------------------数据连接------------------------------
    public DbLinkEntity getDbLink(String dbLink) {
        DbLinkEntity link = StringUtils.isNotEmpty(dbLink) ? dblinkService.getInfo(dbLink) : null;
        return link;
    }

    public void createTable(List<DbTableCreate> dbTable) throws DataException {
        for (DbTableCreate dbTableCreate : dbTable) {
            dbTableService.createTable(dbTableCreate);
        }
    }

    //--------------------------------数据字典------------------------------
    public List<DictionaryDataEntity> getDiList() {
        List<DictionaryDataEntity> dictionList = dictionaryDataService.getList(DictionaryDataEnum.FLOWWOEK_ENGINE.getDictionaryTypeId());
        return dictionList;
    }

    public List<DictionaryDataEntity> getDictionName(List<String> id) {
        List<DictionaryDataEntity> dictionList = dictionaryDataService.getDictionName(id,null);
        return dictionList;
    }

    //--------------------------------用户关系表------------------------------
    public List<UserRelationEntity> getListByUserIdAll(List<String> id) {
        List<UserRelationEntity> list = userRelationService.getListByUserIdAll(id);
        return list;
    }

    public List<UserRelationEntity> getListByObjectIdAll(List<String> objectIdList) {
        List<UserRelationEntity> list = userRelationService.getListByObjectIdAll(objectIdList);
        return list;
    }

    //--------------------------------用户------------------------------
    public List<UserEntity> getUserName(List<String> id) {
        List<UserEntity> list = userService.getUserName(id);
        return list;
    }

    public List<UserEntity> getUserName(List<String> id, Pagination pagination) {
        List<UserEntity> list = userService.getUserName(id, pagination);
        return list;
    }

    public UserEntity getUserInfo(String id) {
        UserEntity entity = StringUtils.isNotEmpty(id) ? userService.getInfo(id) : null;
        return entity;
    }

    public UserEntity getByRealName(String realName) {
        UserEntity entity = StringUtils.isNotEmpty(realName) ? userService.getByRealName(realName) : null;
        return entity;
    }

    //--------------------------------单据规则------------------------------
    public String getBillNumber(String enCode) {
        String billNo = "";
        try {
            billNo = billRuleService.getBillNumber(enCode, false);
        } catch (Exception e) {

        }
        return billNo;
    }

    public void useBillNumber(String enCode) {
        billRuleService.useBillNumber(enCode);
    }

    //--------------------------------角色------------------------------
    public List<RoleEntity> getListByIds(List<String> id) {
        List<RoleEntity> list = roleService.getListByIds(id);
        return list;
    }

    //--------------------------------组织------------------------------
    public List<OrganizeEntity> getOrganizeName(List<String> id) {
        List<OrganizeEntity> list = organizeService.getOrganizeName(id);
        return list;
    }

    public OrganizeEntity getOrganizeInfo(String id) {
        OrganizeEntity entity = StringUtils.isNotEmpty(id) ? organizeService.getInfo(id) : null;
        return entity;
    }

    public OrganizeEntity getOrganizeFullName(String fullName) {
        OrganizeEntity entity = organizeService.getByFullName(fullName);
        return entity;
    }

    public List<OrganizeEntity> getOrganizeId(String organizeId) {
        List<OrganizeEntity> organizeList = new ArrayList<>();
        organizeService.getOrganizeId(organizeId, organizeList);
        Collections.reverse(organizeList);
        return organizeList;
    }

    //--------------------------------岗位------------------------------
    public List<PositionEntity> getPositionName(List<String> id) {
        List<PositionEntity> list = positionService.getPositionName(id);
        return list;
    }

    public PositionEntity getPositionFullName(String fullName) {
        PositionEntity entity = positionService.getByFullName(fullName);
        return entity;
    }

    public PositionEntity getPositionInfo(String id) {
        PositionEntity entity = StringUtils.isNotEmpty(id) ? positionService.getInfo(id) : null;
        return entity;
    }

    //--------------------------------远端------------------------------
    public void infoToId(String interId, Map<String, String> parameterMap) {
        dataInterfaceService.infoToId(interId, null, parameterMap);
    }

    //--------------------------------发送消息------------------------------
    public void sendFlowMessage(List<SentMessageForm> messageListAll) {
        for (SentMessageForm messageForm : messageListAll) {
            if (messageForm.getToUserIds().size() > 0) {
                try {
                    sentMessageUtil.newSendMessage(messageForm);
                } catch (Exception e) {
                    logger.error("发消息异常,{}",e.getMessage());
                }
            }
        }
    }


    /*public void messagePush(SentMessageForm sentMessageForm) {
        if (WebTool.isNull(sentMessageForm))
            return;
        Map<String, String> map = new HashMap<>();
        map.put("title", sentMessageForm.getTitle());
        map.put("content", sentMessageForm.getContent());
        map.put("AppUrl", sentMessageForm.getUrl());
        // 消息时间
        map.put("MessageTime", sentMessageForm.getMessageTime());

        sentMessageForm.setParameterMap(map);
        sentMessageForm.setBodyText(map);
        List<SentMessageForm> messageListAll = new ArrayList<>();
        messageListAll.add(sentMessageForm);
        sendMessage(messageListAll);
    }

    public SentMessageForm getMessageForm(Integer type, String templateCode) {
        QueryWrapper<MessageTemplateEntity> templateEntityQueryWrapper = new QueryWrapper<>();
        templateEntityQueryWrapper.lambda().eq(MessageTemplateEntity::getEnCode, templateCode);
        MessageTemplateEntity one = messageTemplateService.getOne(templateEntityQueryWrapper);
        if (WebTool.isNull(one)) {
            logger.info("未配置消息模板,code:{}", templateCode);
            return null;
        }
        SentMessageForm sentMessageForm = new SentMessageForm();
        sentMessageForm.setType(type);
        sentMessageForm.setTemplateId(one.getId());
        sentMessageForm.setUrl(appPageConfig.getDomain());
        sentMessageForm.setMessageTime(DateUtil.dateFormat(new Date()));
        return sentMessageForm;
    }*/

}
