package com.bringspring.workflow.engine.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.database.model.DataSourceModel;
import com.bringspring.common.database.model.DbTableFieldModel;
import com.bringspring.common.database.model.entity.DbLinkEntity;
import com.bringspring.common.model.FormAllModel;
import com.bringspring.common.model.FormColumnTableModel;
import com.bringspring.common.model.FormEnum;
import com.bringspring.common.model.visiual.ComponentKeyConsts;
import com.bringspring.common.model.visiual.TableFields;
import com.bringspring.common.model.visiual.TableModel;
import com.bringspring.common.model.visiual.fields.FieLdsModel;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.base.model.dbtable.DbTableCreate;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author ：RKKJ开发平台组
 * @version: V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date ：2022/3/25 9:30
 */
@Slf4j
@Component
public class VisualDevTableCre {
    @Autowired
    private ServiceAllUtil serviceAllUtil;
    @Autowired
    private DataSourceModel dataSourceModel;

    /**
     * 表单赋值tableName
     *
     * @param jsonArray
     * @param tableModels
     */
    private void fieldsTableName(JSONArray jsonArray, List<TableModel> tableModels, boolean isO) {
        for (int i = 0; i < jsonArray.size(); i++) {
            JSONObject jsonObject = (JSONObject) jsonArray.get(i);
            String keyName = jsonObject.getJSONObject("__config__").getString("keyName");
            if (FormEnum.card.getMessage().equals(keyName) || FormEnum.row.getMessage().equals(keyName) || FormEnum.tab.getMessage().equals(keyName) || FormEnum.collapse.getMessage().equals(keyName) || StringUtils.isEmpty(keyName)) {
                JSONArray childArray = jsonObject.getJSONObject("__config__").getJSONArray("children");
                this.fieldsTableName(childArray, tableModels, isO);
                jsonObject.getJSONObject("__config__").put("children", childArray);
            } else if (FormEnum.table.getMessage().equals(keyName)) {
                JSONArray childrenList = new JSONArray();
                JSONArray children = jsonObject.getJSONObject("__config__").getJSONArray("children");
                String tableModel = "";
                for (int k = 0; k < children.size(); k++) {
                    JSONObject childrenObject = (JSONObject) children.get(k);
                    this.fieldsModel(childrenObject, tableModels, isO);
                    if (StringUtils.isEmpty(tableModel)) {
                        tableModel = childrenObject.getJSONObject("__config__").getString("relationTable");
                    }
                    childrenList.add(childrenObject);
                }
                jsonObject.getJSONObject("__config__").put("tableName", tableModel);
                jsonObject.getJSONObject("__config__").put("children", childrenList);
            } else {
                this.fieldsModel(jsonObject, tableModels, isO);
            }
        }
    }

    /**
     * 赋值table
     *
     * @param jsonObject
     * @param tableModels
     */
    private TableModel fieldsModel(JSONObject jsonObject, List<TableModel> tableModels, boolean isO) {
        String vModel = isO ? jsonObject.getString("__vModel__").toUpperCase() : jsonObject.getString("__vModel__");
        jsonObject.put("__vModel__",vModel);
        String relationField = StringUtils.isNotEmpty(jsonObject.getString("relationField")) ? jsonObject.getString("relationField") : "";
        String keyName = jsonObject.getJSONObject("__config__").getString("keyName");
        TableModel tableName = tableModels.stream().filter(t -> "1".equals(t.getTypeId())).findFirst().orElse(null);
        if (tableName != null) {
            jsonObject.getJSONObject("__config__").put("tableName", tableName.getTable());
        }
        List<TableModel> childTableAll = tableModels.stream().filter(t -> "0".equals(t.getTypeId())).collect(Collectors.toList());
        TableModel childTableaa = childTableAll.stream().filter(t -> t.getFields().stream().filter(k -> k.getField().equals(vModel)).count() > 0).findFirst().orElse(null);
        if (childTableaa != null) {
            jsonObject.getJSONObject("__config__").put("relationTable", childTableaa.getTable());
        }
        if (FormEnum.relationFormAttr.getMessage().equals(keyName) || FormEnum.popupAttr.getMessage().equals(keyName)) {
            if (StringUtils.isNotEmpty(relationField)) {
                Boolean isSubTable = jsonObject.getJSONObject("__config__").getBooleanValue("isSubTable");
                String model = relationField.split("_jsbosTable_")[0];
                jsonObject.put("relationField", model + "_jsbosTable_" + tableName.getTable() + (isSubTable ? "0" : "1"));
            }
        }
        return childTableaa;
    }

    /**
     * 创建表
     *
     * @param formAllModel
     * @return
     */
    public List<TableModel> tableList(JSONArray jsonArray, List<FormAllModel> formAllModel, String table, String linkId) throws WorkFlowException {
        List<TableModel> tableModelList = new LinkedList<>();
        Map<String, String> tableNameList = new HashMap<>();
        DbLinkEntity dbLink = serviceAllUtil.getDbLink(linkId);
        boolean isO = dbLink != null ? ("oracle".equalsIgnoreCase(dbLink.getDbType()) || "dm8".equalsIgnoreCase(dbLink.getDbType())) : ("oracle".equalsIgnoreCase(dataSourceModel.getDbType()) || "dm8".equalsIgnoreCase(dataSourceModel.getDbType()));
        try {
            List<DbTableFieldModel> fieldList = new ArrayList<>();
            Map<String, List<DbTableFieldModel>> tableListAll = new HashMap<>();
            Map<String, String> tableNameAll = new HashMap<>();
            for (FormAllModel model : formAllModel) {
                if (FormEnum.mast.getMessage().equals(model.getKeyName())) {
                    FieLdsModel fieLdsModel = model.getFormColumnModel().getFieLdsModel();
                    this.fieldList(fieLdsModel, table, fieldList, isO);
                    tableNameAll.put(fieLdsModel.getVModel(), table);
                } else if (FormEnum.table.getMessage().equals(model.getKeyName())) {
                    String tableName = "ct" + RandomUtil.uuId();
                    FormColumnTableModel fieLdsModel = model.getChildList();
                    List<DbTableFieldModel> tableList = new ArrayList<>();
                    String tableModel = fieLdsModel.getTableModel();
                    List<FieLdsModel> fieldsList = fieLdsModel.getChildList().stream().map(t -> t.getFieLdsModel()).collect(Collectors.toList());
                    for (FieLdsModel tableFieLdsModel : fieldsList) {
                        this.fieldList(tableFieLdsModel, tableName, tableList, isO);
                        tableNameAll.put(tableFieLdsModel.getVModel(), tableName);
                    }
                    this.dbTableField(tableList, true);
                    tableNameList.put(tableModel, tableName);
                    tableListAll.put(tableModel, tableList);
                }
            }
            this.dbTableField(fieldList, false);
            List<DbTableCreate> dbTableList = new ArrayList<>();
            //创建子表
            for (String key : tableListAll.keySet()) {
                String tableName = isO ? tableNameList.get(key).toUpperCase() : tableNameList.get(key);
                List<DbTableFieldModel> datableList = tableListAll.get(key);
                this.tableModel(tableModelList, datableList, tableName, table, true);
                DbTableCreate dbTable = this.dbTable(linkId, tableName, datableList, true);
                dbTableList.add(dbTable);
            }
            table = isO ? table.toUpperCase() : table;
            this.tableModel(tableModelList, fieldList, table, table, false);
            DbTableCreate dbTable = this.dbTable(linkId, table, fieldList, false);
            dbTableList.add(dbTable);
            serviceAllUtil.createTable(dbTableList);
            this.fieldsTableName(jsonArray, tableModelList, isO);
        } catch (Exception e) {
            log.error("表新增错误:{}", e.getMessage());
        }
        return tableModelList;
    }

    /**
     * 获取表单字段
     *
     * @param fieLdsModel
     * @param tableList
     */
    private void fieldList(FieLdsModel fieLdsModel, String table, List<DbTableFieldModel> tableList, boolean isO) {
        String vmodel = isO ? fieLdsModel.getVModel().toUpperCase() : fieLdsModel.getVModel();
        String lable = fieLdsModel.getConfig().getLabel();
        String keyName = fieLdsModel.getConfig().getKeyName();
        fieLdsModel.getConfig().setTableName(table);
        if (StringUtils.isNotEmpty(vmodel)) {
            DbTableFieldModel fieldForm = new DbTableFieldModel();
            fieldForm.setAllowNull(1);
            fieldForm.setDataType("varchar");
            fieldForm.setDataLength("255");
            fieldForm.setPrimaryKey(0);
            if (StringUtils.isNotEmpty(fieLdsModel.getVModel())) {
                if (ComponentKeyConsts.UPLOADIMG.equals(keyName) || ComponentKeyConsts.UPLOADFZ.equals(keyName) || ComponentKeyConsts.ADDRESS.equals(keyName)) {
                    fieldForm.setDataType("text");
                }
                if (ComponentKeyConsts.MODIFYTIME.equals(keyName) || ComponentKeyConsts.CREATETIME.equals(keyName) || ComponentKeyConsts.DATE.equals(keyName)) {
                    fieldForm.setDataType("datetime");
                }
                if (ComponentKeyConsts.NUM_INPUT.equals(keyName)) {
                    fieldForm.setDataType("decimal");
                }
                fieldForm.setField(vmodel);
                fieldForm.setFieldName(lable);
                tableList.add(fieldForm);
            }
        }
    }

    /**
     * 创建主外键字段
     *
     * @param tableList
     * @param isforeign
     */
    private void dbTableField(List<DbTableFieldModel> tableList, boolean isforeign) {
        DbTableFieldModel tableKey = new DbTableFieldModel();
        tableKey.setAllowNull(0);
        tableKey.setDataType("varchar");
        tableKey.setDataLength("50");
        tableKey.setPrimaryKey(1);
        tableKey.setField("f_id");
        tableKey.setFieldName("主键");
        tableList.add(tableKey);
        if (isforeign) {
            DbTableFieldModel tableForeignKey = new DbTableFieldModel();
            tableForeignKey.setAllowNull(1);
            tableForeignKey.setDataType("varchar");
            tableForeignKey.setDataLength("50");
            tableForeignKey.setPrimaryKey(0);
            tableForeignKey.setField("f_foreignId");
            tableForeignKey.setFieldName("外键");
            tableList.add(tableForeignKey);
        }
    }

    /**
     * 组装字段list
     *
     * @param tableModelList
     * @param dbtable
     * @param table
     * @param mastTable
     * @param isforeign
     */
    private void tableModel(List<TableModel> tableModelList, List<DbTableFieldModel> dbtable, String table, String mastTable, boolean isforeign) {
        TableModel tableModel = new TableModel();
        tableModel.setRelationField(isforeign ? "f_id" : "");
        tableModel.setRelationTable(isforeign ? mastTable : "");
        tableModel.setTable(table);
        tableModel.setTableName(isforeign ? "子表" : "主表");
        tableModel.setTableField(isforeign ? "f_foreignId" : "");
        tableModel.setTypeId(isforeign ? "0" : "1");
        tableModel.setFields(JsonUtil.getJsonToList(dbtable, TableFields.class));
        tableModelList.add(tableModel);
    }

    /**
     * 组装创表字段
     *
     * @param linkId
     * @param tableName
     * @param tableFieldList
     * @param isforeign
     * @return
     */
    private DbTableCreate dbTable(String linkId, String tableName, List<DbTableFieldModel> tableFieldList, boolean isforeign) {
        DbTableCreate dbTable = new DbTableCreate();
        dbTable.setDbLinkId(linkId);
        dbTable.setNewTable(tableName);
        dbTable.setDbTableFieldModelList(tableFieldList);
        dbTable.setTableComment(isforeign ? "子表" : "主表");
        return dbTable;
    }
}
